/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopFixCore;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.LambdaExpressionsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.code.ConvertAnonymousToNestedRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineConstantRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineTempRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryCatchRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.LambdaExpressionsCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ASTRewriteRemoveImportsCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.RefactoringCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.TypeChangeCorrectionProposalCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.InvertBooleanUtility;
import org.eclipse.jdt.ls.core.internal.corrections.ProposalKindWrapper;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.ActionMessages;
import org.eclipse.jdt.ls.core.internal.text.correction.RefactorProposalUtility;
import org.eclipse.jdt.ls.core.internal.text.correction.RefactoringCorrectionCommandProposal;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RefactorProcessor {
    public static final String CONVERT_ANONYMOUS_CLASS_TO_NESTED_COMMAND = "convertAnonymousClassToNestedCommand";
    private PreferenceManager preferenceManager;

    public RefactorProcessor(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<ProposalKindWrapper> getProposals(CodeActionParams params, IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ProposalKindWrapper> proposals = new ArrayList<ProposalKindWrapper>();
            InvertBooleanUtility.getInverseConditionProposals(params, context, coveringNode, proposals);
            this.getInverseLocalVariableProposals(params, context, coveringNode, proposals);
            this.getMoveRefactoringProposals(params, context, coveringNode, proposals);
            boolean noErrorsAtLocation = RefactorProcessor.noErrorsAtLocation(locations, coveringNode);
            if (noErrorsAtLocation) {
                boolean problemsAtLocation = locations.length != 0;
                this.getExtractVariableProposal(params, context, problemsAtLocation, proposals);
                this.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, proposals);
                this.getExtractFieldProposal(params, context, problemsAtLocation, proposals);
                this.getInlineProposal(context, coveringNode, proposals);
                this.getConvertAnonymousToNestedProposals(params, context, coveringNode, proposals);
                RefactorProcessor.getConvertAnonymousClassCreationsToLambdaProposals(context, coveringNode, proposals);
                RefactorProcessor.getConvertLambdaToAnonymousClassCreationsProposals(context, coveringNode, proposals);
                RefactorProcessor.getConvertVarTypeToResolvedTypeProposal(context, coveringNode, proposals);
                RefactorProcessor.getConvertResolvedTypeToVarTypeProposal(context, coveringNode, proposals);
                RefactorProcessor.getAddStaticImportProposals(context, coveringNode, proposals);
                RefactorProcessor.getConvertForLoopProposal(context, coveringNode, proposals);
                this.getAssignToVariableProposals(context, coveringNode, locations, proposals, params);
                this.getIntroduceParameterProposals(params, context, coveringNode, locations, proposals);
                this.getExtractInterfaceProposal(params, context, proposals);
                this.getChangeSignatureProposal(params, context, proposals);
                this.getSurroundWithTryCatchProposal(context, proposals);
            }
            return proposals;
        }
        return Collections.emptyList();
    }

    private boolean getIntroduceParameterProposals(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, IProblemLocation[] locations, ArrayList<ProposalKindWrapper> resultingCollections) throws CoreException {
        if (resultingCollections == null) {
            return false;
        }
        ProposalKindWrapper proposal = RefactorProposalUtility.getIntroduceParameterRefactoringProposals(params, context, coveringNode, this.preferenceManager.getClientPreferences().isAdvancedIntroduceParameterRefactoringSupported(), locations);
        if (proposal != null) {
            return resultingCollections.add(proposal);
        }
        return false;
    }

    private boolean getInverseLocalVariableProposals(CodeActionParams params, IInvocationContext context, ASTNode covering, Collection<ProposalKindWrapper> proposals) {
        if (proposals == null) {
            return false;
        }
        ProposalKindWrapper proposal = null;
        proposal = this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported() ? InvertBooleanUtility.getInvertVariableProposal(params, context, covering, true) : InvertBooleanUtility.getInvertVariableProposal(params, context, covering, false);
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    private boolean getMoveRefactoringProposals(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        List<ProposalKindWrapper> newProposals;
        if (resultingCollections == null) {
            return false;
        }
        if (this.preferenceManager.getClientPreferences().isMoveRefactoringSupported() && (newProposals = RefactorProposalUtility.getMoveRefactoringProposals(params, context)) != null && !newProposals.isEmpty()) {
            resultingCollections.addAll(newProposals);
            return true;
        }
        return false;
    }

    static boolean noErrorsAtLocation(IProblemLocation[] locations, ASTNode coveringNode) {
        if (locations != null) {
            int start = coveringNode.getStartPosition();
            int length = coveringNode.getLength();
            int i = 0;
            while (i < locations.length) {
                IProblemLocation location = locations[i];
                if (location.getOffset() <= start + length && location.getOffset() + location.getLength() >= start && location.isError() && (!"org.eclipse.jdt.core.problem".equals(location.getMarkerType()) || JavaCore.getOptionForConfigurableSeverity((int)location.getProblemId()) == null)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean getExtractVariableProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Collection<ProposalKindWrapper> proposals) throws CoreException {
        if (proposals == null) {
            return false;
        }
        List<ProposalKindWrapper> newProposals = null;
        newProposals = this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported() ? RefactorProposalUtility.getExtractVariableCommandProposals(params, context, problemsAtLocation, this.preferenceManager.getClientPreferences().isExtractVariableInferSelectionSupported()) : RefactorProposalUtility.getExtractVariableProposals(params, context, problemsAtLocation, this.preferenceManager.getClientPreferences().isExtractVariableInferSelectionSupported());
        if (newProposals == null || newProposals.isEmpty()) {
            return false;
        }
        proposals.addAll(newProposals);
        return true;
    }

    private boolean getAssignToVariableProposals(IInvocationContext context, ASTNode node, IProblemLocation[] locations, Collection<ProposalKindWrapper> resultingCollections, CodeActionParams params) {
        String declsToFinal = this.preferenceManager.getPreferences().getCodeGenerationAddFinalForNewDeclaration();
        try {
            Map formatterOptions = null;
            ProposalKindWrapper proposal = RefactorProposalUtility.getAssignVariableProposal(params, context, locations != null && locations.length != 0, formatterOptions, this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported(), locations, "all".equals(declsToFinal) || "variables".equals(declsToFinal));
            if (proposal != null) {
                resultingCollections.add(proposal);
            }
            if ((proposal = RefactorProposalUtility.getAssignFieldProposal(params, context, locations != null && locations.length != 0, formatterOptions, this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported(), locations)) != null) {
                resultingCollections.add(proposal);
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException(e);
        }
        return true;
    }

    private boolean getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Collection<ProposalKindWrapper> proposals) throws CoreException {
        if (proposals == null) {
            return false;
        }
        ProposalKindWrapper proposal = null;
        proposal = this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported() ? RefactorProposalUtility.getExtractMethodCommandProposal(params, context, coveringNode, problemsAtLocation, this.preferenceManager.getClientPreferences().isExtractMethodInferSelectionSupported()) : RefactorProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, this.preferenceManager.getClientPreferences().isExtractMethodInferSelectionSupported());
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    private boolean getExtractFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Collection<ProposalKindWrapper> proposals) throws CoreException {
        if (proposals == null) {
            return false;
        }
        ProposalKindWrapper proposal = RefactorProposalUtility.getGenericExtractFieldProposal(params, context, problemsAtLocation, null, null, this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported(), this.preferenceManager.getClientPreferences().isExtractFieldInferSelectionSupported());
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    private boolean getInlineProposal(IInvocationContext context, ASTNode node, Collection<ProposalKindWrapper> resultingCollections) {
        block18: {
            IBinding binding;
            block19: {
                block14: {
                    boolean status;
                    ILocalVariable localVar;
                    ASTNode decl;
                    block17: {
                        IVariableBinding varBinding;
                        block16: {
                            InlineConstantRefactoring refactoring;
                            block15: {
                                if (resultingCollections == null) {
                                    return false;
                                }
                                if (!(node instanceof SimpleName)) {
                                    return false;
                                }
                                SimpleName name = (SimpleName)node;
                                binding = name.resolveBinding();
                                if (!(binding instanceof IVariableBinding)) break block14;
                                varBinding = (IVariableBinding)binding;
                                if (!varBinding.isParameter()) break block15;
                                return false;
                            }
                            if (!varBinding.isField()) break block16;
                            if (RefactoringAvailabilityTesterCore.isInlineConstantAvailable((IField)((IField)varBinding.getJavaElement())) && (refactoring = new InlineConstantRefactoring(context.getCompilationUnit(), context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength())) != null && refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK() && refactoring.getReferences((IProgressMonitor)new NullProgressMonitor(), new RefactoringStatus()).length > 0) {
                                refactoring.setRemoveDeclaration(refactoring.isDeclarationSelected());
                                refactoring.setReplaceAllReferences(refactoring.isDeclarationSelected());
                                CheckConditionsOperation check = new CheckConditionsOperation((Refactoring)refactoring, 4);
                                CreateChangeOperation create = new CreateChangeOperation(check, 4);
                                create.run((IProgressMonitor)new NullProgressMonitor());
                                String label = ActionMessages.InlineConstantRefactoringAction_label;
                                int relevance = 5;
                                ChangeCorrectionProposalCore proposal = new ChangeCorrectionProposalCore(label, create.getChange(), relevance);
                                resultingCollections.add(CodeActionHandler.wrap(proposal, "refactor.inline"));
                                return true;
                            }
                            return false;
                        }
                        decl = context.getASTRoot().findDeclaringNode((IBinding)varBinding);
                        if (decl instanceof VariableDeclarationFragment && decl.getLocationInParent() == VariableDeclarationStatement.FRAGMENTS_PROPERTY) break block17;
                        return false;
                    }
                    IJavaElement create = binding.getJavaElement();
                    if (!(create instanceof ILocalVariable) || !RefactoringAvailabilityTesterCore.isInlineTempAvailable((ILocalVariable)(localVar = (ILocalVariable)create))) break block18;
                    InlineTempRefactoring refactoring = new InlineTempRefactoring((VariableDeclaration)decl);
                    try {
                        status = refactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor()).isOK();
                    }
                    catch (Exception e) {
                        status = false;
                    }
                    if (status && refactoring.getReferences().length > 0) {
                        String label = CorrectionMessages.QuickAssistProcessor_inline_local_description;
                        int relevance = 5;
                        RefactoringCorrectionProposalCore proposal = new RefactoringCorrectionProposalCore(label, context.getCompilationUnit(), (Refactoring)refactoring, relevance);
                        resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.inline"));
                        return true;
                    }
                }
                if (!(binding instanceof IMethodBinding)) break block18;
                boolean isUnnamedClass = List.of(context.getCompilationUnit().getTypes()).stream().anyMatch(t -> JDTUtils.isUnnamedClass((IJavaElement)t));
                if (!isUnnamedClass) break block19;
                return false;
            }
            try {
                InlineMethodRefactoring refactoring;
                if (RefactoringAvailabilityTesterCore.isInlineMethodAvailable((IMethod)((IMethod)binding.getJavaElement())) && (refactoring = InlineMethodRefactoring.create((ITypeRoot)context.getCompilationUnit(), (CompilationUnit)context.getASTRoot(), (int)context.getSelectionOffset(), (int)context.getSelectionLength())) != null && refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    CheckConditionsOperation check = new CheckConditionsOperation((Refactoring)refactoring, 4);
                    CreateChangeOperation create = new CreateChangeOperation(check, 4);
                    create.run((IProgressMonitor)new NullProgressMonitor());
                    String label = ActionMessages.InlineMethodRefactoringAction_label;
                    int relevance = 5;
                    ChangeCorrectionProposalCore proposal = new ChangeCorrectionProposalCore(label, create.getChange(), relevance);
                    resultingCollections.add(CodeActionHandler.wrap(proposal, "refactor.inline"));
                    return true;
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e);
            }
        }
        return false;
    }

    private boolean getConvertAnonymousToNestedProposals(CodeActionParams params, IInvocationContext context, ASTNode node, Collection<ProposalKindWrapper> proposals) throws CoreException {
        if (proposals == null) {
            return false;
        }
        ProposalKindWrapper proposal = null;
        proposal = this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported() ? RefactorProcessor.getConvertAnonymousToNestedProposal(params, context, node, true) : RefactorProcessor.getConvertAnonymousToNestedProposal(params, context, node, false);
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    public static ProposalKindWrapper getConvertAnonymousToNestedProposal(CodeActionParams params, IInvocationContext context, ASTNode node, boolean returnAsCommand) throws CoreException {
        String label = CorrectionMessages.QuickAssistProcessor_convert_anonym_to_nested;
        ClassInstanceCreation cic = RefactorProcessor.getClassInstanceCreation(node);
        if (cic == null) {
            return null;
        }
        AnonymousClassDeclaration anonymTypeDecl = cic.getAnonymousClassDeclaration();
        if (anonymTypeDecl == null || anonymTypeDecl.resolveBinding() == null) {
            return null;
        }
        ConvertAnonymousToNestedRefactoring refactoring = new ConvertAnonymousToNestedRefactoring(anonymTypeDecl);
        if (!refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            return null;
        }
        if (returnAsCommand) {
            RefactoringCorrectionCommandProposal p1 = new RefactoringCorrectionCommandProposal(label, context.getCompilationUnit(), 5, "java.action.applyRefactoringCommand", Arrays.asList(CONVERT_ANONYMOUS_CLASS_TO_NESTED_COMMAND, params));
            return CodeActionHandler.wrap((ChangeCorrectionProposalCore)p1, "refactor");
        }
        String extTypeName = ASTNodes.getTypeName((Type)cic.getType());
        ITypeBinding anonymTypeBinding = anonymTypeDecl.resolveBinding();
        String className = anonymTypeBinding.getInterfaces().length == 0 ? Messages.format((String)CorrectionMessages.QuickAssistProcessor_name_extension_from_interface, (Object)extTypeName) : Messages.format((String)CorrectionMessages.QuickAssistProcessor_name_extension_from_class, (Object)extTypeName);
        String[][] existingTypes = ((IType)anonymTypeBinding.getJavaElement()).resolveType(className);
        int i = 1;
        while (existingTypes != null) {
            existingTypes = ((IType)anonymTypeBinding.getJavaElement()).resolveType(className + ++i);
        }
        refactoring.setClassName((String)(i == 1 ? className : className + i));
        LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
        refactoring.setLinkedProposalModel(linkedProposalModel);
        ICompilationUnit cu = context.getCompilationUnit();
        RefactoringCorrectionProposalCore proposal = new RefactoringCorrectionProposalCore(label, cu, (Refactoring)refactoring, 5);
        proposal.setLinkedProposalModel(linkedProposalModel);
        return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor");
    }

    private static ClassInstanceCreation getClassInstanceCreation(ASTNode node) {
        while (node instanceof Name || node instanceof Type || node instanceof Dimension || node.getParent() instanceof MethodDeclaration || node.getLocationInParent() == AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY) {
            node = node.getParent();
        }
        if (node instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)node;
            return classInstanceCreation;
        }
        if (node.getLocationInParent() == ClassInstanceCreation.ANONYMOUS_CLASS_DECLARATION_PROPERTY) {
            return (ClassInstanceCreation)node.getParent();
        }
        return null;
    }

    private static boolean getConvertAnonymousClassCreationsToLambdaProposals(IInvocationContext context, ASTNode covering, Collection<ProposalKindWrapper> resultingCollections) {
        ClassInstanceCreation cic = RefactorProcessor.getClassInstanceCreation(covering);
        if (cic == null) {
            return false;
        }
        LambdaExpressionsFixCore fix = LambdaExpressionsFixCore.createConvertToLambdaFix((ClassInstanceCreation)cic);
        if (fix == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cleanup.convert_functional_interfaces", "true");
        options.put("cleanup.use_lambda", "true");
        FixCorrectionProposalCore proposal = new FixCorrectionProposalCore((IProposableFix)fix, (ICleanUp)new LambdaExpressionsCleanUpCore(options), 6, context);
        resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor"));
        return true;
    }

    private static boolean getConvertLambdaToAnonymousClassCreationsProposals(IInvocationContext context, ASTNode covering, Collection<ProposalKindWrapper> resultingCollections) {
        LambdaExpression lambda;
        if (resultingCollections == null) {
            return true;
        }
        if (covering instanceof LambdaExpression) {
            LambdaExpression lambdaExpression;
            lambda = lambdaExpression = (LambdaExpression)covering;
        } else if (covering.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            lambda = (LambdaExpression)covering.getParent();
        } else {
            return false;
        }
        IProposableFix fix = LambdaExpressionsFixCore.createConvertToAnonymousClassCreationsFix((LambdaExpression)lambda);
        if (fix == null) {
            return false;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cleanup.convert_functional_interfaces", "true");
        options.put("cleanup.use_anonymous_class_creation", "true");
        FixCorrectionProposalCore proposal = new FixCorrectionProposalCore(fix, (ICleanUp)new LambdaExpressionsCleanUpCore(options), 2, context);
        resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor"));
        return true;
    }

    private static boolean getConvertVarTypeToResolvedTypeProposal(IInvocationContext context, ASTNode node, Collection<ProposalKindWrapper> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        IJavaElement root = astRoot.getJavaElement();
        if (root == null) {
            return false;
        }
        IJavaProject javaProject = root.getJavaProject();
        if (javaProject == null) {
            return false;
        }
        if (!JavaModelUtil.is10OrHigher((IJavaProject)javaProject)) {
            return false;
        }
        SimpleName name = RefactorProcessor.getSimpleNameForVariable(node);
        if (name == null) {
            return false;
        }
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding varBinding = (IVariableBinding)binding;
        if (varBinding.isField() || varBinding.isParameter()) {
            return false;
        }
        ASTNode varDeclaration = astRoot.findDeclaringNode((IBinding)varBinding);
        if (varDeclaration == null) {
            return false;
        }
        ITypeBinding typeBinding = varBinding.getType();
        if (typeBinding == null || typeBinding.isAnonymous() || typeBinding.isIntersectionType() || typeBinding.isWildcardType()) {
            return false;
        }
        Type type = null;
        if (varDeclaration instanceof SingleVariableDeclaration) {
            SingleVariableDeclaration singleVar = (SingleVariableDeclaration)varDeclaration;
            type = singleVar.getType();
        } else if (varDeclaration instanceof VariableDeclarationFragment) {
            ASTNode parent = varDeclaration.getParent();
            if (parent instanceof VariableDeclarationStatement) {
                VariableDeclarationStatement variableDeclStatement = (VariableDeclarationStatement)parent;
                type = variableDeclStatement.getType();
            } else if (parent instanceof VariableDeclarationExpression) {
                VariableDeclarationExpression variableDeclExpression = (VariableDeclarationExpression)parent;
                type = variableDeclExpression.getType();
            }
        }
        if (type == null || !type.isVar()) {
            return false;
        }
        TypeChangeCorrectionProposalCore proposal = new TypeChangeCorrectionProposalCore(context.getCompilationUnit(), (IBinding)varBinding, astRoot, typeBinding, false, 8);
        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor"));
        return true;
    }

    private static SimpleName getSimpleNameForVariable(ASTNode node) {
        if (!(node instanceof SimpleName)) {
            return null;
        }
        SimpleName name = (SimpleName)node;
        if (!name.isDeclaration()) {
            VariableDeclarationStatement variableDeclStatement;
            List fragments;
            while (node instanceof Name || node instanceof Type) {
                node = node.getParent();
            }
            if (node instanceof VariableDeclarationStatement && (fragments = (variableDeclStatement = (VariableDeclarationStatement)node).fragments()).size() > 0) {
                name = ((VariableDeclarationFragment)fragments.get(0)).getName();
            }
        }
        return name;
    }

    private static boolean getConvertResolvedTypeToVarTypeProposal(IInvocationContext context, ASTNode node, Collection<ProposalKindWrapper> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        IJavaElement root = astRoot.getJavaElement();
        if (root == null) {
            return false;
        }
        IJavaProject javaProject = root.getJavaProject();
        if (javaProject == null) {
            return false;
        }
        if (!JavaModelUtil.is10OrHigher((IJavaProject)javaProject)) {
            return false;
        }
        SimpleName name = RefactorProcessor.getSimpleNameForVariable(node);
        if (name == null) {
            return false;
        }
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding varBinding = (IVariableBinding)binding;
        if (varBinding.isField() || varBinding.isParameter()) {
            return false;
        }
        ASTNode varDeclaration = astRoot.findDeclaringNode((IBinding)varBinding);
        if (varDeclaration == null) {
            return false;
        }
        Type type = null;
        Expression expression = null;
        ITypeBinding typeBinding = varBinding.getType();
        if (typeBinding == null) {
            return false;
        }
        ITypeBinding expressionTypeBinding = null;
        if (varDeclaration instanceof SingleVariableDeclaration) {
            SingleVariableDeclaration svDecl = (SingleVariableDeclaration)varDeclaration;
            type = svDecl.getType();
            expression = svDecl.getInitializer();
            if (expression != null) {
                expressionTypeBinding = expression.resolveTypeBinding();
            } else {
                ITypeBinding expBinding;
                EnhancedForStatement efStmt;
                ASTNode parent = svDecl.getParent();
                if (parent instanceof EnhancedForStatement && (expression = (efStmt = (EnhancedForStatement)parent).getExpression()) != null && (expBinding = expression.resolveTypeBinding()) != null) {
                    if (expBinding.isArray()) {
                        expressionTypeBinding = expBinding.getElementType();
                    } else {
                        ITypeBinding[] typeArguments;
                        ITypeBinding iterable = Bindings.findTypeInHierarchy((ITypeBinding)expBinding, (String)"java.lang.Iterable");
                        if (iterable != null && (typeArguments = iterable.getTypeArguments()).length == 1) {
                            expressionTypeBinding = typeArguments[0];
                            expressionTypeBinding = Bindings.normalizeForDeclarationUse((ITypeBinding)expressionTypeBinding, (AST)context.getASTRoot().getAST());
                        }
                    }
                }
            }
        } else if (varDeclaration instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)varDeclaration;
            ASTNode parent = varDeclaration.getParent();
            expression = variableDeclarationFragment.getInitializer();
            if (expression != null) {
                expressionTypeBinding = expression.resolveTypeBinding();
            }
            if (parent instanceof VariableDeclarationStatement) {
                VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)parent;
                type = variableDeclarationStatement.getType();
            } else if (parent instanceof VariableDeclarationExpression) {
                VariableDeclarationExpression varDecl = (VariableDeclarationExpression)parent;
                if (varDecl.fragments().size() > 1) {
                    return false;
                }
                type = varDecl.getType();
            }
        }
        if (type == null || type.isVar()) {
            return false;
        }
        if (expression == null || expression instanceof ArrayInitializer || expression instanceof LambdaExpression || expression instanceof MethodReference) {
            return false;
        }
        if (expressionTypeBinding == null || !expressionTypeBinding.isEqualTo((IBinding)typeBinding)) {
            return false;
        }
        TypeChangeCorrectionProposalCore proposal = new TypeChangeCorrectionProposalCore(context.getCompilationUnit(), (IBinding)varBinding, astRoot, typeBinding, 8);
        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor"));
        return true;
    }

    private static boolean getAddStaticImportProposals(IInvocationContext context, final ASTNode node, Collection<ProposalKindWrapper> proposals) {
        QualifiedName qn;
        MethodInvocation mi;
        ImportRemover removerAllOccurences;
        ImportRemover remover;
        ASTRewrite astRewriteReplaceAllOccurrences;
        ASTRewrite astRewrite;
        ImportRewrite importRewrite;
        boolean needImport;
        IMethodBinding binding;
        SimpleName name;
        block20: {
            ITypeBinding declaringClass;
            if (!(node instanceof SimpleName)) {
                return false;
            }
            name = (SimpleName)node;
            ASTNode aSTNode = name.getParent();
            if (aSTNode instanceof MethodInvocation) {
                MethodInvocation mi2 = (MethodInvocation)aSTNode;
                Expression expression = mi2.getExpression();
                if (expression == null || expression.equals((Object)name)) {
                    return false;
                }
                binding = mi2.resolveMethodBinding();
                if (binding == null) {
                    return false;
                }
                declaringClass = binding.getDeclaringClass();
            } else {
                ASTNode aSTNode2 = name.getParent();
                if (aSTNode2 instanceof QualifiedName) {
                    QualifiedName qualifiedName = (QualifiedName)aSTNode2;
                    if (name.equals((Object)qualifiedName.getQualifier()) || qualifiedName.getParent() instanceof ImportDeclaration) {
                        return false;
                    }
                    binding = qualifiedName.resolveBinding();
                    if (!(binding instanceof IVariableBinding)) {
                        return false;
                    }
                    declaringClass = ((IVariableBinding)binding).getDeclaringClass();
                } else {
                    return false;
                }
            }
            if (!Modifier.isStatic((int)binding.getModifiers())) {
                return false;
            }
            needImport = false;
            if (!RefactorProcessor.isDirectlyAccessible((ASTNode)name, declaringClass)) {
                if (Modifier.isPrivate((int)declaringClass.getModifiers())) {
                    return false;
                }
                needImport = true;
            }
            if (proposals == null) {
                return true;
            }
            importRewrite = StubUtility.createImportRewrite((ICompilationUnit)context.getCompilationUnit(), (boolean)true);
            astRewrite = ASTRewrite.create((AST)node.getAST());
            astRewriteReplaceAllOccurrences = ASTRewrite.create((AST)node.getAST());
            remover = new ImportRemover(context.getCompilationUnit().getJavaProject(), context.getASTRoot());
            removerAllOccurences = new ImportRemover(context.getCompilationUnit().getJavaProject(), context.getASTRoot());
            mi = null;
            qn = null;
            ASTNode aSTNode3 = name.getParent();
            if (aSTNode3 instanceof MethodInvocation) {
                MethodInvocation parentInvocation;
                mi = parentInvocation = (MethodInvocation)aSTNode3;
                astRewrite.remove((ASTNode)mi.getExpression(), null);
                remover.registerRemovedNode((ASTNode)mi.getExpression());
                removerAllOccurences.registerRemovedNode((ASTNode)mi.getExpression());
                mi.typeArguments().forEach(typeObject -> {
                    Type type = (Type)typeObject;
                    astRewrite.remove((ASTNode)type, null);
                    remover.registerRemovedNode((ASTNode)type);
                    removerAllOccurences.registerRemovedNode((ASTNode)type);
                });
                break block20;
            }
            ASTNode aSTNode4 = name.getParent();
            if (aSTNode4 instanceof QualifiedName) {
                QualifiedName qname;
                qn = qname = (QualifiedName)aSTNode4;
                astRewrite.replace((ASTNode)qn, (ASTNode)ASTNodeFactory.newName((AST)node.getAST(), (String)name.getFullyQualifiedName()), null);
                remover.registerRemovedNode((ASTNode)qn);
                removerAllOccurences.registerRemovedNode((ASTNode)qn);
                break block20;
            }
            return false;
        }
        try {
            final MethodInvocation miFinal = mi;
            name.getRoot().accept(new ASTVisitor(){

                public boolean visit(MethodInvocation methodInvocation) {
                    Expression methodInvocationExpression = methodInvocation.getExpression();
                    if (methodInvocationExpression == null) {
                        return super.visit(methodInvocation);
                    }
                    if (methodInvocationExpression instanceof Name) {
                        Name exprName;
                        Expression expression;
                        Name name = (Name)methodInvocationExpression;
                        String fullyQualifiedName = name.getFullyQualifiedName();
                        if (miFinal != null && (expression = miFinal.getExpression()) instanceof Name && (exprName = (Name)expression).getFullyQualifiedName().equals(fullyQualifiedName) && miFinal.getName().getIdentifier().equals(methodInvocation.getName().getIdentifier())) {
                            methodInvocation.typeArguments().forEach(type -> {
                                astRewriteReplaceAllOccurrences.remove((ASTNode)((Type)type), null);
                                removerAllOccurences.registerRemovedNode((ASTNode)((Type)type));
                            });
                            astRewriteReplaceAllOccurrences.remove((ASTNode)methodInvocationExpression, null);
                            removerAllOccurences.registerRemovedNode((ASTNode)methodInvocationExpression);
                        }
                    }
                    return super.visit(methodInvocation);
                }
            });
            final QualifiedName qnFinal = qn;
            name.getRoot().accept(new ASTVisitor(){

                public boolean visit(QualifiedName qualifiedName) {
                    if (qnFinal != null && qualifiedName.getFullyQualifiedName().equals(qnFinal.getFullyQualifiedName())) {
                        astRewriteReplaceAllOccurrences.replace((ASTNode)qualifiedName, (ASTNode)ASTNodeFactory.newName((AST)node.getAST(), (String)name.getFullyQualifiedName()), null);
                        removerAllOccurences.registerRemovedNode((ASTNode)qualifiedName);
                    }
                    return super.visit(qualifiedName);
                }
            });
            if (needImport) {
                importRewrite.addStaticImport((IBinding)binding);
            }
            ASTRewriteRemoveImportsCorrectionProposalCore proposal = new ASTRewriteRemoveImportsCorrectionProposalCore(CorrectionMessages.QuickAssistProcessor_convert_to_static_import, context.getCompilationUnit(), astRewrite, 5);
            proposal.setImportRewrite(importRewrite);
            proposal.setImportRemover(remover);
            proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor"));
            ASTRewriteRemoveImportsCorrectionProposalCore proposalReplaceAllOccurrences = new ASTRewriteRemoveImportsCorrectionProposalCore(CorrectionMessages.QuickAssistProcessor_convert_to_static_import_replace_all, context.getCompilationUnit(), astRewriteReplaceAllOccurrences, 5);
            proposalReplaceAllOccurrences.setImportRewrite(importRewrite);
            proposalReplaceAllOccurrences.setImportRemover(removerAllOccurences);
            proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposalReplaceAllOccurrences, "refactor"));
        }
        catch (IllegalArgumentException e) {
            JavaLanguageServerPlugin.logException("Failed to get static import proposal", e);
            return false;
        }
        catch (JavaModelException e) {
            return false;
        }
        return true;
    }

    private static boolean isDirectlyAccessible(ASTNode nameNode, ITypeBinding declaringClass) {
        ASTNode node = nameNode.getParent();
        while (node != null) {
            AnonymousClassDeclaration anonymousClassDecl;
            ITypeBinding binding;
            AbstractTypeDeclaration typeDecl;
            ITypeBinding binding2;
            if (node instanceof AbstractTypeDeclaration ? (binding2 = (typeDecl = (AbstractTypeDeclaration)node).resolveBinding()) != null && binding2.isSubTypeCompatible(declaringClass) : node instanceof AnonymousClassDeclaration && (binding = (anonymousClassDecl = (AnonymousClassDeclaration)node).resolveBinding()) != null && binding.isSubTypeCompatible(declaringClass)) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private static boolean getConvertForLoopProposal(IInvocationContext context, ASTNode node, Collection<ProposalKindWrapper> resultingCollections) {
        ForStatement forStatement = RefactorProcessor.getEnclosingForStatementHeader(node);
        if (forStatement == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ConvertLoopFixCore fix = ConvertLoopFixCore.createConvertForLoopToEnhancedFix((CompilationUnit)context.getASTRoot(), (ForStatement)forStatement);
        if (fix == null) {
            return false;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cleanup.convert_to_enhanced_for_loop", "true");
        AbstractCleanUp cleanUp = new AbstractCleanUp(options){

            public CleanUpRequirements getRequirements() {
                return new CleanUpRequirements(this.isEnabled("cleanup.convert_to_enhanced_for_loop"), false, false, null);
            }

            public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
                CompilationUnit compilationUnit = context.getAST();
                if (compilationUnit == null) {
                    return null;
                }
                boolean convertForLoops = this.isEnabled("cleanup.convert_to_enhanced_for_loop");
                boolean checkIfLoopVarUsed = this.isEnabled("cleanup.convert_to_enhanced_for_loop_if_loop_var_used");
                return ConvertLoopFixCore.createCleanUp((CompilationUnit)compilationUnit, (boolean)convertForLoops, (boolean)convertForLoops, (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final") ? 1 : 0) != 0, (boolean)checkIfLoopVarUsed);
            }

            public String[] getStepDescriptions() {
                ArrayList<String> result = new ArrayList<String>();
                if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
                    result.add(MultiFixMessages.Java50CleanUp_ConvertToEnhancedForLoop_description);
                    if (this.isEnabled("cleanup.convert_to_enhanced_for_loop_if_loop_var_used")) {
                        result.add(MultiFixMessages.Java50CleanUp_ConvertLoopOnlyIfLoopVarUsed_description);
                    }
                }
                return result.toArray(new String[result.size()]);
            }

            public String getPreview() {
                StringBuilder buf = new StringBuilder();
                if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
                    buf.append("for (int element : ids) {\n");
                    buf.append("    double value= element / 2; \n");
                    buf.append("    System.out.println(value);\n");
                    buf.append("}\n");
                } else {
                    buf.append("for (int i = 0; i < ids.length; i++) {\n");
                    buf.append("    double value= ids[i] / 2; \n");
                    buf.append("    System.out.println(value);\n");
                    buf.append("}\n");
                }
                if (this.isEnabled("cleanup.convert_to_enhanced_for_loop") && !this.isEnabled("cleanup.convert_to_enhanced_for_loop_if_loop_var_used")) {
                    buf.append("for (int id : ids) {\n");
                    buf.append("    System.out.println(\"here\");\n");
                    buf.append("}\n");
                } else {
                    buf.append("for (int i = 0; i < ids.length; i++) {\n");
                    buf.append("    System.out.println(\"here\");\n");
                    buf.append("}\n");
                }
                return buf.toString();
            }
        };
        FixCorrectionProposalCore proposal = new FixCorrectionProposalCore((IProposableFix)fix, (ICleanUp)cleanUp, 1, context);
        resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor"));
        return true;
    }

    private static ForStatement getEnclosingForStatementHeader(ASTNode node) {
        return RefactorProcessor.getEnclosingHeader(node, ForStatement.class, new StructuralPropertyDescriptor[]{ForStatement.INITIALIZERS_PROPERTY, ForStatement.EXPRESSION_PROPERTY, ForStatement.UPDATERS_PROPERTY});
    }

    /*
     * Unable to fully structure code
     */
    private static <T extends ASTNode> T getEnclosingHeader(ASTNode node, Class<T> headerType, StructuralPropertyDescriptor ... headerProperties) {
        if (!headerType.isInstance(node)) ** GOTO lbl17
        return (T)((ASTNode)headerType.cast(node));
lbl-1000:
        // 1 sources

        {
            parent = node.getParent();
            if (headerType.isInstance(parent)) {
                locationInParent = node.getLocationInParent();
                var8_5 = headerProperties;
                var7_6 = headerProperties.length;
                var6_7 = 0;
                while (var6_7 < var7_6) {
                    property = var8_5[var6_7];
                    if (locationInParent == property) {
                        return (T)((ASTNode)headerType.cast(parent));
                    }
                    ++var6_7;
                }
                return null;
            }
            node = parent;
lbl17:
            // 2 sources

            ** while (node != null)
        }
lbl18:
        // 1 sources

        return null;
    }

    private boolean getExtractInterfaceProposal(CodeActionParams params, IInvocationContext context, Collection<ProposalKindWrapper> proposals) {
        if (proposals == null) {
            return false;
        }
        if (!this.preferenceManager.getClientPreferences().isExtractInterfaceSupport() || !this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported()) {
            return false;
        }
        ProposalKindWrapper proposal = RefactorProposalUtility.getExtractInterfaceProposal(params, context);
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    private boolean getChangeSignatureProposal(CodeActionParams params, IInvocationContext context, Collection<ProposalKindWrapper> proposals) {
        if (proposals == null) {
            return false;
        }
        ProposalKindWrapper proposal = RefactorProposalUtility.getChangeSignatureProposal(params, context);
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean getSurroundWithTryCatchProposal(IInvocationContext context, Collection<ProposalKindWrapper> proposals) {
        block8: {
            if (proposals == null) {
                return false;
            }
            if (context.getSelectionLength() <= 0) {
                return false;
            }
            cu = context.getCompilationUnit();
            astRoot = context.getASTRoot();
            selectedNode = context.getCoveredNode();
            if (selectedNode != null) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                selectedNode = selectedNode.getParent();
lbl11:
                // 2 sources

                ** while (selectedNode != null && !(selectedNode instanceof Statement) && !(selectedNode instanceof VariableDeclarationExpression) && selectedNode.getLocationInParent() != LambdaExpression.BODY_PROPERTY && !(selectedNode instanceof MethodReference))
            }
lbl12:
            // 1 sources

            if (selectedNode == null) {
                return false;
            }
            offset = selectedNode.getStartPosition();
            length = selectedNode.getLength();
            selectionEnd = context.getSelectionOffset() + context.getSelectionLength();
            if (selectionEnd > offset + length) {
                length = selectionEnd - offset;
            }
            try {
                refactoring = SurroundWithTryCatchRefactoring.create((ICompilationUnit)cu, (int)offset, (int)length);
                if (refactoring.checkActivationBasics(astRoot).isOK()) break block8;
                return false;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e);
                return false;
            }
        }
        refactoring.setLeaveDirty(true);
        label = CorrectionMessages.LocalCorrectionsSubProcessor_surroundwith_trycatch_description;
        proposal = new RefactoringCorrectionProposalCore(label, cu, (Refactoring)refactoring, 6);
        proposal.setLinkedProposalModel(refactoring.getLinkedProposalModel());
        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor"));
        return true;
    }
}

