/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractConstantRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractTempRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.IntroduceParameterRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.PromoteTempToFieldRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceProcessor;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AssignToVariableAssistProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.RefactoringCorrectionProposalCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.ExtractFieldRefactoring;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.ProposalKindWrapper;
import org.eclipse.jdt.ls.core.internal.handlers.ChangeSignatureHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.ActionMessages;
import org.eclipse.jdt.ls.core.internal.text.correction.AssignToVariableAssistCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.CUCorrectionCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.CodeActionUtility;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.ltk.core.refactoring.Refactoring;

public class RefactorProposalUtility {
    public static final String APPLY_REFACTORING_COMMAND_ID = "java.action.applyRefactoringCommand";
    public static final String EXTRACT_VARIABLE_ALL_OCCURRENCE_COMMAND = "extractVariableAllOccurrence";
    public static final String EXTRACT_VARIABLE_COMMAND = "extractVariable";
    public static final String ASSIGN_VARIABLE_COMMAND = "assignVariable";
    public static final String EXTRACT_CONSTANT_COMMAND = "extractConstant";
    public static final String EXTRACT_METHOD_COMMAND = "extractMethod";
    public static final String EXTRACT_FIELD_COMMAND = "extractField";
    public static final String EXTRACT_INTERFACE_COMMAND = "extractInterface";
    public static final String CHANGE_SIGNATURE_COMMAND = "changeSignature";
    public static final String ASSIGN_FIELD_COMMAND = "assignField";
    public static final String CONVERT_VARIABLE_TO_FIELD_COMMAND = "convertVariableToField";
    public static final String MOVE_FILE_COMMAND = "moveFile";
    public static final String MOVE_INSTANCE_METHOD_COMMAND = "moveInstanceMethod";
    public static final String MOVE_STATIC_MEMBER_COMMAND = "moveStaticMember";
    public static final String MOVE_TYPE_COMMAND = "moveType";
    public static final String INTRODUCE_PARAMETER_COMMAND = "introduceParameter";

    public static List<ProposalKindWrapper> getMoveRefactoringProposals(CodeActionParams params, IInvocationContext context) {
        int relevance = 6;
        List kindOfActions = params.getContext().getOnly();
        boolean alwaysShowMove = kindOfActions != null && kindOfActions.contains("refactor");
        ASTNode node = context.getCoveredNode();
        if (node == null) {
            node = context.getCoveringNode();
        }
        node = RefactorProposalUtility.getDeclarationNode(node, alwaysShowMove);
        ICompilationUnit cu = context.getCompilationUnit();
        String uri = JDTUtils.toURI(cu);
        if (cu != null && node != null) {
            try {
                if (node instanceof MethodDeclaration || node instanceof FieldDeclaration || node instanceof AbstractTypeDeclaration) {
                    MethodDeclaration methodDecl;
                    String displayName = RefactorProposalUtility.getDisplayName(node);
                    String label = alwaysShowMove ? ActionMessages.MoveRefactoringAction_label : Messages.format(ActionMessages.MoveRefactoringAction_templateLabel, displayName);
                    int memberType = node.getNodeType();
                    String enclosingTypeName = RefactorProposalUtility.getEnclosingType(node);
                    String projectName = cu.getJavaProject().getProject().getName();
                    if (node instanceof AbstractTypeDeclaration) {
                        AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)node;
                        MoveTypeInfo moveTypeInfo = new MoveTypeInfo(displayName, enclosingTypeName, projectName);
                        if (RefactorProposalUtility.isMoveInnerAvailable(typeDecl)) {
                            moveTypeInfo.addDestinationKind("newFile");
                        }
                        if (RefactorProposalUtility.isMoveStaticMemberAvailable(node)) {
                            moveTypeInfo.addDestinationKind("class");
                        }
                        if (moveTypeInfo.isMoveAvaiable()) {
                            CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(MOVE_TYPE_COMMAND, params, moveTypeInfo));
                            return Collections.singletonList(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.move"));
                        }
                        CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(MOVE_FILE_COMMAND, params, new MoveFileInfo(uri)));
                        return Collections.singletonList(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.move"));
                    }
                    if (JdtFlags.isStatic((BodyDeclaration)((BodyDeclaration)node))) {
                        if (RefactorProposalUtility.isMoveStaticMemberAvailable(node)) {
                            CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(MOVE_STATIC_MEMBER_COMMAND, params, new MoveMemberInfo(displayName, memberType, enclosingTypeName, projectName)));
                            return Collections.singletonList(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.move"));
                        }
                    } else if (node instanceof MethodDeclaration && RefactorProposalUtility.isMoveMethodAvailable(methodDecl = (MethodDeclaration)node)) {
                        CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(MOVE_INSTANCE_METHOD_COMMAND, params, new MoveMemberInfo(displayName)));
                        return Collections.singletonList(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.move"));
                    }
                }
            }
            catch (JavaModelException displayName) {
                // empty catch block
            }
            return Collections.emptyList();
        }
        if (alwaysShowMove) {
            CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(ActionMessages.MoveRefactoringAction_label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(MOVE_FILE_COMMAND, params, new MoveFileInfo(uri)));
            return Collections.singletonList(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.move"));
        }
        return Collections.emptyList();
    }

    /*
     * Unable to fully structure code
     */
    private static ASTNode getDeclarationNode(ASTNode node, boolean alwaysShowMove) {
        block4: {
            block3: {
                if (node == null) {
                    return null;
                }
                if (!alwaysShowMove) break block3;
                while (node != null && !(node instanceof BodyDeclaration)) {
                    node = node.getParent();
                }
                break block4;
            }
            if (!(node instanceof BodyDeclaration)) ** GOTO lbl12
            return null;
lbl-1000:
            // 1 sources

            {
                node = node.getParent();
lbl12:
                // 2 sources

                ** while (node != null && !(node instanceof BodyDeclaration) && !(node instanceof Statement))
            }
        }
        return node;
    }

    private static boolean isMoveMethodAvailable(MethodDeclaration declaration) throws JavaModelException {
        IMethod method;
        IMethodBinding methodBinding = declaration.resolveBinding();
        IMethod iMethod = method = methodBinding == null ? null : (IMethod)methodBinding.getJavaElement();
        return method != null && RefactoringAvailabilityTesterCore.isMoveMethodAvailable((IMethod)method);
    }

    private static boolean isMoveStaticMemberAvailable(ASTNode declaration) throws JavaModelException {
        if (declaration instanceof MethodDeclaration) {
            MethodDeclaration methodDecl = (MethodDeclaration)declaration;
            IMethodBinding method = methodDecl.resolveBinding();
            return method != null && RefactoringAvailabilityTesterCore.isMoveStaticAvailable((IMember)((IMember)method.getJavaElement()));
        }
        if (declaration instanceof FieldDeclaration) {
            FieldDeclaration fieldDecl = (FieldDeclaration)declaration;
            ArrayList<IField> members = new ArrayList<IField>();
            for (Object fragment : fieldDecl.fragments()) {
                IVariableBinding variable = ((VariableDeclarationFragment)fragment).resolveBinding();
                if (variable == null) continue;
                members.add((IField)variable.getJavaElement());
            }
            return RefactoringAvailabilityTesterCore.isMoveStaticMembersAvailable((IMember[])members.toArray(new IMember[0]));
        }
        if (declaration instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)declaration;
            ITypeBinding type = typeDecl.resolveBinding();
            return type != null && RefactoringAvailabilityTesterCore.isMoveStaticAvailable((IMember)((IType)type.getJavaElement()));
        }
        return false;
    }

    private static boolean isMoveInnerAvailable(AbstractTypeDeclaration declaration) throws JavaModelException {
        ITypeBinding type = declaration.resolveBinding();
        if (type != null) {
            return RefactoringAvailabilityTesterCore.isMoveInnerAvailable((IType)((IType)type.getJavaElement()));
        }
        return false;
    }

    private static String getDisplayName(ASTNode declaration) {
        if (declaration instanceof MethodDeclaration) {
            MethodDeclaration methodDecl = (MethodDeclaration)declaration;
            IMethodBinding method = methodDecl.resolveBinding();
            if (method != null) {
                String name = method.getName();
                CharSequence[] parameters = (String[])Stream.of(method.getParameterTypes()).map(type -> type.getName()).toArray(String[]::new);
                return name + "(" + String.join((CharSequence)",", parameters) + ")";
            }
        } else {
            AbstractTypeDeclaration typeDecl;
            ITypeBinding type2;
            if (declaration instanceof FieldDeclaration) {
                FieldDeclaration fieldDecl = (FieldDeclaration)declaration;
                ArrayList<String> fieldNames = new ArrayList<String>();
                for (Object fragment : fieldDecl.fragments()) {
                    IVariableBinding variable = ((VariableDeclarationFragment)fragment).resolveBinding();
                    if (variable == null) continue;
                    fieldNames.add(variable.getName());
                }
                return String.join((CharSequence)",", fieldNames);
            }
            if (declaration instanceof AbstractTypeDeclaration && (type2 = (typeDecl = (AbstractTypeDeclaration)declaration).resolveBinding()) != null) {
                return type2.getName();
            }
        }
        return null;
    }

    private static String getEnclosingType(ASTNode declaration) {
        ASTNode node = declaration == null ? null : declaration.getParent();
        ITypeBinding type = ASTNodes.getEnclosingType((ASTNode)node);
        return type == null ? null : type.getQualifiedName();
    }

    public static List<ProposalKindWrapper> getExtractVariableProposals(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, boolean inferSelectionSupport) throws CoreException {
        return RefactorProposalUtility.getExtractVariableProposals(params, context, problemsAtLocation, false, inferSelectionSupport);
    }

    public static List<ProposalKindWrapper> getExtractVariableCommandProposals(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, boolean inferSelectionSupport) throws CoreException {
        return RefactorProposalUtility.getExtractVariableProposals(params, context, problemsAtLocation, true, inferSelectionSupport);
    }

    public static ProposalKindWrapper getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, boolean inferSelectionSupport) throws CoreException {
        return RefactorProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, null, false, inferSelectionSupport);
    }

    public static ProposalKindWrapper getExtractMethodCommandProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, boolean inferSelectionSupport) throws CoreException {
        return RefactorProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, null, true, inferSelectionSupport);
    }

    private static List<ProposalKindWrapper> getExtractVariableProposals(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        if (!RefactorProposalUtility.supportsExtractVariable(context)) {
            return null;
        }
        ArrayList<ProposalKindWrapper> proposals = new ArrayList<ProposalKindWrapper>();
        ProposalKindWrapper proposal = RefactorProposalUtility.getExtractVariableAllOccurrenceProposal(params, context, problemsAtLocation, null, returnAsCommand, inferSelectionSupport);
        if (proposal != null) {
            proposals.add(proposal);
        }
        if ((proposal = RefactorProposalUtility.getExtractVariableProposal(params, context, problemsAtLocation, null, returnAsCommand, inferSelectionSupport)) != null) {
            proposals.add(proposal);
        }
        if ((proposal = RefactorProposalUtility.getExtractConstantProposal(params, context, problemsAtLocation, null, returnAsCommand, inferSelectionSupport)) != null) {
            proposals.add(proposal);
        }
        return proposals;
    }

    private static boolean supportsExtractVariable(IInvocationContext context) {
        Expression expression;
        ITypeBinding binding;
        ASTNode node = context.getCoveredNode();
        if (!(node instanceof Expression)) {
            if (context.getSelectionLength() != 0) {
                return false;
            }
            node = context.getCoveringNode();
            if (!(node instanceof Expression)) {
                return false;
            }
        }
        if ((binding = (expression = (Expression)node).resolveTypeBinding()) == null || Bindings.isVoidType((ITypeBinding)binding)) {
            return false;
        }
        try {
            boolean isUnnamedClass = List.of(context.getCompilationUnit().getTypes()).stream().anyMatch(t -> JDTUtils.isUnnamedClass((IJavaElement)t));
            if (isUnnamedClass) {
                return false;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return true;
    }

    public static ProposalKindWrapper getExtractVariableAllOccurrenceProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand) throws CoreException {
        return RefactorProposalUtility.getExtractVariableAllOccurrenceProposal(params, context, problemsAtLocation, formatterOptions, returnAsCommand, false);
    }

    private static ProposalKindWrapper getExtractVariableAllOccurrenceProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        String label = CorrectionMessages.QuickAssistProcessor_extract_to_local_all_description;
        int relevance = context.getSelectionLength() == 0 ? 0 : (problemsAtLocation ? 3 : 6);
        if (inferSelectionSupport && context.getSelectionLength() == 0) {
            ASTNode parent = context.getCoveringNode();
            while (parent != null && parent instanceof Expression) {
                if (parent instanceof ParenthesizedExpression) {
                    parent = parent.getParent();
                    continue;
                }
                ExtractTempRefactoring refactoring = new ExtractTempRefactoring(context.getASTRoot(), parent.getStartPosition(), parent.getLength());
                if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_VARIABLE_ALL_OCCURRENCE_COMMAND, params));
                    return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.variable");
                }
                parent = parent.getParent();
            }
            return null;
        }
        ExtractTempRefactoring extractTempRefactoring = new ExtractTempRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength(), formatterOptions);
        if (extractTempRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            if (returnAsCommand) {
                CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_VARIABLE_ALL_OCCURRENCE_COMMAND, params));
                return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.variable");
            }
            extractTempRefactoring.setReplaceAllOccurrences(true);
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractTempRefactoring.setLinkedProposalModel(linkedProposalModel);
            extractTempRefactoring.setCheckResultForCompileProblems(false);
            RefactoringCorrectionProposalCore proposal = new RefactoringCorrectionProposalCore(label, cu, (Refactoring)extractTempRefactoring, relevance){

                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractTempRefactoring etr = (ExtractTempRefactoring)refactoring;
                    etr.setTempName(etr.guessTempName());
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.variable");
        }
        return null;
    }

    public static ProposalKindWrapper getExtractVariableProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand) throws CoreException {
        return RefactorProposalUtility.getExtractVariableProposal(params, context, problemsAtLocation, formatterOptions, returnAsCommand, false);
    }

    private static ProposalKindWrapper getExtractVariableProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        String label = CorrectionMessages.QuickAssistProcessor_extract_to_local_description;
        int relevance = context.getSelectionLength() == 0 ? -1 : (problemsAtLocation ? 2 : 5);
        if (inferSelectionSupport && context.getSelectionLength() == 0) {
            ASTNode parent = context.getCoveringNode();
            while (parent != null && parent instanceof Expression) {
                if (parent instanceof ParenthesizedExpression) {
                    parent = parent.getParent();
                    continue;
                }
                ExtractTempRefactoring refactoring = new ExtractTempRefactoring(context.getASTRoot(), parent.getStartPosition(), parent.getLength());
                if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_VARIABLE_COMMAND, params));
                    return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.variable");
                }
                parent = parent.getParent();
            }
            return null;
        }
        ExtractTempRefactoring extractTempRefactoringSelectedOnly = new ExtractTempRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength(), formatterOptions);
        extractTempRefactoringSelectedOnly.setReplaceAllOccurrences(false);
        if (extractTempRefactoringSelectedOnly.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            if (returnAsCommand) {
                CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_VARIABLE_COMMAND, params));
                return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.variable");
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractTempRefactoringSelectedOnly.setLinkedProposalModel(linkedProposalModel);
            extractTempRefactoringSelectedOnly.setCheckResultForCompileProblems(false);
            RefactoringCorrectionProposalCore proposal = new RefactoringCorrectionProposalCore(label, cu, (Refactoring)extractTempRefactoringSelectedOnly, relevance){

                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractTempRefactoring etr = (ExtractTempRefactoring)refactoring;
                    etr.setTempName(etr.guessTempName());
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.variable");
        }
        return null;
    }

    public static boolean containsMatchingProblem(IProblemLocation[] locations, int problemId) {
        if (locations != null) {
            IProblemLocation[] iProblemLocationArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                IProblemLocation location = iProblemLocationArray[n2];
                if ("org.eclipse.jdt.core.problem".equals(location.getMarkerType()) && location.getProblemId() == problemId) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static ProposalKindWrapper getAssignVariableProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand, IProblemLocation[] locations) throws CoreException {
        ASTNode node = context.getCoveringNode();
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (!(statement instanceof ExpressionStatement)) {
            return null;
        }
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        Expression expression = expressionStatement.getExpression();
        if (expression.getNodeType() == 7) {
            return null;
        }
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        if ((typeBinding = Bindings.normalizeTypeBinding((ITypeBinding)typeBinding)) == null) {
            return null;
        }
        if (RefactorProposalUtility.containsMatchingProblem(locations, 536871060)) {
            return null;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        int relevance = context.getSelectionLength() == 0 ? -1 : (problemsAtLocation ? 2 : 5);
        if (returnAsCommand) {
            AssignToVariableAssistCommandProposal p = new AssignToVariableAssistCommandProposal(cu, 1, expressionStatement, typeBinding, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(ASSIGN_VARIABLE_COMMAND, params));
            return CodeActionHandler.wrap((ChangeCorrectionProposalCore)p, "refactor.assign.variable");
        }
        AssignToVariableAssistProposalCore p = new AssignToVariableAssistProposalCore(cu, 1, expressionStatement, typeBinding, relevance, false);
        return CodeActionHandler.wrap((ChangeCorrectionProposalCore)p, "refactor.assign.variable");
    }

    public static ProposalKindWrapper getAssignFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand, IProblemLocation[] locations) throws CoreException {
        ASTNode node = context.getCoveringNode();
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (!(statement instanceof ExpressionStatement)) {
            return null;
        }
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        Expression expression = expressionStatement.getExpression();
        if (expression.getNodeType() == 7) {
            return null;
        }
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        if ((typeBinding = Bindings.normalizeTypeBinding((ITypeBinding)typeBinding)) == null) {
            return null;
        }
        if (RefactorProposalUtility.containsMatchingProblem(locations, 536871060)) {
            return null;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode type = ASTResolving.findParentType((ASTNode)expression);
        if (type != null) {
            int relevance = context.getSelectionLength() == 0 ? -1 : (problemsAtLocation ? 2 : 5);
            if (returnAsCommand) {
                AssignToVariableAssistCommandProposal proposal = new AssignToVariableAssistCommandProposal(cu, 2, expressionStatement, typeBinding, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(ASSIGN_FIELD_COMMAND, params));
                return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.assign.field");
            }
            AssignToVariableAssistProposalCore proposal = new AssignToVariableAssistProposalCore(cu, 2, expressionStatement, typeBinding, relevance, false);
            return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.assign.field");
        }
        return null;
    }

    public static ProposalKindWrapper getGenericExtractFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, String initializeIn, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        ProposalKindWrapper proposal = RefactorProposalUtility.getConvertVariableToFieldProposal(params, context, problemsAtLocation, formatterOptions, initializeIn, returnAsCommand);
        if (proposal != null) {
            return proposal;
        }
        return RefactorProposalUtility.getExtractFieldProposal(params, context, problemsAtLocation, formatterOptions, initializeIn, returnAsCommand, inferSelectionSupport);
    }

    public static ProposalKindWrapper getExtractFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, String initializeIn, boolean returnAsCommand) throws CoreException {
        return RefactorProposalUtility.getExtractFieldProposal(params, context, problemsAtLocation, formatterOptions, initializeIn, returnAsCommand, false);
    }

    private static ProposalKindWrapper getExtractFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, String initializeIn, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        if (!RefactorProposalUtility.supportsExtractVariable(context)) {
            return null;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        String label = CorrectionMessages.QuickAssistProcessor_extract_to_field_description;
        int relevance = context.getSelectionLength() == 0 ? -1 : (problemsAtLocation ? 2 : 5);
        if (context.getSelectionLength() == 0 && inferSelectionSupport) {
            ASTNode parent = context.getCoveringNode();
            while (parent != null && parent instanceof Expression) {
                if (parent instanceof ParenthesizedExpression) {
                    parent = parent.getParent();
                    continue;
                }
                ExtractFieldRefactoring refactoring = new ExtractFieldRefactoring(context.getASTRoot(), parent.getStartPosition(), parent.getLength());
                if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    List<String> scopes;
                    InitializeScope scope = InitializeScope.fromName(initializeIn);
                    if (scope != null) {
                        refactoring.setInitializeIn(scope.ordinal());
                    }
                    if (!(scopes = RefactorProposalUtility.getInitializeScopes(refactoring)).isEmpty()) {
                        CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_FIELD_COMMAND, params));
                        return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.field");
                    }
                }
                parent = parent.getParent();
            }
            return null;
        }
        ExtractFieldRefactoring extractFieldRefactoringSelectedOnly = new ExtractFieldRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength());
        extractFieldRefactoringSelectedOnly.setFormatterOptions(formatterOptions);
        if (extractFieldRefactoringSelectedOnly.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            InitializeScope scope = InitializeScope.fromName(initializeIn);
            if (scope != null) {
                extractFieldRefactoringSelectedOnly.setInitializeIn(scope.ordinal());
            }
            if (returnAsCommand) {
                List<String> scopes = RefactorProposalUtility.getInitializeScopes(extractFieldRefactoringSelectedOnly);
                CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_FIELD_COMMAND, params, new ExtractFieldInfo(scopes)));
                return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.field");
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractFieldRefactoringSelectedOnly.setLinkedProposalModel(linkedProposalModel);
            RefactoringCorrectionProposalCore proposal = new RefactoringCorrectionProposalCore(label, cu, extractFieldRefactoringSelectedOnly, relevance){

                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractFieldRefactoring etr = (ExtractFieldRefactoring)refactoring;
                    etr.setFieldName(etr.guessFieldName());
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.field");
        }
        return null;
    }

    public static List<String> getInitializeScopes(ExtractFieldRefactoring refactoring) throws CoreException {
        ArrayList<String> scopes = new ArrayList<String>();
        if (refactoring.canEnableSettingDeclareInMethod()) {
            scopes.add(InitializeScope.CURRENT_METHOD.getName());
        }
        if (refactoring.canEnableSettingDeclareInFieldDeclaration()) {
            scopes.add(InitializeScope.FIELD_DECLARATION.getName());
        }
        if (refactoring.canEnableSettingDeclareInConstructors()) {
            scopes.add(InitializeScope.CLASS_CONSTRUCTORS.getName());
        }
        return scopes;
    }

    public static ProposalKindWrapper getExtractConstantProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand) throws CoreException {
        return RefactorProposalUtility.getExtractConstantProposal(params, context, problemsAtLocation, formatterOptions, returnAsCommand, false);
    }

    private static ProposalKindWrapper getExtractConstantProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        String label = CorrectionMessages.QuickAssistProcessor_extract_to_constant_description;
        int relevance = context.getSelectionLength() == 0 ? -2 : (problemsAtLocation ? 1 : 4);
        if (inferSelectionSupport && context.getSelectionLength() == 0) {
            ASTNode parent = context.getCoveringNode();
            while (parent != null && parent instanceof Expression) {
                if (parent instanceof ParenthesizedExpression) {
                    parent = parent.getParent();
                    continue;
                }
                ExtractConstantRefactoring refactoring = new ExtractConstantRefactoring(context.getASTRoot(), parent.getStartPosition(), parent.getLength());
                if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_CONSTANT_COMMAND, params));
                    return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.constant");
                }
                parent = parent.getParent();
            }
            return null;
        }
        ExtractConstantRefactoring extractConstRefactoring = new ExtractConstantRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength(), formatterOptions);
        if (extractConstRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            if (returnAsCommand) {
                CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_CONSTANT_COMMAND, params));
                return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.constant");
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractConstRefactoring.setLinkedProposalModel(linkedProposalModel);
            extractConstRefactoring.setCheckResultForCompileProblems(false);
            RefactoringCorrectionProposalCore proposal = new RefactoringCorrectionProposalCore(label, cu, (Refactoring)extractConstRefactoring, relevance){

                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractConstantRefactoring etr = (ExtractConstantRefactoring)refactoring;
                    etr.setConstantName(etr.guessConstantName());
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.constant");
        }
        return null;
    }

    public static ProposalKindWrapper getConvertVariableToFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, String initializeIn, boolean returnAsCommand) throws CoreException {
        SimpleName name;
        IBinding binding;
        ASTNode node = context.getCoveredNode();
        if (!(node instanceof SimpleName)) {
            if (context.getSelectionLength() != 0) {
                return null;
            }
            node = context.getCoveringNode();
            if (!(node instanceof SimpleName)) {
                return null;
            }
        }
        if (!((binding = (name = (SimpleName)node).resolveBinding()) instanceof IVariableBinding)) {
            return null;
        }
        IVariableBinding varBinding = (IVariableBinding)binding;
        if (varBinding.isField() || varBinding.isParameter()) {
            return null;
        }
        ASTNode decl = context.getASTRoot().findDeclaringNode((IBinding)varBinding);
        if (decl == null || decl.getLocationInParent() != VariableDeclarationStatement.FRAGMENTS_PROPERTY) {
            return null;
        }
        PromoteTempToFieldRefactoring refactoring = new PromoteTempToFieldRefactoring((VariableDeclaration)decl);
        refactoring.setFormatterOptions(formatterOptions);
        if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            InitializeScope scope = InitializeScope.fromName(initializeIn);
            if (scope != null) {
                refactoring.setInitializeIn(scope.ordinal());
            }
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_field_description;
            if (returnAsCommand) {
                ArrayList<String> scopes = new ArrayList<String>();
                if (refactoring.canEnableSettingDeclareInMethod()) {
                    scopes.add(InitializeScope.CURRENT_METHOD.getName());
                }
                if (refactoring.canEnableSettingDeclareInFieldDeclaration()) {
                    scopes.add(InitializeScope.FIELD_DECLARATION.getName());
                }
                if (refactoring.canEnableSettingDeclareInConstructors()) {
                    scopes.add(InitializeScope.CLASS_CONSTRUCTORS.getName());
                }
                CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, context.getCompilationUnit(), 5, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(CONVERT_VARIABLE_TO_FIELD_COMMAND, params, new ExtractFieldInfo(scopes)));
                return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.field");
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            refactoring.setLinkedProposalModel(linkedProposalModel);
            RefactoringCorrectionProposalCore proposal = new RefactoringCorrectionProposalCore(label, context.getCompilationUnit(), (Refactoring)refactoring, 5){

                protected void init(Refactoring refactoring) throws CoreException {
                    PromoteTempToFieldRefactoring etr = (PromoteTempToFieldRefactoring)refactoring;
                    String[] names = etr.guessFieldNames();
                    if (names.length > 0) {
                        etr.setFieldName(names[0]);
                    }
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.field");
        }
        return null;
    }

    public static ProposalKindWrapper getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Map formattingOptions, boolean returnAsCommand) throws CoreException {
        return RefactorProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, formattingOptions, returnAsCommand, false);
    }

    private static ProposalKindWrapper getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Map formattingOptions, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        int relevance;
        if (!(coveringNode instanceof Expression || coveringNode instanceof Statement || coveringNode instanceof Block)) {
            return null;
        }
        if (coveringNode instanceof Block) {
            List statements = ((Block)coveringNode).statements();
            int startIndex = RefactorProposalUtility.getIndex(context.getSelectionOffset(), statements);
            if (startIndex == -1) {
                return null;
            }
            int endIndex = RefactorProposalUtility.getIndex(context.getSelectionOffset() + context.getSelectionLength(), statements);
            if (endIndex == -1 || endIndex <= startIndex) {
                return null;
            }
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractMethodRefactoring extractMethodRefactoring = new ExtractMethodRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength(), formattingOptions);
        String suggestedName = RefactorProposalUtility.proposeMethodNameHeuristic(context, coveringNode);
        String uniqueMethodName = RefactorProposalUtility.getUniqueMethodName(coveringNode, suggestedName);
        extractMethodRefactoring.setMethodName(uniqueMethodName);
        String label = CorrectionMessages.QuickAssistProcessor_extractmethod_description;
        int n = relevance = problemsAtLocation ? 1 : 4;
        if (context.getSelectionLength() == 0) {
            if (!inferSelectionSupport) {
                return null;
            }
            ASTNode parent = coveringNode;
            while (parent != null && parent instanceof Expression) {
                if (parent instanceof ParenthesizedExpression) {
                    parent = parent.getParent();
                    continue;
                }
                ExtractMethodRefactoring refactoring = new ExtractMethodRefactoring(context.getASTRoot(), parent.getStartPosition(), parent.getLength(), formattingOptions);
                if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_METHOD_COMMAND, params));
                    return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.function");
                }
                parent = parent.getParent();
            }
            return null;
        }
        if (extractMethodRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            if (returnAsCommand) {
                CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_METHOD_COMMAND, params));
                return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.function");
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractMethodRefactoring.setLinkedProposalModel(linkedProposalModel);
            RefactoringCorrectionProposalCore proposal = new RefactoringCorrectionProposalCore(label, cu, (Refactoring)extractMethodRefactoring, relevance);
            proposal.setLinkedProposalModel(linkedProposalModel);
            return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.extract.function");
        }
        return null;
    }

    private static String proposeMethodNameHeuristic(IInvocationContext context, ASTNode coveringNode) {
        Expression leftHandSide;
        IProblem problem;
        NodeFinder finder;
        ASTNode nodeVar;
        int selStart = context.getSelectionOffset();
        int selEnd = context.getSelectionOffset() + context.getSelectionLength();
        CompilationUnit cu = context.getASTRoot();
        Optional<IProblem> res = Arrays.asList(cu.getProblems()).stream().filter(p -> p.getID() == 536870973).filter(p -> p.getSourceStart() >= selStart && p.getSourceEnd() <= selEnd).max((p1, p2) -> p1.getSourceStart() - p2.getSourceStart());
        if (res.isPresent() && (nodeVar = (finder = new NodeFinder((ASTNode)cu, (problem = res.get()).getSourceStart(), problem.getSourceEnd() - problem.getSourceStart())).getCoveringNode()) instanceof SimpleName) {
            return "get" + StringUtils.capitalize((String)((SimpleName)nodeVar).getIdentifier());
        }
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength((int)context.getSelectionOffset(), (int)context.getSelectionLength()), true);
        cu.accept((ASTVisitor)analyzer);
        List varDeclStatements = Arrays.asList(analyzer.getSelectedNodes()).stream().filter(e -> e.getNodeType() == 60).collect(Collectors.toList());
        if (varDeclStatements.isEmpty() && coveringNode.getNodeType() == 60) {
            varDeclStatements.add(coveringNode);
        } else if (coveringNode.getNodeType() == 21 && ((ExpressionStatement)coveringNode).getExpression().getNodeType() == 7 && (leftHandSide = ((Assignment)((ExpressionStatement)coveringNode).getExpression()).getLeftHandSide()).getNodeType() == 42) {
            return "get" + StringUtils.capitalize((String)((SimpleName)leftHandSide).getIdentifier());
        }
        if (!varDeclStatements.isEmpty()) {
            VariableDeclarationStatement lastStatement = (VariableDeclarationStatement)varDeclStatements.get(varDeclStatements.size() - 1);
            List fragments = lastStatement.fragments();
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
            String identifier = fragment.getName().getIdentifier();
            return "get" + StringUtils.capitalize((String)identifier);
        }
        return "extracted";
    }

    public static ProposalKindWrapper getIntroduceParameterRefactoringProposals(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean returnAsCommand, IProblemLocation[] problemLocations) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        boolean isUnnamedClass = List.of(cu.getTypes()).stream().anyMatch(t -> JDTUtils.isUnnamedClass((IJavaElement)t));
        if (isUnnamedClass) {
            return null;
        }
        IntroduceParameterRefactoring introduceParameterRefactoring = new IntroduceParameterRefactoring(cu, context.getSelectionOffset(), context.getSelectionLength());
        LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
        introduceParameterRefactoring.setLinkedProposalModel(linkedProposalModel);
        if (introduceParameterRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            int relevance;
            introduceParameterRefactoring.setParameterName(introduceParameterRefactoring.guessedParameterName());
            String label = RefactoringCoreMessages.IntroduceParameterRefactoring_name + "...";
            int n = relevance = problemLocations != null && problemLocations.length > 0 ? 1 : 4;
            if (returnAsCommand) {
                CUCorrectionCommandProposal proposal = new CUCorrectionCommandProposal(label, cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(INTRODUCE_PARAMETER_COMMAND, params));
                return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.introduce.parameter");
            }
            RefactoringCorrectionProposalCore proposal = new RefactoringCorrectionProposalCore(label, cu, (Refactoring)introduceParameterRefactoring, relevance);
            proposal.setLinkedProposalModel(linkedProposalModel);
            return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor.introduce.parameter");
        }
        return null;
    }

    public static ProposalKindWrapper getExtractInterfaceProposal(CodeActionParams params, IInvocationContext context) {
        ICompilationUnit cu = context.getCompilationUnit();
        if (cu == null) {
            return null;
        }
        IType type = cu.findPrimaryType();
        if (type == null) {
            return null;
        }
        try {
            CodeGenerationSettings settings = PreferenceManager.getCodeGenerationSettings(cu);
            ExtractInterfaceProcessor processor = new ExtractInterfaceProcessor(type, settings);
            if (RefactoringAvailabilityTesterCore.isExtractInterfaceAvailable((IType)type) && processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                CUCorrectionCommandProposal p = new CUCorrectionCommandProposal(CorrectionMessages.RefactorProcessor_extract_interface, cu, 7, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_INTERFACE_COMMAND, params));
                return CodeActionHandler.wrap((ChangeCorrectionProposalCore)p, "refactor.extract.interface");
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static ProposalKindWrapper getChangeSignatureProposal(CodeActionParams params, IInvocationContext context) {
        ICompilationUnit cu = context.getCompilationUnit();
        if (cu == null) {
            return null;
        }
        ASTNode methodNode = CodeActionUtility.inferASTNode(context.getCoveringNode(), MethodDeclaration.class);
        if (methodNode == null) {
            return null;
        }
        IMethodBinding methodBinding = ((MethodDeclaration)methodNode).resolveBinding();
        if (methodBinding == null) {
            return null;
        }
        IJavaElement element = methodBinding.getJavaElement();
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            try {
                ChangeSignatureProcessor processor = new ChangeSignatureProcessor(method);
                if (RefactoringAvailabilityTesterCore.isChangeSignatureAvailable((IMethod)method) && processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    Object info3;
                    ArrayList<ChangeSignatureHandler.MethodParameter> parameters = new ArrayList<ChangeSignatureHandler.MethodParameter>();
                    for (ParameterInfo info2 : processor.getParameterInfos()) {
                        parameters.add(new ChangeSignatureHandler.MethodParameter(info2.getOldTypeName(), info2.getOldName(), info2.getDefaultValue() == null ? "null" : info2.getDefaultValue(), info2.getOldIndex()));
                    }
                    ArrayList<ChangeSignatureHandler.MethodException> exceptions = new ArrayList<ChangeSignatureHandler.MethodException>();
                    for (Object info3 : processor.getExceptionInfos()) {
                        exceptions.add(new ChangeSignatureHandler.MethodException(info3.getFullyQualifiedName(), info3.getElement().getHandleIdentifier()));
                    }
                    info3 = new ChangeSignatureInfo(method.getHandleIdentifier(), JdtFlags.getVisibilityString((int)processor.getVisibility()), processor.getReturnTypeString(), method.getElementName(), (ChangeSignatureHandler.MethodParameter[])parameters.toArray(ChangeSignatureHandler.MethodParameter[]::new), (ChangeSignatureHandler.MethodException[])exceptions.toArray(ChangeSignatureHandler.MethodException[]::new));
                    String label = Messages.format(org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringCoreMessages.ChangeSignatureRefactoring_change_signature_for, new String[]{method.getElementName()});
                    CUCorrectionCommandProposal p1 = new CUCorrectionCommandProposal(label, cu, 7, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(CHANGE_SIGNATURE_COMMAND, params, info3));
                    return CodeActionHandler.wrap((ChangeCorrectionProposalCore)p1, "refactor.change.signature");
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e);
            }
        }
        return null;
    }

    public static String getUniqueMethodName(ASTNode astNode, String suggestedName) throws JavaModelException {
        while (astNode != null && !(astNode instanceof TypeDeclaration) && !(astNode instanceof AnonymousClassDeclaration)) {
            astNode = astNode.getParent();
        }
        if (astNode instanceof TypeDeclaration) {
            TypeDeclaration typeDecl = (TypeDeclaration)astNode;
            ITypeBinding typeBinding = typeDecl.resolveBinding();
            if (typeBinding == null) {
                return suggestedName;
            }
            IType type = (IType)typeBinding.getJavaElement();
            if (type == null) {
                return suggestedName;
            }
            IMethod[] methods = type.getMethods();
            int suggestedPostfix = 2;
            Object resultName = suggestedName;
            while (suggestedPostfix < 1000) {
                if (!RefactorProposalUtility.hasMethod(methods, (String)resultName)) {
                    return resultName;
                }
                resultName = suggestedName + suggestedPostfix++;
            }
        }
        return suggestedName;
    }

    private static boolean hasMethod(IMethod[] methods, String name) {
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (name.equals(method.getElementName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static int getIndex(int offset, List<Statement> statements) {
        int i = 0;
        while (i < statements.size()) {
            Statement s = statements.get(i);
            if (offset <= s.getStartPosition()) {
                return i;
            }
            if (offset < s.getStartPosition() + s.getLength()) {
                return -1;
            }
            ++i;
        }
        return statements.size();
    }

    public static class ChangeSignatureInfo {
        public String methodIdentifier;
        public String modifier;
        public String returnType;
        public String methodName;
        public ChangeSignatureHandler.MethodParameter[] parameters;
        public ChangeSignatureHandler.MethodException[] exceptions;

        public ChangeSignatureInfo(String methodIdentifier, String modifier, String returnType, String methodName, ChangeSignatureHandler.MethodParameter[] parameters, ChangeSignatureHandler.MethodException[] exceptions) {
            this.methodIdentifier = methodIdentifier;
            this.modifier = modifier;
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameters = parameters;
            this.exceptions = exceptions;
        }
    }

    public static class ExtractFieldInfo {
        List<String> initializedScopes;

        public ExtractFieldInfo(List<String> scopes) {
            this.initializedScopes = scopes;
        }
    }

    public static enum InitializeScope {
        FIELD_DECLARATION("Field declaration"),
        CURRENT_METHOD("Current method"),
        CLASS_CONSTRUCTORS("Class constructors");

        private final String name;

        private InitializeScope(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static InitializeScope fromName(String name) {
            if (name != null) {
                InitializeScope[] initializeScopeArray = InitializeScope.values();
                int n = initializeScopeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    InitializeScope scope = initializeScopeArray[n2];
                    if (scope.name.equals(name)) {
                        return scope;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }

    public static class MoveFileInfo {
        public String uri;

        public MoveFileInfo(String uri) {
            this.uri = uri;
        }
    }

    public static class MoveMemberInfo {
        public String displayName;
        public int memberType;
        public String enclosingTypeName;
        public String projectName;

        public MoveMemberInfo(String displayName, int memberType, String enclosingTypeName, String projectName) {
            this.displayName = displayName;
            this.memberType = memberType;
            this.enclosingTypeName = enclosingTypeName;
            this.projectName = projectName;
        }

        public MoveMemberInfo(String displayName, String enclosingTypeName, String projectName) {
            this(displayName, 0, enclosingTypeName, projectName);
        }

        public MoveMemberInfo(String displayName) {
            this.displayName = displayName;
        }
    }

    public static class MoveTypeInfo
    extends MoveMemberInfo {
        public List<String> supportedDestinationKinds = new ArrayList<String>();

        public MoveTypeInfo(String displayName, String enclosingTypeName, String projectName) {
            super(displayName, 55, enclosingTypeName, projectName);
        }

        public void addDestinationKind(String kind) {
            this.supportedDestinationKinds.add(kind);
        }

        public boolean isMoveAvaiable() {
            return !this.supportedDestinationKinds.isEmpty();
        }
    }
}

