/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.lsp4j.Range;

public class DiagnosticsHelper {
    public static int getEndOffset(ICompilationUnit unit, Range range) {
        try {
            return JsonRpcHelpers.toOffset(unit.getBuffer(), range.getEnd().getLine(), range.getEnd().getCharacter());
        }
        catch (JavaModelException e) {
            return -1;
        }
    }

    public static int getStartOffset(ICompilationUnit unit, Range range) {
        try {
            return JsonRpcHelpers.toOffset(unit.getBuffer(), range.getStart().getLine(), range.getStart().getCharacter());
        }
        catch (JavaModelException e) {
            return -1;
        }
    }

    public static int getLength(ICompilationUnit unit, Range range) {
        int start = DiagnosticsHelper.getStartOffset(unit, range);
        int end = DiagnosticsHelper.getEndOffset(unit, range);
        return end - start;
    }
}

