/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class LambdaExpressionAndMethodRefFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public LambdaExpressionAndMethodRefFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    public static ICleanUpFix createCleanUp(CompilationUnit unit) {
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> rewriteOperations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        LambdaExpressionFinder finder = new LambdaExpressionFinder(rewriteOperations);
        unit.accept((ASTVisitor)finder);
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.LambdaExpressionAndMethodRefCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]));
    }

    public static LambdaExpressionAndMethodRefFixCore createLambdaExpressionAndMethodRefFix(ASTNode exp) {
        CompilationUnit root = (CompilationUnit)exp.getRoot();
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> rewriteOperations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        LambdaExpressionFinder finder = new LambdaExpressionFinder(rewriteOperations);
        exp.accept((ASTVisitor)finder);
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new LambdaExpressionAndMethodRefFixCore(FixMessages.LambdaExpressionAndMethodRefFix_clean_up_expression_msg, root, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{(CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation)rewriteOperations.get(0)});
    }

    protected LambdaExpressionAndMethodRefFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static enum ActionType {
        DO_NOTHING,
        REMOVE_RETURN,
        CLASS_INSTANCE_REF,
        TYPE_REF,
        SUPER_METHOD_REF,
        METHOD_REF,
        INSTANCEOF_REF;

    }

    public static final class LambdaExpressionFinder
    extends ASTVisitor {
        private final List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> rewriteOperations;

        public LambdaExpressionFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations) {
            super(true);
            this.rewriteOperations = operations;
        }

        public boolean visit(LambdaExpression visited) {
            ActionType actionType = ActionType.DO_NOTHING;
            ITypeBinding classBinding = null;
            boolean removeParamParentheses = this.hasToRemoveParamParentheses(visited);
            Expression bodyExpression = null;
            if (visited.getBody() instanceof Block) {
                ReturnStatement returnStatement = ASTNodes.as((Statement)((Block)visited.getBody()), ReturnStatement.class);
                if (returnStatement != null) {
                    bodyExpression = returnStatement.getExpression();
                    actionType = ActionType.REMOVE_RETURN;
                }
            } else if (visited.getBody() instanceof Expression) {
                bodyExpression = (Expression)visited.getBody();
            }
            if (bodyExpression instanceof ClassInstanceCreation) {
                ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)bodyExpression;
                List arguments = classInstanceCreation.arguments();
                if (visited.parameters().size() == arguments.size() && this.areSameIdentifiers(visited, arguments) && classInstanceCreation.getAnonymousClassDeclaration() == null) {
                    actionType = ActionType.CLASS_INSTANCE_REF;
                }
            } else if (bodyExpression instanceof SuperMethodInvocation) {
                SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)bodyExpression;
                List arguments = superMethodInvocation.arguments();
                if (visited.parameters().size() == arguments.size() && this.areSameIdentifiers(visited, arguments)) {
                    actionType = ActionType.SUPER_METHOD_REF;
                }
            } else if (bodyExpression instanceof MethodInvocation) {
                SimpleName calledObject;
                MethodInvocation methodInvocation = (MethodInvocation)bodyExpression;
                Expression calledExpression = methodInvocation.getExpression();
                List arguments = methodInvocation.arguments();
                if (visited.parameters().size() == arguments.size()) {
                    if (this.areSameIdentifiers(visited, arguments)) {
                        AbstractTypeDeclaration enclosingType;
                        IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                        ITypeBinding calledType = null;
                        if (methodBinding != null) {
                            calledType = methodBinding.getDeclaringClass();
                        } else if (calledExpression != null) {
                            calledType = calledExpression.resolveTypeBinding();
                        } else {
                            ITypeBinding enclosingTypeBinding;
                            enclosingType = ASTNodes.getTypedAncestor((ASTNode)visited, AbstractTypeDeclaration.class);
                            if (enclosingType != null && (enclosingTypeBinding = enclosingType.resolveBinding()) != null) {
                                List argumentTypes = methodInvocation.typeArguments();
                                String[] parameterTypeNames = new String[methodInvocation.arguments().size()];
                                int i = 0;
                                while (i < argumentTypes.size()) {
                                    Type argumentType = (Type)argumentTypes.get(i);
                                    if (argumentType.resolveBinding() == null) {
                                        return true;
                                    }
                                    parameterTypeNames[i] = argumentType.resolveBinding().getQualifiedName();
                                    ++i;
                                }
                                IMethodBinding[] iMethodBindingArray = enclosingTypeBinding.getDeclaredMethods();
                                int n = iMethodBindingArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IMethodBinding declaredMethods = iMethodBindingArray[n2];
                                    if (ASTNodes.usesGivenSignature(declaredMethods, enclosingTypeBinding.getQualifiedName(), methodInvocation.getName().getIdentifier(), parameterTypeNames)) {
                                        calledType = enclosingTypeBinding;
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                        }
                        if (Boolean.TRUE.equals(ASTNodes.isStatic(methodInvocation)) && calledType != null) {
                            boolean valid = true;
                            if (!arguments.isEmpty() && ((Expression)arguments.get(0)).resolveTypeBinding() != null && ((Expression)arguments.get(0)).resolveTypeBinding().isSubTypeCompatible(calledType)) {
                                String[] remainingParams = new String[arguments.size() - 1];
                                int i = 0;
                                while (i < arguments.size() - 1) {
                                    ITypeBinding resolveTypeBinding = ((Expression)arguments.get(i + 1)).resolveTypeBinding();
                                    if (resolveTypeBinding == null) {
                                        valid = false;
                                        break;
                                    }
                                    remainingParams[i] = resolveTypeBinding.getQualifiedName();
                                    ++i;
                                }
                                if (valid) {
                                    IMethodBinding[] iMethodBindingArray = calledType.getDeclaredMethods();
                                    int n = iMethodBindingArray.length;
                                    int resolveTypeBinding = 0;
                                    while (resolveTypeBinding < n) {
                                        IMethodBinding declaredMethodBinding = iMethodBindingArray[resolveTypeBinding];
                                        if (!Modifier.isStatic((int)declaredMethodBinding.getModifiers()) && ASTNodes.usesGivenSignature(declaredMethodBinding, calledType.getQualifiedName(), methodInvocation.getName().getIdentifier(), remainingParams)) {
                                            valid = false;
                                            break;
                                        }
                                        ++resolveTypeBinding;
                                    }
                                }
                            }
                            if (valid) {
                                actionType = ActionType.TYPE_REF;
                                classBinding = calledType;
                            }
                        }
                        if (actionType != ActionType.TYPE_REF) {
                            FieldAccess fieldAccess;
                            if (calledExpression == null) {
                                if (calledType != null && (enclosingType = Bindings.getBindingOfParentType((ASTNode)visited)) != null && Bindings.isSuperType(calledType, (ITypeBinding)enclosingType)) {
                                    actionType = ActionType.METHOD_REF;
                                }
                            } else if (calledExpression instanceof StringLiteral || calledExpression instanceof NumberLiteral || calledExpression instanceof ThisExpression) {
                                actionType = ActionType.METHOD_REF;
                            } else if (calledExpression instanceof FieldAccess) {
                                fieldAccess = (FieldAccess)calledExpression;
                                if (fieldAccess.resolveFieldBinding() != null && fieldAccess.resolveFieldBinding().isEffectivelyFinal()) {
                                    actionType = ActionType.METHOD_REF;
                                }
                            } else if (calledExpression instanceof SuperFieldAccess && (fieldAccess = (SuperFieldAccess)calledExpression).resolveFieldBinding() != null && fieldAccess.resolveFieldBinding().isEffectivelyFinal()) {
                                actionType = ActionType.METHOD_REF;
                            }
                        }
                    }
                } else if (calledExpression instanceof SimpleName && visited.parameters().size() == arguments.size() + 1 && this.isSameIdentifier(visited, 0, calledObject = (SimpleName)calledExpression)) {
                    boolean valid = true;
                    int i = 0;
                    while (i < arguments.size()) {
                        Expression expression = ASTNodes.getUnparenthesedExpression((Expression)arguments.get(i));
                        if (!(expression instanceof SimpleName) || !this.isSameIdentifier(visited, i + 1, (SimpleName)expression)) {
                            valid = false;
                            break;
                        }
                        ++i;
                    }
                    if (valid) {
                        ITypeBinding klass = null;
                        if (calledExpression.resolveTypeBinding() != null) {
                            klass = calledExpression.resolveTypeBinding();
                        } else if (methodInvocation.resolveMethodBinding() != null && methodInvocation.resolveMethodBinding().getDeclaringClass() != null) {
                            klass = methodInvocation.resolveMethodBinding().getDeclaringClass();
                        }
                        if (klass != null) {
                            String[] cumulativeParams = new String[arguments.size() + 1];
                            cumulativeParams[0] = klass.getQualifiedName();
                            int i2 = 0;
                            while (i2 < arguments.size()) {
                                ITypeBinding resolveTypeBinding = ((Expression)arguments.get(i2)).resolveTypeBinding();
                                if (resolveTypeBinding == null) {
                                    valid = false;
                                    break;
                                }
                                cumulativeParams[i2 + 1] = resolveTypeBinding.getQualifiedName();
                                ++i2;
                            }
                            if (valid) {
                                IMethodBinding[] iMethodBindingArray = klass.getDeclaredMethods();
                                int n = iMethodBindingArray.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    IMethodBinding declaredMethodBinding = iMethodBindingArray[n3];
                                    if (Modifier.isStatic((int)declaredMethodBinding.getModifiers()) && ASTNodes.usesGivenSignature(declaredMethodBinding, klass.getQualifiedName(), methodInvocation.getName().getIdentifier(), cumulativeParams)) {
                                        valid = false;
                                        break;
                                    }
                                    ++n3;
                                }
                            }
                            if (valid) {
                                actionType = ActionType.TYPE_REF;
                                classBinding = klass;
                            }
                        }
                    }
                }
            } else if (bodyExpression instanceof InstanceofExpression) {
                InstanceofExpression exp = (InstanceofExpression)bodyExpression;
                Expression leftOp = exp.getLeftOperand();
                if (visited.parameters().size() == 1 && this.areSameIdentifiers(visited, List.of(leftOp)) && exp.getRightOperand().resolveBinding() != null) {
                    actionType = ActionType.INSTANCEOF_REF;
                    classBinding = exp.getRightOperand().resolveBinding();
                }
            }
            if (removeParamParentheses || actionType != ActionType.DO_NOTHING) {
                this.rewriteOperations.add(new ReplaceLambdaOperation(visited, removeParamParentheses, actionType, bodyExpression, classBinding));
                return false;
            }
            return true;
        }

        private boolean hasToRemoveParamParentheses(LambdaExpression node) {
            return node.hasParentheses() && node.parameters().size() == 1 && node.parameters().get(0) instanceof VariableDeclarationFragment;
        }

        private boolean areSameIdentifiers(LambdaExpression node, List<Expression> arguments) {
            int i = 0;
            while (i < node.parameters().size()) {
                Expression expression = ASTNodes.getUnparenthesedExpression(arguments.get(i));
                if (!(expression instanceof SimpleName) || !this.isSameIdentifier(node, i, (SimpleName)expression)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean isSameIdentifier(LambdaExpression node, int i, SimpleName argument) {
            Object param0 = node.parameters().get(i);
            if (param0 instanceof VariableDeclarationFragment) {
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)param0;
                return variableDeclarationFragment.getName().getIdentifier().equals(argument.getIdentifier());
            }
            return false;
        }
    }

    private static class ReplaceLambdaOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final LambdaExpression visited;
        private final boolean removeParentheses;
        private final ActionType action;
        private final Expression bodyExpression;
        private final ITypeBinding classBinding;

        public ReplaceLambdaOperation(LambdaExpression visited, boolean removeParentheses, ActionType action, Expression bodyExpression, ITypeBinding classBinding) {
            this.visited = visited;
            this.removeParentheses = removeParentheses;
            this.action = action;
            this.bodyExpression = bodyExpression;
            this.classBinding = classBinding;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.LambdaExpressionAndMethodRefCleanUp_description, cuRewrite);
            switch (this.action) {
                case REMOVE_RETURN: {
                    LambdaExpression copyOfLambdaExpression2 = ast.newLambdaExpression();
                    this.copyParameters(rewrite, this.visited, copyOfLambdaExpression2);
                    if (this.removeParentheses) {
                        copyOfLambdaExpression2.setParentheses(false);
                    }
                    copyOfLambdaExpression2.setBody((ASTNode)ASTNodeFactory.parenthesizeIfNeeded(ast, ASTNodes.createMoveTarget(rewrite, this.bodyExpression)));
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)copyOfLambdaExpression2, group);
                    break;
                }
                case TYPE_REF: {
                    TypeMethodReference typeMethodRef = ast.newTypeMethodReference();
                    MethodInvocation typeMethodInvocation = (MethodInvocation)this.bodyExpression;
                    typeMethodRef.setType(ReplaceLambdaOperation.copyType(cuRewrite, ast, (ASTNode)typeMethodInvocation, this.classBinding));
                    typeMethodRef.setName(ASTNodes.createMoveTarget(rewrite, typeMethodInvocation.getName()));
                    ASTNode replacementNode1 = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)typeMethodRef);
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, replacementNode1, group);
                    break;
                }
                case METHOD_REF: {
                    ExpressionMethodReference methodRef = ast.newExpressionMethodReference();
                    MethodInvocation methodInvocation = (MethodInvocation)this.bodyExpression;
                    if (methodInvocation.getExpression() != null) {
                        methodRef.setExpression(ASTNodes.createMoveTarget(rewrite, methodInvocation.getExpression()));
                    } else {
                        methodRef.setExpression((Expression)ast.newThisExpression());
                    }
                    methodRef.setName(ASTNodes.createMoveTarget(rewrite, methodInvocation.getName()));
                    ASTNode replacementNode2 = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)methodRef);
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, replacementNode2, group);
                    break;
                }
                case SUPER_METHOD_REF: {
                    SuperMethodReference superMethodRef = ast.newSuperMethodReference();
                    SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)this.bodyExpression;
                    superMethodRef.setName(ASTNodes.createMoveTarget(rewrite, superMethodInvocation.getName()));
                    ASTNode replacementNode3 = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)superMethodRef);
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, replacementNode3, group);
                    break;
                }
                case CLASS_INSTANCE_REF: {
                    CreationReference creationRef = ast.newCreationReference();
                    ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)this.bodyExpression;
                    creationRef.setType(ReplaceLambdaOperation.copyType(cuRewrite, ast, (ASTNode)classInstanceCreation, classInstanceCreation.resolveTypeBinding()));
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)creationRef, group);
                    break;
                }
                case INSTANCEOF_REF: {
                    ExpressionMethodReference instanceOfMethodRef = ast.newExpressionMethodReference();
                    TypeLiteral typeLiteral = ast.newTypeLiteral();
                    typeLiteral.setType(ReplaceLambdaOperation.copyType(cuRewrite, ast, (ASTNode)this.bodyExpression, this.classBinding));
                    instanceOfMethodRef.setExpression((Expression)typeLiteral);
                    instanceOfMethodRef.setName(ast.newSimpleName("isInstance"));
                    ASTNode replacementNode4 = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)instanceOfMethodRef);
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, replacementNode4, group);
                    break;
                }
                default: {
                    LambdaExpression copyOfLambdaExpression = ast.newLambdaExpression();
                    this.copyParameters(rewrite, this.visited, copyOfLambdaExpression);
                    if (this.removeParentheses) {
                        copyOfLambdaExpression.setParentheses(false);
                    }
                    copyOfLambdaExpression.setBody(rewrite.createMoveTarget(this.visited.getBody()));
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)copyOfLambdaExpression, group);
                }
            }
        }

        private ASTNode castMethodRefIfNeeded(CompilationUnitRewrite cuRewrite, AST ast, Expression methodRef) {
            boolean needCast = false;
            Expression replacementNode = methodRef;
            if (this.visited.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY) {
                MethodInvocation parent = (MethodInvocation)this.visited.getParent();
                List args = parent.arguments();
                IMethodBinding parentBinding = parent.resolveMethodBinding();
                if (parentBinding != null) {
                    ITypeBinding parentTypeBinding = parentBinding.getDeclaringClass();
                    while (parentTypeBinding != null) {
                        IMethodBinding[] parentTypeMethods;
                        IMethodBinding[] iMethodBindingArray = parentTypeMethods = parentTypeBinding.getDeclaredMethods();
                        int n = parentTypeMethods.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethodBinding parentTypeMethod = iMethodBindingArray[n2];
                            if (parentTypeMethod.getName().equals(parentBinding.getName()) && !parentTypeMethod.isEqualTo((IBinding)parentBinding)) {
                                needCast = true;
                                break;
                            }
                            ++n2;
                        }
                        if (needCast) break;
                        parentTypeBinding = parentTypeBinding.getSuperclass();
                    }
                    if (needCast) {
                        for (Expression arg : args) {
                            if (arg != this.visited) continue;
                            CastExpression cast = ast.newCastExpression();
                            cast.setExpression(methodRef);
                            ITypeBinding argTypeBinding = arg.resolveTypeBinding();
                            if (argTypeBinding == null) {
                                return replacementNode;
                            }
                            ImportRewrite importRewriter = cuRewrite.getImportRewrite();
                            Type argType = importRewriter.addImport(argTypeBinding, ast);
                            cast.setType(argType);
                            replacementNode = cast;
                        }
                    }
                }
            }
            return replacementNode;
        }

        private void copyParameters(ASTRewrite rewrite, LambdaExpression oldLambdaExpression, LambdaExpression copyOfLambdaExpression) {
            for (Object oldParameter : oldLambdaExpression.parameters()) {
                ASTNode copyOfParameter = ASTNodes.createMoveTarget(rewrite, (ASTNode)oldParameter);
                copyOfLambdaExpression.parameters().add(copyOfParameter);
            }
            copyOfLambdaExpression.setParentheses(oldLambdaExpression.hasParentheses());
        }

        private static Type copyType(CompilationUnitRewrite cuRewrite, AST ast, ASTNode node, ITypeBinding typeBinding) {
            ITypeBinding[] bounds;
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext(node, importRewrite);
            ITypeBinding modifiedType = typeBinding.getTypeParameters().length == 0 ? (typeBinding.isCapture() ? ((bounds = typeBinding.getTypeBounds()).length > 0 ? bounds[0] : typeBinding.getErasure()) : typeBinding.getErasure()) : typeBinding;
            return ASTNodeFactory.newCreationType(ast, modifiedType, importRewrite, importContext);
        }
    }
}

