/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.GeneralizeTypeDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompositeOrTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintCollector;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintOperator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariableFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.DeclaringTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ExpressionVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.FullConstraintCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ParameterTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ReturnTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.SimpleTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeConstraintFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.util.Progress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ChangeTypeRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_TYPE = "type";
    private final Map<ICompilationUnit, List<ITypeConstraint>> fConstraintCache;
    private int fSelectionStart;
    private int fSelectionLength;
    private int fEffectiveSelectionStart;
    private int fEffectiveSelectionLength;
    private ICompilationUnit fCu;
    private IMethodBinding fMethodBinding;
    private int fParamIndex;
    private String fParamName;
    private IVariableBinding fFieldBinding;
    private ICompilationUnit[] fAffectedUnits;
    private Collection<ConstraintVariable> fRelevantVars;
    private final Collection<ITypeBinding> fValidTypes;
    private Collection<ITypeConstraint> fRelevantConstraints;
    private Collection<ITypeConstraint> fAllConstraints;
    private String fSelectedTypeName;
    private ITypeBinding fSelectedType;
    private Map<ICompilationUnit, SearchResultGroup> fCuToSearchResultGroup = new HashMap<ICompilationUnit, SearchResultGroup>();
    private ITypeBinding fObject;
    private static final boolean DEBUG = false;
    private ConstraintVariable fCv;
    private IBinding fSelectionBinding;
    private ITypeBinding fSelectionTypeBinding;
    private ConstraintCollector fCollector;

    public ITypeBinding getObject() {
        return this.fObject;
    }

    public ChangeTypeRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength) {
        this(cu, selectionStart, selectionLength, null);
    }

    public ChangeTypeRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength, String selectedType) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fEffectiveSelectionStart = selectionStart;
        this.fEffectiveSelectionLength = selectionLength;
        this.fCu = cu;
        if (selectedType != null) {
            this.fSelectedTypeName = selectedType;
        }
        this.fConstraintCache = new HashMap<ICompilationUnit, List<ITypeConstraint>>();
        this.fValidTypes = new HashSet<ITypeBinding>();
    }

    public ChangeTypeRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null, 0, 0, null);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fCu == null || !this.fCu.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_invalidSelection);
        }
        return this.checkSelection(Progress.subMonitor(pm, 1));
    }

    private void setSelectionRanges(Expression exp) {
        this.fEffectiveSelectionStart = exp.getStartPosition();
        this.fEffectiveSelectionLength = exp.getLength();
        this.fSelectionBinding = ExpressionVariable.resolveBinding(exp);
        this.setOriginalType(exp.resolveTypeBinding());
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) {
        try {
            IMethod selectedMethod;
            pm.beginTask("", 5);
            ASTNode node = this.getTargetNode(this.fCu, this.fSelectionStart, this.fSelectionLength);
            TypeConstraintFactory typeConstraintFactory = new TypeConstraintFactory(){

                @Override
                public boolean filter(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator o) {
                    if (o.isStrictSubtypeOperator()) {
                        return true;
                    }
                    if (v1.getBinding() != null && v2.getBinding() != null && !Bindings.equals((IBinding)v1.getBinding(), (IBinding)ChangeTypeRefactoring.this.fSelectionTypeBinding) && !Bindings.equals((IBinding)v2.getBinding(), (IBinding)ChangeTypeRefactoring.this.fSelectionTypeBinding)) {
                        return true;
                    }
                    return super.filter(v1, v2, o);
                }
            };
            this.fCollector = new ConstraintCollector(new FullConstraintCreator(new ConstraintVariableFactory(), typeConstraintFactory));
            String selectionValid = this.determineSelection(node);
            if (selectionValid != null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)selectionValid);
                return refactoringStatus;
            }
            if (this.fMethodBinding != null && (selectedMethod = (IMethod)this.fMethodBinding.getJavaElement()) == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_insideLocalTypesNotSupported);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            if (this.fSelectionTypeBinding.isArray()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_arraysNotSupported);
                return refactoringStatus;
            }
            if (this.fSelectionTypeBinding.isPrimitive()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_primitivesNotSupported);
                return refactoringStatus;
            }
            if (this.checkOverriddenBinaryMethods()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnBinary);
                return refactoringStatus;
            }
            if (this.fSelectionTypeBinding.isLocal()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_localTypesNotSupported);
                return refactoringStatus;
            }
            if (this.fFieldBinding != null && this.fFieldBinding.getDeclaringClass().isLocal()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_insideLocalTypesNotSupported);
                return refactoringStatus;
            }
            if (this.fSelectionTypeBinding.isTypeVariable()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_typeParametersNotSupported);
                return refactoringStatus;
            }
            if (this.fSelectionTypeBinding.isEnum()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_enumsNotSupported);
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.fSelectedType != null) {
                this.computeValidTypes((IProgressMonitor)new NullProgressMonitor());
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private boolean checkOverriddenBinaryMethods() {
        if (this.fMethodBinding != null) {
            Set<ITypeBinding> declaringSupertypes = ChangeTypeRefactoring.getDeclaringSuperTypes(this.fMethodBinding);
            for (ITypeBinding superType : declaringSupertypes) {
                IMethodBinding overriddenMethod = ChangeTypeRefactoring.findMethod(this.fMethodBinding, superType);
                Assert.isNotNull((Object)overriddenMethod);
                IMethod iMethod = (IMethod)overriddenMethod.getJavaElement();
                if (!iMethod.isBinary()) continue;
                return true;
            }
        }
        return false;
    }

    private static IMethodBinding findMethod(IMethodBinding methodBinding, ITypeBinding type) {
        if (methodBinding.getDeclaringClass().equals((Object)type)) {
            return methodBinding;
        }
        return Bindings.findOverriddenMethodInType(type, methodBinding);
    }

    private static Set<ITypeBinding> getDeclaringSuperTypes(IMethodBinding methodBinding) {
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        ITypeBinding[] iTypeBindingArray = Bindings.getAllSuperTypes(methodBinding.getDeclaringClass());
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding type = iTypeBindingArray[n2];
            if (ChangeTypeRefactoring.findMethod(methodBinding, type) != null) {
                result.add(type);
            }
            ++n2;
        }
        return result;
    }

    public Collection<ITypeBinding> computeValidTypes(IProgressMonitor pm) {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_checking_preconditions, 100);
        try {
            this.fCv = this.findConstraintVariableForSelectedNode(Progress.subMonitor(pm, 3));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fRelevantVars = this.findRelevantConstraintVars(this.fCv, Progress.subMonitor(pm, 50));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fRelevantConstraints = this.findRelevantConstraints(this.fRelevantVars, Progress.subMonitor(pm, 30));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fValidTypes.addAll(this.computeValidTypes(this.fSelectionTypeBinding, this.fRelevantVars, this.fRelevantConstraints, Progress.subMonitor(pm, 20)));
        }
        catch (CoreException e) {
            JavaManipulationPlugin.logErrorMessage("Error occurred during computation of valid types: " + e.toString());
            this.fValidTypes.clear();
        }
        pm.done();
        return this.fValidTypes;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_checking_preconditions, 1);
        RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fAffectedUnits), this.getValidationContext(), pm);
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeMessages_CreateChangesForChangeType, 1);
        try {
            HashMap<ICompilationUnit, Set<ConstraintVariable>> relevantVarsByUnit = new HashMap<ICompilationUnit, Set<ConstraintVariable>>();
            this.groupChangesByCompilationUnit(relevantVarsByUnit);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaProject javaProject = this.fCu.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            String description = RefactoringCoreMessages.ChangeTypeRefactoring_descriptor_description_short;
            String header = Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_descriptor_description, new String[]{BindingLabelProviderCore.getBindingLabel(this.fSelectionBinding, 2235681801344L), BindingLabelProviderCore.getBindingLabel((IBinding)this.fSelectedType, 2235681801344L)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_original_element_pattern, BindingLabelProviderCore.getBindingLabel(this.fSelectionBinding, 2235681801344L)));
            comment.addSetting(Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_original_type_pattern, BindingLabelProviderCore.getBindingLabel((IBinding)this.getOriginalType(), 2235681801344L)));
            comment.addSetting(Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_refactored_type_pattern, BindingLabelProviderCore.getBindingLabel((IBinding)this.fSelectedType, 2235681801344L)));
            GeneralizeTypeDescriptor descriptor = RefactoringSignatureDescriptorFactory.createGeneralizeTypeDescriptor(project, description, comment.asString(), arguments, 786434);
            arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCu));
            arguments.put("selection", Integer.toString(this.fSelectionStart) + " " + Integer.toString(this.fSelectionLength));
            arguments.put(ATTRIBUTE_TYPE, this.fSelectedType.getQualifiedName());
            DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.ChangeTypeRefactoring_allChanges);
            for (Map.Entry entry : relevantVarsByUnit.entrySet()) {
                ICompilationUnit icu = (ICompilationUnit)entry.getKey();
                Set cVars = (Set)entry.getValue();
                CompilationUnitChange cuChange = new CompilationUnitChange(this.getName(), icu);
                this.addAllChangesFor(icu, cVars, cuChange);
                result.add((Change)cuChange);
                pm.worked(1);
                if (!pm.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = result;
            return dynamicValidationRefactoringChange;
        }
        finally {
            pm.done();
        }
    }

    private void addAllChangesFor(ICompilationUnit icu, Set<ConstraintVariable> vars, CompilationUnitChange unitChange) throws CoreException {
        CompilationUnit unit = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse((ITypeRoot)icu, true);
        ASTRewrite unitRewriter = ASTRewrite.create((AST)unit.getAST());
        MultiTextEdit root = new MultiTextEdit();
        unitChange.setEdit((TextEdit)root);
        ImportRemover remover = new ImportRemover(this.fCu.getJavaProject(), unit);
        String typeName = this.updateImports(unit, root);
        this.updateCu(unit, vars, unitChange, unitRewriter, typeName, remover);
        this.removeUnusedImport(remover, unit, root);
        root.addChild(unitRewriter.rewriteAST());
    }

    private void updateCu(CompilationUnit unit, Set<ConstraintVariable> vars, CompilationUnitChange unitChange, ASTRewrite unitRewriter, String typeName, ImportRemover remover) throws JavaModelException {
        unitRewriter.setTargetSourceRangeComputer((TargetSourceRangeComputer)new SourceRangeComputer());
        for (ConstraintVariable cv : vars) {
            ASTNode decl = this.findDeclaration(unit, cv);
            if ((decl instanceof SimpleName || decl instanceof QualifiedName) && cv instanceof ExpressionVariable) {
                ASTNode gp = decl.getParent().getParent();
                this.updateType(unit, ChangeTypeRefactoring.getType(gp), unitChange, unitRewriter, typeName, remover);
                continue;
            }
            if (!(decl instanceof MethodDeclaration) && !(decl instanceof FieldDeclaration) && !(decl instanceof ParameterizedType)) continue;
            this.updateType(unit, ChangeTypeRefactoring.getType(decl), unitChange, unitRewriter, typeName, remover);
        }
    }

    private void updateType(CompilationUnit cu, Type oldType, CompilationUnitChange unitChange, ASTRewrite unitRewriter, String typeName, ImportRemover remover) {
        String oldName = this.fSelectionTypeBinding.getName();
        Object[] keys = new String[]{BasicElementLabels.getJavaElementName(oldName), BasicElementLabels.getJavaElementName(typeName)};
        String description = Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_typeChange, keys);
        TextEditGroup gd = new TextEditGroup(description);
        AST ast = cu.getAST();
        Type nodeToReplace = oldType;
        if (this.fSelectionTypeBinding.isParameterizedType() && !this.fSelectionTypeBinding.isRawType() && oldType.isSimpleType()) {
            nodeToReplace = oldType.getParent();
        }
        Assert.isTrue((this.fSelectedType.isClass() || this.fSelectedType.isInterface() ? 1 : 0) != 0);
        Object newType = null;
        newType = !this.fSelectedType.isParameterizedType() ? ast.newSimpleType(ASTNodeFactory.newName(ast, typeName)) : this.createParameterizedType(ast, this.fSelectedType);
        unitRewriter.replace((ASTNode)nodeToReplace, (ASTNode)newType, gd);
        remover.registerRemovedNode((ASTNode)nodeToReplace);
        unitChange.addTextEditGroup(gd);
    }

    private Type createParameterizedType(AST ast, ITypeBinding typeBinding) {
        if (typeBinding.isParameterizedType() && !typeBinding.isRawType()) {
            SimpleType baseType = ast.newSimpleType(ASTNodeFactory.newName(ast, typeBinding.getErasure().getName()));
            ParameterizedType newType = ast.newParameterizedType((Type)baseType);
            int i = 0;
            while (i < typeBinding.getTypeArguments().length) {
                ITypeBinding typeArg = typeBinding.getTypeArguments()[i];
                Type argType = this.createParameterizedType(ast, typeArg);
                newType.typeArguments().add(argType);
                ++i;
            }
            return newType;
        }
        if (!typeBinding.isTypeVariable()) {
            return ast.newSimpleType(ASTNodeFactory.newName(ast, typeBinding.getErasure().getName()));
        }
        return ast.newSimpleType((Name)ast.newSimpleName(typeBinding.getName()));
    }

    private void groupChangesByCompilationUnit(Map<ICompilationUnit, Set<ConstraintVariable>> relevantVarsByUnit) {
        for (ConstraintVariable cv : this.fRelevantVars) {
            if (!(cv instanceof ExpressionVariable) && !(cv instanceof ReturnTypeVariable)) continue;
            ICompilationUnit icu = null;
            if (cv instanceof ExpressionVariable) {
                ExpressionVariable ev = (ExpressionVariable)cv;
                icu = ev.getCompilationUnitRange().getCompilationUnit();
            } else if (cv instanceof ReturnTypeVariable) {
                ReturnTypeVariable rtv = (ReturnTypeVariable)cv;
                IMethodBinding mb = rtv.getMethodBinding();
                icu = ((IMethod)mb.getJavaElement()).getCompilationUnit();
            }
            if (!relevantVarsByUnit.containsKey(icu)) {
                relevantVarsByUnit.put(icu, new HashSet());
            }
            relevantVarsByUnit.get(icu).add(cv);
        }
    }

    private ASTNode findDeclaration(CompilationUnit root, ConstraintVariable cv) throws JavaModelException {
        if (this.fFieldBinding != null) {
            IField f = (IField)this.fFieldBinding.getJavaElement();
            return ASTNodeSearchUtil.getFieldDeclarationNode(f, root);
        }
        if (cv instanceof ExpressionVariable) {
            for (ITypeConstraint constraint : this.fAllConstraints) {
                ConstraintVariable right;
                SimpleTypeConstraint stc;
                if (!constraint.isSimpleTypeConstraint() || !(stc = (SimpleTypeConstraint)constraint).isDefinesConstraint() || !stc.getLeft().equals(cv) || !((right = stc.getRight()) instanceof TypeVariable)) continue;
                TypeVariable typeVariable = (TypeVariable)right;
                return NodeFinder.perform((ASTNode)root, (ISourceRange)typeVariable.getCompilationUnitRange().getSourceRange());
            }
        } else if (cv instanceof ReturnTypeVariable) {
            ReturnTypeVariable rtv = (ReturnTypeVariable)cv;
            IMethodBinding mb = rtv.getMethodBinding();
            IMethod im = (IMethod)mb.getJavaElement();
            return ASTNodeSearchUtil.getMethodDeclarationNode(im, root);
        }
        return null;
    }

    private static Type getType(ASTNode node) {
        switch (node.getNodeType()) {
            case 44: {
                return ((SingleVariableDeclaration)node).getType();
            }
            case 23: {
                return ((FieldDeclaration)node).getType();
            }
            case 60: {
                return ((VariableDeclarationStatement)node).getType();
            }
            case 58: {
                return ((VariableDeclarationExpression)node).getType();
            }
            case 31: {
                return ((MethodDeclaration)node).getReturnType2();
            }
            case 74: {
                return ((ParameterizedType)node).getType();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.ChangeTypeRefactoring_name;
    }

    private String determineSelection(ASTNode node) {
        if (node == null) {
            return RefactoringCoreMessages.ChangeTypeRefactoring_invalidSelection;
        }
        ASTNode parent = node.getParent();
        ASTNode grandParent = parent.getParent();
        if (grandParent == null) {
            return ChangeTypeRefactoring.nodeTypeNotSupported();
        }
        if (grandParent.getNodeType() == 74) {
            node = grandParent;
        }
        ASTNode current = null;
        if (node.getNodeType() == 40) {
            current = node;
            while (current.getNodeType() == 40) {
                current = current.getParent();
            }
            if (current.getNodeType() != 43) {
                return ChangeTypeRefactoring.nodeTypeNotSupported();
            }
            node = current.getParent();
        } else if (parent.getNodeType() == 40) {
            current = parent;
            while (current.getNodeType() == 40) {
                current = current.getParent();
            }
            if (current.getNodeType() != 43) {
                return ChangeTypeRefactoring.nodeTypeNotSupported();
            }
            node = current.getParent();
        }
        this.fObject = node.getAST().resolveWellKnownType("java.lang.Object");
        switch (node.getNodeType()) {
            case 42: {
                return this.simpleNameSelected((SimpleName)node);
            }
            case 60: {
                return this.variableDeclarationStatementSelected((VariableDeclarationStatement)node);
            }
            case 23: {
                return this.fieldDeclarationSelected((FieldDeclaration)node);
            }
            case 44: {
                return this.singleVariableDeclarationSelected((SingleVariableDeclaration)node);
            }
            case 74: {
                return this.parameterizedTypeSelected((ParameterizedType)node);
            }
        }
        return ChangeTypeRefactoring.nodeTypeNotSupported();
    }

    private static String nodeTypeNotSupported() {
        return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
    }

    private String singleVariableDeclarationSelected(SingleVariableDeclaration svd) {
        SimpleName name = svd.getName();
        this.setSelectionRanges((Expression)name);
        return this.simpleNameSelected(name);
    }

    private String parameterizedTypeSelected(ParameterizedType pt) {
        ASTNode parent = pt.getParent();
        if (parent.getNodeType() != 31) {
            if (parent.getNodeType() == 44) {
                return this.singleVariableDeclarationSelected((SingleVariableDeclaration)parent);
            }
            if (parent.getNodeType() == 60) {
                return this.variableDeclarationStatementSelected((VariableDeclarationStatement)parent);
            }
            if (parent.getNodeType() == 23) {
                return this.fieldDeclarationSelected((FieldDeclaration)parent);
            }
            return ChangeTypeRefactoring.nodeTypeNotSupported();
        }
        this.fMethodBinding = ((MethodDeclaration)parent).resolveBinding();
        this.fParamIndex = -1;
        this.fEffectiveSelectionStart = pt.getStartPosition();
        this.fEffectiveSelectionLength = pt.getLength();
        this.setOriginalType(pt.resolveBinding());
        return null;
    }

    private String variableDeclarationStatementSelected(VariableDeclarationStatement vds) {
        if (vds.fragments().size() != 1) {
            return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
        }
        VariableDeclarationFragment elem = (VariableDeclarationFragment)vds.fragments().iterator().next();
        SimpleName name = elem.getName();
        this.setSelectionRanges((Expression)name);
        return this.simpleNameSelected(name);
    }

    private String fieldDeclarationSelected(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration.fragments().size() != 1) {
            return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
        }
        VariableDeclarationFragment elem = (VariableDeclarationFragment)fieldDeclaration.fragments().iterator().next();
        this.fFieldBinding = elem.resolveBinding();
        SimpleName name = elem.getName();
        this.setSelectionRanges((Expression)name);
        return this.simpleNameSelected(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String simpleNameSelected(SimpleName simpleName) {
        ASTNode parent = simpleName.getParent();
        ASTNode grandParent = parent.getParent();
        if (parent.getNodeType() == 60) {
            VariableDeclarationStatement vds = (VariableDeclarationStatement)parent;
            if (vds.fragments().size() <= 1) return null;
            return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
        }
        if (parent.getNodeType() == 59) {
            if (grandParent.getNodeType() == 60) {
                VariableDeclarationStatement vds = (VariableDeclarationStatement)grandParent;
                if (vds.fragments().size() > 1) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
                }
                this.setSelectionRanges((Expression)simpleName);
                return null;
            } else if (grandParent.getNodeType() == 58) {
                VariableDeclarationExpression vde = (VariableDeclarationExpression)grandParent;
                if (vde.fragments().size() > 1) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
                }
                this.setSelectionRanges((Expression)simpleName);
                return null;
            } else {
                if (grandParent.getNodeType() != 23) return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
                FieldDeclaration fd = (FieldDeclaration)grandParent;
                if (fd.fragments().size() > 1) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
                }
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)parent;
                this.fFieldBinding = fragment.resolveBinding();
                this.setSelectionRanges((Expression)fragment.getName());
            }
            return null;
        } else if (parent.getNodeType() == 44) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parent;
            if (singleVariableDeclaration.getType() instanceof UnionType) {
                return RefactoringCoreMessages.ChangeTypeRefactoring_uniontypeNotSupported;
            }
            if (grandParent.getNodeType() == 31) {
                this.fMethodBinding = ((MethodDeclaration)grandParent).resolveBinding();
                this.setOriginalType(simpleName.resolveTypeBinding());
                this.fParamIndex = ((MethodDeclaration)grandParent).parameters().indexOf(parent);
                this.fParamName = singleVariableDeclaration.getName().getIdentifier();
                return null;
            } else {
                this.setSelectionRanges((Expression)singleVariableDeclaration.getName());
            }
            return null;
        } else if (parent.getNodeType() == 43 && grandParent.getNodeType() == 44) {
            ASTNode greatGrandParent = grandParent.getParent();
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)grandParent;
            if (singleVariableDeclaration.getExtraDimensions() > 0 || singleVariableDeclaration.isVarargs()) {
                return RefactoringCoreMessages.ChangeTypeRefactoring_arraysNotSupported;
            }
            if (greatGrandParent != null && greatGrandParent.getNodeType() == 31) {
                this.fMethodBinding = ((MethodDeclaration)greatGrandParent).resolveBinding();
                this.fParamIndex = ((MethodDeclaration)greatGrandParent).parameters().indexOf(grandParent);
                this.fParamName = singleVariableDeclaration.getName().getIdentifier();
                this.setSelectionRanges((Expression)simpleName);
                return null;
            } else {
                this.setSelectionRanges((Expression)singleVariableDeclaration.getName());
            }
            return null;
        } else if (parent.getNodeType() == 43 && grandParent.getNodeType() == 31) {
            this.fMethodBinding = ((MethodDeclaration)grandParent).resolveBinding();
            this.setOriginalType(this.fMethodBinding.getReturnType());
            this.fParamIndex = -1;
            return null;
        } else if (parent.getNodeType() == 31 && grandParent.getNodeType() == 55) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)parent;
            if (methodDeclaration.getName().equals((Object)simpleName)) {
                return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
            }
            this.fMethodBinding = ((MethodDeclaration)parent).resolveBinding();
            this.fParamIndex = -1;
            return null;
        } else {
            if (parent.getNodeType() == 43 && grandParent.getNodeType() == 60) {
                return this.variableDeclarationStatementSelected((VariableDeclarationStatement)grandParent);
            }
            if (parent.getNodeType() == 11) {
                ASTNode decl = ChangeTypeRefactoring.findDeclaration(parent.getRoot(), this.fSelectionStart, this.fSelectionLength + 1);
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)decl;
                SimpleName name = fragment.getName();
                this.setSelectionRanges((Expression)name);
                return null;
            } else {
                if (parent.getNodeType() == 43 && grandParent.getNodeType() == 23) {
                    return this.fieldDeclarationSelected((FieldDeclaration)grandParent);
                }
                if (parent.getNodeType() == 43 && grandParent.getNodeType() == 5) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_arraysNotSupported;
                }
                if (parent.getNodeType() != 40) return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
                this.setSelectionRanges((Expression)simpleName);
            }
        }
        return null;
    }

    private ConstraintVariable findConstraintVariableForSelectedNode(IProgressMonitor pm) {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 100);
        ICompilationUnit[] cus = new ICompilationUnit[]{this.fCu};
        Collection<ITypeConstraint> allConstraints = this.getConstraints(cus, Progress.subMonitor(pm, 50));
        IProgressMonitor subMonitor = Progress.subMonitor(pm, 50);
        subMonitor.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, allConstraints.size());
        for (ITypeConstraint tc : allConstraints) {
            subMonitor.worked(1);
            if (!(tc instanceof SimpleTypeConstraint)) continue;
            SimpleTypeConstraint stc = (SimpleTypeConstraint)tc;
            if (this.matchesSelection(stc.getLeft())) {
                return stc.getLeft();
            }
            if (!this.matchesSelection(stc.getRight())) continue;
            return stc.getRight();
        }
        subMonitor.done();
        pm.done();
        Assert.isTrue((boolean)false, (String)RefactoringCoreMessages.ChangeTypeRefactoring_noMatchingConstraintVariable);
        return null;
    }

    private boolean matchesSelection(ConstraintVariable cv) {
        if (cv instanceof ExpressionVariable) {
            ExpressionVariable ev = (ExpressionVariable)cv;
            return this.fSelectionBinding != null && Bindings.equals(this.fSelectionBinding, ev.getExpressionBinding());
        }
        if (cv instanceof ParameterTypeVariable) {
            ParameterTypeVariable ptv = (ParameterTypeVariable)cv;
            if (this.fMethodBinding != null && Bindings.equals((IBinding)ptv.getMethodBinding(), (IBinding)this.fMethodBinding) && ptv.getParameterIndex() == this.fParamIndex) {
                return true;
            }
        } else if (cv instanceof ReturnTypeVariable) {
            ReturnTypeVariable rtv = (ReturnTypeVariable)cv;
            if (this.fMethodBinding != null && Bindings.equals((IBinding)rtv.getMethodBinding(), (IBinding)this.fMethodBinding) && this.fParamIndex == -1) {
                return true;
            }
        }
        return false;
    }

    private Collection<ConstraintVariable> findRelevantConstraintVars(ConstraintVariable cv, IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 150);
        HashSet<ConstraintVariable> result = new HashSet<ConstraintVariable>();
        result.add(cv);
        ICompilationUnit[] cus = this.collectAffectedUnits(Progress.subMonitor(pm, 50));
        Collection<ITypeConstraint> allConstraints = this.getConstraints(cus, Progress.subMonitor(pm, 50));
        ArrayList<ConstraintVariable> workList = new ArrayList<ConstraintVariable>(result);
        while (!workList.isEmpty()) {
            pm.worked(10);
            ConstraintVariable first = (ConstraintVariable)workList.remove(0);
            for (ITypeConstraint typeConstraint : allConstraints) {
                ConstraintVariable match;
                SimpleTypeConstraint stc;
                pm.worked(1);
                if (!typeConstraint.isSimpleTypeConstraint() || !(stc = (SimpleTypeConstraint)typeConstraint).isDefinesConstraint() && !stc.isEqualsConstraint() || !((match = ChangeTypeRefactoring.match(first, stc.getLeft(), stc.getRight())) instanceof ExpressionVariable) && !(match instanceof ParameterTypeVariable) && !(match instanceof ReturnTypeVariable) || result.contains(match)) continue;
                workList.add(match);
                result.add(match);
            }
        }
        pm.done();
        return result;
    }

    private static ConstraintVariable match(ConstraintVariable matchee, ConstraintVariable left, ConstraintVariable right) {
        if (matchee.equals(left)) {
            return right;
        }
        if (matchee.equals(right)) {
            return left;
        }
        return null;
    }

    private Collection<ITypeConstraint> findRelevantConstraints(Collection<ConstraintVariable> relevantConstraintVars, IProgressMonitor pm) throws CoreException {
        ICompilationUnit[] cus = this.collectAffectedUnits(Progress.subMonitor(pm, 100));
        this.fAllConstraints = this.getConstraints(cus, Progress.subMonitor(pm, 900));
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 1000 + this.fAllConstraints.size());
        ArrayList<ITypeConstraint> result = new ArrayList<ITypeConstraint>();
        for (ITypeConstraint tc : this.fAllConstraints) {
            if (tc.isSimpleTypeConstraint()) {
                SimpleTypeConstraint stc = (SimpleTypeConstraint)tc;
                if (stc.isDefinesConstraint() || stc.isEqualsConstraint() || stc.getLeft().equals(stc.getRight()) || ChangeTypeRefactoring.isNull(stc.getLeft())) continue;
                if (relevantConstraintVars.contains(stc.getLeft()) || relevantConstraintVars.contains(stc.getRight())) {
                    result.add(tc);
                }
            } else {
                CompositeOrTypeConstraint cotc = (CompositeOrTypeConstraint)tc;
                ITypeConstraint[] iTypeConstraintArray = cotc.getConstraints();
                int n = iTypeConstraintArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeConstraint component = iTypeConstraintArray[n2];
                    SimpleTypeConstraint simpleComponent = (SimpleTypeConstraint)component;
                    if (relevantConstraintVars.contains(simpleComponent.getLeft())) {
                        result.add(tc);
                    }
                    ++n2;
                }
            }
            pm.worked(1);
        }
        pm.done();
        return result;
    }

    private static ASTNode findDeclaration(ASTNode root, int start, int length) {
        ASTNode node = NodeFinder.perform((ASTNode)root, (int)start, (int)length);
        Assert.isTrue((boolean)(node instanceof SimpleName), (String)String.valueOf(node.getNodeType()));
        Assert.isTrue((boolean)(root instanceof CompilationUnit), (String)String.valueOf(root.getNodeType()));
        return ((CompilationUnit)root).findDeclaringNode(((SimpleName)node).resolveBinding());
    }

    static String print(Collection<ITypeBinding> types) {
        if (types.isEmpty()) {
            return "{ }";
        }
        StringBuilder result = new StringBuilder("{ ");
        Iterator<ITypeBinding> it = types.iterator();
        while (it.hasNext()) {
            ITypeBinding type = it.next();
            result.append(type.getQualifiedName());
            if (it.hasNext()) {
                result.append(", ");
                continue;
            }
            result.append(" }");
        }
        return result.toString();
    }

    private Collection<ITypeBinding> computeValidTypes(ITypeBinding originalType, Collection<ConstraintVariable> relevantVars, Collection<ITypeConstraint> relevantConstraints, IProgressMonitor pm) throws JavaModelException {
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        HashSet<ITypeBinding> allTypes = new HashSet<ITypeBinding>(this.getAllSuperTypes(originalType));
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, allTypes.size());
        for (ITypeBinding type : allTypes) {
            if (!this.isValid(type, relevantVars, relevantConstraints, Progress.subMonitor(pm, 1)) || !this.checkTypeParameterConflict(relevantVars, type)) continue;
            result.add(type);
        }
        result.remove(originalType);
        pm.done();
        return result;
    }

    private boolean checkTypeParameterConflict(Collection<ConstraintVariable> relevantVars, ITypeBinding replaceTypeTo) {
        for (ConstraintVariable constraintVariable : relevantVars) {
            if (!(constraintVariable instanceof ParameterTypeVariable)) continue;
            ParameterTypeVariable parameterTypeVariable = (ParameterTypeVariable)constraintVariable;
            ITypeBinding declaringClass = parameterTypeVariable.getMethodBinding().getDeclaringClass();
            ITypeBinding[] parameterTypeVariableTypes = parameterTypeVariable.getMethodBinding().getParameterTypes();
            ArrayList<IMethodBinding> possibleConflictMethods = new ArrayList<IMethodBinding>();
            IMethodBinding[] iMethodBindingArray = declaringClass.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding declaredMethod = iMethodBindingArray[n2];
                if (declaredMethod.getName().equals(parameterTypeVariable.getMethodBinding().getName()) && declaredMethod.getParameterTypes().length == parameterTypeVariableTypes.length) {
                    possibleConflictMethods.add(declaredMethod);
                }
                ++n2;
            }
            if (possibleConflictMethods.size() < 2) continue;
            block2: for (IMethodBinding declaredMethod : possibleConflictMethods) {
                ITypeBinding[] parameterTypes = declaredMethod.getParameterTypes();
                int i = 0;
                while (i < parameterTypes.length) {
                    if (i != this.fParamIndex && !Bindings.equals((IBinding)parameterTypes[i], (IBinding)parameterTypeVariableTypes[i])) continue block2;
                    ++i;
                }
                if (!Bindings.equals((IBinding)parameterTypes[this.fParamIndex], (IBinding)replaceTypeTo)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValid(ITypeBinding type, Collection<ConstraintVariable> relevantVars, Collection<ITypeConstraint> constraints, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, constraints.size());
        ICompilationUnit[] iCompilationUnitArray = this.fAffectedUnits;
        int n = this.fAffectedUnits.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            if (!JavaModelUtil.isVisibleInHierarchy((IMember)type.getJavaElement(), (IPackageFragment)cu.getParent())) {
                return false;
            }
            ++n2;
        }
        for (ITypeConstraint tc : constraints) {
            if (tc instanceof SimpleTypeConstraint ? !this.isValidSimpleConstraint(type, relevantVars, (SimpleTypeConstraint)tc) : tc instanceof CompositeOrTypeConstraint && !this.isValidOrConstraint(type, relevantVars, (CompositeOrTypeConstraint)tc)) {
                return false;
            }
            pm.worked(1);
        }
        pm.done();
        return true;
    }

    private boolean isValidSimpleConstraint(ITypeBinding type, Collection<ConstraintVariable> relevantVars, SimpleTypeConstraint stc) {
        if (relevantVars.contains(stc.getLeft())) {
            if (this.isSubTypeOf(type, this.findType(stc.getRight()))) {
                return true;
            }
            return this.checkSuperTypeScope(type);
        }
        return true;
    }

    private boolean isValidOrConstraint(ITypeBinding type, Collection<ConstraintVariable> relevantVars, CompositeOrTypeConstraint cotc) {
        ITypeConstraint[] iTypeConstraintArray = cotc.getConstraints();
        int n = iTypeConstraintArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleTypeConstraint sc;
            ITypeConstraint component = iTypeConstraintArray[n2];
            if (component instanceof SimpleTypeConstraint && (relevantVars.contains((sc = (SimpleTypeConstraint)component).getLeft()) ? this.isSubTypeOf(type, this.findType(sc.getRight())) : relevantVars.contains(sc.getRight()) && this.isSubTypeOf(this.findType(sc.getLeft()), type))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean checkSuperTypeScope(ITypeBinding superType) {
        if ("java.lang.Object".equals(superType.getQualifiedName())) {
            return false;
        }
        for (ITypeConstraint tc : this.fRelevantConstraints) {
            IMethodBinding methodBinding;
            IBinding memberBinding;
            SimpleTypeConstraint stc;
            ITypeBinding typeBinding;
            boolean isMethodFromObject;
            if (!tc.isSimpleTypeConstraint() || !((isMethodFromObject = "java.lang.Object".equals((typeBinding = (stc = (SimpleTypeConstraint)tc).getRight().getBinding()).getQualifiedName())) ? superType.isInterface() || Modifier.isAbstract((int)superType.getModifiers()) : (stc.getRight() instanceof DeclaringTypeVariable ? (memberBinding = ((DeclaringTypeVariable)stc.getRight()).getMemberBinding()) instanceof IMethodBinding && (methodBinding = Bindings.findMethodInHierarchy(superType, memberBinding.getName(), null)) == null && (!superType.isInterface() || !isMethodFromObject) : !this.isSubTypeOf(superType, typeBinding)))) continue;
            return false;
        }
        return true;
    }

    private ITypeBinding findType(ConstraintVariable cv) {
        return cv.getBinding();
    }

    private Collection<ITypeConstraint> getConstraints(ICompilationUnit[] referringCus, IProgressMonitor pm) {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, referringCus.length);
        ArrayList<ITypeConstraint> result = new ArrayList<ITypeConstraint>();
        ICompilationUnit[] iCompilationUnitArray = referringCus;
        int n = referringCus.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit referringCu = iCompilationUnitArray[n2];
            result.addAll(this.getConstraints(referringCu));
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
        pm.done();
        return result;
    }

    private List<ITypeConstraint> getConstraints(ICompilationUnit unit) {
        if (this.fConstraintCache.containsKey(unit)) {
            return this.fConstraintCache.get(unit);
        }
        CompilationUnit cu = ASTCreator.createAST(unit, null);
        if (this.fMethodBinding != null && this.fCuToSearchResultGroup.containsKey(unit)) {
            SearchResultGroup group = this.fCuToSearchResultGroup.get(unit);
            ASTNode[] aSTNodeArray = ASTNodeSearchUtil.getAstNodes(group.getSearchResults(), cu);
            int n = aSTNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ASTNode node;
                ASTNode n3 = node = aSTNodeArray[n2];
                while (n3 != null && !(n3 instanceof MethodDeclaration)) {
                    n3 = n3.getParent();
                }
                MethodDeclaration md = (MethodDeclaration)n3;
                if (md != null) {
                    md.accept((ASTVisitor)this.fCollector);
                }
                ++n2;
            }
        } else {
            cu.accept((ASTVisitor)this.fCollector);
        }
        List<ITypeConstraint> constraints = Arrays.asList(this.fCollector.getConstraints());
        this.fConstraintCache.put(unit, constraints);
        return constraints;
    }

    private String updateImports(CompilationUnit astRoot, MultiTextEdit rootEdit) throws CoreException {
        ImportRewrite rewrite = StubUtility.createImportRewrite(astRoot, true);
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(astRoot, this.fSelectionStart, rewrite);
        String typeName = rewrite.addImport(this.fSelectedType.getQualifiedName(), (ImportRewrite.ImportRewriteContext)context);
        rootEdit.addChild(rewrite.rewriteImports(null));
        return typeName;
    }

    private void removeUnusedImport(ImportRemover remover, CompilationUnit astRoot, MultiTextEdit rootEdit) throws CoreException {
        List declList = astRoot.imports();
        ImportDeclaration oldImport = null;
        String importStr = this.getImport(this.fSelectionTypeBinding.getQualifiedName());
        for (ImportDeclaration decl : declList) {
            if (!decl.getName().getFullyQualifiedName().equals(importStr)) continue;
            oldImport = decl;
            break;
        }
        if (oldImport != null) {
            ImportRewrite rewrite = StubUtility.createImportRewrite(astRoot, true);
            remover.applyRemoves(rewrite);
            rootEdit.addChild(rewrite.rewriteImports(null));
        }
    }

    private String getImport(String qualifiedTypeName) {
        int bracketOffset;
        String finalStr = qualifiedTypeName;
        int angleBracketOffset = qualifiedTypeName.indexOf(60);
        if (angleBracketOffset != -1) {
            finalStr = qualifiedTypeName.substring(0, angleBracketOffset);
        }
        if ((bracketOffset = qualifiedTypeName.indexOf(91)) != -1) {
            finalStr = qualifiedTypeName.substring(0, bracketOffset);
        }
        return finalStr;
    }

    public Collection<ITypeBinding> getValidTypes() {
        return this.fValidTypes;
    }

    public ITypeBinding getOriginalType() {
        return this.fSelectionTypeBinding;
    }

    private void setOriginalType(ITypeBinding originalType) {
        this.fSelectionTypeBinding = originalType;
        this.fSelectedType = this.findSuperTypeByName(originalType, this.fSelectedTypeName);
    }

    public String getTarget() {
        String typeName;
        String string = typeName = this.fSelectionTypeBinding == null ? "" : this.fSelectionTypeBinding.getName() + " ";
        if (this.fFieldBinding != null) {
            return typeName + this.fFieldBinding.getName();
        }
        if (this.fMethodBinding != null) {
            if (this.fParamIndex == -1) {
                return typeName + this.fMethodBinding.getName() + "(...)";
            }
            return typeName + this.fParamName;
        }
        if (this.fSelectionBinding != null) {
            return typeName + this.fSelectionBinding.getName();
        }
        return typeName;
    }

    public Collection<String> getValidTypeNames() {
        ArrayList<String> typeNames = new ArrayList<String>();
        for (ITypeBinding type : this.fValidTypes) {
            typeNames.add(type.getQualifiedName());
        }
        return typeNames;
    }

    private ASTNode getTargetNode(ICompilationUnit unit, int offset, int length) {
        CompilationUnit root = ASTCreator.createAST(unit, null);
        ASTNode node = NodeFinder.perform((ASTNode)root, (int)offset, (int)length);
        return node;
    }

    private ICompilationUnit[] collectAffectedUnits(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 100);
        if (this.fAffectedUnits != null) {
            pm.worked(100);
            return this.fAffectedUnits;
        }
        if (this.fMethodBinding != null) {
            IMethod selectedMethod = (IMethod)this.fMethodBinding.getJavaElement();
            if (selectedMethod == null) {
                throw new AssertionFailedException(RefactoringCoreMessages.ChangeTypeRefactoring_no_method);
            }
            IMethod root = selectedMethod;
            if (!root.getDeclaringType().isInterface() && MethodChecks.isVirtual(root)) {
                IProgressMonitor subMonitor = Progress.subMonitor(pm, 5);
                IMethod inInterface = MethodChecks.isDeclaredInInterface(root, root.getDeclaringType().newTypeHierarchy(Progress.subMonitor(subMonitor, 1)), subMonitor);
                if (inInterface != null && !inInterface.equals(root)) {
                    root = inInterface;
                }
            }
            IMethod[] rippleMethods = RippleMethodFinder2.getRelatedMethods(root, Progress.subMonitor(pm, 15), null);
            SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])rippleMethods, 3);
            IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)selectedMethod);
            CollectingSearchRequestor csr = new CollectingSearchRequestor();
            SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, null, scope, csr, Progress.subMonitor(pm, 80), new RefactoringStatus());
            this.fAffectedUnits = this.getCus(groups);
        } else if (this.fFieldBinding != null) {
            SearchPattern pattern;
            IField iField = (IField)this.fFieldBinding.getJavaElement();
            if (iField == null) {
                Assert.isTrue((boolean)false, (String)RefactoringCoreMessages.ChangeTypeRefactoring_no_filed);
            }
            if ((pattern = SearchPattern.createPattern((IJavaElement)iField, (int)3, (int)24)) == null) {
                this.fAffectedUnits = new ICompilationUnit[0];
                return this.fAffectedUnits;
            }
            IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)iField);
            CollectingSearchRequestor csr = new CollectingSearchRequestor();
            SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, null, scope, csr, Progress.subMonitor(pm, 100), new RefactoringStatus());
            this.fAffectedUnits = this.getCus(groups);
        } else {
            this.fAffectedUnits = new ICompilationUnit[]{this.fCu};
        }
        pm.done();
        return this.fAffectedUnits;
    }

    public void setSelectedType(ITypeBinding type) {
        this.fSelectedType = type;
    }

    private static boolean isNull(ConstraintVariable cv) {
        return cv instanceof ExpressionVariable && ((ExpressionVariable)cv).getExpressionType() == 33;
    }

    void printCollection(String title, Collection<?> l) {
        System.out.println(l.size() + " " + title);
        for (Object name : l) {
            System.out.println("  " + String.valueOf(name));
        }
    }

    private ICompilationUnit[] getCus(SearchResultGroup[] groups) {
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>(groups.length);
        SearchResultGroup[] searchResultGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup group = searchResultGroupArray[n2];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu != null) {
                result.add(cu);
                this.fCuToSearchResultGroup.put(cu, group);
            }
            ++n2;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    public Set<ITypeBinding> getAllSuperTypes(ITypeBinding type) {
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        result.add(type);
        if (type.getSuperclass() != null) {
            result.addAll(this.getAllSuperTypes(type.getSuperclass()));
        }
        ITypeBinding[] iTypeBindingArray = type.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding intf = iTypeBindingArray[n2];
            result.addAll(this.getAllSuperTypes(intf));
            ++n2;
        }
        if (type != this.fObject && !ChangeTypeRefactoring.contains(result, this.fObject)) {
            result.add(this.fObject);
        }
        return result;
    }

    private ITypeBinding findSuperTypeByName(ITypeBinding type, String superTypeName) {
        Set<ITypeBinding> superTypes = this.getAllSuperTypes(type);
        for (ITypeBinding sup : superTypes) {
            if (!sup.getQualifiedName().equals(superTypeName)) continue;
            return sup;
        }
        return null;
    }

    public boolean isSubTypeOf(ITypeBinding type1, ITypeBinding type2) {
        if (type1.isParameterizedType() && type1.getTypeDeclaration().isEqualTo((IBinding)type2.getTypeDeclaration())) {
            return true;
        }
        Set<ITypeBinding> superTypes = this.getAllSuperTypes(type1);
        return ChangeTypeRefactoring.contains(superTypes, type2);
    }

    private static boolean contains(Collection<ITypeBinding> c, ITypeBinding binding) {
        for (ITypeBinding b : c) {
            if (!Bindings.equals((IBinding)b, (IBinding)binding)) continue;
            return true;
        }
        return false;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        IJavaElement element;
        int length;
        int offset;
        String selection = arguments.getAttribute("selection");
        if (selection != null) {
            offset = -1;
            length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.parseInt(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.parseInt(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 5) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.change.type");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fCu = (ICompilationUnit)element;
        String type = arguments.getAttribute(ATTRIBUTE_TYPE);
        if (type == null || "".equals(type)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TYPE));
        }
        this.fSelectedTypeName = type;
        return new RefactoringStatus();
    }

    private static class SourceRangeComputer
    extends TargetSourceRangeComputer {
        private SourceRangeComputer() {
        }

        public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode node) {
            return new TargetSourceRangeComputer.SourceRange(node.getStartPosition(), node.getLength());
        }
    }
}

