/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.ui.util.Progress;

public class RippleMethodFinder2 {
    private final IMethod fMethod;
    private Set<IMethod> fDeclarations;
    private ITypeHierarchy fHierarchy;
    private MultiMap<IType, IMethod> fTypeToMethod;
    private Set<IType> fRootTypes;
    private MultiMap<IType, IType> fRootReps;
    private Map<IType, ITypeHierarchy> fRootHierarchies;
    private UnionFind fUnionFind;
    private final boolean fExcludeBinaries;
    private final ReferencesInBinaryContext fBinaryRefs;
    private Map<IMethod, SearchMatch> fDeclarationToMatch;
    private boolean fSearchOnlyInCompilationUnit = false;

    private RippleMethodFinder2(IMethod method, boolean excludeBinaries, boolean searchOnlyInCompilationUnit) {
        this.fMethod = method;
        this.fExcludeBinaries = excludeBinaries;
        this.fSearchOnlyInCompilationUnit = searchOnlyInCompilationUnit;
        this.fBinaryRefs = null;
    }

    private RippleMethodFinder2(IMethod method, ReferencesInBinaryContext binaryRefs) {
        this.fMethod = method;
        this.fExcludeBinaries = true;
        this.fDeclarationToMatch = new HashMap<IMethod, SearchMatch>();
        this.fBinaryRefs = binaryRefs;
    }

    public static IMethod[] getRelatedMethods(IMethod method, boolean excludeBinaries, IProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        try {
            if (!MethodChecks.isVirtual(method)) {
                IMethod[] iMethodArray = new IMethod[]{method};
                return iMethodArray;
            }
            IMethod[] iMethodArray = new RippleMethodFinder2(method, excludeBinaries, false).getAllRippleMethods(pm, owner);
            return iMethodArray;
        }
        finally {
            pm.done();
        }
    }

    public static IMethod[] getRelatedMethodsInCompilationUnit(IMethod method, NullProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        try {
            if (!MethodChecks.isVirtual(method)) {
                IMethod[] iMethodArray = new IMethod[]{method};
                return iMethodArray;
            }
            IMethod[] iMethodArray = new RippleMethodFinder2(method, true, true).getAllRippleMethods((IProgressMonitor)pm, owner);
            return iMethodArray;
        }
        finally {
            pm.done();
        }
    }

    public static IMethod[] getRelatedMethods(IMethod method, IProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        return RippleMethodFinder2.getRelatedMethods(method, true, pm, owner);
    }

    public static IMethod[] getRelatedMethods(IMethod method, ReferencesInBinaryContext binaryRefs, IProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        try {
            if (!MethodChecks.isVirtual(method)) {
                IMethod[] iMethodArray = new IMethod[]{method};
                return iMethodArray;
            }
            IMethod[] iMethodArray = new RippleMethodFinder2(method, binaryRefs).getAllRippleMethods(pm, owner);
            return iMethodArray;
        }
        finally {
            pm.done();
        }
    }

    private IMethod[] getAllRippleMethods(IProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        IMethod[] rippleMethods = this.findAllRippleMethods(pm, owner);
        if (this.fDeclarationToMatch == null) {
            return rippleMethods;
        }
        ArrayList<IMethod> filteredMethods = new ArrayList<IMethod>(rippleMethods.length / 2);
        IMethod[] iMethodArray = rippleMethods;
        int n = rippleMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod currentMethod = iMethodArray[n2];
            SearchMatch match = this.fDeclarationToMatch.get(currentMethod);
            if (match != null) {
                this.fBinaryRefs.add(match);
            } else {
                filteredMethods.add(currentMethod);
            }
            ++n2;
        }
        this.fDeclarationToMatch = null;
        return RippleMethodFinder2.toArray(filteredMethods);
    }

    private IMethod[] findAllRippleMethods(IProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        boolean couldHaveMarriedAlienTypes;
        pm.beginTask("", 4);
        this.findAllDeclarations(Progress.subMonitor(pm, 1), owner);
        if (!this.fDeclarations.contains(this.fMethod)) {
            if (this.fSearchOnlyInCompilationUnit) {
                return new IMethod[0];
            }
            Assert.isTrue((boolean)false, (String)("Search for method declaration did not find original element: " + this.fMethod.toString()));
        }
        this.createHierarchyOfDeclarations(Progress.subMonitor(pm, 1), owner);
        this.addMissedSuperTypes();
        this.createTypeToMethod();
        this.createUnionFind();
        RippleMethodFinder2.checkCanceled(pm);
        this.fHierarchy = null;
        this.fRootTypes = null;
        HashMap<IType, ArrayList<IType>> partitioning = new HashMap<IType, ArrayList<IType>>();
        for (IType type : this.fTypeToMethod.fImplementation.keySet()) {
            IType rep = this.fUnionFind.find(type);
            ArrayList<IType> types = (ArrayList<IType>)partitioning.get(rep);
            if (types == null) {
                types = new ArrayList<IType>();
            }
            types.add(type);
            partitioning.put(rep, types);
        }
        Assert.isTrue((partitioning.size() > 0 ? 1 : 0) != 0);
        if (partitioning.size() == 1) {
            return this.fDeclarations.toArray(new IMethod[this.fDeclarations.size()]);
        }
        IType methodTypeRep = this.fUnionFind.find(this.fMethod.getDeclaringType());
        List relatedTypes = (List)partitioning.get(methodTypeRep);
        boolean hasRelatedInterfaces = false;
        ArrayList<IMethod> relatedMethods = new ArrayList<IMethod>();
        for (IType relatedType : relatedTypes) {
            relatedMethods.addAll(this.fTypeToMethod.get(relatedType));
            if (!relatedType.isInterface()) continue;
            hasRelatedInterfaces = true;
        }
        int numberOfSearchMatches = this.fDeclarations.size();
        LinkedHashSet<IMethod> alienDeclarations = new LinkedHashSet<IMethod>(this.fDeclarations);
        this.fDeclarations = null;
        alienDeclarations.removeAll(relatedMethods);
        LinkedHashSet<IType> alienTypes = new LinkedHashSet<IType>();
        boolean hasAlienInterfaces = false;
        for (IMethod alienDeclaration : alienDeclarations) {
            IType alienType = alienDeclaration.getDeclaringType();
            alienTypes.add(alienType);
            if (!alienType.isInterface()) continue;
            hasAlienInterfaces = true;
        }
        if (alienTypes.isEmpty()) {
            return RippleMethodFinder2.toArray(relatedMethods);
        }
        if (!hasRelatedInterfaces && !hasAlienInterfaces) {
            return RippleMethodFinder2.toArray(relatedMethods);
        }
        RippleMethodFinder2.checkCanceled(pm);
        IType methodType = this.fMethod.getDeclaringType();
        ITypeHierarchy methodHierarchy = this.hierarchy(pm, owner, this.fUnionFind.find(methodType));
        IType[] methodTypeSubtypes = methodHierarchy.getAllSubtypes(methodType);
        if (methodTypeSubtypes.length <= numberOfSearchMatches / 10 && !(couldHaveMarriedAlienTypes = this.couldHaveMarriedAlienTypes(pm, owner, methodHierarchy, methodTypeSubtypes))) {
            return RippleMethodFinder2.toArray(relatedMethods);
        }
        HashSet<IType> relatedSubTypes = new HashSet<IType>();
        ArrayList relatedTypesToProcess = new ArrayList(relatedTypes);
        while (relatedTypesToProcess.size() > 0) {
            for (IType relatedType : relatedTypesToProcess) {
                RippleMethodFinder2.checkCanceled(pm);
                ITypeHierarchy hierarchy = this.hierarchy(pm, owner, relatedType);
                IType[] allSubTypes = hierarchy.getAllSubtypes(relatedType);
                relatedSubTypes.addAll(Arrays.asList(allSubTypes));
            }
            relatedTypesToProcess.clear();
            HashSet<IType> marriedAlienTypeReps = new HashSet<IType>();
            for (IType alienType : alienTypes) {
                RippleMethodFinder2.checkCanceled(pm);
                Collection<IMethod> alienMethods = this.fTypeToMethod.get(alienType);
                for (IMethod alienMethod : alienMethods) {
                    ITypeHierarchy hierarchy = this.hierarchy(pm, owner, alienType);
                    IType[] iTypeArray = hierarchy.getAllSubtypes(alienType);
                    int n = iTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType subtype = iTypeArray[n2];
                        if (relatedSubTypes.contains(subtype) && JavaModelUtil.isVisibleInHierarchy((IMember)alienMethod, subtype.getPackageFragment())) {
                            marriedAlienTypeReps.add(this.fUnionFind.find(alienType));
                        }
                        ++n2;
                    }
                }
            }
            if (marriedAlienTypeReps.isEmpty()) {
                return RippleMethodFinder2.toArray(relatedMethods);
            }
            for (IType marriedAlienTypeRep : marriedAlienTypeReps) {
                List marriedAlienTypes = (List)partitioning.get(marriedAlienTypeRep);
                for (IType marriedAlienInterfaceType : marriedAlienTypes) {
                    relatedMethods.addAll(this.fTypeToMethod.get(marriedAlienInterfaceType));
                }
                alienTypes.removeAll(marriedAlienTypes);
                relatedTypesToProcess.addAll(marriedAlienTypes);
            }
        }
        this.fRootReps = null;
        this.fRootHierarchies = null;
        this.fTypeToMethod = null;
        this.fUnionFind = null;
        return RippleMethodFinder2.toArray(relatedMethods);
    }

    private boolean couldHaveMarriedAlienTypes(IProgressMonitor pm, WorkingCopyOwner owner, ITypeHierarchy methodHierarchy, IType[] methodTypeSubtypes) throws JavaModelException {
        HashSet<IType> allTypesInMethodHierarchy = new HashSet<IType>(Arrays.asList(methodHierarchy.getAllClasses()));
        allTypesInMethodHierarchy.addAll(Arrays.asList(methodHierarchy.getAllInterfaces()));
        IType[] iTypeArray = methodTypeSubtypes;
        int n = methodTypeSubtypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType[] subtypeSuperTypes;
            IType methodTypeSubtype = iTypeArray[n2];
            RippleMethodFinder2.checkCanceled(pm);
            ITypeHierarchy subtypeHierarchy = methodTypeSubtype.newTypeHierarchy(owner, pm);
            IType[] iTypeArray2 = subtypeSuperTypes = subtypeHierarchy.getAllSupertypes(methodTypeSubtype);
            int n3 = subtypeSuperTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                IType subtypeSuperType = iTypeArray2[n4];
                RippleMethodFinder2.checkCanceled(pm);
                if (!allTypesInMethodHierarchy.contains(subtypeSuperType) && RippleMethodFinder2.definesSimilarMethod(subtypeSuperType, this.fMethod)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private static boolean definesSimilarMethod(IType type, IMethod method) throws JavaModelException {
        String methodName = method.getElementName();
        IMethod[] typeMethods = type.getMethods();
        return Arrays.asList(typeMethods).stream().anyMatch(typeMethod -> methodName.equals(typeMethod.getElementName()));
    }

    private static IMethod[] toArray(List<IMethod> methods) {
        return methods.toArray(new IMethod[methods.size()]);
    }

    private static void checkCanceled(IProgressMonitor pm) {
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private ITypeHierarchy hierarchy(IProgressMonitor pm, WorkingCopyOwner owner, IType type) throws JavaModelException {
        ITypeHierarchy hierarchy = this.getCachedHierarchy(type, owner, Progress.subMonitor(pm, 1));
        if (hierarchy == null) {
            hierarchy = type.newTypeHierarchy(owner, Progress.subMonitor(pm, 1));
        }
        return hierarchy;
    }

    private void addMissedSuperTypes() throws JavaModelException {
        HashSet<IMethod> newDeclarations = new HashSet<IMethod>();
        for (IMethod method : this.fDeclarations) {
            MethodOverrideTester methodOverrideTester = new MethodOverrideTester(method.getDeclaringType(), this.fHierarchy);
            newDeclarations.addAll(methodOverrideTester.findAllOverridenMethods(method));
        }
        this.fDeclarations.addAll(newDeclarations);
    }

    private ITypeHierarchy getCachedHierarchy(IType type, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        IType rep = this.fUnionFind.find(type);
        if (rep != null) {
            for (IType root : this.fRootReps.get(rep)) {
                ITypeHierarchy hierarchy = this.fRootHierarchies.get(root);
                if (hierarchy == null) {
                    hierarchy = root.newTypeHierarchy(owner, Progress.subMonitor(monitor, 1));
                    this.fRootHierarchies.put(root, hierarchy);
                }
                if (!hierarchy.contains(type)) continue;
                return hierarchy;
            }
        }
        return null;
    }

    private void findAllDeclarations(IProgressMonitor monitor, WorkingCopyOwner owner) throws CoreException {
        this.fDeclarations = new HashSet<IMethod>();
        int limitTo = 48;
        int matchRule = 24;
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.fMethod, (int)limitTo, (int)matchRule);
        if (pattern == null) {
            return;
        }
        SearchParticipant[] participants = SearchUtils.getDefaultSearchParticipants();
        IJavaSearchScope scope = this.fSearchOnlyInCompilationUnit ? RefactoringScopeFactory.create((IJavaElement)this.fMethod.getCompilationUnit()) : RefactoringScopeFactory.createRelatedProjectsScope(this.fMethod.getJavaProject(), 7);
        class MethodRequestor
        extends SearchRequestor {
            MethodRequestor() {
            }

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IMethod method = (IMethod)match.getElement();
                boolean isVisible = JavaModelUtil.isVisibleInHierarchy((IMember)method, RippleMethodFinder2.this.fMethod.getDeclaringType().getPackageFragment());
                if (isVisible) {
                    boolean isBinary = method.isBinary();
                    if (RippleMethodFinder2.this.fBinaryRefs != null || !RippleMethodFinder2.this.fExcludeBinaries || !isBinary) {
                        RippleMethodFinder2.this.fDeclarations.add(method);
                    }
                    if (isBinary && RippleMethodFinder2.this.fBinaryRefs != null) {
                        RippleMethodFinder2.this.fDeclarationToMatch.put(method, match);
                    }
                }
            }
        }
        MethodRequestor requestor = new MethodRequestor();
        SearchEngine searchEngine = owner != null ? new SearchEngine(owner) : new SearchEngine();
        searchEngine.search(pattern, participants, scope, (SearchRequestor)requestor, monitor);
    }

    private void createHierarchyOfDeclarations(IProgressMonitor pm, WorkingCopyOwner owner) throws JavaModelException {
        Stream<IType> types = this.fDeclarations.stream().map(IMember::getDeclaringType);
        this.fHierarchy = RippleMethodFinder2.createHierarchyOfTypes(pm, owner, types);
    }

    private static ITypeHierarchy createHierarchyOfTypes(IProgressMonitor pm, WorkingCopyOwner owner, Stream<IType> types) throws JavaModelException {
        IRegion region = JavaCore.newRegion();
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            IType type = (IType)iter.next();
            region.add((IJavaElement)type);
        }
        return JavaCore.newTypeHierarchy((IRegion)region, (WorkingCopyOwner)owner, (IProgressMonitor)pm);
    }

    private void createTypeToMethod() {
        this.fTypeToMethod = new MultiMap();
        for (IMethod declaration : this.fDeclarations) {
            this.fTypeToMethod.put(declaration.getDeclaringType(), declaration);
        }
    }

    private void createUnionFind() throws JavaModelException {
        this.fRootTypes = new HashSet(this.fTypeToMethod.fImplementation.keySet());
        this.fUnionFind = new UnionFind();
        for (IType type : this.fTypeToMethod.fImplementation.keySet()) {
            this.fUnionFind.init(type);
        }
        for (IType type : this.fTypeToMethod.fImplementation.keySet()) {
            this.uniteWithSupertypes(type, type);
        }
        this.fRootReps = new MultiMap();
        for (IType type : this.fRootTypes) {
            IType rep = this.fUnionFind.find(type);
            if (rep == null) continue;
            this.fRootReps.put(rep, type);
        }
        this.fRootHierarchies = new HashMap<IType, ITypeHierarchy>();
    }

    private void uniteWithSupertypes(IType anchor, IType type) throws JavaModelException {
        IType[] iTypeArray = this.fHierarchy.getSupertypes(type);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType supertype = iTypeArray[n2];
            IType superRep = this.fUnionFind.find(supertype);
            if (superRep == null) {
                this.uniteWithSupertypes(anchor, supertype);
            } else {
                Collection<IMethod> superMethods = this.fTypeToMethod.get(supertype);
                for (IMethod superMethod : superMethods) {
                    if (!JavaModelUtil.isVisibleInHierarchy((IMember)superMethod, anchor.getPackageFragment())) continue;
                    IType rep = this.fUnionFind.find(anchor);
                    this.fUnionFind.union(rep, superRep);
                    this.fRootTypes.remove(anchor);
                    this.uniteWithSupertypes(supertype, supertype);
                }
            }
            ++n2;
        }
    }

    private static class MultiMap<K, V> {
        HashMap<K, Collection<V>> fImplementation = new HashMap();

        private MultiMap() {
        }

        public void put(K key, V value) {
            Collection<V> collection = this.fImplementation.get(key);
            if (collection == null) {
                collection = new HashSet<V>();
                this.fImplementation.put(key, collection);
            }
            collection.add(value);
        }

        public Collection<V> get(K key) {
            return this.fImplementation.get(key);
        }
    }

    private static class UnionFind {
        HashMap<IType, IType> fElementToRepresentative = new HashMap();

        private UnionFind() {
        }

        public void init(IType type) {
            this.fElementToRepresentative.put(type, type);
        }

        public IType find(IType element) {
            IType root = element;
            IType rep = this.fElementToRepresentative.get(root);
            while (rep != null && !rep.equals(root)) {
                root = rep;
                rep = this.fElementToRepresentative.get(root);
            }
            if (rep == null) {
                return null;
            }
            rep = this.fElementToRepresentative.get(element);
            while (!rep.equals(root)) {
                IType temp = element;
                element = rep;
                this.fElementToRepresentative.put(temp, root);
                rep = this.fElementToRepresentative.get(element);
            }
            return root;
        }

        public void union(IType rep1, IType rep2) {
            this.fElementToRepresentative.put(rep1, rep2);
        }
    }
}

