/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.PotentialProgrammingProblemsFixCore;
import org.eclipse.jdt.internal.ui.text.correction.IInvocationContextCore;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.internal.ui.text.correction.SerialVersionProposalCore;
import org.eclipse.jdt.ls.core.internal.corrections.ProposalKindWrapper;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;

public final class SerialVersionSubProcessor {
    public static final void getSerialVersionProposals(IInvocationContextCore context, IProblemLocationCore location, Collection<ProposalKindWrapper> proposals) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)location);
        Assert.isNotNull(proposals);
        IProposableFix[] fixes = PotentialProgrammingProblemsFixCore.createMissingSerialVersionFixes((CompilationUnit)context.getASTRoot(), (IProblemLocationCore)location);
        if (fixes != null) {
            proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)new SerialVersionProposalCore(fixes[0], 9, context, true), "quickfix"));
            ICompilationUnit unit = context.getCompilationUnit();
            if (unit != null && unit.getJavaProject() != null && !"jdt.ls-java-project".equals(unit.getJavaProject().getProject().getName())) {
                proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)new SerialVersionProposalCore(fixes[1], 9, context, false), "quickfix"));
            }
        }
    }
}

