/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.text.correction.AddAllMissingJavadocTagsProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.AddJavadocCommentProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.AddMissingJavadocTagProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.IInvocationContextCore;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.ProposalKindWrapper;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposalCore;
import org.eclipse.text.edits.TextEditGroup;

public class JavadocTagsSubProcessor {
    private static String[] TAG_ORDER = new String[]{"@author", "@version", "@param", "@return", "@throws", "@see", "@since", "@serial", "@deprecated"};

    public static void getMissingJavadocTagProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<ProposalKindWrapper> proposals) {
        String label;
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)(node = ASTNodes.getNormalizedNode((ASTNode)node)));
        if (bodyDeclaration == null) {
            return;
        }
        Javadoc javadoc = bodyDeclaration.getJavadoc();
        if (javadoc == null) {
            return;
        }
        StructuralPropertyDescriptor location = node.getLocationInParent();
        if (location == SingleVariableDeclaration.NAME_PROPERTY) {
            label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_paramtag_description;
            if (node.getParent().getLocationInParent() != MethodDeclaration.PARAMETERS_PROPERTY) {
                return;
            }
        } else if (location == TypeParameter.NAME_PROPERTY) {
            label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_paramtag_description;
            StructuralPropertyDescriptor parentLocation = node.getParent().getLocationInParent();
            if (parentLocation != MethodDeclaration.TYPE_PARAMETERS_PROPERTY && parentLocation != TypeDeclaration.TYPE_PARAMETERS_PROPERTY) {
                return;
            }
        } else if (location == MethodDeclaration.RETURN_TYPE2_PROPERTY) {
            label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_returntag_description;
        } else if (location == MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY) {
            label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_throwstag_description;
        } else {
            return;
        }
        AddMissingJavadocTagProposalCore proposal = new AddMissingJavadocTagProposalCore(label, context.getCompilationUnit(), (ASTNode)bodyDeclaration, node, 4);
        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
        String label2 = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_allmissing_description;
        AddAllMissingJavadocTagsProposalCore addAllMissing = new AddAllMissingJavadocTagsProposalCore(label2, context.getCompilationUnit(), (ASTNode)bodyDeclaration, 5);
        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)addAllMissing, "quickfix"));
    }

    public static void getUnusedAndUndocumentedParameterOrExceptionProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<ProposalKindWrapper> proposals) {
        String label;
        String key;
        ICompilationUnit cu = context.getCompilationUnit();
        IJavaProject project = cu.getJavaProject();
        if (!"enabled".equals(project.getOption("org.eclipse.jdt.core.compiler.doc.comment.support", true))) {
            return;
        }
        int problemId = problem.getProblemId();
        boolean isUnusedTypeParam = problemId == 16777877;
        boolean isUnusedParam = problemId == 536870974 || isUnusedTypeParam;
        String string = key = isUnusedParam ? "org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference" : "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference";
        if (!"enabled".equals(project.getOption(key, true))) {
            return;
        }
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        BodyDeclaration bodyDecl = ASTResolving.findParentBodyDeclaration((ASTNode)node);
        if (bodyDecl == null || ASTResolving.getParentMethodOrTypeBinding((ASTNode)bodyDecl) == null) {
            return;
        }
        if (isUnusedTypeParam) {
            label = CorrectionMessages.JavadocTagsSubProcessor_document_type_parameter_description;
        } else if (isUnusedParam) {
            label = CorrectionMessages.JavadocTagsSubProcessor_document_parameter_description;
        } else {
            node = ASTNodes.getNormalizedNode((ASTNode)node);
            label = CorrectionMessages.JavadocTagsSubProcessor_document_exception_description;
        }
        AddMissingJavadocTagProposalCore proposal = new AddMissingJavadocTagProposalCore(label, context.getCompilationUnit(), (ASTNode)bodyDecl, node, 1);
        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
    }

    /*
     * WARNING - void declaration
     */
    public static void getMissingJavadocCommentProposals(IInvocationContextCore context, ASTNode node, Collection<ProposalKindWrapper> proposals, String kind) throws CoreException {
        if (node == null) {
            return;
        }
        BodyDeclaration declaration = ASTResolving.findParentBodyDeclaration((ASTNode)node);
        if (declaration == null || declaration.getJavadoc() != null) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ITypeBinding binding = Bindings.getBindingOfParentType((ASTNode)declaration);
        if (binding == null) {
            return;
        }
        BodyDeclaration bodyDeclaration = declaration;
        if (bodyDeclaration instanceof MethodDeclaration) {
            void methodDecl;
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)bodyDeclaration;
            IMethodBinding methodBinding = methodDecl.resolveBinding();
            IMethodBinding overridden = null;
            if (methodBinding != null) {
                overridden = Bindings.findOverriddenMethod((IMethodBinding)methodBinding, (boolean)true);
            }
            if (!methodDecl.isConstructor() && methodDecl.getReturnType2() == null) {
                return;
            }
            String string = CodeGeneration.getMethodComment((ICompilationUnit)cu, (String)binding.getName(), (MethodDeclaration)methodDecl, (IMethodBinding)overridden, (String)String.valueOf('\n'));
            String methodName = methodDecl.getName().getIdentifier();
            if (string != null && methodName != null) {
                String label = Messages.format(CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_method_description, methodName);
                AddJavadocCommentProposalCore proposal = new AddJavadocCommentProposalCore(label, cu, 1, declaration.getStartPosition(), string);
                proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, kind));
            }
        } else if (declaration instanceof AbstractTypeDeclaration) {
            String[] typeParamNames;
            String typeQualifiedName = Bindings.getTypeQualifiedName((ITypeBinding)binding);
            BodyDeclaration label = declaration;
            if (label instanceof TypeDeclaration) {
                void typeDecl;
                TypeDeclaration string = (TypeDeclaration)label;
                TypeDeclaration cfr_ignored_1 = (TypeDeclaration)label;
                List typeParams = typeDecl.typeParameters();
                typeParamNames = new String[typeParams.size()];
                int i = 0;
                while (i < typeParamNames.length) {
                    typeParamNames[i] = ((TypeParameter)typeParams.get(i)).getName().getIdentifier();
                    ++i;
                }
            } else {
                typeParamNames = new String[]{};
            }
            String string = CodeGeneration.getTypeComment((ICompilationUnit)cu, (String)typeQualifiedName, (String[])typeParamNames, (String)String.valueOf('\n'));
            if (string != null && typeQualifiedName != null) {
                String label2 = Messages.format(CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_type_description, typeQualifiedName);
                AddJavadocCommentProposalCore p = new AddJavadocCommentProposalCore(label2, cu, 1, declaration.getStartPosition(), string);
                proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)p, kind));
            }
        } else {
            BodyDeclaration bodyDeclaration2 = declaration;
            if (bodyDeclaration2 instanceof FieldDeclaration) {
                void fieldDecl;
                FieldDeclaration typeQualifiedName = (FieldDeclaration)bodyDeclaration2;
                FieldDeclaration cfr_ignored_2 = (FieldDeclaration)bodyDeclaration2;
                String comment = "/**\n *\n */\n";
                String fieldName = null;
                List fragments = fieldDecl.fragments();
                if (fragments != null && fragments.size() > 0) {
                    VariableDeclaration decl = (VariableDeclaration)fragments.get(0);
                    fieldName = decl.getName().getIdentifier();
                    String typeName = binding.getName();
                    comment = CodeGeneration.getFieldComment((ICompilationUnit)cu, (String)typeName, (String)fieldName, (String)String.valueOf('\n'));
                }
                if (comment != null && fieldName != null) {
                    String label = Messages.format(CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_field_description, fieldName);
                    AddJavadocCommentProposalCore p = new AddJavadocCommentProposalCore(label, cu, 1, declaration.getStartPosition(), comment);
                    proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)p, kind));
                }
            } else {
                BodyDeclaration bodyDeclaration3 = declaration;
                if (bodyDeclaration3 instanceof EnumConstantDeclaration) {
                    void enumDecl;
                    EnumConstantDeclaration comment = (EnumConstantDeclaration)bodyDeclaration3;
                    EnumConstantDeclaration cfr_ignored_3 = (EnumConstantDeclaration)bodyDeclaration3;
                    String id = enumDecl.getName().getIdentifier();
                    String comment2 = CodeGeneration.getFieldComment((ICompilationUnit)cu, (String)binding.getName(), (String)id, (String)String.valueOf('\n'));
                    if (comment2 != null && id != null) {
                        String label = Messages.format(CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_enumconst_description, id);
                        AddJavadocCommentProposalCore p = new AddJavadocCommentProposalCore(label, cu, 1, declaration.getStartPosition(), comment2);
                        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)p, kind));
                    }
                }
            }
        }
    }

    public static Set<String> getPreviousTypeParamNames(List<TypeParameter> typeParams, ASTNode missingNode) {
        HashSet<String> previousNames = new HashSet<String>();
        int i = 0;
        while (i < typeParams.size()) {
            TypeParameter curr = typeParams.get(i);
            if (curr == missingNode) {
                return previousNames;
            }
            previousNames.add("<" + curr.getName().getIdentifier() + ">");
            ++i;
        }
        return previousNames;
    }

    private static Set<String> getPreviousParamNames(List<SingleVariableDeclaration> params, ASTNode missingNode) {
        HashSet<String> previousNames = new HashSet<String>();
        int i = 0;
        while (i < params.size()) {
            SingleVariableDeclaration curr = params.get(i);
            if (curr == missingNode) {
                return previousNames;
            }
            previousNames.add(curr.getName().getIdentifier());
            ++i;
        }
        return previousNames;
    }

    private static Set<String> getPreviousExceptionNames(List<Type> list, ASTNode missingNode) {
        HashSet<String> previousNames = new HashSet<String>();
        int i = 0;
        while (i < list.size() && missingNode != list.get(i)) {
            Type curr = list.get(i);
            previousNames.add(ASTNodes.getTypeName((Type)curr));
            ++i;
        }
        return previousNames;
    }

    public static TagElement findTag(Javadoc javadoc, String name, String arg) {
        List tags = javadoc.tags();
        int nTags = tags.size();
        int i = 0;
        while (i < nTags) {
            TagElement curr = (TagElement)tags.get(i);
            if (name.equals(curr.getTagName())) {
                if (arg != null) {
                    String argument = JavadocTagsSubProcessor.getArgument(curr);
                    if (arg.equals(argument)) {
                        return curr;
                    }
                } else {
                    return curr;
                }
            }
            ++i;
        }
        return null;
    }

    public static TagElement findParamTag(Javadoc javadoc, String arg) {
        List tags = javadoc.tags();
        int nTags = tags.size();
        int i = 0;
        while (i < nTags) {
            String argument;
            TagElement curr = (TagElement)tags.get(i);
            String currName = curr.getTagName();
            if ("@param".equals(currName) && arg.equals(argument = JavadocTagsSubProcessor.getArgument(curr))) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public static TagElement findThrowsTag(Javadoc javadoc, String arg) {
        List tags = javadoc.tags();
        int nTags = tags.size();
        int i = 0;
        while (i < nTags) {
            String argument;
            TagElement curr = (TagElement)tags.get(i);
            String currName = curr.getTagName();
            if (("@throws".equals(currName) || "@exception".equals(currName)) && arg.equals(argument = JavadocTagsSubProcessor.getArgument(curr))) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public static void insertTag(ListRewrite rewriter, TagElement newElement, Set<String> sameKindLeadingNames) {
        JavadocTagsSubProcessor.insertTag(rewriter, newElement, sameKindLeadingNames, null);
    }

    public static void insertTag(ListRewrite rewriter, TagElement newElement, Set<String> sameKindLeadingNames, TextEditGroup groupDescription) {
        List tags = rewriter.getRewrittenList();
        String insertedTagName = newElement.getTagName();
        TagElement after = null;
        int tagRanking = JavadocTagsSubProcessor.getTagRanking(insertedTagName);
        int i = tags.size() - 1;
        while (i >= 0) {
            String arg;
            TagElement curr = (TagElement)tags.get(i);
            String tagName = curr.getTagName();
            if (tagName == null || tagRanking > JavadocTagsSubProcessor.getTagRanking(tagName)) {
                after = curr;
                break;
            }
            if (sameKindLeadingNames != null && JavadocTagsSubProcessor.isSameTag(insertedTagName, tagName) && (arg = JavadocTagsSubProcessor.getArgument(curr)) != null && sameKindLeadingNames.contains(arg)) {
                after = curr;
                break;
            }
            --i;
        }
        if (after != null) {
            rewriter.insertAfter((ASTNode)newElement, after, groupDescription);
        } else {
            rewriter.insertFirst((ASTNode)newElement, groupDescription);
        }
    }

    private static boolean isSameTag(String insertedTagName, String tagName) {
        if (insertedTagName.equals(tagName)) {
            return true;
        }
        if ("@exception".equals(tagName)) {
            return "@throws".equals(insertedTagName);
        }
        return false;
    }

    private static int getTagRanking(String tagName) {
        if (tagName.equals("@exception")) {
            tagName = "@throws";
        }
        int i = 0;
        while (i < TAG_ORDER.length) {
            if (tagName.equals(TAG_ORDER[i])) {
                return i;
            }
            ++i;
        }
        return TAG_ORDER.length;
    }

    /*
     * WARNING - void declaration
     */
    private static String getArgument(TagElement curr) {
        List fragments = curr.fragments();
        if (!fragments.isEmpty()) {
            Object first = fragments.get(0);
            Object e = first;
            if (e instanceof Name) {
                void name;
                Name name2 = (Name)e;
                Name cfr_ignored_0 = (Name)e;
                return ASTNodes.getSimpleNameIdentifier((Name)name);
            }
            Object e2 = first;
            if (e2 instanceof TextElement) {
                TextElement textElement = (TextElement)e2;
                TextElement cfr_ignored_1 = (TextElement)e2;
                if ("@param".equals(curr.getTagName())) {
                    void firstTextElement;
                    String text = firstTextElement.getText();
                    if ("<".equals(text) && fragments.size() >= 3) {
                        Object second = fragments.get(1);
                        Object third = fragments.get(2);
                        Object e3 = second;
                        if (e3 instanceof Name) {
                            Name name = (Name)e3;
                            Name cfr_ignored_2 = (Name)e3;
                            Object e4 = third;
                            if (e4 instanceof TextElement) {
                                void thirdTextElement;
                                TextElement textElement2 = (TextElement)e4;
                                TextElement cfr_ignored_3 = (TextElement)e4;
                                if (">".equals(thirdTextElement.getText())) {
                                    void secondName;
                                    return "<" + ASTNodes.getSimpleNameIdentifier((Name)secondName) + ">";
                                }
                            }
                        }
                    } else if (text.startsWith(String.valueOf('<')) && text.endsWith(String.valueOf('>')) && text.length() > 2) {
                        return text.substring(1, text.length() - 1);
                    }
                }
            }
        }
        return null;
    }

    public static void getRemoveJavadocTagProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<ProposalKindWrapper> proposals) {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        while (node != null && !(node instanceof TagElement)) {
            node = node.getParent();
        }
        if (node == null) {
            return;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)node.getAST());
        rewrite.remove(node, null);
        String label = CorrectionMessages.JavadocTagsSubProcessor_removetag_description;
        ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 5);
        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
    }

    public static void getInvalidQualificationProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<ProposalKindWrapper> proposals) {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (!(node instanceof Name)) {
            return;
        }
        Name name = (Name)node;
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof ITypeBinding)) {
            return;
        }
        ITypeBinding typeBinding = (ITypeBinding)binding;
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        rewrite.replace((ASTNode)name, (ASTNode)ast.newName(typeBinding.getQualifiedName()), null);
        String label = CorrectionMessages.JavadocTagsSubProcessor_qualifylinktoinner_description;
        ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 5);
        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
    }
}

