/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.ExtractSuperclassDescriptor;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MultiStateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.PullUpRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileManagerCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditGroup;

public final class ExtractSupertypeProcessor
extends PullUpRefactoringProcessor {
    private static final String ATTRIBUTE_EXTRACT = "extract";
    private static final String ATTRIBUTE_TYPES = "types";
    private static final GroupCategorySet SET_EXTRACT_SUPERTYPE = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.extractSupertype", RefactoringCoreMessages.ExtractSupertypeProcessor_category_name, RefactoringCoreMessages.ExtractSupertypeProcessor_category_description));
    private final Map<ICompilationUnit, CompilationUnitChange> fLayerChanges = new HashMap<ICompilationUnit, CompilationUnitChange>();
    private IType[] fPossibleCandidates = new IType[0];
    private String fSuperSource;
    private String fTypeName = "";
    private IType[] fTypesToExtract = new IType[0];
    private List<FieldInfo> fUninitializedFinalFieldsToMove = new ArrayList<FieldInfo>();

    public ExtractSupertypeProcessor(IMember[] members, CodeGenerationSettings settings) {
        super(members, settings, true);
        IType declaring;
        if (members != null && (declaring = this.getDeclaringType()) != null) {
            this.fTypesToExtract = new IType[]{declaring};
        }
    }

    public ExtractSupertypeProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        super(null, null, true);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    @Override
    public String getProcessorName() {
        return RefactoringCoreMessages.ExtractSupertypeProcessor_extract_supertype;
    }

    @Override
    protected RefactoringStatus checkDeclaringSuperTypes(IProgressMonitor monitor) throws JavaModelException {
        return new RefactoringStatus();
    }

    @Override
    protected CompilationUnitRewrite getCompilationUnitRewrite(Map<ICompilationUnit, CompilationUnitRewrite> rewrites, ICompilationUnit unit) {
        Assert.isNotNull(rewrites);
        Assert.isNotNull((Object)unit);
        CompilationUnitRewrite rewrite = rewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(this.fOwner, unit);
            rewrite.rememberContent();
            rewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    public RefactoringStatus checkExtractedCompilationUnit() {
        RefactoringStatus status = new RefactoringStatus();
        ICompilationUnit cu = this.getDeclaringType().getCompilationUnit();
        if (this.fTypeName == null || "".equals(this.fTypeName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_Choose_name);
        }
        status.merge(Checks.checkTypeName(this.fTypeName, (IJavaElement)cu));
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(Checks.checkCompilationUnitName(JavaModelUtil.getRenamedCUName(cu, this.fTypeName), (IJavaElement)cu));
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(Checks.checkCompilationUnitNewName(cu, this.fTypeName));
        return status;
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_checking);
            status.merge(this.checkExtractedCompilationUnit());
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = super.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(monitor, 1), context);
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    public IType computeExtractedType(String name) {
        if (name != null && !name.isEmpty()) {
            IType declaring = this.getDeclaringType();
            try {
                String newName = JavaModelUtil.getRenamedCUName(declaring.getCompilationUnit(), name);
                ICompilationUnit result = null;
                ICompilationUnit[] iCompilationUnitArray = declaring.getPackageFragment().getCompilationUnits(this.fOwner);
                int n = iCompilationUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit unit = iCompilationUnitArray[n2];
                    if (unit.getElementName().equals(newName)) {
                        result = unit;
                    }
                    ++n2;
                }
                if (result != null) {
                    IType type = result.getType(name);
                    this.setDestinationType(type);
                    return type;
                }
            }
            catch (JavaModelException exception) {
                JavaManipulationPlugin.log(exception);
            }
        }
        return null;
    }

    @Override
    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IType declaring = this.getDeclaringType();
            IJavaProject javaProject = declaring.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589830;
            try {
                if (declaring.isLocal() || declaring.isAnonymous()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaModelException exception) {
                JavaManipulationPlugin.log(exception);
            }
            String description = Messages.format(RefactoringCoreMessages.ExtractSupertypeProcessor_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fTypeName));
            String header = Messages.format(RefactoringCoreMessages.ExtractSupertypeProcessor_descriptor_description, new String[]{JavaElementLabelsCore.getElementLabel((IJavaElement)this.fDestinationType, 2235681801344L), JavaElementLabelsCore.getElementLabel((IJavaElement)this.fCachedDeclaringType, 2235681801344L)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
            IType[] types = this.getTypesToExtract();
            String[] settings = new String[types.length];
            int index = 0;
            while (index < settings.length) {
                settings[index] = JavaElementLabelsCore.getElementLabel((IJavaElement)types[index], 2235681801344L);
                ++index;
            }
            comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ExtractSupertypeProcessor_subtypes_pattern, settings));
            comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractSupertypeProcessor_refactored_element_pattern, JavaElementLabelsCore.getElementLabel((IJavaElement)this.fDestinationType, 2235681801344L)));
            settings = new String[this.fMembersToMove.length];
            index = 0;
            while (index < settings.length) {
                settings[index] = JavaElementLabelsCore.getElementLabel((IJavaElement)this.fMembersToMove[index], 2235681801344L);
                ++index;
            }
            comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ExtractInterfaceProcessor_extracted_members_pattern, settings));
            this.addSuperTypeSettings(comment, true);
            ExtractSuperclassDescriptor descriptor = RefactoringSignatureDescriptorFactory.createExtractSuperclassDescriptor(project, description, comment.asString(), arguments, flags);
            arguments.put("name", this.fTypeName);
            arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.getDeclaringType()));
            arguments.put("replace", Boolean.toString(this.fReplace));
            arguments.put("instanceof", Boolean.toString(this.fInstanceOf));
            arguments.put("stubs", Boolean.toString(this.fCreateMethodStubs));
            arguments.put(ATTRIBUTE_EXTRACT, Integer.toString(this.fMembersToMove.length));
            int offset = 0;
            while (offset < this.fMembersToMove.length) {
                arguments.put("element" + (offset + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fMembersToMove[offset]));
                ++offset;
            }
            arguments.put("delete", Integer.toString(this.fDeletedMethods.length));
            offset = 0;
            while (offset < this.fDeletedMethods.length) {
                arguments.put("element" + (offset + this.fMembersToMove.length + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fDeletedMethods[offset]));
                ++offset;
            }
            arguments.put("abstract", Integer.toString(this.fAbstractMethods.length));
            offset = 0;
            while (offset < this.fAbstractMethods.length) {
                arguments.put("element" + (offset + this.fMembersToMove.length + this.fDeletedMethods.length + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fAbstractMethods[offset]));
                ++offset;
            }
            arguments.put(ATTRIBUTE_TYPES, Integer.toString(this.fTypesToExtract.length));
            offset = 0;
            while (offset < this.fTypesToExtract.length) {
                arguments.put("element" + (offset + this.fMembersToMove.length + this.fDeletedMethods.length + this.fAbstractMethods.length + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fTypesToExtract[offset]));
                ++offset;
            }
            DynamicValidationRefactoringChange change = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.ExtractSupertypeProcessor_extract_supertype, (Change[])this.fChangeManager.getAllChanges());
            IFile file = ResourceUtil.getFile(declaring.getCompilationUnit());
            if (this.fSuperSource != null && this.fSuperSource.length() > 0) {
                change.add((Change)new CreateCompilationUnitChange(declaring.getPackageFragment().getCompilationUnit(JavaModelUtil.getRenamedCUName(declaring.getCompilationUnit(), this.fTypeName)), this.fSuperSource, file.getCharset(false)));
            }
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = change;
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
            this.clearCaches();
        }
    }

    protected RefactoringStatus createExtractedSuperType(IType superType, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)monitor);
        this.fSuperSource = null;
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing, 20);
            IType declaring = this.getDeclaringType();
            CompilationUnitRewrite declaringRewrite = new CompilationUnitRewrite(this.fOwner, declaring.getCompilationUnit());
            AbstractTypeDeclaration declaringDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(declaring, declaringRewrite.getRoot());
            if (declaringDeclaration != null) {
                String name = JavaModelUtil.getRenamedCUName(declaring.getCompilationUnit(), this.fTypeName);
                ICompilationUnit original = declaring.getPackageFragment().getCompilationUnit(name);
                ICompilationUnit copy = this.getSharedWorkingCopy(original.getPrimary(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                this.fSuperSource = this.createSuperTypeSource(copy, superType, declaringDeclaration, declaringRewrite, status, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                if (this.fSuperSource != null) {
                    copy.getBuffer().setContents(this.fSuperSource);
                    JavaModelUtil.reconcile(copy);
                }
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    protected void createModifiedSubType(ICompilationUnit unit, CompilationUnit root, IType extractedType, ITypeBinding extractedBinding, AbstractTypeDeclaration subDeclaration, RefactoringStatus status) {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)subDeclaration);
        Assert.isNotNull((Object)extractedType);
        try {
            CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.fOwner, unit, root);
            this.createTypeSignature(rewrite, subDeclaration, extractedType, extractedBinding, (IProgressMonitor)new NullProgressMonitor());
            Document document = new Document(unit.getBuffer().getContents());
            CompilationUnitChange change = rewrite.createChange(true);
            if (change != null) {
                this.fLayerChanges.put(unit.getPrimary(), change);
                TextEdit edit = change.getEdit();
                if (edit != null) {
                    TextEditCopier copier = new TextEditCopier(edit);
                    TextEdit copy = copier.perform();
                    copy.apply((IDocument)document, 0);
                }
            }
            ICompilationUnit copy = this.getSharedWorkingCopy(unit, (IProgressMonitor)new NullProgressMonitor());
            copy.getBuffer().setContents(document.get());
            JavaModelUtil.reconcile(copy);
        }
        catch (CoreException | BadLocationException | MalformedTreeException exception) {
            JavaManipulationPlugin.log(exception);
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
        }
    }

    protected void createNecessaryConstructors(CompilationUnitRewrite targetRewrite, IType superType, AbstractTypeDeclaration targetDeclaration, AbstractTypeDeclaration declaringDeclaration, CompilationUnitRewrite declaringRewrite, RefactoringStatus status) {
        ITypeBinding binding;
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)targetDeclaration);
        this.fUninitializedFinalFieldsToMove.clear();
        if (superType != null && (binding = targetDeclaration.resolveBinding()) != null && binding.isClass()) {
            IMethodBinding[] bindings = StubUtility2Core.getVisibleConstructors(binding, true, true);
            int deprecationCount = 0;
            IMethodBinding[] iMethodBindingArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding b = iMethodBindingArray[n2];
                if (b.isDeprecated()) {
                    ++deprecationCount;
                }
                ++n2;
            }
            ListRewrite rewrite = targetRewrite.getASTRewrite().getListRewrite((ASTNode)targetDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            if (rewrite != null) {
                List members = declaringDeclaration.bodyDeclarations();
                ImportRewrite importRewrite = targetRewrite.getImportRewrite();
                for (BodyDeclaration member : members) {
                    int modifiers;
                    FieldDeclaration fieldDecl;
                    Type fieldType;
                    ITypeBinding fieldTypeBinding;
                    if (!(member instanceof FieldDeclaration) || (fieldTypeBinding = (fieldType = (fieldDecl = (FieldDeclaration)member).getType()).resolveBinding()) == null || !Modifier.isFinal((int)(modifiers = fieldDecl.getModifiers())) || Modifier.isStatic((int)modifiers)) continue;
                    List fragments = fieldDecl.fragments();
                    for (VariableDeclarationFragment fragment : fragments) {
                        IMember[] iMemberArray = this.fMembersToMove;
                        int n3 = this.fMembersToMove.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String name;
                            IMember memberToMove = iMemberArray[n4];
                            if (memberToMove instanceof IField && (name = memberToMove.getElementName()).equals(fragment.getName().getFullyQualifiedName()) && fragment.getInitializer() == null) {
                                this.fUninitializedFinalFieldsToMove.add(new FieldInfo(fieldTypeBinding, name));
                            }
                            ++n4;
                        }
                    }
                }
                boolean createDeprecated = deprecationCount == bindings.length;
                IMethodBinding[] iMethodBindingArray2 = bindings;
                int n5 = bindings.length;
                int n6 = 0;
                while (n6 < n5) {
                    IMethodBinding curr = iMethodBindingArray2[n6];
                    if (!curr.isDeprecated() || createDeprecated) {
                        try {
                            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)targetDeclaration, targetRewrite.getImportRewrite());
                            MethodDeclaration stub = StubUtility2Core.createConstructorStub(targetRewrite.getCu(), targetRewrite.getASTRewrite(), targetRewrite.getImportRewrite(), context, curr, binding.getName(), 1, false, false, this.fSettings);
                            if (stub != null) {
                                if (!this.fUninitializedFinalFieldsToMove.isEmpty()) {
                                    ASTRewrite astRewrite = targetRewrite.getASTRewrite();
                                    List<SingleVariableDeclaration> newParms = this.getNewConstructorParms(stub, this.fUninitializedFinalFieldsToMove, importRewrite);
                                    stub.parameters().addAll(newParms);
                                    Block body = stub.getBody();
                                    ListRewrite bodyRewrite = astRewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY);
                                    int i = 0;
                                    while (i < this.fUninitializedFinalFieldsToMove.size()) {
                                        FieldInfo finalField = this.fUninitializedFinalFieldsToMove.get(i);
                                        SingleVariableDeclaration parm = newParms.get(i);
                                        String name = finalField.getFieldName();
                                        String buffer = "this." + name + " = " + parm.getName().getFullyQualifiedName() + ";";
                                        ExpressionStatement assignment = (ExpressionStatement)astRewrite.createStringPlaceholder(buffer, 21);
                                        bodyRewrite.insertLast((ASTNode)assignment, null);
                                        ++i;
                                    }
                                }
                                rewrite.insertLast((ASTNode)stub, null);
                            }
                        }
                        catch (CoreException exception) {
                            JavaManipulationPlugin.log(exception);
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
                        }
                    }
                    ++n6;
                }
            }
        }
    }

    private List<SingleVariableDeclaration> getNewConstructorParms(MethodDeclaration stub, List<FieldInfo> uninitializedFinalFieldsToMove, ImportRewrite importRewrite) {
        Object name;
        ArrayList<SingleVariableDeclaration> result = new ArrayList<SingleVariableDeclaration>();
        HashSet<String> usedFieldNames = new HashSet<String>();
        HashSet<String> usedFinalFieldNames = new HashSet<String>();
        List params = stub.parameters();
        for (SingleVariableDeclaration param : params) {
            usedFieldNames.add(param.getName().getFullyQualifiedName());
        }
        for (FieldInfo fieldInfo : uninitializedFinalFieldsToMove) {
            name = fieldInfo.getFieldName();
            usedFinalFieldNames.add((String)name);
        }
        for (FieldInfo fieldInfo : uninitializedFinalFieldsToMove) {
            name = fieldInfo.getFieldName();
            if (usedFieldNames.contains(name)) {
                Object newName = name;
                int i = 2;
                while (usedFieldNames.contains(newName = (String)name + "_" + i++) || usedFinalFieldNames.contains(newName)) {
                }
                name = newName;
            }
            AST ast = stub.getAST();
            SingleVariableDeclaration newParam = ast.newSingleVariableDeclaration();
            newParam.setName(ast.newSimpleName((String)name));
            newParam.setType(importRewrite.addImport(fieldInfo.getFieldBinding(), ast));
            result.add(newParam);
        }
        return result;
    }

    @Override
    public RefactoringStatus checkFinalFields(IProgressMonitor monitor) {
        RefactoringStatus result = new RefactoringStatus();
        monitor.done();
        return result;
    }

    private void fixConstructorsWithFinalFieldInitialization(CompilationUnitRewrite rewrite) {
        final ASTRewrite rewriter = rewrite.getASTRewrite();
        final CompilationUnit cu = rewrite.getRoot();
        ASTVisitor visitor = new ASTVisitor(){
            MethodDeclaration currentConstructor = null;
            SuperConstructorInvocation currentSuperCall = null;
            boolean constructorInvocation = false;
            Expression[] fRightSide;
            {
                this.fRightSide = new Expression[ExtractSupertypeProcessor.this.fUninitializedFinalFieldsToMove.size()];
            }

            public boolean visit(MethodDeclaration node) {
                IMethodBinding binding = node.resolveBinding();
                if (binding != null && node.isConstructor() && binding.getDeclaringClass().getQualifiedName().equals(ExtractSupertypeProcessor.this.getDeclaringType().getFullyQualifiedName())) {
                    this.currentConstructor = node;
                    return true;
                }
                return false;
            }

            public boolean visit(SuperConstructorInvocation node) {
                this.currentSuperCall = node;
                return false;
            }

            public boolean visit(ConstructorInvocation node) {
                this.constructorInvocation = true;
                return false;
            }

            public void endVisit(MethodDeclaration node) {
                if (!this.constructorInvocation && this.currentConstructor != null) {
                    Block constructorBody = this.currentConstructor.getBody();
                    ListRewrite constructorRewrite = rewriter.getListRewrite((ASTNode)constructorBody, Block.STATEMENTS_PROPERTY);
                    AST ast = cu.getAST();
                    if (this.currentSuperCall != null) {
                        SuperConstructorInvocation newSuperCall = ast.newSuperConstructorInvocation();
                        List oldArguments = this.currentSuperCall.arguments();
                        for (Expression argument : oldArguments) {
                            newSuperCall.arguments().add(rewriter.createCopyTarget((ASTNode)argument));
                        }
                        Expression[] expressionArray = this.fRightSide;
                        int n = this.fRightSide.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Expression exp = expressionArray[n2];
                            if (exp == null) {
                                return;
                            }
                            Expression newExp = (Expression)rewriter.createCopyTarget((ASTNode)exp);
                            newSuperCall.arguments().add(newExp);
                            Statement stmt = ASTNodes.getFirstAncestorOrNull((ASTNode)exp, Statement.class);
                            constructorRewrite.remove((ASTNode)stmt, null);
                            ++n2;
                        }
                        constructorRewrite.replace((ASTNode)this.currentSuperCall, (ASTNode)newSuperCall, null);
                    } else {
                        SuperConstructorInvocation newSuperCall = ast.newSuperConstructorInvocation();
                        Expression[] expressionArray = this.fRightSide;
                        int n = this.fRightSide.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Expression exp = expressionArray[n3];
                            if (exp == null) {
                                return;
                            }
                            Expression newExp = (Expression)rewriter.createCopyTarget((ASTNode)exp);
                            newSuperCall.arguments().add(newExp);
                            Statement stmt = ASTNodes.getFirstAncestorOrNull((ASTNode)exp, Statement.class);
                            constructorRewrite.remove((ASTNode)stmt, null);
                            ++n3;
                        }
                        constructorRewrite.insertFirst((ASTNode)newSuperCall, null);
                    }
                }
                this.currentConstructor = null;
                this.currentSuperCall = null;
                this.constructorInvocation = false;
            }

            public boolean visit(Assignment node) {
                block4: {
                    IVariableBinding varBinding;
                    IBinding binding;
                    Expression leftSide;
                    block5: {
                        if (this.currentConstructor == null) break block4;
                        leftSide = node.getLeftHandSide();
                        if (!(leftSide instanceof FieldAccess)) break block5;
                        FieldAccess f = (FieldAccess)leftSide;
                        int i = 0;
                        while (i < ExtractSupertypeProcessor.this.fUninitializedFinalFieldsToMove.size()) {
                            if (ExtractSupertypeProcessor.this.fUninitializedFinalFieldsToMove.get(i).getFieldName().equals(f.getName().getFullyQualifiedName())) {
                                this.fRightSide[i] = node.getRightHandSide();
                            }
                            ++i;
                        }
                        break block4;
                    }
                    if (!(leftSide instanceof SimpleName) || !((binding = ((SimpleName)leftSide).resolveBinding()) instanceof IVariableBinding) || !(varBinding = (IVariableBinding)binding).isField() || !varBinding.getDeclaringClass().getQualifiedName().equals(ExtractSupertypeProcessor.this.getDeclaringType().getFullyQualifiedName())) break block4;
                    String fieldName = ((SimpleName)leftSide).getFullyQualifiedName();
                    int i = 0;
                    while (i < ExtractSupertypeProcessor.this.fUninitializedFinalFieldsToMove.size()) {
                        if (ExtractSupertypeProcessor.this.fUninitializedFinalFieldsToMove.get(i).getFieldName().equals(fieldName)) {
                            this.fRightSide[i] = node.getRightHandSide();
                        }
                        ++i;
                    }
                }
                return false;
            }
        };
        cu.accept(visitor);
    }

    protected String createSuperTypeSource(ICompilationUnit extractedWorkingCopy, IType superType, AbstractTypeDeclaration declaringDeclaration, CompilationUnitRewrite declaringRewrite, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        String source;
        block13: {
            Assert.isNotNull((Object)extractedWorkingCopy);
            Assert.isNotNull((Object)declaringDeclaration);
            Assert.isNotNull((Object)status);
            Assert.isNotNull((Object)monitor);
            source = null;
            try {
                String imports;
                monitor.beginTask("", 2);
                monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
                IType declaring = this.getDeclaringType();
                String delimiter = StubUtility.getLineDelimiterUsed(extractedWorkingCopy.getJavaProject());
                String typeComment = null;
                String fileComment = null;
                if (this.fSettings.createComments) {
                    ITypeParameter[] parameters = declaring.getTypeParameters();
                    String[] names = new String[parameters.length];
                    int index = 0;
                    while (index < parameters.length) {
                        names[index] = parameters[index].getElementName();
                        ++index;
                    }
                    typeComment = CodeGeneration.getTypeComment(extractedWorkingCopy, this.fTypeName, names, delimiter);
                    fileComment = CodeGeneration.getFileComment(extractedWorkingCopy, delimiter);
                }
                StringBuffer buffer = new StringBuffer(64);
                ITypeBinding binding = declaringDeclaration.resolveBinding();
                if (binding != null) {
                    ITypeBinding superBinding = binding.getSuperclass();
                    if (superBinding != null) {
                        this.fTypeBindings.add(superBinding);
                    }
                    ITypeBinding[] typeParameters = binding.getTypeParameters();
                    Collections.addAll(this.fTypeBindings, typeParameters);
                    ITypeBinding[] bindings = binding.getInterfaces();
                    Collections.addAll(this.fTypeBindings, bindings);
                }
                if ((imports = this.createTypeImports(extractedWorkingCopy, monitor)) != null && !"".equals(imports)) {
                    buffer.append(imports);
                }
                this.createTypeDeclaration(extractedWorkingCopy, superType, declaringDeclaration, declaringRewrite, typeComment, buffer, status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                source = this.createTypeTemplate(extractedWorkingCopy, "", fileComment, "", buffer.toString());
                if (source == null) {
                    if (!declaring.getPackageFragment().isDefaultPackage()) {
                        if (imports != null && imports.length() > 0) {
                            buffer.insert(0, imports);
                        }
                        buffer.insert(0, "package " + declaring.getPackageFragment().getElementName() + ";");
                    }
                    source = buffer.toString();
                }
                Document document = new Document(source);
                TextEdit edit = CodeFormatterUtil.format2(8, source, 0, delimiter, FormatterProfileManagerCore.getProjectSettings(extractedWorkingCopy.getJavaProject()));
                if (edit == null) break block13;
                try {
                    edit.apply((IDocument)document, 2);
                }
                catch (BadLocationException | MalformedTreeException exception) {
                    JavaManipulationPlugin.log(exception);
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
                }
                source = document.get();
            }
            finally {
                monitor.done();
            }
        }
        return source;
    }

    protected void createTypeDeclaration(ICompilationUnit extractedWorkingCopy, IType superType, AbstractTypeDeclaration declaringDeclaration, CompilationUnitRewrite declaringRewrite, String comment, StringBuffer buffer, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)extractedWorkingCopy);
        Assert.isNotNull((Object)declaringDeclaration);
        Assert.isNotNull((Object)buffer);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
            IJavaProject project = extractedWorkingCopy.getJavaProject();
            String delimiter = StubUtility.getLineDelimiterUsed(project);
            if (comment != null && !"".equals(comment)) {
                buffer.append(comment);
                buffer.append(delimiter);
            }
            buffer.append("public");
            if (superType != null && Flags.isAbstract((int)superType.getFlags())) {
                buffer.append(' ');
                buffer.append("abstract ");
            }
            buffer.append(' ');
            buffer.append("class ");
            buffer.append(this.fTypeName);
            if (superType != null && !"java.lang.Object".equals(superType.getFullyQualifiedName())) {
                buffer.append(' ');
                if (superType.isInterface()) {
                    buffer.append("implements ");
                } else {
                    buffer.append("extends ");
                }
                buffer.append(superType.getElementName());
            }
            buffer.append(" {");
            buffer.append(delimiter);
            buffer.append(delimiter);
            buffer.append('}');
            String string = buffer.toString();
            extractedWorkingCopy.getBuffer().setContents(string);
            Document document = new Document(string);
            CompilationUnitRewrite targetRewrite = new CompilationUnitRewrite(this.fOwner, extractedWorkingCopy);
            AbstractTypeDeclaration targetDeclaration = (AbstractTypeDeclaration)targetRewrite.getRoot().types().get(0);
            this.createTypeParameters(targetRewrite, superType, declaringDeclaration, targetDeclaration);
            this.createTypeSignature(targetRewrite, superType, declaringDeclaration, targetDeclaration);
            this.createNecessaryConstructors(targetRewrite, superType, targetDeclaration, declaringDeclaration, declaringRewrite, status);
            TextEdit edit = targetRewrite.createChange(true).getEdit();
            try {
                edit.apply((IDocument)document, 2);
            }
            catch (BadLocationException | MalformedTreeException exception) {
                JavaManipulationPlugin.log(exception);
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
            }
            buffer.setLength(0);
            buffer.append(document.get());
        }
        finally {
            monitor.done();
        }
    }

    protected void createTypeParameters(CompilationUnitRewrite targetRewrite, IType subType, AbstractTypeDeclaration sourceDeclaration, AbstractTypeDeclaration targetDeclaration) {
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)sourceDeclaration);
        Assert.isNotNull((Object)targetDeclaration);
        if (sourceDeclaration instanceof TypeDeclaration) {
            TypeParameter parameter2 = null;
            ListRewrite rewrite = targetRewrite.getASTRewrite().getListRewrite((ASTNode)targetDeclaration, TypeDeclaration.TYPE_PARAMETERS_PROPERTY);
            for (TypeParameter parameter2 : ((TypeDeclaration)sourceDeclaration).typeParameters()) {
                ASTNode node = ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)parameter2);
                rewrite.insertLast(node, null);
            }
        }
    }

    protected void createTypeSignature(CompilationUnitRewrite subRewrite, AbstractTypeDeclaration declaration, IType extractedType, ITypeBinding extractedBinding, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)subRewrite);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)extractedType);
        Assert.isNotNull((Object)monitor);
        try {
            ITypeParameter[] parameters;
            monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing, 10);
            AST ast = subRewrite.getAST();
            Type type = null;
            if (extractedBinding != null) {
                type = subRewrite.getImportRewrite().addImport(extractedBinding, ast);
            } else {
                subRewrite.getImportRewrite().addImport(extractedType.getFullyQualifiedName('.'));
                type = ast.newSimpleType((Name)ast.newSimpleName(extractedType.getElementName()));
            }
            subRewrite.getImportRemover().registerAddedImport(extractedType.getFullyQualifiedName('.'));
            if (type != null && (parameters = extractedType.getTypeParameters()).length > 0) {
                ParameterizedType parameterized = ast.newParameterizedType(type);
                ITypeParameter[] iTypeParameterArray = parameters;
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeParameter parameter = iTypeParameterArray[n2];
                    parameterized.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameter.getElementName())));
                    ++n2;
                }
                type = parameterized;
            }
            ASTRewrite rewriter = subRewrite.getASTRewrite();
            if (type != null && declaration instanceof TypeDeclaration) {
                TypeDeclaration extended = (TypeDeclaration)declaration;
                Type superClass = extended.getSuperclassType();
                if (superClass != null) {
                    rewriter.replace((ASTNode)superClass, (ASTNode)type, (TextEditGroup)subRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractSupertypeProcessor_add_supertype, SET_EXTRACT_SUPERTYPE));
                    subRewrite.getImportRemover().registerRemovedNode((ASTNode)superClass);
                } else {
                    rewriter.set((ASTNode)extended, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)type, (TextEditGroup)subRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractSupertypeProcessor_add_supertype, SET_EXTRACT_SUPERTYPE));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void createTypeSignature(CompilationUnitRewrite targetRewrite, IType superType, AbstractTypeDeclaration declaringDeclaration, AbstractTypeDeclaration targetDeclaration) {
        TypeDeclaration declaration;
        Type superclassType;
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)declaringDeclaration);
        Assert.isNotNull((Object)targetDeclaration);
        if (declaringDeclaration instanceof TypeDeclaration && (superclassType = (declaration = (TypeDeclaration)declaringDeclaration).getSuperclassType()) != null) {
            Type type = null;
            ITypeBinding binding = superclassType.resolveBinding();
            if (binding != null) {
                type = targetRewrite.getImportRewrite().addImport(binding, targetRewrite.getAST());
                targetRewrite.getImportRemover().registerAddedImports(type);
            }
            if (type != null && targetDeclaration instanceof TypeDeclaration) {
                TypeDeclaration extended = (TypeDeclaration)targetDeclaration;
                Type targetSuperType = extended.getSuperclassType();
                if (targetSuperType != null) {
                    targetRewrite.getASTRewrite().replace((ASTNode)targetSuperType, (ASTNode)type, null);
                } else {
                    targetRewrite.getASTRewrite().set((ASTNode)extended, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)type, null);
                }
            }
        }
    }

    @Override
    public RefactoringStatus createWorkingCopyLayer(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing, 70);
            status.merge(super.createWorkingCopyLayer((IProgressMonitor)new SubProgressMonitor(monitor, 10)));
            IType declaring = this.getDeclaringType();
            status.merge(this.createExtractedSuperType(this.getDeclaringSuperTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 10)).getSuperclass(declaring), (IProgressMonitor)new SubProgressMonitor(monitor, 10)));
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            try {
                AbstractTypeDeclaration extractDeclaration;
                IType extractedType = this.computeExtractedType(this.fTypeName);
                this.setDestinationType(extractedType);
                ArrayList<IType> subTypes = new ArrayList<IType>(Arrays.asList(this.fTypesToExtract));
                if (!subTypes.contains(declaring)) {
                    subTypes.add(declaring);
                }
                HashMap<ICompilationUnit, ArrayList<IType>> unitToTypes = new HashMap<ICompilationUnit, ArrayList<IType>>(subTypes.size());
                HashSet<ICompilationUnit> units = new HashSet<ICompilationUnit>(subTypes.size());
                for (IType type : subTypes) {
                    ICompilationUnit unit = type.getCompilationUnit();
                    units.add(unit);
                    ArrayList<IType> collection = (ArrayList<IType>)unitToTypes.get(unit);
                    if (collection == null) {
                        collection = new ArrayList<IType>(2);
                        unitToTypes.put(unit, collection);
                    }
                    collection.add(type);
                }
                HashMap<IJavaProject, ArrayList<ICompilationUnit>> projectToUnits = new HashMap<IJavaProject, ArrayList<ICompilationUnit>>();
                Collection collection = null;
                IJavaProject project2 = null;
                ICompilationUnit current2 = null;
                for (ICompilationUnit current2 : units) {
                    project2 = current2.getJavaProject();
                    collection = (ArrayList<ICompilationUnit>)projectToUnits.get(project2);
                    if (collection == null) {
                        collection = new ArrayList<ICompilationUnit>();
                        projectToUnits.put(project2, (ArrayList<ICompilationUnit>)collection);
                    }
                    collection.add(current2);
                }
                ITypeBinding[] extractBindings = new ITypeBinding[1];
                ASTParser extractParser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
                extractParser.setWorkingCopyOwner(this.fOwner);
                extractParser.setResolveBindings(true);
                extractParser.setProject(project2);
                extractParser.setSource(extractedType.getCompilationUnit());
                CompilationUnit extractUnit = (CompilationUnit)extractParser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                if (extractUnit != null && (extractDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(extractedType, extractUnit)) != null) {
                    extractBindings[0] = extractDeclaration.resolveBinding();
                }
                ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 30);
                try {
                    Set keySet = projectToUnits.keySet();
                    subMonitor.beginTask("", keySet.size());
                    subMonitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
                    for (IJavaProject project2 : keySet) {
                        collection = (Collection)projectToUnits.get(project2);
                        parser.setWorkingCopyOwner(this.fOwner);
                        parser.setResolveBindings(true);
                        parser.setProject(project2);
                        parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project2));
                        SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 1);
                        try {
                            subsubMonitor.beginTask("", collection.size());
                            subsubMonitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
                            parser.createASTs(collection.toArray(new ICompilationUnit[collection.size()]), new String[0], new ASTRequestor((IProgressMonitor)subsubMonitor, unitToTypes, extractedType, extractBindings, status){
                                private final /* synthetic */ IProgressMonitor val$subsubMonitor;
                                private final /* synthetic */ Map val$unitToTypes;
                                private final /* synthetic */ IType val$extractedType;
                                private final /* synthetic */ ITypeBinding[] val$extractBindings;
                                private final /* synthetic */ RefactoringStatus val$status;
                                {
                                    this.val$subsubMonitor = iProgressMonitor;
                                    this.val$unitToTypes = map;
                                    this.val$extractedType = iType;
                                    this.val$extractBindings = iTypeBindingArray;
                                    this.val$status = refactoringStatus;
                                }

                                public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                                    try {
                                        try {
                                            Collection types = (Collection)this.val$unitToTypes.get(unit);
                                            if (types != null) {
                                                for (IType currentType : types) {
                                                    AbstractTypeDeclaration currentDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(currentType, node);
                                                    if (currentDeclaration == null) continue;
                                                    ExtractSupertypeProcessor.this.createModifiedSubType(unit, node, this.val$extractedType, this.val$extractBindings[0], currentDeclaration, this.val$status);
                                                }
                                            }
                                        }
                                        catch (CoreException exception) {
                                            JavaManipulationPlugin.log(exception);
                                            this.val$status.merge(RefactoringStatus.createFatalErrorStatus((String)exception.getLocalizedMessage()));
                                            this.val$subsubMonitor.worked(1);
                                        }
                                    }
                                    finally {
                                        this.val$subsubMonitor.worked(1);
                                    }
                                }

                                public final void acceptBinding(String key, IBinding binding) {
                                }
                            }, (IProgressMonitor)subsubMonitor);
                        }
                        finally {
                            subsubMonitor.done();
                        }
                    }
                }
                finally {
                    subMonitor.done();
                }
            }
            catch (CoreException exception) {
                JavaManipulationPlugin.log(exception);
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    @Override
    public IType[] getCandidateTypes(RefactoringStatus status, IProgressMonitor monitor) {
        IType declaring;
        Assert.isNotNull((Object)monitor);
        if ((this.fPossibleCandidates == null || this.fPossibleCandidates.length == 0) && (declaring = this.getDeclaringType()) != null) {
            try {
                try {
                    monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_computing_possible_types, 10);
                    IType superType = this.getDeclaringSuperTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).getSuperclass(declaring);
                    if (superType != null) {
                        this.fPossibleCandidates = superType.newTypeHierarchy(this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 9, 2)).getSubtypes(superType);
                        LinkedList<IType> list = new LinkedList<IType>(Arrays.asList(this.fPossibleCandidates));
                        HashSet<String> names = new HashSet<String>();
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            IType type = (IType)iterator.next();
                            if (type.isReadOnly() || type.isBinary() || type.isAnonymous() || !type.isClass() || names.contains(type.getFullyQualifiedName())) {
                                iterator.remove();
                                continue;
                            }
                            names.add(type.getFullyQualifiedName());
                        }
                        this.fPossibleCandidates = list.toArray(new IType[list.size()]);
                    }
                }
                catch (JavaModelException exception) {
                    JavaManipulationPlugin.log(exception);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
        return this.fPossibleCandidates;
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.getDeclaringType()};
    }

    public IType getExtractedType() {
        return this.getDestinationType();
    }

    public String getTypeName() {
        return this.fTypeName;
    }

    public IType[] getTypesToExtract() {
        return this.fTypesToExtract;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        IJavaElement element;
        String attribute;
        IType type;
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.fTypeName = name;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            IJavaElement element2 = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element2 == null || element2.getElementType() != 7) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element2, this.getProcessorName(), "org.eclipse.jdt.ui.extract.superclass");
            }
            type = null;
            ICompilationUnit unit = ((IType)element2).getCompilationUnit();
            if (unit != null && unit.exists()) {
                try {
                    ICompilationUnit copy = this.getSharedWorkingCopy(unit, (IProgressMonitor)new NullProgressMonitor());
                    IJavaElement[] elements = copy.findElements(element2);
                    if (elements != null && elements.length == 1 && elements[0] instanceof IType && elements[0].exists()) {
                        type = (IType)elements[0];
                    }
                }
                catch (JavaModelException copy) {
                    // empty catch block
                }
            }
            if (type == null) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element2, this.getProcessorName(), "org.eclipse.jdt.ui.extract.superclass");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fCachedDeclaringType = type;
        String stubs = extended.getAttribute("stubs");
        if (stubs == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "stubs"));
        }
        this.fCreateMethodStubs = Boolean.parseBoolean(stubs);
        String instance = extended.getAttribute("instanceof");
        if (instance == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "instanceof"));
        }
        this.fInstanceOf = Boolean.parseBoolean(instance);
        String replace = extended.getAttribute("replace");
        if (replace == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "replace"));
        }
        this.fReplace = Boolean.parseBoolean(replace);
        int extractCount = 0;
        int abstractCount = 0;
        int deleteCount = 0;
        int typeCount = 0;
        String value = extended.getAttribute("abstract");
        if (value != null && !"".equals(value)) {
            try {
                abstractCount = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "abstract"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "abstract"));
        }
        value = extended.getAttribute("delete");
        if (value != null && !"".equals(value)) {
            try {
                deleteCount = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "delete"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "delete"));
        }
        value = extended.getAttribute(ATTRIBUTE_EXTRACT);
        if (value != null && !"".equals(value)) {
            try {
                extractCount = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_EXTRACT));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_EXTRACT));
        }
        value = extended.getAttribute(ATTRIBUTE_TYPES);
        if (value != null && !"".equals(value)) {
            try {
                typeCount = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TYPES));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TYPES));
        }
        RefactoringStatus status = new RefactoringStatus();
        ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
        int index = 0;
        while (index < extractCount) {
            attribute = "element" + (index + 1);
            handle = extended.getAttribute(attribute);
            if (handle != null && !"".equals(handle)) {
                element = JavaRefactoringDescriptorUtil.handleToElement(this.fOwner, extended.getProject(), handle, false);
                if (element == null || !element.exists()) {
                    status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.extract.superclass"));
                } else {
                    elements.add(element);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
            }
            ++index;
        }
        this.fMembersToMove = elements.toArray(new IMember[elements.size()]);
        elements = new ArrayList();
        index = 0;
        while (index < deleteCount) {
            attribute = "element" + (extractCount + index + 1);
            handle = extended.getAttribute(attribute);
            if (handle != null && !"".equals(handle)) {
                element = JavaRefactoringDescriptorUtil.handleToElement(this.fOwner, extended.getProject(), handle, false);
                if (element == null || !element.exists()) {
                    status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.extract.superclass"));
                } else {
                    elements.add(element);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
            }
            ++index;
        }
        this.fDeletedMethods = elements.toArray(new IMethod[elements.size()]);
        elements = new ArrayList();
        index = 0;
        while (index < abstractCount) {
            attribute = "element" + (extractCount + abstractCount + index + 1);
            handle = extended.getAttribute(attribute);
            if (handle != null && !"".equals(handle)) {
                element = JavaRefactoringDescriptorUtil.handleToElement(this.fOwner, extended.getProject(), handle, false);
                if (element == null || !element.exists()) {
                    status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.extract.superclass"));
                } else {
                    elements.add(element);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
            }
            ++index;
        }
        this.fAbstractMethods = elements.toArray(new IMethod[elements.size()]);
        elements = new ArrayList();
        index = 0;
        while (index < typeCount) {
            attribute = "element" + (extractCount + abstractCount + deleteCount + index + 1);
            handle = extended.getAttribute(attribute);
            if (handle != null && !"".equals(handle)) {
                element = JavaRefactoringDescriptorUtil.handleToElement(this.fOwner, extended.getProject(), handle, false);
                if (element == null || !element.exists()) {
                    status.merge(JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.extract.superclass"));
                } else {
                    elements.add(element);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
            }
            ++index;
        }
        this.fTypesToExtract = elements.toArray(new IType[elements.size()]);
        IJavaProject project = null;
        if (this.fMembersToMove.length > 0) {
            project = this.fMembersToMove[0].getJavaProject();
        }
        this.fSettings = JavaPreferencesSettings.getCodeGenerationSettings(project);
        if (!status.isOK()) {
            return status;
        }
        return new RefactoringStatus();
    }

    @Override
    protected void registerChanges(TextEditBasedChangeManager manager) throws CoreException {
        try {
            ICompilationUnit extractedUnit = this.getExtractedType().getCompilationUnit();
            ICompilationUnit unit2 = null;
            CompilationUnitRewrite rewrite = null;
            for (ICompilationUnit unit2 : this.fCompilationUnitRewrites.keySet()) {
                if (unit2.equals(extractedUnit)) {
                    TextEdit edit;
                    CompilationUnitChange change;
                    rewrite = (CompilationUnitRewrite)this.fCompilationUnitRewrites.get(unit2);
                    if (rewrite == null || (change = rewrite.createChange(true)) == null || (edit = change.getEdit()) == null) continue;
                    Document document = new Document(this.fSuperSource);
                    try {
                        edit.apply((IDocument)document, 2);
                    }
                    catch (BadLocationException | MalformedTreeException exception) {
                        JavaManipulationPlugin.log(exception);
                    }
                    this.fSuperSource = document.get();
                    manager.remove(extractedUnit);
                    continue;
                }
                rewrite = (CompilationUnitRewrite)this.fCompilationUnitRewrites.get(unit2);
                if (rewrite == null) continue;
                this.fixConstructorsWithFinalFieldInitialization(rewrite);
                CompilationUnitChange layerChange = this.fLayerChanges.get(unit2.getPrimary());
                CompilationUnitChange rewriteChange = rewrite.createChange(true);
                if (rewriteChange != null && layerChange != null) {
                    MultiStateCompilationUnitChange change = new MultiStateCompilationUnitChange(rewriteChange.getName(), unit2);
                    change.addChange((TextChange)layerChange);
                    change.addChange((TextChange)rewriteChange);
                    this.fLayerChanges.remove(unit2.getPrimary());
                    manager.manage(unit2, (TextEditBasedChange)change);
                    continue;
                }
                if (layerChange != null) {
                    manager.manage(unit2, (TextEditBasedChange)layerChange);
                    this.fLayerChanges.remove(unit2.getPrimary());
                    continue;
                }
                if (rewriteChange == null) continue;
                manager.manage(unit2, (TextEditBasedChange)rewriteChange);
            }
            for (Map.Entry<ICompilationUnit, CompilationUnitChange> entry : this.fLayerChanges.entrySet()) {
                manager.manage(entry.getKey(), (TextEditBasedChange)entry.getValue());
            }
            ICompilationUnit[] iCompilationUnitArray = manager.getAllCompilationUnits();
            int n = iCompilationUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit cu = iCompilationUnitArray[n2];
                if (cu.getPath().equals((Object)extractedUnit.getPath())) {
                    manager.remove(cu);
                }
                ++n2;
            }
        }
        finally {
            this.fLayerChanges.clear();
        }
    }

    public void resetChanges() {
        this.fLayerChanges.clear();
    }

    public void setTypeName(String name) {
        Assert.isNotNull((Object)name);
        this.fTypeName = name;
    }

    public void setTypesToExtract(IType[] types) {
        Assert.isNotNull((Object)types);
        this.fTypesToExtract = types;
    }

    private static class FieldInfo {
        private ITypeBinding fieldBinding;
        private String fieldName;

        public FieldInfo(ITypeBinding fieldBinding, String fieldName) {
            this.fieldBinding = fieldBinding;
            this.fieldName = fieldName;
        }

        public ITypeBinding getFieldBinding() {
            return this.fieldBinding;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

