/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.syntaxserver;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.BaseInitHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.SemanticTokensHandler;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.DocumentFilter;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.SaveOptions;
import org.eclipse.lsp4j.SemanticTokensServerFull;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;

public class SyntaxInitHandler
extends BaseInitHandler {
    private ProjectsManager projectsManager;
    private PreferenceManager preferenceManager;

    public SyntaxInitHandler(ProjectsManager projectsManager, PreferenceManager preferenceManager) {
        super(projectsManager, preferenceManager);
        this.projectsManager = projectsManager;
        this.preferenceManager = preferenceManager;
    }

    @Override
    public void registerCapabilities(InitializeResult initializeResult) {
        ServerCapabilities capabilities = new ServerCapabilities();
        if (!this.preferenceManager.getClientPreferences().isClientDocumentSymbolProviderRegistered() && !this.preferenceManager.getClientPreferences().isDocumentSymbolDynamicRegistered()) {
            capabilities.setDocumentSymbolProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isDefinitionDynamicRegistered()) {
            capabilities.setDefinitionProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isTypeDefinitionDynamicRegistered()) {
            capabilities.setTypeDefinitionProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isFoldgingRangeDynamicRegistered()) {
            capabilities.setFoldingRangeProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isSelectionRangeDynamicRegistered()) {
            capabilities.setSelectionRangeProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isHoverDynamicRegistered()) {
            capabilities.setHoverProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isCompletionDynamicRegistered()) {
            capabilities.setCompletionProvider(CompletionHandler.getDefaultCompletionOptions(this.preferenceManager));
        }
        if (!this.preferenceManager.getClientPreferences().isDocumentHighlightDynamicRegistered()) {
            capabilities.setDocumentHighlightProvider(Boolean.TRUE);
        }
        TextDocumentSyncOptions textDocumentSyncOptions = new TextDocumentSyncOptions();
        textDocumentSyncOptions.setOpenClose(Boolean.TRUE);
        textDocumentSyncOptions.setSave(new SaveOptions(Boolean.TRUE));
        textDocumentSyncOptions.setChange(TextDocumentSyncKind.Incremental);
        capabilities.setTextDocumentSync(textDocumentSyncOptions);
        WorkspaceServerCapabilities wsCapabilities = new WorkspaceServerCapabilities();
        WorkspaceFoldersOptions wsFoldersOptions = new WorkspaceFoldersOptions();
        wsFoldersOptions.setSupported(Boolean.TRUE);
        wsFoldersOptions.setChangeNotifications(Boolean.TRUE);
        wsCapabilities.setWorkspaceFolders(wsFoldersOptions);
        capabilities.setWorkspace(wsCapabilities);
        SemanticTokensWithRegistrationOptions semanticTokensOptions = new SemanticTokensWithRegistrationOptions();
        semanticTokensOptions.setFull(new SemanticTokensServerFull(Boolean.valueOf(false)));
        semanticTokensOptions.setRange(Boolean.valueOf(false));
        semanticTokensOptions.setDocumentSelector(List.of(new DocumentFilter("java", "file", null), new DocumentFilter("java", "jdt", null)));
        semanticTokensOptions.setLegend(SemanticTokensHandler.legend());
        capabilities.setSemanticTokensProvider(semanticTokensOptions);
        initializeResult.setCapabilities(capabilities);
    }

    @Override
    public void triggerInitialization(final Collection<IPath> roots) {
        WorkspaceJob job = new WorkspaceJob("Initialize Workspace"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                long start = System.currentTimeMillis();
                try {
                    try {
                        SyntaxInitHandler.this.projectsManager.initializeProjects(roots, monitor);
                        JavaLanguageServerPlugin.logInfo("Workspace initialized in " + (System.currentTimeMillis() - start) + "ms");
                    }
                    catch (Exception e) {
                        JavaLanguageServerPlugin.logException("Initialization failed ", e);
                        SyntaxInitHandler.this.projectsManager.registerListeners();
                    }
                }
                finally {
                    SyntaxInitHandler.this.projectsManager.registerListeners();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                Collection rootPathsSet = roots.stream().collect(Collectors.toSet());
                boolean equalToRootPaths = false;
                if (family instanceof Collection) {
                    equalToRootPaths = rootPathsSet.equals(((Collection)family).stream().collect(Collectors.toSet()));
                }
                return "java-ls-initialization-jobs".equals(family) || equalToRootPaths;
            }
        };
        job.setPriority(40);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }
}

