/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.builder.jdtbuilder;

import com.microsoft.java.builder.jdtbuilder.ClasspathJar;
import java.io.IOException;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class ClasspathJMod
extends ClasspathJar {
    public static char[] CLASSES = "classes".toCharArray();
    public static char[] CLASSES_FOLDER = "classes/".toCharArray();
    private static int MODULE_DESCRIPTOR_NAME_LENGTH = "module-info.class".length();

    ClasspathJMod(String zipFilename, long lastModified, AccessRuleSet accessRuleSet, IPath externalAnnotationPath) {
        super(zipFilename, lastModified, accessRuleSet, externalAnnotationPath, true);
    }

    @Override
    IModule initializeModule() {
        IBinaryModule mod;
        block15: {
            mod = null;
            ZipFile file = null;
            try {
                try {
                    file = new ZipFile(this.zipFilename);
                    String fileName = new String(CLASSES_FOLDER) + "module-info.class";
                    ClassFileReader classfile = ClassFileReader.read((ZipFile)file, (String)fileName);
                    if (classfile != null) {
                        mod = classfile.getModuleDeclaration();
                    }
                }
                catch (IOException | ClassFormatException throwable) {
                    try {
                        if (file != null) {
                            file.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException iOException) {}
        }
        return mod;
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        if (!this.isPackage(qualifiedPackageName, moduleName)) {
            return null;
        }
        if (moduleNameFilter != null && this.module != null && !moduleNameFilter.test(String.valueOf(this.module.name()))) {
            return null;
        }
        try {
            qualifiedBinaryFileName = new String(CharOperation.append((char[])CLASSES_FOLDER, (char[])qualifiedBinaryFileName.toCharArray()));
            ClassFileReader reader = ClassFileReader.read((ZipFile)this.zipFile, (String)qualifiedBinaryFileName);
            if (reader != null) {
                char[] modName;
                char[] cArray = modName = this.module == null ? null : this.module.name();
                if (reader instanceof ClassFileReader) {
                    ClassFileReader classReader = reader;
                    if (classReader.moduleName == null) {
                        classReader.moduleName = modName;
                    } else {
                        modName = classReader.moduleName;
                    }
                }
                String fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
                return this.createAnswer(fileNameWithoutExtension, (IBinaryType)reader, modName);
            }
        }
        catch (IOException | ClassFormatException throwable) {}
        return null;
    }

    @Override
    protected String readJarContent(SimpleSet packageSet) {
        String modInfo = null;
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            char[] folder;
            ZipEntry entry = e.nextElement();
            char[] entryName = entry.getName().toCharArray();
            int index = CharOperation.indexOf((char)'/', (char[])entryName);
            if (index == -1 || !CharOperation.equals((char[])CLASSES, (char[])(folder = CharOperation.subarray((char[])entryName, (int)0, (int)index)))) continue;
            char[] fileName = CharOperation.subarray((char[])entryName, (int)(index + 1), (int)entryName.length);
            if (modInfo == null && fileName.length == MODULE_DESCRIPTOR_NAME_LENGTH && CharOperation.equals((char[])fileName, (char[])"module-info.class".toCharArray())) {
                modInfo = new String(entryName);
            }
            ClasspathJMod.addToPackageSet(packageSet, new String(fileName), false);
        }
        return modInfo;
    }
}

