/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import org.codehaus.plexus.util.SelectorUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.JVMConfigurator;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.EclipseBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.InternalBuildSupports;
import org.eclipse.jdt.ls.core.internal.managers.InvisibleProjectPreferenceChangeListener;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.managers.UpdateClasspathJob;
import org.eclipse.jdt.ls.core.internal.preferences.IPreferencesChangeListener;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;

public class InvisibleProjectBuildSupport
extends EclipseBuildSupport
implements IBuildSupport {
    private static IPreferencesChangeListener listener = new InvisibleProjectPreferenceChangeListener();
    public static final String LIB_FOLDER = "lib";

    @Override
    public boolean applies(IProject project) {
        return project != null && project.isAccessible() && !ProjectUtils.isVisibleProject(project);
    }

    @Override
    public boolean fileChanged(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        if (resource == null || !this.applies(resource.getProject())) {
            return false;
        }
        this.refresh(resource, changeType, monitor);
        String resourcePath = resource.getLocation().toOSString();
        IProject project = resource.getProject();
        IPath projectFolder = ProjectUtils.getProjectRealFolder(project);
        Preferences.ReferencedLibraries libraries = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getReferencedLibraries();
        for (String pattern : libraries.getExclude()) {
            if (!this.matchPattern(projectFolder, pattern, resourcePath)) continue;
            return false;
        }
        for (String pattern : libraries.getInclude()) {
            if (!this.matchPattern(projectFolder, pattern, resourcePath)) continue;
            UpdateClasspathJob.getInstance().updateClasspath(JavaCore.create((IProject)project), libraries);
            return false;
        }
        IPath settings = projectFolder.append(".settings");
        if (settings.equals((Object)resource.getLocation())) {
            if (ProjectsManager.CHANGE_TYPE.CREATED.equals((Object)changeType)) {
                IFolder settingsLinkFolder = project.getFolder(".settings");
                if (!settingsLinkFolder.isLinked()) {
                    settingsLinkFolder.createLink(resource.getLocationURI(), 256, null);
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    JVMConfigurator.configureJVMSettings(javaProject);
                }
            } else if (ProjectsManager.CHANGE_TYPE.DELETED.equals((Object)changeType) && resource.isLinked()) {
                resource.delete(1, monitor);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                JVMConfigurator.configureJVMSettings(javaProject);
            }
        }
        return false;
    }

    public boolean matchPattern(IPath base, String pattern, String path) {
        String glob = ProjectUtils.resolveGlobPath(base, pattern).toOSString();
        if (base.getDevice() != null) {
            return SelectorUtils.matchPath((String)glob, (String)path, (boolean)false);
        }
        return SelectorUtils.matchPath((String)glob, (String)path);
    }

    @Override
    public void discoverSource(IClassFile classFile, IProgressMonitor monitor) throws CoreException {
        JavaLanguageServerPlugin.getDefaultSourceDownloader().discoverSource(classFile, monitor);
    }

    @Override
    public void registerPreferencesChangeListener(PreferenceManager preferenceManager) throws CoreException {
        preferenceManager.addPreferencesChangeListener(listener);
    }

    @Override
    public void unregisterPreferencesChangeListener(PreferenceManager preferenceManager) throws CoreException {
        preferenceManager.removePreferencesChangeListener(listener);
    }

    @Override
    public String buildToolName() {
        return InternalBuildSupports.INVISIBLE.toString();
    }
}

