/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.filesystem;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.ls.core.internal.filesystem.JLSFsUtils;

public class JLSFile
extends LocalFile {
    public JLSFile(File file) {
        super(file);
    }

    public String[] childNames(int options, IProgressMonitor monitor) {
        String[] childNames = super.childNames(options, monitor);
        if (JLSFsUtils.generatesMetadataFilesAtProjectRoot()) {
            return childNames;
        }
        Path filePath = new Path(this.filePath);
        if (JLSFsUtils.isExcluded((IPath)filePath)) {
            return childNames;
        }
        String projectName = JLSFsUtils.getProjectNameIfLocationIsProjectRoot((IPath)filePath);
        if (projectName == null) {
            return childNames;
        }
        LinkedHashSet<String> childNameSet = new LinkedHashSet<String>(Arrays.asList(childNames));
        for (String fileName : JLSFsUtils.METADATA_NAMES) {
            if (childNameSet.contains(fileName) || !JLSFsUtils.METADATA_FOLDER_PATH.append(projectName).append(fileName).toFile().exists()) continue;
            childNameSet.add(fileName);
        }
        return (String[])childNameSet.toArray(String[]::new);
    }

    public IFileStore getChild(String name) {
        IPath path = new Path(this.filePath).append(name);
        if (JLSFsUtils.shouldStoreInMetadataArea(path) && !JLSFsUtils.isExcluded(path)) {
            IPath containerPath = JLSFsUtils.getContainerPath(path);
            String projectName = JLSFsUtils.getProjectNameIfLocationIsProjectRoot(containerPath);
            if (projectName == null) {
                return new JLSFile(new File(this.file, name));
            }
            IPath redirectedPath = JLSFsUtils.getMetaDataFilePath(projectName, (IPath)new Path(name));
            if (redirectedPath != null) {
                return new JLSFile(redirectedPath.toFile());
            }
        }
        return new JLSFile(new File(this.file, name));
    }

    public IFileStore getFileStore(IPath path) {
        IPath fullPath = new Path(this.filePath).append(path);
        if (JLSFsUtils.shouldStoreInMetadataArea(fullPath) && !JLSFsUtils.isExcluded(fullPath)) {
            IPath containerPath = JLSFsUtils.getContainerPath(fullPath);
            String projectName = JLSFsUtils.getProjectNameIfLocationIsProjectRoot(containerPath);
            if (projectName == null) {
                return new JLSFile(fullPath.toFile());
            }
            IPath redirectedPath = JLSFsUtils.getMetaDataFilePath(projectName, path);
            if (redirectedPath != null) {
                return new JLSFile(redirectedPath.toFile());
            }
        }
        return new JLSFile(fullPath.toFile());
    }
}

