/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.internal.core.search.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.SearchMatchingUtility;
import org.eclipse.jdt.internal.core.search.matching.TypeReferenceLocator;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;

public class DOMTypeReferenceLocator
extends DOMPatternLocator {
    private TypeReferenceLocator locator;
    private List<IJavaElement> foundElements = new ArrayList<IJavaElement>();
    private Set<Name> imports = new HashSet<Name>();
    private static final int TYPE_PARAMS_MATCH = 1;
    private static final int TYPE_PARAMS_COUNT_MATCH = 2;
    private static final int TYPE_PARAMS_NO_MATCH = 3;

    public DOMTypeReferenceLocator(TypeReferenceLocator locator) {
        super((SearchPattern)locator.pattern);
        this.locator = locator;
    }

    private boolean hasPackageDeclarationAncestor(ASTNode node) {
        if (node instanceof PackageDeclaration) {
            return true;
        }
        return node == null ? false : this.hasPackageDeclarationAncestor(node.getParent());
    }

    @Override
    public LocatorResponse match(Annotation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.match(node.getTypeName(), nodeSet, locator);
    }

    @Override
    public LocatorResponse match(Name name, NodeSetWrapper nodeSet, MatchLocator locator) {
        BreakStatement bs;
        LabeledStatement ls;
        if (name.getParent() instanceof AbstractTypeDeclaration) {
            return this.toResponse(0);
        }
        ASTNode aSTNode = name.getParent();
        if (aSTNode instanceof LabeledStatement && (ls = (LabeledStatement)aSTNode).getLabel() == name) {
            return this.toResponse(0);
        }
        aSTNode = name.getParent();
        if (aSTNode instanceof BreakStatement && (bs = (BreakStatement)aSTNode).getLabel() == name) {
            return this.toResponse(0);
        }
        if (DOMTypeReferenceLocator.failsFineGrain((ASTNode)name, this.locator.fineGrain())) {
            return this.toResponse(0);
        }
        if (this.locator.pattern.simpleName == null) {
            int v = nodeSet.addMatch((ASTNode)name, this.locator.pattern.mustResolve ? 2 : 3);
            return this.toResponse(v, true);
        }
        if (name instanceof SimpleName) {
            QualifiedName qn3;
            SimpleName sn2 = (SimpleName)name;
            if (this.locator.pattern.qualification == null) {
                return this.toResponse(this.match(sn2, nodeSet));
            }
            ASTNode parent3 = name.getParent();
            if (!(parent3 instanceof QualifiedName)) {
                return this.toResponse(this.match(sn2, nodeSet));
            }
            if (parent3 instanceof QualifiedName && (qn3 = (QualifiedName)parent3).getQualifier() == name && this.match(sn2, nodeSet) == 2) {
                return this.toResponse(2);
            }
            if (this.locator.pattern.getMatchMode() == 0) {
                return this.toResponse(0);
            }
            if (this.match(sn2, nodeSet) == 2) {
                return this.toResponse(2);
            }
            return this.toResponse(0);
        }
        if (name instanceof QualifiedName) {
            QualifiedName qn2 = (QualifiedName)name;
            return this.toResponse(this.match(qn2, nodeSet));
        }
        return this.toResponse(0);
    }

    @Override
    public LocatorResponse match(ASTNode node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (DOMTypeReferenceLocator.failsFineGrain(node, this.locator.fineGrain())) {
            return this.toResponse(0);
        }
        if (node instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDecl = (EnumConstantDeclaration)node;
            ASTNode aSTNode = node.getParent();
            if (aSTNode instanceof EnumDeclaration) {
                EnumDeclaration enumDeclaration = (EnumDeclaration)aSTNode;
                if (enumConstantDecl.getAnonymousClassDeclaration() != null) {
                    if (this.locator.pattern.simpleName == null) {
                        int v = nodeSet.addMatch(node, this.locator.pattern.mustResolve ? 2 : 3);
                        return this.toResponse(v, true);
                    }
                    if (this.locator.matchesName(this.locator.pattern.simpleName, enumDeclaration.getName().getIdentifier().toCharArray())) {
                        int v = nodeSet.addMatch(node, this.locator.pattern.mustResolve ? 2 : 3);
                        return this.toResponse(v, true);
                    }
                }
            }
        }
        if (node instanceof ImportDeclaration) {
            ImportDeclaration id = (ImportDeclaration)node;
            Name n = id.getName();
            this.imports.add(n);
        }
        return this.toResponse(0);
    }

    private LocatorResponse matchTypeNodeReturnComponent(Type node, String qualifiedNameFromNode, String fqqn, int defaultLevel) {
        if (this.locator.matchesName(qualifiedNameFromNode.toCharArray(), fqqn.toCharArray())) {
            Type type;
            if (node instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)node;
                type = pt.getType();
            } else {
                type = null;
            }
            Type componentType = type;
            boolean replacementFound = componentType != node;
            int typeParamMatches = this.validateTypeParameters(node);
            if (typeParamMatches == 1) {
                return new LocatorResponse(defaultLevel, replacementFound, (ASTNode)componentType, false, false);
            }
            int ret = typeParamMatches == 2 ? 4 : 0;
            return new LocatorResponse(ret, replacementFound, (ASTNode)componentType, false, false);
        }
        return null;
    }

    @Override
    public LocatorResponse match(Type node, NodeSetWrapper nodeSet, MatchLocator locator) {
        int defaultLevel;
        if (DOMTypeReferenceLocator.failsFineGrain((ASTNode)node, this.locator.fineGrain())) {
            return this.toResponse(0);
        }
        int n = defaultLevel = this.locator.pattern.mustResolve ? 2 : 3;
        if (this.locator.pattern.simpleName == null) {
            int v = nodeSet.addMatch((ASTNode)node, defaultLevel);
            return this.toResponse(v, true);
        }
        String qualifiedNameFromNode = this.getQualifiedNameFromType(node);
        String simpleNameFromNode = this.getNameStringFromType(node);
        if (qualifiedNameFromNode != null && this.locator.pattern.qualification != null) {
            String[] qualifiedNameFromNodeStringSegments;
            String fqqn;
            String[] patternQualifiedStringSegments;
            String firstSegment;
            String fqqnImport;
            String patternQualifiedString = new String(this.locator.pattern.qualification) + "." + new String(this.locator.pattern.simpleName);
            LocatorResponse r1 = this.matchTypeNodeReturnComponent(node, patternQualifiedString, qualifiedNameFromNode, defaultLevel);
            if (r1 != null) {
                return r1;
            }
            if (qualifiedNameFromNode.endsWith(patternQualifiedString) ? (fqqnImport = this.fqqnFromImport(firstSegment = (patternQualifiedStringSegments = patternQualifiedString.split("\\.")) == null || patternQualifiedStringSegments.length == 0 ? null : patternQualifiedStringSegments[0])) != null && (r1 = this.matchTypeNodeReturnComponent(node, qualifiedNameFromNode, fqqn = fqqnImport + patternQualifiedString.substring(firstSegment.length()), defaultLevel)) != null : patternQualifiedString.endsWith(qualifiedNameFromNode) && (fqqnImport = this.fqqnFromImport(firstSegment = (qualifiedNameFromNodeStringSegments = qualifiedNameFromNode.split("\\.")) == null || qualifiedNameFromNodeStringSegments.length == 0 ? null : qualifiedNameFromNodeStringSegments[0])) != null && (r1 = this.matchTypeNodeReturnComponent(node, patternQualifiedString, fqqn = fqqnImport + qualifiedNameFromNode.substring(firstSegment.length()), defaultLevel)) != null) {
                return r1;
            }
        } else if (simpleNameFromNode != null && this.locator.matchesName(this.locator.pattern.simpleName, simpleNameFromNode.toCharArray())) {
            int level = this.locator.pattern.mustResolve || this.locator.pattern.qualification == null ? 2 : 3;
            int typeParamMatches = this.validateTypeParameters(node);
            if (typeParamMatches == 3) {
                level = 0;
            }
            if (typeParamMatches == 2) {
                level = 4;
            }
            if (level != 0) {
                Name n2 = this.getSimpleNameNodeFromType(node);
                if (n2 != null) {
                    nodeSet.addMatch((ASTNode)n2, level);
                    return new LocatorResponse(level, true, (ASTNode)n2, true, true);
                }
                int v = nodeSet.addMatch((ASTNode)node, level);
                return this.toResponse(v, true);
            }
        }
        return this.toResponse(0);
    }

    private int validateTypeParameters(Type node) {
        SimpleType st;
        boolean equivMatch;
        char[][][] fromPattern = this.locator.pattern.getTypeArguments();
        if (fromPattern == null) {
            return 1;
        }
        int r = this.locator.pattern.getMatchRule();
        boolean erasureMatch = (r & 0x10) == 16;
        boolean bl = equivMatch = (r & 0x20) == 32;
        if (node instanceof SimpleType && ((st = (SimpleType)node).getName() instanceof QualifiedName || st.getName() instanceof SimpleName)) {
            if (fromPattern != null && fromPattern.length > 0 && fromPattern[0] != null && fromPattern[0].length != 0 && !erasureMatch) {
                return 3;
            }
            return 1;
        }
        Type working = node;
        boolean done = false;
        int i = 0;
        boolean countMatchesAtAllLevels = true;
        for (i = 0; i < fromPattern.length && !done; ++i) {
            char[][] thisLevelTypeParams = fromPattern[i];
            if (thisLevelTypeParams != null && thisLevelTypeParams.length != 0 && working instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)working;
                List typeArgs = pt.typeArguments();
                if (typeArgs == null || typeArgs.size() != thisLevelTypeParams.length) {
                    return 3;
                }
                for (int j = 0; j < thisLevelTypeParams.length; ++j) {
                    String sig;
                    String typeFromPattern = new String(thisLevelTypeParams[j]);
                    IBinding b = DOMASTNodeUtils.getBinding((ASTNode)typeArgs.get(j));
                    if (b == null) {
                        v1 = null;
                    } else if (b instanceof JavacTypeBinding) {
                        JavacTypeBinding jctb = (JavacTypeBinding)b;
                        v1 = jctb.getGenericTypeSignature(false);
                    } else {
                        v1 = sig = b.getKey();
                    }
                    if (typeFromPattern.equals(sig)) continue;
                    return 2;
                }
            }
            if (working instanceof ParameterizedType) {
                ParameterizedType ptt = (ParameterizedType)working;
                working = ptt.getType();
            }
            if (working instanceof QualifiedType) {
                QualifiedType qtt = (QualifiedType)working;
                working = qtt.getQualifier();
            }
            if (!(working instanceof SimpleType)) continue;
            done = true;
        }
        for (int k = i; k < fromPattern.length; ++k) {
            if (fromPattern[k] == null || fromPattern[k].length == 0) continue;
            return 3;
        }
        return 1;
    }

    private String getQualifiedNameFromType(Type query) {
        if (query instanceof QualifiedType) {
            QualifiedType qtt = (QualifiedType)query;
            String qualString = this.getQualifiedNameFromType(qtt.getQualifier());
            String nameString = this.getNameStringFromType(query);
            return qualString == null || nameString == null ? null : qualString + "." + nameString;
        }
        if (query instanceof ParameterizedType) {
            ParameterizedType ptt = (ParameterizedType)query;
            return this.getQualifiedNameFromType(ptt.getType());
        }
        if (query instanceof SimpleType) {
            SimpleType st = (SimpleType)query;
            String fqqn = this.fqqnFromImport(st.getName().toString());
            return fqqn != null ? fqqn : st.getName().toString();
        }
        return null;
    }

    private String getNameStringFromType(Type node) {
        if (node instanceof SimpleType) {
            SimpleType simple = (SimpleType)node;
            Name name = simple.getName();
            if (name instanceof SimpleName) {
                SimpleName name2 = (SimpleName)name;
                return name2.getIdentifier();
            }
            name = simple.getName();
            if (name instanceof QualifiedName) {
                QualifiedName name3 = (QualifiedName)name;
                return name3.getName().getIdentifier();
            }
        } else {
            if (node instanceof QualifiedType) {
                QualifiedType qualified = (QualifiedType)node;
                return qualified.getName().getIdentifier();
            }
            if (node instanceof ParameterizedType) {
                ParameterizedType ptt = (ParameterizedType)node;
                return this.getNameStringFromType(ptt.getType());
            }
        }
        return null;
    }

    private Name getSimpleNameNodeFromType(Type node) {
        Name name = this.getNameNodeFromType(node);
        if (name != null) {
            if (name instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)name;
                return qn.getName();
            }
            return name;
        }
        return null;
    }

    private Name getNameNodeFromType(Type node) {
        if (node instanceof SimpleType) {
            SimpleType simple = (SimpleType)node;
            return simple.getName();
        }
        if (node instanceof QualifiedType) {
            QualifiedType qualified = (QualifiedType)node;
            return qualified.getName();
        }
        if (node instanceof ParameterizedType) {
            ParameterizedType ptt = (ParameterizedType)node;
            return this.getNameNodeFromType(ptt.getType());
        }
        return null;
    }

    private String fqqnFromImport(String firstSegment) {
        if (firstSegment == null) {
            return null;
        }
        for (Name n : this.imports) {
            if (n.isSimpleName() && n.toString().equals(firstSegment)) {
                return n.toString();
            }
            if (!n.isQualifiedName() || !n.toString().endsWith("." + firstSegment)) continue;
            return n.toString();
        }
        return null;
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding == null) {
            SimpleName sn;
            int accuracy;
            if (node instanceof SimpleName && (accuracy = this.resolveLevelForSimpleName(node, (sn = (SimpleName)node).getIdentifier())) != -1) {
                IResource r = null;
                IJavaElement enclosing = DOMASTNodeUtils.getEnclosingJavaElement(node);
                IJavaElement ancestor = enclosing == null ? null : enclosing.getAncestor(5);
                try {
                    r = ancestor == null ? null : ancestor.getCorrespondingResource();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                TypeReferenceMatch typeMatch = new TypeReferenceMatch(enclosing, accuracy, node.getStartPosition(), node.getLength(), DOMASTNodeUtils.insideDocComment(node), locator.getParticipant(), r);
                try {
                    locator.report((SearchMatch)typeMatch);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return this.toResponse(0);
            }
            return this.toResponse(1);
        }
        if (binding instanceof ITypeBinding) {
            ITypeBinding typeBinding = (ITypeBinding)binding;
            ASTNode r = node.getParent();
            if (r instanceof ImportDeclaration) {
                ImportDeclaration id = (ImportDeclaration)r;
                return this.resolveLevelForImportBinding(node, typeBinding, locator);
            }
            int v = this.resolveLevelForTypeBinding(node, typeBinding, locator);
            if (node instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)node;
                return new LocatorResponse(v, true, (ASTNode)pt.getType(), false, false);
            }
            return this.toResponse(v);
        }
        if (binding instanceof IPackageBinding && node instanceof SimpleName) {
            SimpleName sn = (SimpleName)node;
            if (this.locator.isDeclarationOfReferencedTypesPattern) {
                return this.toResponse(0);
            }
            if (this.hasPackageDeclarationAncestor(node)) {
                return this.toResponse(0);
            }
            String identifier = sn.getIdentifier();
            if (this.locator.matchesName(this.locator.pattern.simpleName, identifier.toCharArray())) {
                return this.toResponse(1);
            }
        }
        return this.toResponse(0);
    }

    private LocatorResponse resolveLevelForImportBinding(ASTNode node, ITypeBinding typeBinding, MatchLocator locator2) {
        int newLevel = this.resolveLevelForTypeFQN(this.locator.pattern.simpleName, this.locator.pattern.qualification, typeBinding, null);
        return this.toResponse(newLevel);
    }

    private static boolean failsFineGrain(ASTNode node, int fineGrain) {
        if (fineGrain == 0) {
            return false;
        }
        if ((fineGrain & 0x100000) != 0) {
            ASTNode cursor;
            for (cursor = node; cursor != null && !(cursor instanceof InstanceofExpression); cursor = cursor.getParent()) {
            }
            if (cursor == null) {
                return true;
            }
        }
        return false;
    }

    private int resolveLevelForSimpleName(ASTNode node, String simpleNameNeedle) {
        if (!simpleNameNeedle.contains(".") && this.locator.pattern.qualification != null && this.locator.pattern.qualification.length > 0) {
            for (Name id : this.imports) {
                QualifiedName qn;
                if (!(id instanceof QualifiedName) || !(qn = (QualifiedName)id).getName().toString().equals(simpleNameNeedle)) continue;
                char[] qualifiedPattern = this.locator.getQualifiedPattern(this.locator.pattern.simpleName, this.locator.pattern.qualification);
                int level3 = this.resolveLevelForTypeSourceName(qualifiedPattern, qn.toString().toCharArray(), null);
                if (level3 == 3) {
                    return 1;
                }
                return 1;
            }
        }
        return -1;
    }

    private int resolveLevelForTypeBinding(ASTNode node, ITypeBinding typeBinding, MatchLocator locator) {
        String qualNameFromBinding;
        int simpleNameMatch;
        DOMPatternLocator.IImportDiscovery importDiscovery = new DOMPatternLocator.IImportDiscovery(){

            @Override
            public String findImportForString(String s) {
                return DOMTypeReferenceLocator.this.fqqnFromImport(s);
            }
        };
        int newLevel = this.resolveLevelForTypeFQN(this.locator.pattern.simpleName, this.locator.pattern.qualification, typeBinding, importDiscovery);
        if (newLevel == 0 && (simpleNameMatch = this.resolveLevelForSimpleName(node, qualNameFromBinding = typeBinding.getQualifiedName())) != -1) {
            return simpleNameMatch;
        }
        if (this.locator.isDeclarationOfReferencedTypesPattern) {
            return this.resolveLevelForTypeBindingDeclarationOfReferencedTypes(typeBinding, node, newLevel, locator);
        }
        if (newLevel == 3 && this.locator.pattern.hasTypeArguments()) {
            return this.resolveLevelForTypeBindingWithTypeArguments(typeBinding, node, newLevel, locator);
        }
        return newLevel;
    }

    private int resolveLevelForTypeBindingWithTypeArguments(ITypeBinding typeBinding, ASTNode node, int newLevel, MatchLocator locator2) {
        int bindingTypeArgsLength;
        boolean patternHasTypeParameters = this.locator.pattern.hasTypeParameters();
        char[][][] patternTypeArgArray = this.locator.pattern.getTypeArguments();
        int patternTypeArgsLength = patternTypeArgArray == null ? -1 : (patternTypeArgArray[0] == null ? -1 : (patternTypeArgArray[0].length == 0 ? -1 : patternTypeArgArray[0].length));
        boolean bindingIsRaw = typeBinding.isRawType();
        boolean bindingIsGeneric = typeBinding.isGenericType();
        boolean bindingIsParameterized = typeBinding.isParameterizedType();
        int patternRule = this.locator.pattern.getMatchRule();
        boolean patternIsErasureMatch = (patternRule & 0x10) == 16;
        boolean patternIsEquivMatch = (patternRule & 0x20) == 32;
        ITypeBinding[] bindingArgs = typeBinding.getTypeArguments();
        ITypeBinding[] bindingParams = typeBinding.getTypeParameters();
        int n = bindingTypeArgsLength = bindingArgs == null ? -1 : bindingArgs.length;
        if (patternTypeArgsLength == bindingTypeArgsLength) {
            if (!bindingIsRaw && patternHasTypeParameters) {
                return 4;
            }
            return newLevel;
        }
        if (patternTypeArgsLength == 0) {
            return newLevel;
        }
        if (bindingTypeArgsLength == 0 && !patternIsEquivMatch) {
            return newLevel;
        }
        return 0;
    }

    private int resolveLevelForTypeBindingDeclarationOfReferencedTypes(ITypeBinding typeBinding, ASTNode node, int newLevel, MatchLocator locator) {
        IJavaElement je;
        IJavaElement enclosing = ((DeclarationOfReferencedTypesPattern)this.locator.pattern).enclosingElement;
        ITypeBinding t2 = typeBinding.getTypeDeclaration();
        IJavaElement iJavaElement = je = t2 == null ? null : t2.getJavaElement();
        if (je != null && !this.foundElements.contains(je) && DOMASTNodeUtils.isWithinRange(node, enclosing)) {
            ISourceRange rangeToUse;
            ISourceReference sr = je instanceof ISourceReference ? (ISourceReference)je : null;
            IResource r = null;
            ISourceRange srg = null;
            ISourceRange nameRange = null;
            try {
                srg = sr.getSourceRange();
                nameRange = sr.getNameRange();
                IJavaElement ancestor = je.getAncestor(5);
                r = ancestor == null ? null : ancestor.getCorrespondingResource();
            }
            catch (JavaModelException ancestor) {
                // empty catch block
            }
            ISourceRange iSourceRange = rangeToUse = nameRange == null ? srg : nameRange;
            if (rangeToUse != null) {
                TypeDeclarationMatch tdm = new TypeDeclarationMatch(je, newLevel, rangeToUse.getOffset(), rangeToUse.getLength(), locator.getParticipant(), r);
                try {
                    this.foundElements.add(je);
                    locator.report((SearchMatch)tdm);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    private CompilationUnit findCU(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)node;
            return cu;
        }
        return this.findCU(node.getParent());
    }

    public int match(SimpleName name, NodeSetWrapper nodeSet) {
        String simpleName = name.getIdentifier();
        return simpleName != null && this.locator.matchesName(this.locator.pattern.simpleName, simpleName.toCharArray()) ? 2 : 0;
    }

    public int match(QualifiedName name, NodeSetWrapper nodeSet) {
        String desiredQualifier;
        String simpleName = name.getName().getIdentifier();
        String qualifier = name.getQualifier().toString();
        if (this.locator.pattern.qualification == null) {
            return 0;
        }
        if (qualifier != null && !qualifier.equals(desiredQualifier = new String(this.locator.pattern.qualification))) {
            return 0;
        }
        return simpleName != null && this.locator.matchesName(this.locator.pattern.simpleName, simpleName.toCharArray()) ? 2 : 0;
    }

    protected int resolveLevelForType(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            if (this.locator.pattern.typeSuffix != '\u0000') {
                return 1;
            }
        } else {
            switch (this.locator.pattern.typeSuffix) {
                case 'C': {
                    if (typeBinding.isClass()) break;
                    return 0;
                }
                case '\n': {
                    if (typeBinding.isClass() || typeBinding.isInterface() && !typeBinding.isAnnotation()) break;
                    return 0;
                }
                case '\t': {
                    if (typeBinding.isClass() || typeBinding.isEnum()) break;
                    return 0;
                }
                case 'I': {
                    if (typeBinding.isInterface() && !typeBinding.isAnnotation()) break;
                    return 0;
                }
                case '\u000b': {
                    if (typeBinding.isInterface() || typeBinding.isAnnotation()) break;
                    return 0;
                }
                case 'E': {
                    if (typeBinding.isEnum()) break;
                    return 0;
                }
                case 'A': {
                    if (typeBinding.isAnnotation()) break;
                    return 0;
                }
            }
        }
        return this.resolveLevelForType(this.locator.pattern.simpleName, this.locator.pattern.qualification, typeBinding);
    }

    @Override
    public void reportSearchMatch(MatchLocator locator, ASTNode node, SearchMatch match) throws CoreException {
        boolean report;
        ASTNode replacementNode = null;
        if (node instanceof QualifiedType) {
            QualifiedType qtt = (QualifiedType)node;
            replacementNode = this.findNodeMatchingPatternQualifier(qtt.getQualifier());
        } else if (node instanceof SimpleType) {
            SimpleType st = (SimpleType)node;
            replacementNode = this.findNodeMatchingPatternQualifier((Type)st);
        }
        if (replacementNode != null) {
            int matchStart = match.getOffset();
            int matchEnd = matchStart + match.getLength();
            int newStart = replacementNode.getStartPosition();
            int newLength = matchEnd - newStart;
            match.setOffset(newStart);
            match.setLength(newLength);
        }
        boolean bl = report = this.isErasureMatch && match.isErasure() || this.isEquivalentMatch && match.isEquivalent() || match.isExact();
        if (!report) {
            return;
        }
        SearchMatchingUtility.reportSearchMatch(locator, match);
    }

    private ASTNode findNodeMatchingPatternQualifier(Type qualifier) {
        String needle;
        if (qualifier instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)qualifier;
            return this.findNodeMatchingPatternQualifier(pt.getType());
        }
        final Name[] retNode = new Name[]{null};
        String string = needle = this.locator.pattern.qualification == null ? null : new String(this.locator.pattern.qualification);
        if (needle != null) {
            qualifier.accept(new ASTVisitor(this){

                public boolean visit(QualifiedName node) {
                    if (node.getName().toString().equals(needle)) {
                        retNode[0] = node.getName();
                    }
                    return retNode[0] == null;
                }

                public boolean visit(SimpleName node) {
                    if (node.toString().equals(needle)) {
                        retNode[0] = node;
                    }
                    return retNode[0] == null;
                }

                public boolean visit(ParameterizedType node) {
                    node.getType().accept((ASTVisitor)this);
                    return false;
                }
            });
        }
        return retNode[0];
    }
}

