/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.Objects;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.LocalVariableLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;

public class DOMLocalVariableLocator
extends DOMPatternLocator {
    private LocalVariableLocator locator;

    public DOMLocalVariableLocator(LocalVariableLocator lcl) {
        super((SearchPattern)lcl.pattern);
        this.locator = lcl;
    }

    @Override
    public LocatorResponse match(Name node, NodeSetWrapper nodeSet, MatchLocator locator) {
        ChildPropertyDescriptor descriptor;
        StructuralPropertyDescriptor structuralPropertyDescriptor = node.getLocationInParent();
        if (structuralPropertyDescriptor instanceof ChildPropertyDescriptor && ((descriptor = (ChildPropertyDescriptor)structuralPropertyDescriptor).getChildType() == Expression.class || descriptor == QualifiedName.QUALIFIER_PROPERTY) && node instanceof SimpleName) {
            SimpleName simple = (SimpleName)node;
            if (this.locator.getLocalVariable().getElementName().equals(simple.getIdentifier())) {
                return this.toResponse(2);
            }
        }
        return this.toResponse(0);
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (!(binding instanceof IVariableBinding)) {
            return this.toResponse(0);
        }
        if (Objects.equals(binding.getJavaElement(), this.locator.getLocalVariable())) {
            return this.toResponse(3);
        }
        return this.toResponse(1);
    }

    @Override
    public LocatorResponse match(VariableDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        int referencesLevel = 0;
        if (this.locator.pattern.findReferences && this.locator.pattern.writeAccess && !this.locator.pattern.readAccess && node.getInitializer() != null && this.locator.matchesName(this.locator.pattern.name, node.getName().getIdentifier().toCharArray())) {
            referencesLevel = this.locator.pattern.mustResolve ? 2 : 3;
        }
        int declarationsLevel = 0;
        if (this.locator.pattern.findDeclarations && this.locator.matchesName(this.locator.pattern.name, node.getName().getIdentifier().toCharArray()) && node.getStartPosition() == this.locator.getLocalVariable().declarationSourceStart) {
            declarationsLevel = this.locator.pattern.mustResolve ? 2 : 3;
        }
        int level = nodeSet.addMatch((ASTNode)node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
        return this.toResponse(level, true);
    }
}

