/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.UnionType;

public class DOMThrownExceptionFinder
extends ASTVisitor {
    private Set<ITypeBinding> thrownExceptions;
    private Stack<Set<ITypeBinding>> exceptionsStack;
    private Set<ITypeBinding> caughtExceptions;
    private Set<ITypeBinding> discouragedExceptions;

    public void processThrownExceptions(TryStatement tryStatement) {
        this.thrownExceptions = new HashSet<ITypeBinding>();
        this.exceptionsStack = new Stack();
        this.caughtExceptions = new HashSet<ITypeBinding>();
        this.discouragedExceptions = new HashSet<ITypeBinding>();
        tryStatement.accept((ASTVisitor)this);
        this.removeCaughtExceptions(tryStatement, true);
    }

    private void acceptException(ITypeBinding binding) {
        if (binding != null && !binding.isRecovered()) {
            this.thrownExceptions.add(binding);
        }
    }

    public void endVisit(MethodInvocation node) {
        this.endVisitMethodInvocation(node.resolveMethodBinding());
        super.visit(node);
    }

    public void endVisit(ClassInstanceCreation node) {
        this.endVisitMethodInvocation(node.resolveConstructorBinding());
        super.visit(node);
    }

    public void endVisit(ThrowStatement node) {
        this.acceptException(node.getExpression().resolveTypeBinding());
        super.visit(node);
    }

    private void endVisitMethodInvocation(IMethodBinding methodBinding) {
        if (methodBinding == null) {
            return;
        }
        for (ITypeBinding thrownException : methodBinding.getExceptionTypes()) {
            this.acceptException(thrownException);
        }
    }

    public ITypeBinding[] getAlreadyCaughtExceptions() {
        return (ITypeBinding[])this.caughtExceptions.toArray(ITypeBinding[]::new);
    }

    public ITypeBinding[] getThrownUncaughtExceptions() {
        return (ITypeBinding[])this.thrownExceptions.toArray(ITypeBinding[]::new);
    }

    public ITypeBinding[] getDiscouragedExceptions() {
        return (ITypeBinding[])this.discouragedExceptions.toArray(ITypeBinding[]::new);
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        return false;
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        return false;
    }

    public boolean visit(RecordDeclaration recordDeclaration) {
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        return false;
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        this.exceptionsStack.push(this.thrownExceptions);
        HashSet<ITypeBinding> exceptionSet = new HashSet<ITypeBinding>();
        this.thrownExceptions = exceptionSet;
        tryStatement.getBody().accept((ASTVisitor)this);
        this.removeCaughtExceptions(tryStatement, false);
        this.thrownExceptions = this.exceptionsStack.pop();
        for (ITypeBinding value : exceptionSet) {
            this.thrownExceptions.add(value);
        }
        for (CatchClause catchClause : tryStatement.catchClauses()) {
            catchClause.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    private void removeCaughtExceptions(TryStatement tryStatement, boolean recordUncheckedCaughtExceptions) {
        for (CatchClause catchClause : tryStatement.catchClauses()) {
            Type exceptionType = catchClause.getException().getType();
            if (exceptionType instanceof UnionType) {
                UnionType unionType = (UnionType)exceptionType;
                for (Type unionMemberType : unionType.types()) {
                    ITypeBinding unionMemberTypeBinding = unionMemberType.resolveBinding();
                    if (unionMemberTypeBinding.isRecovered()) continue;
                    if (recordUncheckedCaughtExceptions) {
                        this.removeCaughtException(unionMemberTypeBinding);
                        this.caughtExceptions.add(unionMemberTypeBinding);
                        continue;
                    }
                    if (this.isUncheckedException(unionMemberTypeBinding)) continue;
                    this.discouragedExceptions.add(unionMemberTypeBinding);
                }
                continue;
            }
            ITypeBinding exception = catchClause.getException().getType().resolveBinding();
            if (exception.isRecovered()) continue;
            if (recordUncheckedCaughtExceptions) {
                this.removeCaughtException(exception);
                this.caughtExceptions.add(exception);
                continue;
            }
            if (this.isUncheckedException(exception)) continue;
            this.discouragedExceptions.add(exception);
        }
    }

    private void removeCaughtException(ITypeBinding caughtException) {
        ArrayList<ITypeBinding> toRemoves = new ArrayList<ITypeBinding>();
        for (ITypeBinding exception : this.thrownExceptions) {
            if (caughtException.getKey().equals(exception.getKey())) {
                toRemoves.add(exception);
                continue;
            }
            if (!exception.isSubTypeCompatible(caughtException)) continue;
            toRemoves.add(exception);
            this.discouragedExceptions.add(exception);
        }
        for (ITypeBinding toRemove : toRemoves) {
            this.thrownExceptions.remove(toRemove);
        }
    }

    private boolean isUncheckedException(ITypeBinding binding) {
        for (ITypeBinding cursor = binding; cursor != null; cursor = cursor.getSuperclass()) {
            if ("Ljava/lang/RuntimeException;".equals(cursor.getKey())) {
                return true;
            }
            if (!"Ljava/lang/Error;".equals(cursor.getKey())) continue;
            return true;
        }
        return false;
    }
}

