/*********************************************************************
 * Copyright (c) 2018 QNX Software Systems and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import { IGDBBackend } from '../types/gdb';
import { MIResponse } from './base';
export declare function sendExecArguments(gdb: IGDBBackend, params: {
    arguments: string;
}): Promise<MIResponse>;
export declare function sendExecRun(gdb: IGDBBackend): Promise<unknown>;
export declare function sendExecContinue(gdb: IGDBBackend, threadId?: number): Promise<unknown>;
export declare function sendExecNext(gdb: IGDBBackend, threadId?: number): Promise<unknown>;
export declare function sendExecNextInstruction(gdb: IGDBBackend, threadId?: number): Promise<unknown>;
export declare function sendExecStep(gdb: IGDBBackend, threadId?: number): Promise<unknown>;
export declare function sendExecStepInstruction(gdb: IGDBBackend, threadId?: number): Promise<unknown>;
export declare function sendExecFinish(gdb: IGDBBackend, threadId?: number): Promise<unknown>;
export declare function sendExecInterrupt(gdb: IGDBBackend, threadId?: number): Promise<unknown>;
