"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendExecInterrupt = exports.sendExecFinish = exports.sendExecStepInstruction = exports.sendExecStep = exports.sendExecNextInstruction = exports.sendExecNext = exports.sendExecContinue = exports.sendExecRun = exports.sendExecArguments = void 0;
function sendExecArguments(gdb, params) {
    return gdb.sendCommand(`-exec-arguments ${params.arguments}`);
}
exports.sendExecArguments = sendExecArguments;
function sendExecRun(gdb) {
    return gdb.sendCommand('-exec-run');
}
exports.sendExecRun = sendExecRun;
function sendExecContinue(gdb, threadId) {
    let command = '-exec-continue';
    if (threadId !== undefined) {
        command += ` --thread ${threadId}`;
    }
    return gdb.sendCommand(command);
}
exports.sendExecContinue = sendExecContinue;
function sendExecNext(gdb, threadId) {
    let command = '-exec-next';
    if (threadId !== undefined) {
        command += ` --thread ${threadId}`;
    }
    return gdb.sendCommand(command);
}
exports.sendExecNext = sendExecNext;
function sendExecNextInstruction(gdb, threadId) {
    let command = '-exec-next-instruction';
    if (threadId !== undefined) {
        command += ` --thread ${threadId}`;
    }
    return gdb.sendCommand(command);
}
exports.sendExecNextInstruction = sendExecNextInstruction;
function sendExecStep(gdb, threadId) {
    let command = '-exec-step';
    if (threadId !== undefined) {
        command += ` --thread ${threadId}`;
    }
    return gdb.sendCommand(command);
}
exports.sendExecStep = sendExecStep;
function sendExecStepInstruction(gdb, threadId) {
    let command = '-exec-step-instruction';
    if (threadId !== undefined) {
        command += ` --thread ${threadId}`;
    }
    return gdb.sendCommand(command);
}
exports.sendExecStepInstruction = sendExecStepInstruction;
function sendExecFinish(gdb, threadId) {
    let command = '-exec-finish';
    if (threadId !== undefined) {
        command += ` --thread ${threadId}`;
    }
    return gdb.sendCommand(command);
}
exports.sendExecFinish = sendExecFinish;
function sendExecInterrupt(gdb, threadId) {
    let command = '-exec-interrupt';
    if (threadId !== undefined) {
        command += ` --thread ${threadId}`;
    }
    else {
        command += ' --all';
    }
    return gdb.sendCommand(command);
}
exports.sendExecInterrupt = sendExecInterrupt;
//# sourceMappingURL=exec.js.map