"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphPerformanceTest = void 0;
var time_graph_container_1 = require("../../time-graph-container");
var time_graph_row_controller_1 = require("../../time-graph-row-controller");
var time_graph_unit_controller_1 = require("../../time-graph-unit-controller");
var time_graph_axis_1 = require("../time-graph-axis");
var time_graph_axis_cursors_1 = require("../time-graph-axis-cursors");
var time_graph_chart_1 = require("../time-graph-chart");
var time_graph_chart_cursors_1 = require("../time-graph-chart-cursors");
var time_graph_chart_grid_1 = require("../time-graph-chart-grid");
var time_graph_chart_selection_range_1 = require("../time-graph-chart-selection-range");
var test_data_provider_1 = require("./test-data-provider");
var styleConfig = {
    mainWidth: 1418,
    mainHeight: 820,
    naviBackgroundColor: 0xf7eaaf,
    chartBackgroundColor: 0xf9f6e8,
    cursorColor: 0xb77f09
};
var TimeGraphPerformanceTest = /** @class */ (function () {
    function TimeGraphPerformanceTest(data, viewRange) {
        var _this = this;
        // Set up HTML container
        document.body.innerHTML = "\n        <div id=\"main\"><div/>\n        ";
        var styleMap = new Map();
        var rowHeight = 20;
        var container = document.getElementById('main');
        if (!container) {
            throw ("No container available.");
        }
        container.innerHTML = '';
        container.style.width = styleConfig.mainWidth + "px";
        // Create the data stub
        var dataStub = new test_data_provider_1.TimeGraphPerformanceTestDataStubJsonImp(data);
        this.testDataProvider = new test_data_provider_1.TestDataProvider(styleConfig.mainWidth, dataStub);
        var timeGraph = this.testDataProvider.fetchTimeGraphData({});
        // Create the unit controller
        this.unitController = new time_graph_unit_controller_1.TimeGraphUnitController(timeGraph.totalLength, viewRange);
        this.unitController.numberTranslator = function (theNumber) {
            var originalStart = _this.testDataProvider.absoluteStart;
            theNumber += originalStart;
            var zeroPad = function (num) { return String(num).padStart(3, '0'); };
            var seconds = theNumber / BigInt(1000000000);
            var millis = zeroPad((theNumber / BigInt(1000000)) % BigInt(1000));
            var micros = zeroPad((theNumber / BigInt(1000)) % BigInt(1000));
            var nanos = zeroPad(theNumber % BigInt(1000));
            return seconds + '.' + millis + ' ' + micros + ' ' + nanos;
        };
        this.unitController.worldRenderFactor = 0.25;
        // Create providers
        var providers = {
            rowProvider: function () {
                return {
                    rowIds: _this.testDataProvider.getRowIds()
                };
            },
            dataProvider: function (range, resolution) {
                var newRange = range;
                var newResolution = resolution * 0.1;
                timeGraph = _this.testDataProvider.fetchTimeGraphData({ range: newRange, resolution: newResolution });
                return {
                    rows: timeGraph.rows,
                    range: newRange,
                    resolution: newResolution
                };
            },
            stateStyleProvider: function (model) {
                var styles = [
                    {
                        color: 0x11ad1b,
                        height: rowHeight * 0.8
                    }, {
                        color: 0xbc2f00,
                        height: rowHeight * 0.7
                    }, {
                        color: 0xccbf5d,
                        height: rowHeight * 0.6
                    }
                ];
                var style = styles[0];
                if (model.data && model.data.value) {
                    var val = model.data.value;
                    style = styleMap.get(val);
                    if (!style) {
                        style = styles[(styleMap.size % styles.length)];
                        styleMap.set(val, style);
                    }
                }
                return {
                    color: style.color,
                    height: style.height,
                    borderWidth: model.selected ? 1 : 0,
                    minWidthForLabels: 100
                };
            },
            rowStyleProvider: function (row) {
                if (row) {
                    return {
                        backgroundColor: 0xe0ddcf,
                        backgroundOpacity: row.selected ? 0.6 : 0,
                        lineColor: row.data && row.data.hasStates ? 0xdddddd : 0xaa4444,
                        lineThickness: row.data && row.data.hasStates ? 1 : 3
                    };
                }
                return {};
            },
            rowAnnotationStyleProvider: function (annotation) {
                var _a, _b, _c, _d;
                return {
                    color: (_a = annotation.data) === null || _a === void 0 ? void 0 : _a.color,
                    size: 7 * (annotation.data && annotation.data.height ? annotation.data.height : 1.0),
                    symbol: (_b = annotation.data) === null || _b === void 0 ? void 0 : _b.symbol,
                    verticalAlign: (_c = annotation.data) === null || _c === void 0 ? void 0 : _c.verticalAlign,
                    opacity: (_d = annotation.data) === null || _d === void 0 ? void 0 : _d.opacity
                };
            }
        };
        var totalHeight = timeGraph.rows.length * rowHeight;
        var rowController = new time_graph_row_controller_1.TimeGraphRowController(rowHeight, totalHeight);
        var axisHTMLContainer = document.createElement('div');
        axisHTMLContainer.id = 'main_axis';
        container.appendChild(axisHTMLContainer);
        var axisCanvas = document.createElement('canvas');
        var timeGraphAxisContainer = new time_graph_container_1.TimeGraphContainer({
            height: 30,
            width: styleConfig.mainWidth,
            id: timeGraph.id + '_axis',
            backgroundColor: 0xffffff
        }, this.unitController, axisCanvas);
        axisHTMLContainer.appendChild(timeGraphAxisContainer.canvas);
        var timeAxisCursors = new time_graph_axis_cursors_1.TimeGraphAxisCursors('timeGraphAxisCursors', { color: styleConfig.cursorColor });
        var timeAxisLayer = new time_graph_axis_1.TimeGraphAxis('timeGraphAxis', { color: styleConfig.naviBackgroundColor, verticalAlign: 'bottom' });
        timeGraphAxisContainer.addLayers([timeAxisLayer, timeAxisCursors]);
        var chartHTMLContainer = document.createElement('div');
        chartHTMLContainer.id = 'main_chart2';
        container.appendChild(chartHTMLContainer);
        var chartCanvas = document.createElement('canvas');
        chartCanvas.tabIndex = 1;
        this.timeGraphChartContainer = new time_graph_container_1.TimeGraphContainer({
            id: timeGraph.id + '_chart',
            height: styleConfig.mainHeight,
            width: styleConfig.mainWidth,
            backgroundColor: styleConfig.chartBackgroundColor
        }, this.unitController, chartCanvas);
        chartHTMLContainer.appendChild(this.timeGraphChartContainer.canvas);
        var timeGraphChartGridLayer = new time_graph_chart_grid_1.TimeGraphChartGrid('timeGraphGrid', rowHeight);
        this.timeGraphChart = new time_graph_chart_1.TimeGraphChart('timeGraphChart', providers, rowController);
        var timeGraphSelectionRange = new time_graph_chart_selection_range_1.TimeGraphChartSelectionRange('chart-selection-range', { color: styleConfig.cursorColor });
        var timeGraphChartCursors = new time_graph_chart_cursors_1.TimeGraphChartCursors('chart-cursors', this.timeGraphChart, rowController, { color: styleConfig.cursorColor });
        this.timeGraphChartContainer.addLayers([timeGraphChartGridLayer,
            this.timeGraphChart,
            timeGraphSelectionRange,
            timeGraphChartCursors
        ]);
    }
    TimeGraphPerformanceTest.prototype.setViewRange = function (start, end) {
        this.unitController.viewRange = {
            start: start,
            end: end
        };
    };
    TimeGraphPerformanceTest.prototype.scaleChart = function (scaleFactor) {
        // @ts-ignore
        this.timeGraphChartContainer.stateController.scaleFactor = scaleFactor;
    };
    TimeGraphPerformanceTest.prototype.getTimeGraphChart = function () {
        return this.timeGraphChart;
    };
    TimeGraphPerformanceTest.prototype.getTotalLength = function () {
        return this.testDataProvider.totalLength;
    };
    TimeGraphPerformanceTest.prototype.getAbsoluteStart = function () {
        return this.testDataProvider.absoluteStart;
    };
    TimeGraphPerformanceTest.prototype.toNextDataSet = function () {
        // Change the data fetched
        this.testDataProvider.toNextDataSet();
    };
    TimeGraphPerformanceTest.prototype.getData = function () {
        // Call the stub to fetch the test data
        return this.testDataProvider.fetchTimeGraphData({});
    };
    return TimeGraphPerformanceTest;
}());
exports.TimeGraphPerformanceTest = TimeGraphPerformanceTest;
//# sourceMappingURL=time-graph-performance-test.js.map