"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphStateComponent = void 0;
var time_graph_component_1 = require("./time-graph-component");
var time_graph_font_controller_1 = require("../time-graph-font-controller");
var PIXI = require("pixi.js-legacy");
/**
 * Using BitMapText.getLocalBounds() to measure the full label width is expensive, because
 * we need to create a BitMapText object to use it. This means that we need to create a BitMapText
 * for every state, even if we don't use it. When we remove the states, these objects need to
 * be removed as well. In the case where we have a lot states, this cause multiple garbage collection
 * and hogs the performance of the timeline chart.
 *
 * An alternative to measure the width of the label is to use PIXI.TextMetrics.measureText().
 * However, this method applies only for Text objects, and not BitMapText; therefore there is a
 * slight difference between the values returned by the two methods. PIXI.TextMetrics returns a
 * slightly smaller value. Currently, PIXI does not support measureText() for BitMapText.
 *
 * Through some trials, it looks like the ratio between the text width returned by the two methods is
 * consistent. Hence, we can use PIXI.TextMetrics.measureText() to get a good estimation of the text width,
 * then multiply with the SCALING_FACTOR to determine the actual width of the label when rendered
 * with BitMapText.
 *
 * SCALING_FACTOR = BitMapText.getLocalBounds() / PIXI.TextMetrics.measureText()
 */
var SCALING_FACTOR = 1.04;
var TimeGraphStateComponent = /** @class */ (function (_super) {
    __extends(TimeGraphStateComponent, _super);
    function TimeGraphStateComponent(id, model, xStart, xEnd, _row, _style, displayWidth, displayObject) {
        if (_style === void 0) { _style = { color: 0xfffa66, height: 14 }; }
        var _this = _super.call(this, id, displayObject, model) || this;
        _this._row = _row;
        _this._style = _style;
        _this.displayWidth = displayWidth;
        var height = _row.height === 0 ? 0 : Math.min(_style.height || 14, _row.height - 1);
        var position = {
            x: xStart,
            y: _this._row.position.y + ((_this.row.height - height) / 2)
        };
        // min width of a state should never be less than 1 (for visibility)
        var width = Math.max(1, xEnd - xStart);
        _this._options = {
            color: _style.color,
            opacity: _style.opacity,
            height: height,
            position: position,
            width: width,
            displayWidth: displayWidth,
            borderRadius: 2,
            borderWidth: _style.borderWidth || 0,
            borderColor: _style.borderColor || 0x000000
        };
        return _this;
    }
    /**
     * Conveniently generate the labels of states and apply proper scaling when zooming
     *
     * @param scaleFactor
     */
    TimeGraphStateComponent.prototype.renderLabel = function (scaleFactor) {
        var _a;
        if (scaleFactor === void 0) { scaleFactor = 1; }
        if (!this.model.label) {
            return;
        }
        var _b = TimeGraphStateComponent.fontController.getFont(this._options.color ? this._options.color : 0, this._options.height - 2) ||
            TimeGraphStateComponent.fontController.getDefaultFont(), fontName = _b.fontName, fontStyle = _b.fontStyle;
        var position = {
            x: this._options.position.x + this._options.width < 0 ? this._options.position.x : Math.max(0, this._options.position.x),
            y: this._options.position.y
        };
        var displayWidth = this._options.displayWidth ? this._options.displayWidth : 0;
        var labelText = this.model.label;
        var textPadding = 0.5;
        if (displayWidth < 3) {
            this.removeLabel();
            return;
        }
        if (fontStyle) {
            var metrics = PIXI.TextMetrics.measureText(this.model.label, fontStyle);
            // Round the text width up just to be sure that it will fit in the state
            var textWidth = Math.ceil(metrics.width * SCALING_FACTOR / scaleFactor);
            var textObjX = position.x + textPadding;
            var textObjY = position.y + textPadding;
            var displayLabel = "";
            if (displayWidth > textWidth) {
                textObjX = position.x + (displayWidth - textWidth) / 2;
                displayLabel = labelText;
            }
            else {
                var textScaler = displayWidth / textWidth;
                var index = Math.min(Math.floor(textScaler * labelText.length), labelText.length - 1);
                var partialLabel = labelText.substr(0, Math.max(index - 1, 0));
                if (partialLabel.length > 0) {
                    displayLabel = partialLabel.concat("…");
                }
            }
            if (displayLabel === "") {
                this.removeLabel();
                return;
            }
            if (!this.textLabelObject) {
                this.textLabelObject = new PIXI.BitmapText(displayLabel, { fontName: fontName });
                this.displayObject.addChild(this.textLabelObject);
            }
            else {
                this.textLabelObject.text = displayLabel;
            }
            this.textLabelObject.alpha = (_a = this._options.opacity) !== null && _a !== void 0 ? _a : 1;
            this.textLabelObject.x = textObjX;
            this.textLabelObject.y = textObjY;
            this.textLabelObject.scale.x = 1 / scaleFactor;
        }
    };
    /**
     * Scale only state labels that actually have text displayed.
     *
     * @param scaleFactor
     */
    TimeGraphStateComponent.prototype.scaleLabel = function (scaleFactor) {
        if (this.textLabelObject && this.textLabelObject.scale && scaleFactor !== 1) {
            this.renderLabel(scaleFactor);
        }
    };
    TimeGraphStateComponent.prototype.removeLabel = function () {
        if (this.textLabelObject) {
            this.textLabelObject.destroy();
            this.textLabelObject = undefined;
        }
    };
    Object.defineProperty(TimeGraphStateComponent.prototype, "height", {
        get: function () {
            return this._options.height;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphStateComponent.prototype, "width", {
        get: function () {
            return this._options.width;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphStateComponent.prototype, "position", {
        get: function () {
            return this._options.position;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphStateComponent.prototype, "row", {
        get: function () {
            return this._row;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphStateComponent.prototype, "style", {
        get: function () {
            return this._style;
        },
        set: function (style) {
            if (style.color !== undefined) {
                this._options.color = style.color;
            }
            if (style.opacity !== undefined) {
                this._options.opacity = style.opacity;
            }
            if (style.height !== undefined) {
                this._options.height = style.height;
            }
            if (style.borderColor !== undefined) {
                this._options.borderColor = style.borderColor;
            }
            if (style.borderWidth !== undefined) {
                this._options.borderWidth = style.borderWidth;
            }
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    TimeGraphStateComponent.prototype.update = function (opts) {
        if (opts) {
            this._options.position = opts.position;
            this._options.width = opts.width;
            this._options.displayWidth = opts.displayWidth;
        }
        _super.prototype.update.call(this);
    };
    TimeGraphStateComponent.prototype.render = function () {
        this.rect(this._options);
        this.renderLabel();
    };
    TimeGraphStateComponent.prototype.clear = function () {
        _super.prototype.clear.call(this);
    };
    TimeGraphStateComponent.fontController = new time_graph_font_controller_1.FontController();
    return TimeGraphStateComponent;
}(time_graph_component_1.TimeGraphComponent));
exports.TimeGraphStateComponent = TimeGraphStateComponent;
//# sourceMappingURL=time-graph-state.js.map