"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UriList = exports.addExternalEditorsDropData = exports.createFileDataTransferItemFromFile = exports.toVSDataTransfer = void 0;
const dnd_1 = require("../../base/browser/dnd");
const arrays_1 = require("../../base/common/arrays");
const dataTransfer_1 = require("../../base/common/dataTransfer");
const mime_1 = require("../../base/common/mime");
const uri_1 = require("../../base/common/uri");
const dnd_2 = require("../../platform/dnd/browser/dnd");
function toVSDataTransfer(dataTransfer) {
    const vsDataTransfer = new dataTransfer_1.VSDataTransfer();
    for (const item of dataTransfer.items) {
        const type = item.type;
        if (item.kind === 'string') {
            const asStringValue = new Promise(resolve => item.getAsString(resolve));
            vsDataTransfer.append(type, (0, dataTransfer_1.createStringDataTransferItem)(asStringValue));
        }
        else if (item.kind === 'file') {
            const file = item.getAsFile();
            if (file) {
                vsDataTransfer.append(type, createFileDataTransferItemFromFile(file));
            }
        }
    }
    return vsDataTransfer;
}
exports.toVSDataTransfer = toVSDataTransfer;
function createFileDataTransferItemFromFile(file) {
    const uri = file.path ? uri_1.URI.parse(file.path) : undefined;
    return (0, dataTransfer_1.createFileDataTransferItem)(file.name, uri, () => __awaiter(this, void 0, void 0, function* () {
        return new Uint8Array(yield file.arrayBuffer());
    }));
}
exports.createFileDataTransferItemFromFile = createFileDataTransferItemFromFile;
const INTERNAL_DND_MIME_TYPES = Object.freeze([
    dnd_2.CodeDataTransfers.EDITORS,
    dnd_2.CodeDataTransfers.FILES,
    dnd_1.DataTransfers.RESOURCES,
]);
function addExternalEditorsDropData(dataTransfer, dragEvent, overwriteUriList = false) {
    var _a;
    if (dragEvent.dataTransfer && (overwriteUriList || !dataTransfer.has(mime_1.Mimes.uriList))) {
        const editorData = (0, dnd_2.extractEditorsDropData)(dragEvent)
            .filter(input => input.resource)
            .map(input => input.resource.toString());
        // Also add in the files
        for (const item of (_a = dragEvent.dataTransfer) === null || _a === void 0 ? void 0 : _a.items) {
            const file = item.getAsFile();
            if (file) {
                editorData.push(file.path ? uri_1.URI.file(file.path).toString() : file.name);
            }
        }
        if (editorData.length) {
            dataTransfer.replace(mime_1.Mimes.uriList, (0, dataTransfer_1.createStringDataTransferItem)(exports.UriList.create(editorData)));
        }
    }
    for (const internal of INTERNAL_DND_MIME_TYPES) {
        dataTransfer.delete(internal);
    }
}
exports.addExternalEditorsDropData = addExternalEditorsDropData;
exports.UriList = Object.freeze({
    // http://amundsen.com/hypermedia/urilist/
    create: (entries) => {
        return (0, arrays_1.distinct)(entries.map(x => x.toString())).join('\r\n');
    },
    parse: (str) => {
        return str.split('\r\n').filter(value => !value.startsWith('#'));
    }
});
//# sourceMappingURL=dnd.js.map