"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactTimeGraphContainer = void 0;
const React = __importStar(require("react"));
const time_graph_container_1 = require("timeline-chart/lib/time-graph-container");
const lodash_1 = require("lodash");
class ReactTimeGraphContainer extends React.Component {
    componentDidMount() {
        const { options, unitController, layers } = this.props;
        this.container = new time_graph_container_1.TimeGraphContainer(options, unitController, this.ref);
        if (this.container) {
            this.container.addLayers(layers);
        }
        this._resizeHandler = (0, lodash_1.debounce)(() => this.resize(), 500, { trailing: true, leading: false });
        this.props.addWidgetResizeHandler(this._resizeHandler);
    }
    componentWillUnmount() {
        if (this.container) {
            this.container.destroy();
        }
        if (this._resizeHandler) {
            this.props.removeWidgetResizeHandler(this._resizeHandler);
        }
    }
    shouldComponentUpdate(nextProps) {
        return nextProps.options.height !== this.props.options.height
            || nextProps.options.width !== this.props.options.width
            || nextProps.options.backgroundColor !== this.props.options.backgroundColor;
    }
    componentDidUpdate(prevProps) {
        if ((prevProps.options.height !== this.props.options.height
            || prevProps.options.backgroundColor !== this.props.options.backgroundColor)
            && this.container) {
            this.container.updateCanvas(this.props.options.width, this.props.options.height, this.props.options.backgroundColor, this.props.options.lineColor);
        }
    }
    render() {
        return React.createElement("canvas", { ref: ref => this.ref = ref || undefined, onWheel: e => e.preventDefault(), tabIndex: 0 });
    }
    resize() {
        if (this.container) {
            this.container.updateCanvas(this.props.options.width, this.props.options.height, this.props.options.backgroundColor, this.props.options.lineColor);
        }
    }
}
exports.ReactTimeGraphContainer = ReactTimeGraphContainer;
//# sourceMappingURL=timegraph-container-component.js.map