"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaginationBarComponent = void 0;
const React = __importStar(require("react"));
const xy_output_component_utils_1 = require("./xy-output-component-utils");
const react_fontawesome_1 = require("@fortawesome/react-fontawesome");
const free_solid_svg_icons_1 = require("@fortawesome/free-solid-svg-icons");
const free_solid_svg_icons_2 = require("@fortawesome/free-solid-svg-icons");
var Direction;
(function (Direction) {
    Direction[Direction["NEXT"] = 0] = "NEXT";
    Direction[Direction["PREVIOUS"] = 1] = "PREVIOUS";
    Direction[Direction["FIRST"] = 2] = "FIRST";
    Direction[Direction["LAST"] = 3] = "LAST";
})(Direction || (Direction = {}));
class PaginationBarComponent extends React.Component {
    render() {
        var _a, _b;
        const currentPage = ((_a = this.props.gridApi) === null || _a === void 0 ? void 0 : _a.paginationGetCurrentPage()) ? ((_b = this.props.gridApi) === null || _b === void 0 ? void 0 : _b.paginationGetCurrentPage()) + 1 : 1;
        const firstRowRaw = (currentPage - 1) * this.props.paginationPageSize + 1;
        const firstRow = (0, xy_output_component_utils_1.numberFormat)(firstRowRaw);
        const lastRow = currentPage === this.props.paginationTotalPages + 1 ?
            (0, xy_output_component_utils_1.numberFormat)(this.props.nbEvents) :
            (0, xy_output_component_utils_1.numberFormat)(firstRowRaw + this.props.paginationPageSize - 1);
        return React.createElement("div", { className: 'pagination-bar' },
            React.createElement("span", { style: { margin: 'auto 10px auto auto' } },
                firstRow,
                " to ",
                lastRow,
                " of ",
                (0, xy_output_component_utils_1.numberFormat)(this.props.nbEvents)),
            React.createElement("button", { className: 'pagination-button', onClick: () => this.paginationJumpTo(Direction.FIRST) },
                React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_2.faChevronLeft }),
                React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_2.faChevronLeft })),
            React.createElement("button", { className: 'pagination-button', onClick: () => this.paginationJumpTo(Direction.PREVIOUS) },
                React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_2.faChevronLeft })),
            React.createElement("span", { style: { margin: 'auto 10px' } },
                "Page ",
                currentPage,
                " of ",
                this.props.paginationTotalPages + 1),
            React.createElement("button", { className: 'pagination-button', onClick: () => this.paginationJumpTo(Direction.NEXT) },
                React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_1.faChevronRight })),
            React.createElement("button", { className: 'pagination-button', style: { marginRight: '10px' }, onClick: () => this.paginationJumpTo(Direction.LAST) },
                React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_1.faChevronRight }),
                React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_1.faChevronRight })));
    }
    paginationJumpTo(direction) {
        var _a, _b, _c, _d;
        switch (direction) {
            case Direction.FIRST:
                (_a = this.props.gridApi) === null || _a === void 0 ? void 0 : _a.paginationGoToFirstPage();
                break;
            case Direction.LAST:
                (_b = this.props.gridApi) === null || _b === void 0 ? void 0 : _b.paginationGoToLastPage();
                break;
            case Direction.NEXT:
                (_c = this.props.gridApi) === null || _c === void 0 ? void 0 : _c.paginationGoToNextPage();
                break;
            case Direction.PREVIOUS:
                (_d = this.props.gridApi) === null || _d === void 0 ? void 0 : _d.paginationGoToPreviousPage();
                break;
        }
        this.forceUpdate();
    }
}
exports.PaginationBarComponent = PaginationBarComponent;
//# sourceMappingURL=pagination-bar-component.js.map