"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FontController = void 0;
var PIXI = require("pixi.js-legacy");
var FontController = /** @class */ (function () {
    function FontController(fontFamily) {
        if (fontFamily === void 0) { fontFamily = "monospace"; }
        this.defaultFontName = "LabelFont8White";
        this.fontFamily = fontFamily;
        this.fontNameMap = new Map();
        this.fontColorMap = new Map();
        var defaultFontSize = 8;
        this.updateFontNameMap(defaultFontSize);
    }
    FontController.prototype.getDefaultFontName = function () {
        return this.defaultFontName;
    };
    FontController.prototype.createFontName = function (fontColor, fontSize) {
        var fontName = "LabelFont" + fontSize.toString() + fontColor;
        var fontStyle = {
            fontFamily: this.fontFamily,
            fontSize: fontSize,
            fill: fontColor === "White" ? "white" : "black",
            fontWeight: "bold"
        };
        PIXI.BitmapFont.from(fontName, fontStyle, { chars: this.getCharacterSet() });
        return fontName;
    };
    FontController.prototype.updateFontNameMap = function (size) {
        var color2FontMap = new Map();
        color2FontMap.set("black", this.createFontName("Black", size));
        color2FontMap.set("white", this.createFontName("White", size));
        this.fontNameMap.set(size, color2FontMap);
    };
    FontController.prototype.getFontName = function (color, size) {
        var fontColor = this.fontColorMap.get(color);
        if (!fontColor) {
            var colorInHex = color.toString(16);
            var numZeros = 6 - colorInHex.length;
            for (var i = 0; i < numZeros; ++i) {
                colorInHex = "0" + colorInHex;
            }
            var result = /([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(colorInHex);
            var r = (parseInt(result ? result[1] : "ff", 16)) / 255;
            var g = (parseInt(result ? result[2] : "ff", 16)) / 255;
            var b = (parseInt(result ? result[3] : "ff", 16)) / 255;
            if ((0.2126 * Math.pow(r, 2.2) + 0.7152 * Math.pow(g, 2.2) + 0.0722 * Math.pow(b, 2.2)) <= Math.pow(0.5, 2.2)) {
                fontColor = "white";
            }
            else {
                fontColor = "black";
            }
            this.fontColorMap.set(color, fontColor);
        }
        var fontName;
        if (size) {
            var MIN_FONT_SIZE = 6;
            size = Math.max(size, MIN_FONT_SIZE);
            if (!this.fontNameMap.has(size)) {
                this.updateFontNameMap(size);
            }
            var size2FontMap = this.fontNameMap.get(size);
            fontName = size2FontMap ? size2FontMap.get(fontColor) : undefined;
        }
        return fontName ? fontName : "";
    };
    FontController.prototype.getCharacterSet = function () {
        var letters = [];
        letters.push(PIXI.BitmapFont.ASCII[0]);
        letters.push(['★', '★']);
        letters.push(['…', '…']);
        return letters;
    };
    return FontController;
}());
exports.FontController = FontController;
//# sourceMappingURL=time-graph-font-controller.js.map