"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TraceExplorerPlaceholderWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceExplorerPlaceholderWidget = void 0;
const inversify_1 = require("inversify");
const browser_1 = require("@theia/core/lib/browser");
const React = __importStar(require("react"));
const core_1 = require("@theia/core");
const trace_viewer_commands_1 = require("../../trace-viewer/trace-viewer-commands");
let TraceExplorerPlaceholderWidget = TraceExplorerPlaceholderWidget_1 = class TraceExplorerPlaceholderWidget extends browser_1.ReactWidget {
    constructor() {
        super();
        this.state = {
            loading: false
        };
        this.handleOpenTrace = async () => this.doHandleOpenTrace();
    }
    init() {
        this.id = TraceExplorerPlaceholderWidget_1.ID;
        this.title.label = TraceExplorerPlaceholderWidget_1.LABEL;
        this.update();
    }
    render() {
        const { loading } = this.state;
        return React.createElement("div", { className: 'theia-navigator-container', tabIndex: 0 },
            React.createElement("div", { className: 'center' }, 'You have not yet opened a trace.'),
            React.createElement("div", { className: 'open-workspace-button-container' },
                React.createElement("button", { className: 'theia-button open-workspace-button', title: 'Select a trace to open', onClick: this.handleOpenTrace, disabled: loading },
                    loading && (React.createElement("i", { className: 'fa fa-refresh fa-spin', style: { marginRight: '5px' } })),
                    loading && React.createElement("span", null, "Connecting to trace server"),
                    !loading && React.createElement("span", null, "Open Trace"))));
    }
    async doHandleOpenTrace() {
        this.state.loading = true;
        this.update();
        await this.commandService.executeCommand(trace_viewer_commands_1.OpenTraceCommand.id);
        this.state.loading = false;
        this.update();
    }
};
TraceExplorerPlaceholderWidget.ID = 'trace-explorer-placeholder-widget';
TraceExplorerPlaceholderWidget.LABEL = 'Trace Explorer Placeholder Widget';
__decorate([
    (0, inversify_1.inject)(core_1.CommandService),
    __metadata("design:type", Object)
], TraceExplorerPlaceholderWidget.prototype, "commandService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TraceExplorerPlaceholderWidget.prototype, "init", null);
TraceExplorerPlaceholderWidget = TraceExplorerPlaceholderWidget_1 = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [])
], TraceExplorerPlaceholderWidget);
exports.TraceExplorerPlaceholderWidget = TraceExplorerPlaceholderWidget;
//# sourceMappingURL=trace-explorer-placeholder-widget.js.map