"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseResolvedKeybinding = void 0;
const errors_1 = require("../../../base/common/errors");
const keybindingLabels_1 = require("../../../base/common/keybindingLabels");
const keybindings_1 = require("../../../base/common/keybindings");
class BaseResolvedKeybinding extends keybindings_1.ResolvedKeybinding {
    constructor(os, parts) {
        super();
        if (parts.length === 0) {
            throw (0, errors_1.illegalArgument)(`parts`);
        }
        this._os = os;
        this._parts = parts;
    }
    getLabel() {
        return keybindingLabels_1.UILabelProvider.toLabel(this._os, this._parts, (keybinding) => this._getLabel(keybinding));
    }
    getAriaLabel() {
        return keybindingLabels_1.AriaLabelProvider.toLabel(this._os, this._parts, (keybinding) => this._getAriaLabel(keybinding));
    }
    getElectronAccelerator() {
        if (this._parts.length > 1) {
            // [Electron Accelerators] Electron cannot handle chords
            return null;
        }
        if (this._parts[0].isDuplicateModifierCase()) {
            // [Electron Accelerators] Electron cannot handle modifier only keybindings
            // e.g. "shift shift"
            return null;
        }
        return keybindingLabels_1.ElectronAcceleratorLabelProvider.toLabel(this._os, this._parts, (keybinding) => this._getElectronAccelerator(keybinding));
    }
    getUserSettingsLabel() {
        return keybindingLabels_1.UserSettingsLabelProvider.toLabel(this._os, this._parts, (keybinding) => this._getUserSettingsLabel(keybinding));
    }
    isWYSIWYG() {
        return this._parts.every((keybinding) => this._isWYSIWYG(keybinding));
    }
    isChord() {
        return (this._parts.length > 1);
    }
    getParts() {
        return this._parts.map((keybinding) => this._getPart(keybinding));
    }
    _getPart(keybinding) {
        return new keybindings_1.ResolvedKeybindingPart(keybinding.ctrlKey, keybinding.shiftKey, keybinding.altKey, keybinding.metaKey, this._getLabel(keybinding), this._getAriaLabel(keybinding));
    }
    getDispatchParts() {
        return this._parts.map((keybinding) => this._getDispatchPart(keybinding));
    }
    getSingleModifierDispatchParts() {
        return this._parts.map((keybinding) => this._getSingleModifierDispatchPart(keybinding));
    }
}
exports.BaseResolvedKeybinding = BaseResolvedKeybinding;
//# sourceMappingURL=baseResolvedKeybinding.js.map