"use strict";
// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.unreachable = exports.nullToUndefined = exports.isStringArray = exports.isArray = exports.isUndefined = exports.isObject = exports.isFunction = exports.isErrorLike = exports.isError = exports.isNumber = exports.isString = exports.isBoolean = exports.Prioritizeable = exports.ArrayUtils = void 0;
var array_utils_1 = require("./array-utils");
Object.defineProperty(exports, "ArrayUtils", { enumerable: true, get: function () { return array_utils_1.ArrayUtils; } });
var prioritizeable_1 = require("./prioritizeable");
Object.defineProperty(exports, "Prioritizeable", { enumerable: true, get: function () { return prioritizeable_1.Prioritizeable; } });
function isBoolean(value) {
    return value === true || value === false;
}
exports.isBoolean = isBoolean;
function isString(value) {
    return typeof value === 'string' || value instanceof String;
}
exports.isString = isString;
function isNumber(value) {
    return typeof value === 'number' || value instanceof Number;
}
exports.isNumber = isNumber;
function isError(value) {
    return value instanceof Error;
}
exports.isError = isError;
function isErrorLike(value) {
    return isObject(value) && isString(value.name) && isString(value.message) && (isUndefined(value.stack) || isString(value.stack));
}
exports.isErrorLike = isErrorLike;
// eslint-disable-next-line space-before-function-paren
function isFunction(value) {
    return typeof value === 'function';
}
exports.isFunction = isFunction;
function isObject(value) {
    // eslint-disable-next-line no-null/no-null
    return typeof value === 'object' && value !== null;
}
exports.isObject = isObject;
function isUndefined(value) {
    return typeof value === 'undefined';
}
exports.isUndefined = isUndefined;
/**
 * @param value value to check.
 * @param every optional predicate ran on every element of the array.
 * @param thisArg value to substitute `this` with when invoking in the predicate.
 * @returns whether or not `value` is an array.
 */
function isArray(value, every, thisArg) {
    return Array.isArray(value) && (!isFunction(every) || value.every(every, thisArg));
}
exports.isArray = isArray;
function isStringArray(value) {
    return isArray(value, isString);
}
exports.isStringArray = isStringArray;
/**
 * Creates a shallow copy with all ownkeys of the original object that are `null` made `undefined`
 */
function nullToUndefined(nullable) {
    const undefinable = Object.assign({}, nullable);
    for (const key in nullable) {
        // eslint-disable-next-line no-null/no-null
        if (nullable[key] === null && Object.prototype.hasOwnProperty.call(nullable, key)) {
            undefinable[key] = undefined;
        }
    }
    return undefinable;
}
exports.nullToUndefined = nullToUndefined;
/**
 * Throws when called and statically makes sure that all variants of a type were consumed.
 */
function unreachable(_never, message = 'unhandled case') {
    throw new Error(message);
}
exports.unreachable = unreachable;
//# sourceMappingURL=types.js.map