import { Disposable, CancellationToken, ProviderResult, Diagnostic as VDiagnostic, Uri } from 'vscode';
import { Proposed, ClientCapabilities, ServerCapabilities, DocumentSelector } from 'vscode-languageserver-protocol';
import { TextDocumentFeature, BaseLanguageClient } from './client';
interface DiagnosticProvider {
    provideDiagnostics(resource: Uri, token: CancellationToken): ProviderResult<VDiagnostic[]>;
}
export interface ProvideDiagnosticsSignature {
    (this: void, resource: Uri, token: CancellationToken): ProviderResult<VDiagnostic[]>;
}
export declare class DiagnosticFeature extends TextDocumentFeature<boolean | Proposed.DiagnosticOptions, Proposed.DiagnosticRegistrationOptions, DiagnosticProvider> {
    constructor(client: BaseLanguageClient);
    fillClientCapabilities(capabilities: ClientCapabilities & Proposed.$DiagnosticClientCapabilities): void;
    initialize(capabilities: ServerCapabilities & Proposed.$DiagnosticServerCapabilities, documentSelector: DocumentSelector): void;
    protected registerLanguageProvider(options: Proposed.DiagnosticRegistrationOptions): [Disposable, DiagnosticProvider];
}
export {};
