"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.XYOutputComponent = void 0;
const React = __importStar(require("react"));
const responses_1 = require("tsp-typescript-client/lib/models/response/responses");
const bigint_utils_1 = require("timeline-chart/lib/bigint-utils");
const d3_scale_1 = require("d3-scale");
const abstract_xy_output_component_1 = require("./abstract-xy-output-component");
const utils_1 = require("./utils/filter-tree/utils");
class XYOutputComponent extends abstract_xy_output_component_1.AbstractXYOutputComponent {
    constructor(props) {
        var _a, _b;
        super(props);
        this.mousePanningStart = BigInt(0);
        this.resolution = 0;
        this.state = {
            outputStatus: responses_1.ResponseStatus.RUNNING,
            selectedSeriesId: [],
            xyTree: [],
            checkedSeries: (0, utils_1.validateNumArray)((_a = this.props.persistChartState) === null || _a === void 0 ? void 0 : _a.checkedSeries) ? this.props.persistChartState.checkedSeries : [],
            collapsedNodes: (0, utils_1.validateNumArray)((_b = this.props.persistChartState) === null || _b === void 0 ? void 0 : _b.collapsedNodes) ? this.props.persistChartState.collapsedNodes : [],
            orderedNodes: [],
            xyData: {},
            columns: [{ title: 'Name', sortable: true }],
            allMax: 0,
            allMin: 0,
            cursor: 'default',
            optionsDropdownOpen: false
        };
    }
    renderChart() {
        var _a, _b;
        if (this.state.outputStatus === responses_1.ResponseStatus.COMPLETED && ((_b = (_a = this.state.xyData) === null || _a === void 0 ? void 0 : _a.datasets) === null || _b === void 0 ? void 0 : _b.length) === 0) {
            return React.createElement(React.Fragment, null,
                React.createElement("div", { className: 'chart-message' }, "Select a checkbox to see analysis results"));
        }
        return React.createElement(React.Fragment, null, this.state.outputStatus === responses_1.ResponseStatus.COMPLETED ?
            React.createElement("div", { id: this.props.traceId + this.props.outputDescriptor.id + 'focusContainer', className: 'xy-main', tabIndex: 0, onKeyDown: event => this.onKeyDown(event), onKeyUp: event => this.onKeyUp(event), onWheel: event => this.onWheel(event), onMouseMove: event => this.onMouseMove(event), onContextMenu: event => event.preventDefault(), onMouseLeave: event => this.onMouseLeave(event), onMouseDown: event => this.onMouseDown(event), style: { height: this.props.style.height, position: 'relative', cursor: this.state.cursor }, ref: this.divRef }, this.isBarPlot ? this.drawD3Chart() : this.chooseChart()) :
            React.createElement("div", { id: this.props.traceId + this.props.outputDescriptor.id + 'focusContainer', className: 'analysis-running' },
                React.createElement("i", { className: 'fa fa-refresh fa-spin', style: { marginRight: '5px' } }),
                React.createElement("span", null, "Analysis running")));
    }
    drawD3Chart() {
        var _a, _b, _c;
        const chartHeight = parseInt(this.props.style.height.toString());
        const chartWidth = this.getChartWidth();
        if (((_a = this.state.xyData.labels) === null || _a === void 0 ? void 0 : _a.length) > 0) {
            const data = [];
            (_c = (_b = this.state.xyData) === null || _b === void 0 ? void 0 : _b.datasets) === null || _c === void 0 ? void 0 : _c.forEach((dSet) => {
                const row = [];
                if (this.isScatterPlot) {
                    dSet.data.forEach((tupple) => {
                        row.push({ xValue: tupple.x, yValue: tupple.y });
                    });
                }
                else {
                    dSet.data.forEach((y, j) => {
                        row.push({ xValue: this.state.xyData.labels[j], yValue: y });
                    });
                }
                data.push(row);
            });
            const yScale = (0, d3_scale_1.scaleLinear)()
                .domain([this.state.allMin, Math.max(this.state.allMax, 1)])
                .range([chartHeight - this.margin.bottom, this.margin.top]);
            const xDomain = this.state.xyData.labels.length - 1;
            const start = this.getXForTime(this.state.xyData.labels[0]);
            const end = this.getXForTime(this.state.xyData.labels[xDomain]);
            const xScale = (0, d3_scale_1.scaleLinear)()
                .domain([start, end].map(Number))
                .range([0, chartWidth]);
            if (this.chartRef.current) {
                const ctx = this.chartRef.current.getContext('2d');
                // Fix blurred lines in retina displays
                const dpr = window.devicePixelRatio;
                this.chartRef.current.width = dpr * chartWidth;
                this.chartRef.current.height = dpr * chartHeight;
                this.chartRef.current.style.width = chartWidth + 'px';
                this.chartRef.current.style.height = chartHeight + 'px';
                ctx.scale(dpr, dpr);
                // Bar chart
                if (ctx) {
                    ctx.clearRect(0, 0, chartWidth, chartHeight);
                    ctx.save();
                    data.forEach((row, i) => {
                        ctx.fillStyle = this.state.xyData.datasets[i].borderColor;
                        row.forEach((tupple) => {
                            ctx.beginPath();
                            const xPos = this.getXForTime(tupple.xValue);
                            ctx.fillRect(xScale(xPos), chartHeight, 2, -chartHeight + yScale(+tupple.yValue));
                            ctx.closePath();
                        });
                    });
                    ctx.restore();
                    this.afterChartDraw(this.chartRef.current.getContext('2d'));
                }
            }
        }
        return (React.createElement("canvas", { ref: this.chartRef, height: chartHeight, width: chartWidth }));
    }
    afterChartDraw(ctx, chartArea) {
        var _a;
        if (ctx) {
            if (this.props.selectionRange) {
                const startPixel = this.getXForTime(this.props.selectionRange.getStart());
                const endPixel = this.getXForTime(this.props.selectionRange.getEnd());
                ctx.strokeStyle = '#259fd8';
                ctx.fillStyle = '#259fd8';
                this.drawSelection(ctx, chartArea, startPixel, endPixel);
            }
            if (this.clickedMouseButton === abstract_xy_output_component_1.MouseButton.RIGHT) {
                const offset = (_a = this.props.viewRange.getOffset()) !== null && _a !== void 0 ? _a : BigInt(0);
                const startPixel = this.getXForTime(this.startPositionMouseRightClick + offset);
                const endPixel = this.positionXMove;
                ctx.strokeStyle = '#9f9f9f';
                ctx.fillStyle = '#9f9f9f';
                this.drawSelection(ctx, chartArea, startPixel, endPixel);
            }
        }
    }
    drawSelection(ctx, chartArea, startPixel, endPixel) {
        var _a, _b;
        const minPixel = Math.min(startPixel, endPixel);
        const maxPixel = Math.max(startPixel, endPixel);
        const initialPoint = this.isBarPlot ? 0 : (_a = chartArea === null || chartArea === void 0 ? void 0 : chartArea.left) !== null && _a !== void 0 ? _a : 0;
        const chartHeight = parseInt(this.props.style.height.toString());
        const finalPoint = this.isBarPlot ? chartHeight : (_b = chartArea === null || chartArea === void 0 ? void 0 : chartArea.bottom) !== null && _b !== void 0 ? _b : 0;
        if (ctx) {
            ctx.save();
            ctx.lineWidth = 1;
            // Selection borders
            if (startPixel > initialPoint) {
                ctx.beginPath();
                ctx.moveTo(minPixel, 0);
                ctx.lineTo(minPixel, finalPoint);
                ctx.stroke();
            }
            if (endPixel < this.props.viewRange.getEnd()) {
                ctx.beginPath();
                ctx.moveTo(maxPixel, 0);
                ctx.lineTo(maxPixel, finalPoint);
                ctx.stroke();
            }
            // Selection fill
            ctx.globalAlpha = 0.2;
            ctx.fillRect(minPixel, 0, maxPixel - minPixel, finalPoint);
            ctx.restore();
        }
    }
    onMouseDown(event) {
        this.isMouseLeave = false;
        this.mouseIsDown = true;
        this.posPixelSelect = event.nativeEvent.screenX;
        const startTime = this.getTimeForX(event.nativeEvent.offsetX);
        this.clickedMouseButton = event.button;
        if (this.clickedMouseButton === abstract_xy_output_component_1.MouseButton.RIGHT) {
            this.isSelecting = false;
            this.setState({ cursor: 'col-resize' });
            this.startPositionMouseRightClick = startTime;
        }
        else {
            if (event.shiftKey && !event.ctrlKey && this.props.unitController.selectionRange) {
                this.isSelecting = true;
                this.setState({ cursor: 'crosshair' });
                this.props.unitController.selectionRange = {
                    start: this.props.unitController.selectionRange.start,
                    end: startTime
                };
            }
            else if ((event.ctrlKey && !event.shiftKey) || (!(event.shiftKey && event.ctrlKey) && this.clickedMouseButton === abstract_xy_output_component_1.MouseButton.MID)) {
                this.resolution = this.getChartWidth() / Number(this.props.unitController.viewRangeLength);
                this.mousePanningStart = this.props.unitController.viewRange.start + bigint_utils_1.BIMath.round(event.nativeEvent.x / this.resolution);
                this.isPanning = true;
                this.setState({ cursor: 'grabbing' });
            }
            else if (!(event.shiftKey && event.ctrlKey)) {
                this.isSelecting = true;
                this.setState({ cursor: 'crosshair' });
                this.props.unitController.selectionRange = {
                    start: startTime,
                    end: startTime
                };
            }
            this.onMouseMove(event);
        }
        document.addEventListener('mouseup', this.endSelection);
    }
    panHorizontally(event) {
        const delta = event.nativeEvent.x;
        const change = Number(this.mousePanningStart) - (delta / this.resolution);
        const min = BigInt(0);
        const max = this.props.unitController.absoluteRange - this.props.unitController.viewRangeLength;
        const start = bigint_utils_1.BIMath.clamp(change, min, max);
        const end = start + this.props.unitController.viewRangeLength;
        this.props.unitController.viewRange = {
            start,
            end
        };
    }
    onWheel(wheel) {
        this.isMouseLeave = false;
        if (wheel.shiftKey) {
            if (wheel.deltaY < 0) {
                this.pan(abstract_xy_output_component_1.FLAG_PAN_LEFT);
            }
            else if (wheel.deltaY > 0) {
                this.pan(abstract_xy_output_component_1.FLAG_PAN_RIGHT);
            }
        }
        else if (wheel.ctrlKey) {
            if (wheel.deltaY < 0) {
                this.zoom(abstract_xy_output_component_1.FLAG_ZOOM_IN);
            }
            else if (wheel.deltaY > 0) {
                this.zoom(abstract_xy_output_component_1.FLAG_ZOOM_OUT);
            }
        }
    }
    onMouseMove(event) {
        this.positionXMove = event.nativeEvent.offsetX;
        this.positionYMove = event.nativeEvent.offsetY;
        this.isMouseLeave = false;
        if (this.mouseIsDown) {
            if (this.isPanning) {
                this.panHorizontally(event);
            }
            else if (this.isSelecting) {
                this.updateSelection();
            }
            else {
                this.forceUpdate();
            }
        }
        if (this.state.xyData.datasets.length > 0) {
            this.tooltip(event.nativeEvent.x, event.nativeEvent.y);
        }
    }
    onMouseLeave(event) {
        this.isMouseLeave = true;
        const width = this.isBarPlot ? this.getChartWidth() : this.chartRef.current.chartInstance.width;
        this.positionXMove = Math.max(0, Math.min(event.nativeEvent.offsetX, width));
        this.forceUpdate();
        if (this.mouseIsDown && !(this.clickedMouseButton === abstract_xy_output_component_1.MouseButton.RIGHT)) {
            this.updateSelection();
        }
        this.hideTooltip();
    }
    onKeyDown(key) {
        this.hideTooltip();
        if (!this.isMouseLeave) {
            switch (key.key) {
                case 'W':
                case 'w':
                case 'i':
                case 'I': {
                    this.zoom(abstract_xy_output_component_1.FLAG_ZOOM_IN);
                    break;
                }
                case 'S':
                case 's':
                case 'K':
                case 'k': {
                    this.zoom(abstract_xy_output_component_1.FLAG_ZOOM_OUT);
                    break;
                }
                case 'A':
                case 'a':
                case 'J':
                case 'j':
                case 'ArrowLeft': {
                    this.pan(abstract_xy_output_component_1.FLAG_PAN_LEFT);
                    break;
                }
                case 'D':
                case 'd':
                case 'L':
                case 'l':
                case 'ArrowRight': {
                    this.pan(abstract_xy_output_component_1.FLAG_PAN_RIGHT);
                    break;
                }
                case 'Shift': {
                    if (!this.isPanning && !(this.clickedMouseButton === abstract_xy_output_component_1.MouseButton.RIGHT) && !this.isSelecting) {
                        if (key.ctrlKey) {
                            this.setState({ cursor: 'default' });
                        }
                        else {
                            this.setState({ cursor: 'crosshair' });
                        }
                    }
                    break;
                }
                case 'Control': {
                    if (!this.isSelecting && !this.isPanning) {
                        if (key.shiftKey) {
                            this.setState({ cursor: 'default' });
                        }
                        else {
                            this.setState({ cursor: 'grabbing' });
                        }
                    }
                    break;
                }
            }
        }
    }
    onKeyUp(key) {
        var _a;
        if (!this.isSelecting && !this.isPanning) {
            let keyCursor = (_a = this.state.cursor) !== null && _a !== void 0 ? _a : 'default';
            if (key.key === 'Shift') {
                if (key.ctrlKey) {
                    keyCursor = 'grabbing';
                }
                else if (!this.mouseIsDown) {
                    keyCursor = 'default';
                }
            }
            else if (key.key === 'Control') {
                if (key.shiftKey) {
                    keyCursor = 'crosshair';
                }
                else if (!this.mouseIsDown) {
                    this.isPanning = false;
                    keyCursor = 'default';
                }
            }
            this.setState({ cursor: keyCursor });
        }
    }
    getDisplayedRange() {
        return this.props.viewRange;
    }
    getZoomTime() {
        return this.getTimeForX(this.positionXMove);
    }
    showOptions() {
        return React.createElement(React.Fragment, null,
            React.createElement("ul", null,
                this.props.pinned === undefined &&
                    React.createElement("li", { className: 'drop-down-list-item', onClick: () => this.pinView({ checkedSeries: this.state.checkedSeries,
                            collapsedNodes: this.state.collapsedNodes }) },
                        React.createElement("div", { className: 'drop-down-list-item-text' }, "Pin View")),
                this.props.pinned === true &&
                    React.createElement("li", { className: 'drop-down-list-item', onClick: () => this.unPinView({ checkedSeries: this.state.checkedSeries,
                            collapsedNodes: this.state.collapsedNodes }) },
                        React.createElement("div", { className: 'drop-down-list-item-text' }, "Unpin View"))),
            this.state.additionalOptions && this.showAdditionalOptions());
    }
}
exports.XYOutputComponent = XYOutputComponent;
//# sourceMappingURL=xy-output-component.js.map