"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphVerticalScrollbarBackground = exports.TimeGraphVerticalScrollbarHandle = exports.TimeGraphVerticalScrollbar = void 0;
var time_graph_component_1 = require("../components/time-graph-component");
var time_graph_chart_layer_1 = require("./time-graph-chart-layer");
var TimeGraphVerticalScrollbar = /** @class */ (function (_super) {
    __extends(TimeGraphVerticalScrollbar, _super);
    function TimeGraphVerticalScrollbar(id, rowController) {
        var _this = _super.call(this, id, rowController) || this;
        _this.rowController = rowController;
        return _this;
    }
    TimeGraphVerticalScrollbar.prototype.afterAddToContainer = function () {
        var _this = this;
        this.updateFactor();
        this.navigatorHandle = new TimeGraphVerticalScrollbarHandle(this.rowController, this.stateController, this.factor);
        this.navigatorBackground = new TimeGraphVerticalScrollbarBackground(this.rowController, this.stateController, this.factor);
        this.addChild(this.navigatorBackground);
        this.addChild(this.navigatorHandle);
        this._contextMenuHandler = function (e) {
            e.preventDefault();
        };
        this.onCanvasEvent('contextmenu', this._contextMenuHandler);
        this._verticalOffsetChangedHandler = function () {
            _this.update();
        };
        this._totalHeightChangedHandler = function () {
            _this.updateFactor();
            _this.navigatorHandle.updateFactor(_this.factor);
            _this.navigatorBackground.updateFactor(_this.factor);
            _this.update();
        };
        this.rowController.onVerticalOffsetChangedHandler(this._verticalOffsetChangedHandler);
        this.rowController.onTotalHeightChangedHandler(this._totalHeightChangedHandler);
    };
    TimeGraphVerticalScrollbar.prototype.updateFactor = function () {
        if (this.rowController.totalHeight) {
            this.factor = this.stateController.canvasDisplayHeight / this.rowController.totalHeight;
        }
        else {
            this.factor = 0;
        }
    };
    TimeGraphVerticalScrollbar.prototype.update = function () {
        this.navigatorHandle.clear();
        this.navigatorHandle.render();
        this.navigatorBackground.clear();
        this.navigatorBackground.render();
    };
    TimeGraphVerticalScrollbar.prototype.destroy = function () {
        if (this.rowController) {
            this.rowController.removeTotalHeightChangedHandler(this._totalHeightChangedHandler);
            this.rowController.removeVerticalOffsetChangedHandler(this._verticalOffsetChangedHandler);
        }
        if (this._contextMenuHandler) {
            this.removeOnCanvasEvent('contextmenu', this._contextMenuHandler);
        }
        ;
        _super.prototype.destroy.call(this);
    };
    return TimeGraphVerticalScrollbar;
}(time_graph_chart_layer_1.TimeGraphChartLayer));
exports.TimeGraphVerticalScrollbar = TimeGraphVerticalScrollbar;
var TimeGraphVerticalScrollbarHandle = /** @class */ (function (_super) {
    __extends(TimeGraphVerticalScrollbarHandle, _super);
    function TimeGraphVerticalScrollbarHandle(rowController, stateController, factor) {
        var _this = _super.call(this, 'vscroll_handle') || this;
        _this.rowController = rowController;
        _this.stateController = stateController;
        _this.factor = factor;
        var moveStart = function (event) {
            _this.mouseStartY = event.data.global.y;
            _this.oldVerticalOffset = _this.rowController.verticalOffset;
            _this.mouseIsDown = true;
            _this.stateController.snapped = false;
            document.addEventListener('snap-y-end', _this._moveEndHandler);
        };
        _this._moveEndHandler = function () {
            _this.mouseIsDown = false;
            document.removeEventListener('snap-y-end', _this._moveEndHandler);
        };
        _this.addEvent('mouseover', function (event) {
            if (_this.stateController.snapped) {
                moveStart(event);
            }
        }, _this._displayObject);
        _this.addEvent('mousedown', moveStart, _this._displayObject);
        _this.addEvent('mousemove', function (event) {
            if (_this.mouseIsDown) {
                var delta = (event.data.global.y - _this.mouseStartY) / _this.factor;
                var verticalOffset = _this.oldVerticalOffset + delta;
                _this.rowController.verticalOffset = Math.max(0, Math.min(_this.rowController.totalHeight - _this.stateController.canvasDisplayHeight, verticalOffset));
            }
        }, _this._displayObject);
        _this.addEvent('mouseup', _this._moveEndHandler, _this._displayObject);
        _this.addEvent('mouseupoutside', _this._moveEndHandler, _this._displayObject);
        return _this;
    }
    TimeGraphVerticalScrollbarHandle.prototype.updateFactor = function (factor) {
        this.factor = factor;
    };
    TimeGraphVerticalScrollbarHandle.prototype.render = function () {
        this.position = { x: 0, y: this.rowController.verticalOffset * this.factor };
        this.height = this.stateController.canvasDisplayHeight * this.factor;
        this.rect({
            height: this.height,
            position: this.position,
            width: 10,
            color: 0x777769
        });
    };
    return TimeGraphVerticalScrollbarHandle;
}(time_graph_component_1.TimeGraphComponent));
exports.TimeGraphVerticalScrollbarHandle = TimeGraphVerticalScrollbarHandle;
var TimeGraphVerticalScrollbarBackground = /** @class */ (function (_super) {
    __extends(TimeGraphVerticalScrollbarBackground, _super);
    function TimeGraphVerticalScrollbarBackground(rowController, stateController, factor) {
        var _this = _super.call(this, "vscroll_background") || this;
        _this.rowController = rowController;
        _this.stateController = stateController;
        _this.factor = factor;
        _this.toggleSnappedState = function (bool) {
            _this.stateController.snapped = bool;
        };
        _this.addEvent("mousedown", function (event) {
            // Get y position of click (in pixels).
            var y = event.data.getLocalPosition(_this._displayObject).y;
            // Convert to units used by rowController.
            var center = (y / _this.stateController.canvasDisplayHeight) * _this.rowController.totalHeight;
            // We have the center of the new scrollbar position, but need the starting pixel.
            // start = middle - (scrollbarHeight / 2)
            var scrollBarHeight = (_this.rowController.totalHeight * _this.factor);
            var newOffset = center - (scrollBarHeight / 2);
            // Clamp our new verticalOffset value
            var vOffsetMin = 0;
            var vOffsetMax = _this.rowController.totalHeight - _this.stateController.canvasDisplayHeight;
            newOffset = Math.max(vOffsetMin, Math.min(vOffsetMax, newOffset));
            _this.rowController.verticalOffset = newOffset;
            // Set snapped state
            _this.toggleSnappedState(true);
        }, _this._displayObject);
        // Emit custom event to let vertical handler know when 'mousedown' is released.
        _this.snapEvent = new CustomEvent(_this.snapEventString = 'snap-y-end');
        var endSnap = function () {
            _this.toggleSnappedState(false);
            document.dispatchEvent(_this.snapEvent);
        };
        _this.addEvent('mouseup', endSnap, _this._displayObject);
        _this.addEvent('mouseupoutside', endSnap, _this._displayObject);
        _this.addEvent('rightdown', function (event) {
            // Get y position of click (in raw pixels).
            var y = event.data.getLocalPosition(_this._displayObject).y;
            // Convert y to correct units used by rowController.
            var clickPoint = (y / _this.stateController.canvasDisplayHeight) * _this.rowController.totalHeight;
            // Are we clicking above or below the current scrollbar position?
            var _a = _this.rowController, verticalOffset = _a.verticalOffset, totalHeight = _a.totalHeight;
            var scrollBarHeight = totalHeight * _this.factor;
            var newOffset = verticalOffset;
            var start = verticalOffset;
            var end = verticalOffset + scrollBarHeight;
            if (clickPoint < start) {
                // If above, move up one page.
                newOffset = newOffset - scrollBarHeight;
            }
            else if (clickPoint > end) {
                // If below, move down one page.
                newOffset = newOffset + scrollBarHeight;
            }
            // Clamp our new values
            var vOffsetMin = 0;
            var vOffsetMax = totalHeight - scrollBarHeight;
            newOffset = Math.max(vOffsetMin, Math.min(vOffsetMax, newOffset));
            //  Assign new value
            _this.rowController.verticalOffset = newOffset;
        }, _this._displayObject);
        return _this;
    }
    TimeGraphVerticalScrollbarBackground.prototype.updateFactor = function (factor) {
        this.factor = factor;
    };
    TimeGraphVerticalScrollbarBackground.prototype.render = function () {
        this.rect({
            height: this.stateController.canvasDisplayHeight,
            position: { x: 0, y: 0 },
            width: 10,
            opacity: 0
        });
    };
    return TimeGraphVerticalScrollbarBackground;
}(time_graph_component_1.TimeGraphComponent));
exports.TimeGraphVerticalScrollbarBackground = TimeGraphVerticalScrollbarBackground;
//# sourceMappingURL=time-graph-vertical-scrollbar.js.map