"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphStateComponent = void 0;
var time_graph_component_1 = require("./time-graph-component");
var time_graph_font_controller_1 = require("../time-graph-font-controller");
var PIXI = require("pixi.js-legacy");
var TimeGraphStateComponent = /** @class */ (function (_super) {
    __extends(TimeGraphStateComponent, _super);
    function TimeGraphStateComponent(id, model, xStart, xEnd, _row, _style, displayWidth, displayObject) {
        if (_style === void 0) { _style = { color: 0xfffa66, height: 14 }; }
        var _this = _super.call(this, id, displayObject, model) || this;
        _this._row = _row;
        _this._style = _style;
        _this.displayWidth = displayWidth;
        var height = _row.height === 0 ? 0 : Math.min(_style.height || 14, _row.height - 1);
        var position = {
            x: xStart,
            y: _this._row.position.y + ((_this.row.height - height) / 2)
        };
        // min width of a state should never be less than 1 (for visibility)
        var width = Math.max(1, xEnd - xStart);
        _this._options = {
            color: _style.color,
            opacity: _style.opacity,
            height: height,
            position: position,
            width: width,
            displayWidth: displayWidth,
            borderRadius: 2,
            borderWidth: _style.borderWidth || 0,
            borderColor: _style.borderColor || 0x000000
        };
        return _this;
    }
    TimeGraphStateComponent.prototype.renderLabel = function () {
        if (!this.model.label) {
            return;
        }
        var fontName = TimeGraphStateComponent.fontController.getFontName(this._options.color ? this._options.color : 0, this._options.height - 2) ||
            TimeGraphStateComponent.fontController.getDefaultFontName();
        var position = {
            x: this._options.position.x + this._options.width < 0 ? this._options.position.x : Math.max(0, this._options.position.x),
            y: this._options.position.y
        };
        var displayWidth = this._options.displayWidth ? this._options.displayWidth : 0;
        var labelText = this.model.label;
        var textPadding = 0.5;
        if (displayWidth < 3) {
            this.clearLabel();
            return;
        }
        var textObj = new PIXI.BitmapText(this.model.label, { fontName: fontName });
        var textWidth = textObj.getLocalBounds().width;
        var textObjX = position.x + textPadding;
        var textObjY = position.y + textPadding;
        var displayLabel = "";
        if (displayWidth > textWidth) {
            textObjX = position.x + (displayWidth - textWidth) / 2;
            displayLabel = labelText;
        }
        else {
            var textScaler = displayWidth / textWidth;
            var index = Math.min(Math.floor(textScaler * labelText.length), labelText.length - 1);
            var partialLabel = labelText.substr(0, Math.max(index - 3, 0));
            if (partialLabel.length > 0) {
                displayLabel = partialLabel.concat("...");
            }
        }
        if (displayLabel === "") {
            this.clearLabel();
            return;
        }
        if (displayLabel === this.model.label) {
            textObj.x = textObjX;
            textObj.y = textObjY;
            this.displayObject.addChild(textObj);
        }
        else {
            var newTextObj = new PIXI.BitmapText(displayLabel, { fontName: fontName });
            newTextObj.x = textObjX;
            newTextObj.y = textObjY;
            this.displayObject.addChild(newTextObj);
        }
    };
    TimeGraphStateComponent.prototype.clearLabel = function () {
        this.displayObject.children.forEach(function (element) { return element.destroy(); });
        this.displayObject.removeChildren();
    };
    Object.defineProperty(TimeGraphStateComponent.prototype, "height", {
        get: function () {
            return this._options.height;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphStateComponent.prototype, "width", {
        get: function () {
            return this._options.width;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphStateComponent.prototype, "position", {
        get: function () {
            return this._options.position;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphStateComponent.prototype, "row", {
        get: function () {
            return this._row;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphStateComponent.prototype, "style", {
        get: function () {
            return this._style;
        },
        set: function (style) {
            if (style.color !== undefined) {
                this._options.color = style.color;
            }
            if (style.opacity !== undefined) {
                this._options.opacity = style.opacity;
            }
            if (style.height !== undefined) {
                this._options.height = style.height;
            }
            if (style.borderColor !== undefined) {
                this._options.borderColor = style.borderColor;
            }
            if (style.borderWidth !== undefined) {
                this._options.borderWidth = style.borderWidth;
            }
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    TimeGraphStateComponent.prototype.update = function (opts) {
        if (opts) {
            this._options.position = opts.position;
            this._options.width = opts.width;
            this._options.displayWidth = opts.displayWidth;
        }
        _super.prototype.update.call(this);
    };
    TimeGraphStateComponent.prototype.render = function () {
        this.rect(this._options);
        this.renderLabel();
    };
    TimeGraphStateComponent.prototype.clear = function () {
        this.clearLabel();
        _super.prototype.clear.call(this);
    };
    TimeGraphStateComponent.fontController = new time_graph_font_controller_1.FontController();
    return TimeGraphStateComponent;
}(time_graph_component_1.TimeGraphComponent));
exports.TimeGraphStateComponent = TimeGraphStateComponent;
//# sourceMappingURL=time-graph-state.js.map