"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var temp = require("temp");
var fs = require("fs-extra");
var Path = require("path");
var chai_1 = require("chai");
var commit_1 = require("./commit");
var test_helper_1 = require("./test-helper");
var git_1 = require("../core/git");
var track = temp.track();
describe('commit', function () { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        after(function () { return __awaiter(void 0, void 0, void 0, function () {
            return __generator(this, function (_a) {
                track.cleanupSync();
                return [2 /*return*/];
            });
        }); });
        it('keeps the line breaks', function () { return __awaiter(void 0, void 0, void 0, function () {
            var path, expected, _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        path = track.mkdirSync('commit-line-breaks');
                        return [4 /*yield*/, (0, test_helper_1.initRepository)(path)];
                    case 1:
                        _c.sent();
                        fs.createFileSync(Path.join(path, 'some-file.txt'));
                        (0, chai_1.expect)(fs.existsSync(Path.join(path, 'some-file.txt'))).to.be.true;
                        expected = "aaaa\n\nbbbb\n\nSigned-off-by: Akos Kitta <kittaakos@gmail.com>\n";
                        _a = chai_1.expect;
                        return [4 /*yield*/, (0, git_1.git)(['add', '.'], path, 'add')];
                    case 2:
                        _a.apply(void 0, [(_c.sent()).exitCode]).to.be.equal(0);
                        return [4 /*yield*/, (0, commit_1.createCommit)(path, expected)];
                    case 3:
                        _c.sent();
                        _b = chai_1.expect;
                        return [4 /*yield*/, (0, git_1.git)(['log', '--format=%B'], path, 'log')];
                    case 4:
                        _b.apply(void 0, [(_c.sent()).stdout.trim()]).to.be.deep.equal(expected.trim());
                        return [2 /*return*/];
                }
            });
        }); });
        describe('sign-off', function () {
            it('disabled', function () { return __awaiter(void 0, void 0, void 0, function () {
                var path, userName, _a, _b;
                return __generator(this, function (_c) {
                    switch (_c.label) {
                        case 0:
                            path = track.mkdirSync('commit-sign-off-disabled');
                            return [4 /*yield*/, (0, test_helper_1.initRepository)(path)];
                        case 1:
                            _c.sent();
                            return [4 /*yield*/, (0, git_1.git)(['config', 'user.name'], path, 'getUserName')];
                        case 2:
                            userName = (_c.sent()).stdout.trim().split('"').join('');
                            (0, chai_1.expect)(userName).not.undefined;
                            (0, chai_1.expect)(userName).not.empty;
                            fs.createFileSync(Path.join(path, 'some-file.txt'));
                            (0, chai_1.expect)(fs.existsSync(Path.join(path, 'some-file.txt'))).to.be.true;
                            _a = chai_1.expect;
                            return [4 /*yield*/, (0, git_1.git)(['add', '.'], path, 'add')];
                        case 3:
                            _a.apply(void 0, [(_c.sent()).exitCode]).to.be.equal(0);
                            return [4 /*yield*/, (0, commit_1.createCommit)(path, 'some commit message')];
                        case 4:
                            _c.sent();
                            _b = chai_1.expect;
                            return [4 /*yield*/, (0, git_1.git)(['log', '--format=%B'], path, 'log')];
                        case 5:
                            _b.apply(void 0, [(_c.sent()).stdout.trim()]).to.not.contain(userName);
                            return [2 /*return*/];
                    }
                });
            }); });
            it('enabled', function () { return __awaiter(void 0, void 0, void 0, function () {
                var path, userName, _a, _b;
                return __generator(this, function (_c) {
                    switch (_c.label) {
                        case 0:
                            path = track.mkdirSync('commit-sign-off-enabled');
                            return [4 /*yield*/, (0, test_helper_1.initRepository)(path)];
                        case 1:
                            _c.sent();
                            return [4 /*yield*/, (0, git_1.git)(['config', 'user.name'], path, 'getUserName')];
                        case 2:
                            userName = (_c.sent()).stdout.trim().split('"').join('');
                            (0, chai_1.expect)(userName).not.undefined;
                            (0, chai_1.expect)(userName).not.empty;
                            fs.createFileSync(Path.join(path, 'some-file.txt'));
                            (0, chai_1.expect)(fs.existsSync(Path.join(path, 'some-file.txt'))).to.be.true;
                            _a = chai_1.expect;
                            return [4 /*yield*/, (0, git_1.git)(['add', '.'], path, 'add')];
                        case 3:
                            _a.apply(void 0, [(_c.sent()).exitCode]).to.be.equal(0);
                            return [4 /*yield*/, (0, commit_1.createCommit)(path, 'some commit message', true)];
                        case 4:
                            _c.sent();
                            _b = chai_1.expect;
                            return [4 /*yield*/, (0, git_1.git)(['log', '--format=%B'], path, 'log')];
                        case 5:
                            _b.apply(void 0, [(_c.sent()).stdout.trim()]).to.contain(userName);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('amend', function () {
            it('w/', function () { return __awaiter(void 0, void 0, void 0, function () {
                var path, _a, beforeAmendCommits, _b, afterAmendCommits;
                return __generator(this, function (_c) {
                    switch (_c.label) {
                        case 0:
                            path = track.mkdirSync('commit-with-amend');
                            return [4 /*yield*/, (0, test_helper_1.initRepository)(path)];
                        case 1:
                            _c.sent();
                            fs.createFileSync(Path.join(path, 'some-file.txt'));
                            (0, chai_1.expect)(fs.existsSync(Path.join(path, 'some-file.txt'))).to.be.true;
                            _a = chai_1.expect;
                            return [4 /*yield*/, (0, git_1.git)(['add', '.'], path, 'add')];
                        case 2:
                            _a.apply(void 0, [(_c.sent()).exitCode]).to.be.equal(0);
                            return [4 /*yield*/, (0, commit_1.createCommit)(path, 'some commit message')];
                        case 3:
                            _c.sent();
                            return [4 /*yield*/, (0, git_1.git)(['log', '--format=%B', '-z'], path, 'log')];
                        case 4:
                            beforeAmendCommits = (_c.sent()).stdout.trim().split('\0').filter(function (c) { return c.trim().length > 0; });
                            (0, chai_1.expect)(beforeAmendCommits).to.have.lengthOf(1);
                            (0, chai_1.expect)(beforeAmendCommits[0].trim().endsWith('some commit message')).to.be.true;
                            fs.createFileSync(Path.join(path, 'another-file.txt'));
                            (0, chai_1.expect)(fs.existsSync(Path.join(path, 'another-file.txt'))).to.be.true;
                            _b = chai_1.expect;
                            return [4 /*yield*/, (0, git_1.git)(['add', '.'], path, 'add')];
                        case 5:
                            _b.apply(void 0, [(_c.sent()).exitCode]).to.be.equal(0);
                            return [4 /*yield*/, (0, commit_1.createCommit)(path, 'another message', false, true)];
                        case 6:
                            _c.sent();
                            return [4 /*yield*/, (0, git_1.git)(['log', '--format=%B', '-z'], path, 'log')];
                        case 7:
                            afterAmendCommits = (_c.sent()).stdout.trim().split('\0').filter(function (c) { return c.trim().length > 0; });
                            (0, chai_1.expect)(afterAmendCommits).to.have.lengthOf(1);
                            (0, chai_1.expect)(afterAmendCommits[0].trim().endsWith('another message')).to.be.true;
                            return [2 /*return*/];
                    }
                });
            }); });
            it('w/o', function () { return __awaiter(void 0, void 0, void 0, function () {
                var path, _a, beforeAmendCommits, _b, afterAmendCommits;
                return __generator(this, function (_c) {
                    switch (_c.label) {
                        case 0:
                            path = track.mkdirSync('commit-without-amend');
                            return [4 /*yield*/, (0, test_helper_1.initRepository)(path)];
                        case 1:
                            _c.sent();
                            fs.createFileSync(Path.join(path, 'some-file.txt'));
                            (0, chai_1.expect)(fs.existsSync(Path.join(path, 'some-file.txt'))).to.be.true;
                            _a = chai_1.expect;
                            return [4 /*yield*/, (0, git_1.git)(['add', '.'], path, 'add')];
                        case 2:
                            _a.apply(void 0, [(_c.sent()).exitCode]).to.be.equal(0);
                            return [4 /*yield*/, (0, commit_1.createCommit)(path, 'some commit message')];
                        case 3:
                            _c.sent();
                            return [4 /*yield*/, (0, git_1.git)(['log', '--format=%B', '-z'], path, 'log')];
                        case 4:
                            beforeAmendCommits = (_c.sent()).stdout.trim().split('\0').filter(function (c) { return c.trim().length > 0; });
                            (0, chai_1.expect)(beforeAmendCommits).to.have.lengthOf(1);
                            (0, chai_1.expect)(beforeAmendCommits[0].trim().endsWith('some commit message')).to.be.true;
                            fs.createFileSync(Path.join(path, 'another-file.txt'));
                            (0, chai_1.expect)(fs.existsSync(Path.join(path, 'another-file.txt'))).to.be.true;
                            _b = chai_1.expect;
                            return [4 /*yield*/, (0, git_1.git)(['add', '.'], path, 'add')];
                        case 5:
                            _b.apply(void 0, [(_c.sent()).exitCode]).to.be.equal(0);
                            return [4 /*yield*/, (0, commit_1.createCommit)(path, 'another message', false, false)];
                        case 6:
                            _c.sent();
                            return [4 /*yield*/, (0, git_1.git)(['log', '--format=%B', '-z'], path, 'log')];
                        case 7:
                            afterAmendCommits = (_c.sent()).stdout.trim().split('\0').filter(function (c) { return c.trim().length > 0; });
                            (0, chai_1.expect)(afterAmendCommits).to.have.lengthOf(2);
                            (0, chai_1.expect)(afterAmendCommits[0].trim().endsWith('another message')).to.be.true;
                            (0, chai_1.expect)(afterAmendCommits[1].trim().endsWith('some commit message')).to.be.true;
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        return [2 /*return*/];
    });
}); });
//# sourceMappingURL=commit.spec.js.map