"use strict";
// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.backendApplicationModule = void 0;
const inversify_1 = require("inversify");
const application_package_1 = require("@theia/application-package");
const request_1 = require("@theia/request");
const common_1 = require("../common");
const backend_application_1 = require("./backend-application");
const cli_1 = require("./cli");
const messaging_1 = require("./messaging");
const application_server_1 = require("./application-server");
const application_protocol_1 = require("../common/application-protocol");
const env_variables_1 = require("./../common/env-variables");
const env_variables_2 = require("./env-variables");
const connection_container_module_1 = require("./messaging/connection-container-module");
const quick_pick_service_1 = require("../common/quick-pick-service");
const ws_request_validators_1 = require("./ws-request-validators");
const keytar_protocol_1 = require("../common/keytar-protocol");
const keytar_server_1 = require("./keytar-server");
const contribution_filter_1 = require("../common/contribution-filter");
const environment_utils_1 = require("./environment-utils");
const process_utils_1 = require("./process-utils");
const proxy_cli_contribution_1 = require("./request/proxy-cli-contribution");
const performance_1 = require("./performance");
const os_backend_application_contribution_1 = require("./os-backend-application-contribution");
const backend_request_facade_1 = require("./request/backend-request-facade");
(0, inversify_1.decorate)((0, inversify_1.injectable)(), application_package_1.ApplicationPackage);
const commandConnectionModule = connection_container_module_1.ConnectionContainerModule.create(({ bindFrontendService }) => {
    bindFrontendService(common_1.commandServicePath, common_1.CommandService);
});
const messageConnectionModule = connection_container_module_1.ConnectionContainerModule.create(({ bind, bindFrontendService }) => {
    bindFrontendService(common_1.messageServicePath, common_1.MessageClient);
    bind(common_1.MessageService).toSelf().inSingletonScope();
});
const quickPickConnectionModule = connection_container_module_1.ConnectionContainerModule.create(({ bindFrontendService }) => {
    bindFrontendService(quick_pick_service_1.quickPickServicePath, quick_pick_service_1.QuickPickService);
});
exports.backendApplicationModule = new inversify_1.ContainerModule(bind => {
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(commandConnectionModule);
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(messageConnectionModule);
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(quickPickConnectionModule);
    bind(cli_1.CliManager).toSelf().inSingletonScope();
    (0, common_1.bindContributionProvider)(bind, cli_1.CliContribution);
    bind(backend_application_1.BackendApplicationCliContribution).toSelf().inSingletonScope();
    bind(cli_1.CliContribution).toService(backend_application_1.BackendApplicationCliContribution);
    bind(backend_application_1.BackendApplication).toSelf().inSingletonScope();
    (0, common_1.bindContributionProvider)(bind, backend_application_1.BackendApplicationContribution);
    // Bind the BackendApplicationServer as a BackendApplicationContribution
    // and fallback to an empty contribution if never bound.
    bind(backend_application_1.BackendApplicationContribution).toDynamicValue(ctx => {
        if (ctx.container.isBound(backend_application_1.BackendApplicationServer)) {
            return ctx.container.get(backend_application_1.BackendApplicationServer);
        }
        else {
            console.warn('no BackendApplicationServer is set, frontend might not be available');
            return {};
        }
    }).inSingletonScope();
    bind(messaging_1.IPCConnectionProvider).toSelf().inSingletonScope();
    bind(application_server_1.ApplicationServerImpl).toSelf().inSingletonScope();
    bind(application_protocol_1.ApplicationServer).toService(application_server_1.ApplicationServerImpl);
    bind(common_1.ConnectionHandler).toDynamicValue(ctx => new common_1.JsonRpcConnectionHandler(application_protocol_1.applicationPath, () => ctx.container.get(application_protocol_1.ApplicationServer))).inSingletonScope();
    bind(env_variables_1.EnvVariablesServer).to(env_variables_2.EnvVariablesServerImpl).inSingletonScope();
    bind(common_1.ConnectionHandler).toDynamicValue(ctx => new common_1.JsonRpcConnectionHandler(env_variables_1.envVariablesPath, () => {
        const envVariablesServer = ctx.container.get(env_variables_1.EnvVariablesServer);
        return envVariablesServer;
    })).inSingletonScope();
    bind(application_package_1.ApplicationPackage).toDynamicValue(({ container }) => {
        const { projectPath } = container.get(backend_application_1.BackendApplicationCliContribution);
        return new application_package_1.ApplicationPackage({ projectPath });
    }).inSingletonScope();
    bind(ws_request_validators_1.WsRequestValidator).toSelf().inSingletonScope();
    (0, common_1.bindContributionProvider)(bind, ws_request_validators_1.WsRequestValidatorContribution);
    bind(keytar_protocol_1.KeytarService).to(keytar_server_1.KeytarServiceImpl).inSingletonScope();
    bind(common_1.ConnectionHandler).toDynamicValue(ctx => new common_1.JsonRpcConnectionHandler(keytar_protocol_1.keytarServicePath, () => ctx.container.get(keytar_protocol_1.KeytarService))).inSingletonScope();
    bind(contribution_filter_1.ContributionFilterRegistry).to(contribution_filter_1.ContributionFilterRegistryImpl).inSingletonScope();
    bind(environment_utils_1.EnvironmentUtils).toSelf().inSingletonScope();
    bind(process_utils_1.ProcessUtils).toSelf().inSingletonScope();
    bind(os_backend_application_contribution_1.OSBackendApplicationContribution).toSelf().inSingletonScope();
    bind(backend_application_1.BackendApplicationContribution).toService(os_backend_application_contribution_1.OSBackendApplicationContribution);
    bind(proxy_cli_contribution_1.ProxyCliContribution).toSelf().inSingletonScope();
    bind(cli_1.CliContribution).toService(proxy_cli_contribution_1.ProxyCliContribution);
    bind(backend_request_facade_1.BackendRequestFacade).toSelf().inSingletonScope();
    bind(common_1.ConnectionHandler).toDynamicValue(ctx => new common_1.JsonRpcConnectionHandler(request_1.REQUEST_SERVICE_PATH, () => ctx.container.get(backend_request_facade_1.BackendRequestFacade))).inSingletonScope();
    (0, performance_1.bindNodeStopwatch)(bind);
    (0, performance_1.bindBackendStopwatchServer)(bind);
});
//# sourceMappingURL=backend-application-module.js.map