import { DebugClient } from '@vscode/debugadapter-testsupport';
import { DebugProtocol } from '@vscode/debugprotocol';
export declare type ReverseRequestHandler<A = any, R extends DebugProtocol.Response = DebugProtocol.Response> = (args: A) => Promise<R['body']>;
export interface ReverseRequestHandlers {
    [key: string]: ReverseRequestHandler | undefined;
    runInTerminal: ReverseRequestHandler<DebugProtocol.RunInTerminalRequestArguments, DebugProtocol.RunInTerminalResponse>;
}
/**
 * Extend the DebugClient to support Reverse Requests:
 * https://microsoft.github.io/debug-adapter-protocol/specification#Reverse_Requests_RunInTerminal
 */
export declare class CdtDebugClient extends DebugClient {
    /**
     * Reverse Request Handlers:
     */
    protected reverseRequestHandlers: ReverseRequestHandlers;
    /**
     * Notify the Debug Adapter by default that this client supports `runInTerminal`.
     */
    initializeRequest(args?: DebugProtocol.InitializeRequestArguments): Promise<DebugProtocol.InitializeResponse>;
    /**
     * Send a continueRequest and wait for target to stop
     */
    continue(args: DebugProtocol.ContinueArguments, reason: string, expected: {
        path?: string | RegExp;
        line?: number;
        column?: number;
    }): Promise<DebugProtocol.StackTraceResponse>;
    /**
     * Send a nextRequest and wait for target to stop
     */
    next(args: DebugProtocol.NextArguments, expected: {
        path?: string | RegExp;
        line?: number;
        column?: number;
    }): Promise<DebugProtocol.StackTraceResponse>;
    /**
     * Send a stepInRequest and wait for target to stop
     */
    stepIn(args: DebugProtocol.StepInArguments, expected: {
        path?: string | RegExp;
        line?: number;
        column?: number;
    }): Promise<DebugProtocol.StackTraceResponse>;
    /**
     * Send a stepOutRequest and wait for target to stop
     */
    stepOut(args: DebugProtocol.StepOutArguments, expected: {
        path?: string | RegExp;
        line?: number;
        column?: number;
    }): Promise<DebugProtocol.StackTraceResponse>;
    /**
     * Send a stepBackRequest and wait for target to stop
     */
    stepBack(args: DebugProtocol.StepBackArguments, expected: {
        path?: string | RegExp;
        line?: number;
        column?: number;
    }): Promise<DebugProtocol.StackTraceResponse>;
    waitForOutputEvent(category: string, timeout?: number): Promise<DebugProtocol.OutputEvent>;
    /**
     * Send a response following a Debug Adapter Reverse Request.
     * @param request original request to respond to.
     * @param handler processes the request and returns the response body.
     */
    private doRespond;
    readMemoryRequest(args: DebugProtocol.ReadMemoryArguments): Promise<DebugProtocol.ReadMemoryResponse>;
    writeMemoryRequest(args: DebugProtocol.WriteMemoryArguments): Promise<DebugProtocol.WriteMemoryResponse>;
}
