import { Handles, Logger, LoggingDebugSession, Response } from '@vscode/debugadapter';
import { DebugProtocol } from '@vscode/debugprotocol';
import { GDBBackend } from './GDBBackend';
import * as mi from './mi';
import { VarObjType } from './varManager';
export interface RequestArguments extends DebugProtocol.LaunchRequestArguments {
    gdb?: string;
    gdbArguments?: string[];
    gdbAsync?: boolean;
    gdbNonStop?: boolean;
    program: string;
    cwd?: string;
    verbose?: boolean;
    logFile?: string;
    openGdbConsole?: boolean;
    initCommands?: string[];
    hardwareBreakpoint?: boolean;
}
export interface LaunchRequestArguments extends RequestArguments {
    arguments?: string;
}
export interface AttachRequestArguments extends RequestArguments {
    processId: string;
}
export interface FrameReference {
    threadId: number;
    frameId: number;
}
export interface FrameVariableReference {
    type: 'frame';
    frameHandle: number;
}
export interface ObjectVariableReference {
    type: 'object';
    frameHandle: number;
    varobjName: string;
}
export interface RegisterVariableReference {
    type: 'registers';
    frameHandle: number;
    regname?: string;
}
export declare type VariableReference = FrameVariableReference | ObjectVariableReference | RegisterVariableReference;
export interface MemoryRequestArguments {
    address: string;
    length: number;
    offset?: number;
}
/**
 * Response for our custom 'cdt-gdb-adapter/Memory' request.
 */
export interface MemoryContents {
    data: string;
    address: string;
}
export interface MemoryResponse extends Response {
    body: MemoryContents;
}
export interface CDTDisassembleArguments extends DebugProtocol.DisassembleArguments {
    /**
     * Memory reference to the end location containing the instructions to disassemble. When this
     * optional setting is provided, the minimum number of lines needed to get to the endMemoryReference
     * is used.
     */
    endMemoryReference: string;
}
declare class ThreadWithStatus implements DebugProtocol.Thread {
    id: number;
    name: string;
    running: boolean;
    constructor(id: number, name: string, running: boolean);
}
export declare function hexToBase64(hex: string): string;
export declare function base64ToHex(base64: string): string;
export declare class GDBDebugSession extends LoggingDebugSession {
    protected gdb: GDBBackend;
    protected isAttach: boolean;
    protected isRunning: boolean;
    protected supportsRunInTerminalRequest: boolean;
    protected supportsGdbConsole: boolean;
    protected logger: Logger.Logger;
    protected frameHandles: Handles<FrameReference>;
    protected variableHandles: Handles<VariableReference>;
    protected functionBreakpoints: string[];
    protected logPointMessages: {
        [key: string]: string;
    };
    protected threads: ThreadWithStatus[];
    protected waitPaused?: (value?: void | PromiseLike<void>) => void;
    protected waitPausedThreadId: number;
    protected waitPausedNeeded: boolean;
    protected isInitialized: boolean;
    constructor();
    protected createBackend(): GDBBackend;
    /**
     * Handle requests not defined in the debug adapter protocol.
     */
    protected customRequest(command: string, response: DebugProtocol.Response, args: any): void;
    protected initializeRequest(response: DebugProtocol.InitializeResponse, args: DebugProtocol.InitializeRequestArguments): void;
    protected attachRequest(response: DebugProtocol.AttachResponse, args: AttachRequestArguments): Promise<void>;
    protected launchRequest(response: DebugProtocol.LaunchResponse, args: LaunchRequestArguments): Promise<void>;
    protected spawn(args: LaunchRequestArguments | AttachRequestArguments): Promise<void>;
    protected spawnInClientTerminal(args: DebugProtocol.LaunchRequestArguments | DebugProtocol.AttachRequestArguments): Promise<void>;
    protected setBreakPointsRequest(response: DebugProtocol.SetBreakpointsResponse, args: DebugProtocol.SetBreakpointsArguments): Promise<void>;
    protected setFunctionBreakPointsRequest(response: DebugProtocol.SetFunctionBreakpointsResponse, args: DebugProtocol.SetFunctionBreakpointsArguments): Promise<void>;
    /**
     * Resolved which VS breakpoints needs to be installed, which
     * GDB breakpoints need to be deleted and which VS breakpoints
     * are already installed with which matching GDB breakpoint.
     * @param vsbps VS DAP breakpoints
     * @param gdbbps GDB breakpoints
     * @param matchFn matcher to compare VS and GDB breakpoints
     * @returns resolved -> array maintaining order of vsbps that identifies whether
     * VS breakpoint has a cooresponding GDB breakpoint (gdbbp field set) or needs to be
     * inserted (gdbbp field empty)
     * deletes -> GDB bps ids that should be deleted because they don't match vsbps
     */
    protected resolveBreakpoints<T>(vsbps: T[], gdbbps: mi.MIBreakpointInfo[], matchFn: (vsbp: T, gdbbp: mi.MIBreakpointInfo) => boolean): {
        resolved: Array<{
            vsbp: T;
            gdbbp?: mi.MIBreakpointInfo;
        }>;
        deletes: string[];
    };
    protected configurationDoneRequest(response: DebugProtocol.ConfigurationDoneResponse, _args: DebugProtocol.ConfigurationDoneArguments): Promise<void>;
    protected convertThread(thread: mi.MIThreadInfo): ThreadWithStatus;
    protected threadsRequest(response: DebugProtocol.ThreadsResponse): Promise<void>;
    protected stackTraceRequest(response: DebugProtocol.StackTraceResponse, args: DebugProtocol.StackTraceArguments): Promise<void>;
    protected nextRequest(response: DebugProtocol.NextResponse, args: DebugProtocol.NextArguments): Promise<void>;
    protected stepInRequest(response: DebugProtocol.StepInResponse, args: DebugProtocol.StepInArguments): Promise<void>;
    protected stepOutRequest(response: DebugProtocol.StepOutResponse, args: DebugProtocol.StepOutArguments): Promise<void>;
    protected continueRequest(response: DebugProtocol.ContinueResponse, args: DebugProtocol.ContinueArguments): Promise<void>;
    protected pauseRequest(response: DebugProtocol.PauseResponse, args: DebugProtocol.PauseArguments): Promise<void>;
    protected scopesRequest(response: DebugProtocol.ScopesResponse, args: DebugProtocol.ScopesArguments): void;
    protected variablesRequest(response: DebugProtocol.VariablesResponse, args: DebugProtocol.VariablesArguments): Promise<void>;
    protected setVariableRequest(response: DebugProtocol.SetVariableResponse, args: DebugProtocol.SetVariableArguments): Promise<void>;
    protected evaluateRequest(response: DebugProtocol.EvaluateResponse, args: DebugProtocol.EvaluateArguments): Promise<void>;
    /**
     * Implement the cdt-gdb-adapter/Memory request.
     */
    protected memoryRequest(response: MemoryResponse, args: any): Promise<void>;
    protected disassembleRequest(response: DebugProtocol.DisassembleResponse, args: CDTDisassembleArguments): Promise<void>;
    protected readMemoryRequest(response: DebugProtocol.ReadMemoryResponse, args: DebugProtocol.ReadMemoryArguments): Promise<void>;
    /**
     * Implement the memoryWrite request.
     */
    protected writeMemoryRequest(response: DebugProtocol.WriteMemoryResponse, args: DebugProtocol.WriteMemoryArguments): Promise<void>;
    protected disconnectRequest(response: DebugProtocol.DisconnectResponse, _args: DebugProtocol.DisconnectArguments): Promise<void>;
    protected sendStoppedEvent(reason: string, threadId: number, allThreadsStopped?: boolean): void;
    protected handleGDBStopped(result: any): void;
    protected handleGDBAsync(resultClass: string, resultData: any): void;
    protected handleGDBNotify(notifyClass: string, notifyData: any): void;
    protected handleVariableRequestFrame(ref: FrameVariableReference): Promise<DebugProtocol.Variable[]>;
    protected handleVariableRequestObject(ref: ObjectVariableReference): Promise<DebugProtocol.Variable[]>;
    private registerMap;
    private registerMapReverse;
    protected handleVariableRequestRegister(ref: RegisterVariableReference): Promise<DebugProtocol.Variable[]>;
    protected getAddr(varobj: VarObjType): Promise<string>;
    protected isChildOfClass(child: mi.MIVarChild): boolean;
}
export {};
