"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphChartGrid = void 0;
var time_graph_layer_1 = require("./time-graph-layer");
var time_graph_grid_1 = require("../components/time-graph-grid");
var TimeGraphChartGrid = /** @class */ (function (_super) {
    __extends(TimeGraphChartGrid, _super);
    function TimeGraphChartGrid(id, rowHeight, lineColor) {
        var _this = _super.call(this, id) || this;
        _this.rowHeight = rowHeight;
        _this.lineColor = lineColor;
        return _this;
    }
    ;
    TimeGraphChartGrid.prototype.afterAddToContainer = function () {
        var _this = this;
        this.gridComponent = new time_graph_grid_1.TimeGraphGrid('', {
            height: this.stateController.canvasDisplayHeight,
            position: { x: 0, y: 0 },
            width: this.stateController.canvasDisplayWidth,
            lineColor: this.lineColor
        }, this.rowHeight, this.unitController, this.stateController);
        this.addChild(this.gridComponent);
        this._updateHandler = function () { return _this.update(); };
        this.unitController.onViewRangeChanged(this._updateHandler);
    };
    TimeGraphChartGrid.prototype.update = function (opts) {
        this.gridComponent.update(opts);
    };
    TimeGraphChartGrid.prototype.destroy = function () {
        if (this.unitController) {
            this.unitController.removeViewRangeChangedHandler(this._updateHandler);
            this.unitController.removeSelectionRangeChangedHandler(this._updateHandler);
        }
        _super.prototype.destroy.call(this);
    };
    return TimeGraphChartGrid;
}(time_graph_layer_1.TimeGraphLayer));
exports.TimeGraphChartGrid = TimeGraphChartGrid;
//# sourceMappingURL=time-graph-chart-grid.js.map