"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceViewerContribution = void 0;
const inversify_1 = require("inversify");
const core_1 = require("@theia/core");
const browser_1 = require("@theia/core/lib/browser");
const uri_1 = __importDefault(require("@theia/core/lib/common/uri"));
const trace_viewer_1 = require("./trace-viewer");
const browser_2 = require("@theia/filesystem/lib/browser");
const workspace_service_1 = require("@theia/workspace/lib/browser/workspace-service");
const trace_viewer_commands_1 = require("./trace-viewer-commands");
const trace_server_config_1 = require("../../common/trace-server-config");
const trace_server_preference_1 = require("../trace-server-preference");
const tsp_client_provider_impl_1 = require("../tsp-client-provider-impl");
const charts_cheatsheet_component_1 = require("./../trace-explorer/trace-explorer-sub-widgets/trace-explorer-keyboard-shortcuts/charts-cheatsheet-component");
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
let TraceViewerContribution = class TraceViewerContribution extends browser_1.WidgetOpenHandler {
    constructor(tspClientProvider) {
        super();
        this.tspClientProvider = tspClientProvider;
        this.id = trace_viewer_1.TraceViewerWidget.ID;
        this.label = 'Trace Viewer';
        this.tspClient = this.tspClientProvider.getTspClient();
        this.tspClientProvider.addTspClientChangeListener(tspClient => this.tspClient = tspClient);
    }
    get path() {
        return this.tracePreferences[trace_server_preference_1.TRACE_PATH];
    }
    get args() {
        return this.tracePreferences[trace_server_preference_1.TRACE_ARGS];
    }
    createWidgetOptions(uri, options) {
        return {
            traceURI: uri.path.toString(),
            traceUUID: options === null || options === void 0 ? void 0 : options.traceUUID
        };
    }
    async launchTraceServer() {
        var _a;
        let healthResponse;
        try {
            healthResponse = await this.tspClient.checkHealth();
        }
        catch (err) {
            // continue to start trace server
        }
        if (healthResponse && healthResponse.isOk() && ((_a = healthResponse.getModel()) === null || _a === void 0 ? void 0 : _a.status) === 'UP') {
            this.openDialog();
        }
        else {
            const progress = await this.messageService.showProgress({ text: '' });
            progress.report({ message: 'Launching trace server... ', work: { done: 10, total: 100 } });
            const { path, args } = this;
            try {
                const resolve = await this.traceServerConfigService.startTraceServer({ path, args });
                if (resolve === 'success') {
                    if (this.args && this.args.length > 0) {
                        progress.report({ message: `Trace server started using the following arguments:  ${this.args}.`, work: { done: 100, total: 100 } });
                    }
                    else {
                        progress.report({ message: 'Trace server started.', work: { done: 100, total: 100 } });
                    }
                    progress.cancel();
                    this.openDialog();
                }
            }
            catch (err) {
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                if (trace_server_config_1.PortBusy.is(err)) {
                    if (this.args && this.args.length > 0) {
                        this.messageService.error(`Error starting the server (port busy) using the following arguments: ${this.args}`);
                    }
                    else {
                        this.messageService.error('Error starting the server (port busy)');
                    }
                }
                else {
                    this.messageService.error('Failed to start the trace server: no such file or directory. Please make sure that the path is correct in Trace Viewer settings and retry');
                }
                progress.cancel();
            }
        }
    }
    async openDialog() {
        const props = {
            title: 'Open Trace',
            // Only support selecting folders, both folders and file doesn't work in Electron (issue #227)
            canSelectFolders: true,
            canSelectFiles: false
        };
        const root = this.workspaceService.tryGetRoots()[0];
        const fileURI = await this.fileDialogService.showOpenDialog(props, root);
        if (fileURI) {
            await this.open(fileURI);
        }
    }
    async open(traceURI, options) {
        var _a;
        let healthResponse;
        try {
            healthResponse = await this.tspClient.checkHealth();
        }
        catch (err) {
            // continue to start trace server
        }
        if (healthResponse && healthResponse.isOk() && ((_a = healthResponse.getModel()) === null || _a === void 0 ? void 0 : _a.status) === 'UP') {
            return super.open(traceURI, options);
        }
        else {
            return this.messageService.showProgress({ text: '' }).then(async (progress) => {
                progress.report({ message: 'Launching trace server... ', work: { done: 10, total: 100 } });
                const { path, args } = this;
                try {
                    const resolve = await this.traceServerConfigService.startTraceServer({ path, args });
                    if (resolve === 'success') {
                        await this.waitForTraceServer(10000);
                        if (this.args && this.args.length > 0) {
                            progress.report({ message: `Trace server started using the following arguments:  ${args}.`, work: { done: 100, total: 100 } });
                        }
                        else {
                            progress.report({ message: 'Trace server started.', work: { done: 100, total: 100 } });
                        }
                        return super.open(traceURI, options);
                    }
                    throw new Error('Could not start trace server: ' + resolve);
                }
                catch (err) {
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any
                    if (trace_server_config_1.PortBusy.is(err)) {
                        if (this.args && this.args.length > 0) {
                            this.messageService.error(`Error starting the server (port busy) using the following arguments: ${this.args}`);
                        }
                        else {
                            this.messageService.error('Error starting the server (port busy)');
                        }
                    }
                    else {
                        this.messageService.error('Failed to start the trace server: no such file or directory. Please make sure that the path is correct in Trace Viewer settings and retry');
                    }
                    throw err;
                }
                finally {
                    progress.cancel();
                }
            });
        }
    }
    registerKeybindings(keybindings) {
        keybindings.registerKeybinding({
            keybinding: 'ctrlcmd+f1',
            command: trace_viewer_commands_1.KeyboardShortcutsCommand.id,
        });
    }
    registerCommands(registry) {
        registry.registerCommand(trace_viewer_commands_1.OpenTraceCommand, {
            execute: () => this.launchTraceServer()
        });
        registry.registerCommand(trace_viewer_commands_1.TraceViewerCommand, {
            execute: (options) => this.open(new uri_1.default(''), options)
        });
        registry.registerCommand(trace_viewer_commands_1.StartServerCommand, {
            execute: async () => {
                const { path, args } = this;
                try {
                    await this.traceServerConfigService.startTraceServer({ path, args });
                    if (this.args && this.args.length > 0) {
                        this.messageService.info(`Trace server started using the following arguments:  ${this.args}.`);
                    }
                    else {
                        this.messageService.info('Trace server started.');
                    }
                    (0, signal_manager_1.signalManager)().fireTraceServerStartedSignal();
                }
                catch (error) {
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any
                    if (trace_server_config_1.PortBusy.is(error)) {
                        if (this.args && this.args.length > 0) {
                            this.messageService.error(`Error starting the server (port busy) using the following arguments: ${this.args}`);
                        }
                        else {
                            this.messageService.error('Error starting the server (port busy)');
                        }
                    }
                    else {
                        console.error(error);
                        this.messageService.error('Failed to start the trace server: no such file or directory. Please make sure that the path is correct in Trace Viewer settings and retry');
                    }
                }
            }
        });
        registry.registerCommand(trace_viewer_commands_1.StopServerCommand, {
            execute: async () => {
                try {
                    await this.traceServerConfigService.stopTraceServer();
                    this.messageService.info('Trace server terminated successfully.');
                }
                catch (err) {
                    this.messageService.error('Failed to stop the trace server.');
                }
            }
        });
        registry.registerCommand(trace_viewer_commands_1.KeyboardShortcutsCommand, {
            execute: () => {
                this.chartShortcuts.open();
            }
        });
    }
    canHandle(_uri) {
        return 100;
    }
    async waitForTraceServer(timeoutMs) {
        var _a, _b;
        let timeout = false;
        const timeoutHandle = setTimeout(() => timeout = true, timeoutMs);
        // Try fetching the Trace Server health, repeat on error only.
        // If we get a response of some sort, it means the HTTP server is up somehow.
        while (true) {
            let error;
            try {
                const healthResponse = await this.tspClient.checkHealth();
                if (healthResponse.isOk() && ((_a = healthResponse.getModel()) === null || _a === void 0 ? void 0 : _a.status) === 'UP') {
                    clearTimeout(timeoutHandle);
                    return;
                }
                error = new Error('Unsuccessful health check: ' + healthResponse.getStatusMessage() + ' status: ' + ((_b = healthResponse.getModel()) === null || _b === void 0 ? void 0 : _b.status));
            }
            catch (err) {
                error = error;
            }
            if (timeout) {
                throw error;
            }
            console.error(error);
        }
    }
};
__decorate([
    (0, inversify_1.inject)(browser_2.FileDialogService),
    __metadata("design:type", Object)
], TraceViewerContribution.prototype, "fileDialogService", void 0);
__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    __metadata("design:type", workspace_service_1.WorkspaceService)
], TraceViewerContribution.prototype, "workspaceService", void 0);
__decorate([
    (0, inversify_1.inject)(trace_server_preference_1.TracePreferences),
    __metadata("design:type", Object)
], TraceViewerContribution.prototype, "tracePreferences", void 0);
__decorate([
    (0, inversify_1.inject)(trace_server_config_1.TraceServerConfigService),
    __metadata("design:type", Object)
], TraceViewerContribution.prototype, "traceServerConfigService", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    __metadata("design:type", core_1.MessageService)
], TraceViewerContribution.prototype, "messageService", void 0);
__decorate([
    (0, inversify_1.inject)(charts_cheatsheet_component_1.ChartShortcutsDialog),
    __metadata("design:type", charts_cheatsheet_component_1.ChartShortcutsDialog)
], TraceViewerContribution.prototype, "chartShortcuts", void 0);
TraceViewerContribution = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(tsp_client_provider_impl_1.TspClientProvider)),
    __metadata("design:paramtypes", [tsp_client_provider_impl_1.TspClientProvider])
], TraceViewerContribution);
exports.TraceViewerContribution = TraceViewerContribution;
//# sourceMappingURL=trace-viewer-contribution.js.map