/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EclipseLogger
implements org.codehaus.plexus.logging.Logger {
    private static final Logger log = LoggerFactory.getLogger(EclipseLogger.class);
    private final IMavenConfiguration mavenConfiguration;

    public EclipseLogger(IMavenConfiguration mavenConfiguration) {
        this.mavenConfiguration = mavenConfiguration;
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            log.debug(msg);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            log.debug(this.toMessageString(msg, t), t);
        }
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            log.info(msg);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            log.info(this.toMessageString(msg, t), t);
        }
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            log.warn(msg);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            log.warn(this.toMessageString(msg, t), t);
        }
    }

    public void fatalError(String msg) {
        if (this.isFatalErrorEnabled()) {
            log.error(msg);
        }
    }

    public void fatalError(String msg, Throwable t) {
        if (this.isFatalErrorEnabled()) {
            log.error(this.toMessageString(msg, t), t);
        }
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            log.error(msg);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            log.error(this.toMessageString(msg, t), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.mavenConfiguration.isDebugOutput();
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalErrorEnabled() {
        return true;
    }

    public void setThreshold(int treshold) {
    }

    public int getThreshold() {
        return 0;
    }

    public org.codehaus.plexus.logging.Logger getChildLogger(String name) {
        return this;
    }

    public String getName() {
        return Messages.EclipseLogger_name;
    }

    private String toMessageString(String msg, Throwable t) {
        if (t == null || t.getMessage() == null) {
            return msg;
        }
        if (msg == null) {
            return t.getMessage();
        }
        return msg + " " + t.getMessage();
    }
}

