/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.uistructure;

import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ViewerElement {
    private StructuredViewer viewer;
    private final AbstractComponentEditor<?> editor;
    private ComboViewer dropDown;
    private Button addButton;
    private final Composite parent;
    private Button removeButton;
    private Button downButton;
    private Button upButton;

    @Inject
    public ViewerElement(Composite parent, AbstractComponentEditor<?> editor) {
        this.parent = parent;
        this.editor = editor;
        this.createControl();
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void createControl() {
        this.createTopButtons();
        if (this.viewer == null) {
            this.viewer = new TableViewer(this.parent);
        }
        GridData gd = new GridData(4, 4, true, true, 3, 1);
        this.viewer.getControl().setLayoutData((Object)gd);
        this.createBottomButtons();
    }

    private void createBottomButtons() {
        Composite buttonCompBot = new Composite(this.parent, 0);
        buttonCompBot.setLayoutData((Object)new GridData(4, 3, false, false, 3, 1));
        GridLayout gl = new GridLayout(3, false);
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        buttonCompBot.setLayout((Layout)gl);
        this.upButton = new Button(buttonCompBot, 0x800008);
        this.upButton.setText(Messages.ModelTooling_Common_Up);
        this.upButton.setImage(this.editor.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.arrow_up"));
        this.upButton.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.downButton = new Button(buttonCompBot, 0x800008);
        this.downButton.setText(Messages.ModelTooling_Common_Down);
        this.downButton.setImage(this.editor.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.arrow_down"));
        this.downButton.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.removeButton = new Button(buttonCompBot, 0x800008);
        this.removeButton.setText(Messages.ModelTooling_Common_Remove);
        this.removeButton.setImage(this.editor.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.table_delete"));
        this.removeButton.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
    }

    public Button getButtonRemove() {
        return this.removeButton;
    }

    public Button getButtonAdd() {
        return this.addButton;
    }

    public Button getButtonDown() {
        return this.downButton;
    }

    public Button getButtonUp() {
        return this.upButton;
    }

    private void createTopButtons() {
        Composite buttonCompTop = new Composite(this.parent, 0);
        buttonCompTop.setLayoutData((Object)new GridData(4, 3, false, false, 3, 1));
        GridLayout buttonCompTopLayout = new GridLayout(2, false);
        buttonCompTopLayout.marginLeft = 0;
        buttonCompTopLayout.marginRight = 0;
        buttonCompTopLayout.marginWidth = 0;
        buttonCompTopLayout.marginHeight = 0;
        buttonCompTop.setLayout((Layout)buttonCompTopLayout);
        this.dropDown = new ComboViewer(buttonCompTop, 12);
        this.dropDown.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.addButton = new Button(buttonCompTop, 0x800008);
        this.addButton.setImage(this.editor.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.table_add"));
        this.addButton.setText(Messages.ModelTooling_Common_AddEllipsis);
        this.addButton.setLayoutData((Object)new GridData(4, 2, false, false));
    }

    public ComboViewer getDropDown() {
        return this.dropDown;
    }

    public static ViewerElement create(IEclipseContext parentContext, Composite parent, AbstractComponentEditor<?> editor) {
        IEclipseContext mycontext = parentContext.createChild();
        mycontext.set(Composite.class, (Object)parent);
        mycontext.set(AbstractComponentEditor.class, editor);
        return (ViewerElement)ContextInjectionFactory.make(ViewerElement.class, (IEclipseContext)mycontext);
    }
}

