/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.E4Properties;
import org.eclipse.e4.tools.emf.ui.internal.common.AbstractPickList;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BindingContextEditor
extends AbstractComponentEditor<MBindingContext> {
    private Composite composite;
    private EMFDataBindingContext context;
    private StackLayout stackLayout;
    private final List<Action> actions = new ArrayList<Action>();

    @Inject
    public BindingContextEditor() {
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.BindingContextEditor_AddContext, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.BindingContext")){

            public void run() {
                BindingContextEditor.this.handleAddContext();
            }
        });
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.BindingContext");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.BindingContextEditor_TreeLabel;
    }

    @Override
    public String getDetailLabel(Object element) {
        MBindingContext context = (MBindingContext)element;
        if (context.getName() != null && context.getName().trim().length() > 0) {
            return context.getName().trim();
        }
        if (context.getElementId() != null && context.getElementId().trim().length() > 0) {
            return context.getElementId().trim();
        }
        return null;
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{CommandsPackageImpl.Literals.BINDING_CONTEXT__NAME}), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID})};
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.BindingContextEditor_TreeLabelDescription;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, this.getMaster(), false);
                this.createForm(this.composite, this.context, this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.requestLayout();
        }
        this.getMaster().setValue((Object)((MBindingContext)object));
        this.enableIdGenerator(CommandsPackageImpl.Literals.BINDING_CONTEXT__NAME, ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID, null);
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue<MBindingContext> master, boolean isImport) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.elementId(this.getEditingDomain()));
        ControlFactory.createTextField(parent, this.Messages.BindingContextEditor_Name, null, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.bindingContextName(this.getEditingDomain()), this.Messages.BindingContextEditor_NameWarning, "DEC_ERROR");
        ControlFactory.createTextField(parent, this.Messages.BindingContextEditor_Description, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.description(this.getEditingDomain()));
        E4PickList pickList = new E4PickList(parent, 0, Arrays.asList(AbstractPickList.PickListFeatures.NO_PICKER), (AbstractComponentEditor)this, (EStructuralFeature)CommandsPackageImpl.Literals.BINDING_CONTEXT__CHILDREN){

            @Override
            protected void addPressed() {
                BindingContextEditor.this.handleAddContext();
            }

            @Override
            protected List<?> getContainerChildren(Object master) {
                return ((MBindingContext)master).getChildren();
            }
        };
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        pickList.setText(this.Messages.BindingContextEditor_Subcontexts);
        TableViewer viewer = pickList.getList();
        viewer.setInput((Object)E4Properties.bindingContextChildren(this.getEditingDomain()).observeDetail(master));
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.ModelTooling_ApplicationElement_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        this.createContributedEditorTabs(folder, context, this.getMaster(), MBindingContext.class);
        folder.setSelection(0);
        return folder;
    }

    @Override
    public IObservableList<?> getChildList(Object element) {
        return E4Properties.bindingContextChildren().observe((Object)((MBindingContext)element));
    }

    protected void handleAddContext() {
        MBindingContext eObject = MCommandsFactory.INSTANCE.createBindingContext();
        this.setElementId(eObject);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)CommandsPackageImpl.Literals.BINDING_CONTEXT__CHILDREN, (Object)eObject);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(eObject);
        }
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }
}

