/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class MassifHeapTreeNode {
    protected MassifHeapTreeNode parent;
    protected String text;
    protected double percent;
    protected long bytes;
    protected String address;
    protected String function;
    protected String filename;
    protected int line;
    protected List<MassifHeapTreeNode> children;

    public MassifHeapTreeNode(MassifHeapTreeNode parent, double percent, long bytes, String address, String function, String filename, int line) {
        this.parent = parent;
        StringBuilder nodeText = new StringBuilder();
        this.formatBytes(percent, bytes, nodeText);
        nodeText.append(address).append(":");
        if (function.length() > 0) {
            nodeText.append(" ");
            nodeText.append(function);
        }
        if (filename != null) {
            nodeText.append(" (").append(filename);
            if (line > 0) {
                nodeText.append(":").append(line);
            }
            nodeText.append(")");
        }
        this.percent = percent;
        this.bytes = bytes;
        this.address = address;
        this.function = function;
        this.filename = filename;
        this.line = line;
        this.text = nodeText.toString();
        this.children = new ArrayList<MassifHeapTreeNode>();
    }

    public MassifHeapTreeNode(MassifHeapTreeNode parent, double percent, long bytes, String text) {
        this.parent = parent;
        StringBuilder nodeText = new StringBuilder();
        this.formatBytes(percent, bytes, nodeText);
        nodeText.append(text);
        this.percent = percent;
        this.bytes = bytes;
        this.address = null;
        this.function = null;
        this.filename = null;
        this.line = 0;
        this.text = nodeText.toString();
        this.children = new ArrayList<MassifHeapTreeNode>();
    }

    private void formatBytes(double percent, long bytes, StringBuilder buffer) {
        buffer.append(new DecimalFormat("0.##").format(percent) + "%");
        buffer.append(" (");
        buffer.append(new DecimalFormat("#,##0").format(bytes) + "B");
        buffer.append(") ");
    }

    public void addChild(MassifHeapTreeNode child) {
        this.children.add(child);
    }

    public MassifHeapTreeNode getParent() {
        return this.parent;
    }

    public MassifHeapTreeNode[] getChildren() {
        return this.children.toArray(new MassifHeapTreeNode[this.children.size()]);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getPercent() {
        return this.percent;
    }

    public long getBytes() {
        return this.bytes;
    }

    public String getAddress() {
        return this.address;
    }

    public String getFunction() {
        return this.function;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public String toString() {
        return this.text;
    }

    public boolean hasSourceFile() {
        return this.filename != null && this.line > 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof MassifHeapTreeNode && this.text.equals(((MassifHeapTreeNode)obj).getText());
    }

    public int hashCode() {
        return this.text.hashCode();
    }
}

