/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.AnnotationResolutionProposal;
import org.eclipse.dltk.ui.text.IAnnotationResolution;
import org.eclipse.dltk.ui.text.IScriptCorrectionContext;
import org.eclipse.dltk.ui.text.MarkerResolutionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.texteditor.ITextEditor;

public class ScriptCorrectionContext
implements IScriptCorrectionContext {
    private List<ICompletionProposal> proposals = null;
    private final IQuickAssistInvocationContext invocationContext;
    private final ITextEditor editor;
    private final ISourceModule module;
    private Map<String, Object> attributes = null;

    public void addProposal(ICompletionProposal proposal) {
        if (this.proposals == null) {
            this.proposals = new ArrayList<ICompletionProposal>();
        }
        this.proposals.add(proposal);
    }

    public void addResolution(IMarkerResolution resolution, IMarker marker) {
        this.addProposal(new MarkerResolutionProposal(resolution, marker));
    }

    public void addResolution(IAnnotationResolution resolution, IScriptAnnotation annotation) {
        this.addProposal(new AnnotationResolutionProposal(resolution, annotation));
    }

    public ICompletionProposal[] getProposals() {
        if (this.proposals != null) {
            return this.proposals.toArray(new ICompletionProposal[this.proposals.size()]);
        }
        return null;
    }

    public ScriptCorrectionContext(IQuickAssistInvocationContext invocationContext, ITextEditor editor, ISourceModule module) {
        this.invocationContext = invocationContext;
        this.editor = editor;
        this.module = module;
    }

    public ITextEditor getEditor() {
        return this.editor;
    }

    public ISourceModule getModule() {
        return this.module;
    }

    public IScriptProject getProject() {
        return this.module.getScriptProject();
    }

    public IQuickAssistInvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    public Object getAttribute(String attributeName) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(attributeName);
    }

    public void setAttribute(String attributeName, Object value) {
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(attributeName, value);
        } else if (this.attributes != null) {
            this.attributes.remove(attributeName);
        }
    }
}

