/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.SwitchComponent;

public class DefaultClause
extends SwitchComponent {
    private Keyword defaultKeyword;

    public DefaultClause(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            List<Statement> statements;
            if (this.defaultKeyword != null) {
                this.defaultKeyword.traverse(visitor);
            }
            if ((statements = this.getStatements()) != null) {
                for (Statement statement : statements) {
                    statement.traverse(visitor);
                }
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Keyword getDefaultKeyword() {
        return this.defaultKeyword;
    }

    public void setDefaultKeyword(Keyword keyword) {
        this.defaultKeyword = keyword;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("default");
        buffer.append(":\n");
        DefaultClause.toSourceString(this.getStatements(), buffer, String.valueOf(indentationString) + "    ");
        return buffer.toString();
    }

    public Keyword getKeyword() {
        return this.getDefaultKeyword();
    }
}

