/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import java.util.Stack;
import org.eclipse.dltk.compiler.IBinaryElementRequestor;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestorExtension;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISearchFactory;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.search.indexing.AbstractIndexer;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.core.search.indexing.IIndexRequestor;

public class SourceIndexerRequestor
implements ISourceElementRequestor,
IBinaryElementRequestor,
IIndexConstants,
IIndexRequestor,
ISourceElementRequestorExtension {
    protected AbstractIndexer indexer;
    protected String[] enclosingTypeNames = new String[5];
    protected int depth = 0;
    protected int methodDepth = 0;
    protected ISearchFactory searchFactory;
    protected ISearchPatternProcessor searchPatternProcessor;
    private Stack<String[]> namespaces = new Stack();

    public SourceIndexerRequestor(AbstractIndexer indexer) {
        this.indexer = indexer;
    }

    public SourceIndexerRequestor() {
    }

    public void setIndexer(AbstractIndexer indexer) {
        this.indexer = indexer;
    }

    public void setSearchFactory(ISearchFactory searchFactory) {
        this.searchFactory = searchFactory;
        this.searchPatternProcessor = searchFactory != null ? searchFactory.createSearchPatternProcessor() : null;
    }

    public void acceptFieldReference(String fieldName, int sourcePosition) {
        this.indexer.addFieldReference(fieldName);
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptMethodReference(String methodName, int argCount, int sourcePosition, int sourceEndPosition) {
        this.indexer.addMethodReference(methodName, argCount);
    }

    public void acceptTypeReference(String simpleTypeName, int sourcePosition) {
        this.indexer.addTypeReference(simpleTypeName);
    }

    public void acceptUnknownReference(String name, int sourcePosition) {
        this.indexer.addNameReference(name);
    }

    protected String[] enclosingTypeNames() {
        if (this.depth == 0) {
            return null;
        }
        String[] qualification = new String[this.depth];
        System.arraycopy(this.enclosingTypeNames, 0, qualification, 0, this.depth);
        return qualification;
    }

    protected String[] namespace() {
        return !this.namespaces.isEmpty() ? this.namespaces.peek() : null;
    }

    public void enterType(IElementRequestor.TypeInfo typeInfo) {
        if (typeInfo.superclasses != null) {
            int i = 0;
            int length = typeInfo.superclasses.length;
            while (i < length) {
                typeInfo.superclasses[i] = this.getSimpleName(typeInfo.superclasses[i]);
                ++i;
            }
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: Add constructore references...");
            }
        }
        String[] typeNames = this.methodDepth > 0 ? ONE_ZERO_CHAR_STRINGS : this.enclosingTypeNames();
        this.indexer.addTypeDeclaration(typeInfo.modifiers, this.namespace(), typeInfo.name, typeNames, typeInfo.superclasses);
        this.pushTypeName(typeInfo.name);
    }

    public void enterConstructor(IElementRequestor.MethodInfo methodInfo) {
        this.indexer.addConstructorDeclaration(methodInfo.name, methodInfo.parameterNames, methodInfo.exceptionTypes);
        ++this.methodDepth;
    }

    public void enterField(IElementRequestor.FieldInfo fieldInfo) {
        this.indexer.addFieldDeclaration(fieldInfo.name, fieldInfo.type);
        ++this.methodDepth;
    }

    public void updateField(IElementRequestor.FieldInfo fieldInfo, int flags) {
        if ((flags & 1) != 0 && fieldInfo.type != null) {
            this.indexer.addTypeReference(fieldInfo.type);
        }
    }

    public void enterMethod(IElementRequestor.MethodInfo methodInfo) {
        this.indexer.addMethodDeclaration(methodInfo.modifiers, this.namespace(), this.enclosingTypeNames(), methodInfo.name, methodInfo.parameterNames, methodInfo.exceptionTypes);
        if (methodInfo.returnType != null) {
            this.indexer.addTypeReference(methodInfo.returnType);
        }
        if (methodInfo.parameterTypes != null) {
            String[] stringArray = methodInfo.parameterTypes;
            int n = methodInfo.parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                if (type != null) {
                    this.indexer.addTypeReference(type);
                }
                ++n2;
            }
        }
        ++this.methodDepth;
    }

    public void exitType(int declarationEnd) {
        this.popTypeName();
    }

    private String getSimpleName(String typeName) {
        if (this.searchPatternProcessor != null) {
            return this.searchPatternProcessor.extractTypeChars(typeName);
        }
        return typeName;
    }

    public void popTypeName() {
        if (this.depth > 0) {
            this.enclosingTypeNames[--this.depth] = null;
        }
    }

    public void pushTypeName(String typeName) {
        if (this.depth == this.enclosingTypeNames.length) {
            this.enclosingTypeNames = new String[this.depth * 2];
            System.arraycopy(this.enclosingTypeNames, 0, this.enclosingTypeNames, 0, this.depth);
        }
        this.enclosingTypeNames[this.depth++] = typeName;
    }

    public void enterMethodRemoveSame(IElementRequestor.MethodInfo info) {
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add replace method code.");
        }
    }

    public void enterModule() {
    }

    public void exitField(int declarationEnd) {
        --this.methodDepth;
    }

    public void exitMethod(int declarationEnd) {
        --this.methodDepth;
    }

    public void exitModule(int declarationEnd) {
    }

    public void acceptPackage(int declarationStart, int declarationEnd, String name) {
    }

    public boolean enterFieldCheckDuplicates(IElementRequestor.FieldInfo info) {
        this.indexer.addFieldDeclaration(info.name, info.type);
        ++this.methodDepth;
        return true;
    }

    public boolean enterTypeAppend(IElementRequestor.TypeInfo info, String fullName, String delimiter) {
        this.enterType(info);
        return true;
    }

    public void enterModuleRoot() {
    }

    public boolean enterTypeAppend(String fullName, String delimiter) {
        return false;
    }

    public void exitModuleRoot() {
    }

    public void acceptImport(IElementRequestor.ImportInfo importInfo) {
    }

    public void enterNamespace(String[] namespace) {
        this.namespaces.push(namespace);
    }

    public void exitNamespace() {
        this.namespaces.pop();
    }

    public int getMode() {
        return 2;
    }
}

