/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.expressions.BigNumericLiteral;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.FloatNumericLiteral;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlighting;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticUpdateWorker;
import org.eclipse.dltk.ruby.ast.RubyConstantDeclaration;
import org.eclipse.dltk.ruby.ast.RubyDRegexpExpression;
import org.eclipse.dltk.ruby.ast.RubyDynamicStringExpression;
import org.eclipse.dltk.ruby.ast.RubyEvaluatableStringExpression;
import org.eclipse.dltk.ruby.ast.RubyRegexpExpression;
import org.eclipse.dltk.ruby.ast.RubySymbolReference;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.dltk.ruby.internal.ui.text.RubySemanticHighlighting;

public class RubySemanticUpdateWorker
extends SemanticUpdateWorker {
    private static final int HL_REGEXP = 0;
    private static final int HL_STRING = 1;
    private static final int HL_SYMBOL = 2;
    private static final int HL_LOCAL_VARIABLE = 3;
    private static final int HL_INSTANCE_VARIABLE = 4;
    private static final int HL_CLASS_VARIABLE = 5;
    private static final int HL_GLOBAL_VARIABLE = 6;
    private static final int HL_CONST = 7;
    private static final int HL_NUMBER = 8;
    private static final int HL_EVAL_EXPR = 9;
    private static final int HL_DEFAULT = 10;
    private final char[] content;
    private static final boolean ACTIVE = true;
    private final Stack stack = new Stack();

    public static SemanticHighlighting[] getSemanticHighlightings() {
        return new SemanticHighlighting[]{new RubySemanticHighlighting("DLTK_string.regexp"), new RubySemanticHighlighting("DLTK_string"), new RubySemanticHighlighting("ruby.symbols"), new RubySemanticHighlighting("variable"), new RubySemanticHighlighting("variable.instance"), new RubySemanticHighlighting("variable.class"), new RubySemanticHighlighting("variable.global"), new RubySemanticHighlighting("const"), new RubySemanticHighlighting("DLTK_number"), new RubySemanticHighlighting("DLTK_string.eval"), new RubySemanticHighlighting("DLTK_default")};
    }

    public RubySemanticUpdateWorker(ISourceModule sourceModule) throws ModelException {
        this.content = sourceModule.getSourceAsCharArray();
    }

    public boolean visitGeneral(ASTNode node) throws Exception {
        if (node instanceof RubyRegexpExpression || node instanceof RubyDRegexpExpression) {
            this.handleRegexp(node);
        } else if (node instanceof RubySymbolReference) {
            this.addHighlightedPosition(node.sourceStart(), node.sourceEnd(), 2);
        } else if (node instanceof VariableReference) {
            this.handleVariableReference((VariableReference)node);
        } else if (node instanceof StringLiteral) {
            if (this.isStringLiteralNeeded(node)) {
                this.addHighlightedPosition(node.sourceStart(), node.sourceEnd(), 1);
            }
        } else if (node instanceof NumericLiteral || node instanceof FloatNumericLiteral || node instanceof BigNumericLiteral) {
            this.addHighlightedPosition(node.sourceStart(), node.sourceEnd(), 8);
        } else if (node instanceof RubyEvaluatableStringExpression) {
            this.handleEvaluatableExpression(node);
        } else if (node instanceof CallExpression) {
            SimpleReference callName;
            CallExpression call = (CallExpression)node;
            if (!RubySyntaxUtils.isRubyOperator((String)call.getName()) && (callName = call.getCallName()).sourceStart() >= 0 && callName.sourceEnd() > callName.sourceStart()) {
                this.addHighlightedPosition(call.sourceStart(), call.sourceEnd(), 10);
            }
        } else if (node instanceof Declaration) {
            Declaration declaration = (Declaration)node;
            this.addHighlightedPosition(declaration.getNameStart(), declaration.getNameEnd(), 10);
        } else if (node instanceof RubyConstantDeclaration) {
            RubyConstantDeclaration declaration = (RubyConstantDeclaration)node;
            SimpleReference name = declaration.getName();
            this.addHighlightedPosition(name.sourceStart(), name.sourceEnd(), 7);
        }
        this.stack.push(node);
        return true;
    }

    private boolean isStringLiteralNeeded(ASTNode node) {
        if (this.stack.empty()) {
            return true;
        }
        ASTNode top = (ASTNode)this.stack.peek();
        if (top instanceof RubyDRegexpExpression) {
            return false;
        }
        if (top instanceof RubyDynamicStringExpression) {
            return node.sourceStart() >= top.sourceStart() && node.sourceEnd() <= top.sourceEnd();
        }
        return true;
    }

    public void endvisitGeneral(ASTNode node) throws Exception {
        this.stack.pop();
    }

    private void handleVariableReference(VariableReference ref) {
        String varName = ref.getName();
        if (varName.length() != 0) {
            if (varName.charAt(0) == '$') {
                this.addHighlightedPosition(ref.sourceStart(), ref.sourceEnd(), 6);
            } else if (varName.charAt(0) == '@') {
                if (varName.length() > 2 && varName.charAt(1) == '@') {
                    this.addHighlightedPosition(ref.sourceStart(), ref.sourceEnd(), 5);
                } else {
                    this.addHighlightedPosition(ref.sourceStart(), ref.sourceEnd(), 4);
                }
            } else {
                this.addHighlightedPosition(ref.sourceStart(), ref.sourceEnd(), 3);
            }
        }
    }

    private void handleEvaluatableExpression(ASTNode node) {
        int start = node.sourceStart();
        int end = node.sourceEnd();
        if (this.content[start] == '#' && this.content[start + 1] == '{') {
            if (this.content[end - 1] == '\r') {
                --end;
            }
            if (this.content[end - 1] == '}') {
                this.addHighlightedPosition(start, start + 2, 9);
                this.addHighlightedPosition(end - 1, end - 0, 9);
            }
        }
    }

    private void handleRegexp(ASTNode node) {
        char terminator;
        int start = node.sourceStart();
        int end = node.sourceEnd();
        if (start >= 1 && this.content[start - 1] == '/') {
            --start;
            if (end < this.content.length && this.content[end] == '/') {
                ++end;
            }
            while (end < this.content.length && RubySyntaxUtils.isValidRegexpModifier((char)this.content[end])) {
                ++end;
            }
        } else if (start >= 3 && this.content[start - 3] == '%' && this.content[start - 2] == 'r' && (terminator = RubySyntaxUtils.getPercentStringTerminator((char)this.content[start - 1])) != '\u0000' && end < this.content.length && this.content[end] == terminator) {
            start -= 3;
            ++end;
            while (end < this.content.length && RubySyntaxUtils.isValidRegexpModifier((char)this.content[end])) {
                ++end;
            }
        }
        this.addHighlightedPosition(start, end, 0);
    }
}

