/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import org.eclipse.dltk.ruby.internal.ui.RubyUI;
import org.eclipse.dltk.ui.text.util.AutoEditUtils;
import org.eclipse.dltk.ui.text.util.ITabPreferencesProvider;
import org.eclipse.dltk.ui.text.util.TabStyle;
import org.eclipse.jface.preference.IPreferenceStore;

public class RubyPreferenceInterpreter
implements ITabPreferencesProvider {
    private static RubyPreferenceInterpreter instance;
    private final IPreferenceStore store;

    public static final RubyPreferenceInterpreter getDefault() {
        if (instance == null) {
            instance = new RubyPreferenceInterpreter(RubyUI.getDefault().getPreferenceStore());
        }
        return instance;
    }

    public RubyPreferenceInterpreter(IPreferenceStore store) {
        this.store = store;
    }

    public boolean isSmartMode() {
        return this.store.getBoolean("editorSmartIndent");
    }

    public boolean isSmartPaste() {
        return this.store.getBoolean("smartPaste");
    }

    public boolean closeBlocks() {
        return this.closeBraces();
    }

    public boolean closeBraces() {
        return this.store.getBoolean("closeBraces");
    }

    public int getIndentSize() {
        return this.store.getInt("formatter.indentation.size");
    }

    public int getTabSize() {
        return this.store.getInt("formatter.tabulation.size");
    }

    public TabStyle getTabStyle() {
        return TabStyle.forName((String)this.store.getString("formatter.tabulation.char"), (TabStyle)TabStyle.TAB);
    }

    public String getIndent() {
        if (this.getTabStyle() == TabStyle.SPACES) {
            return AutoEditUtils.getNSpaces((int)this.getIndentSize());
        }
        return "\t";
    }

    public String getIndentByVirtualSize(int size) {
        if (this.getTabStyle() == TabStyle.SPACES) {
            return AutoEditUtils.getNSpaces((int)size);
        }
        int tabs = size / this.getTabSize();
        int leftover = size - tabs * this.getTabSize();
        return String.valueOf(AutoEditUtils.getNChars((int)tabs, (char)'\t')) + AutoEditUtils.getNSpaces((int)leftover);
    }

    public String getIndent(int count) {
        String indent = this.getIndent();
        StringBuffer result = new StringBuffer(indent.length() * count);
        int i = 0;
        while (i < count) {
            result.append(indent);
            ++i;
        }
        return result.toString();
    }
}

