/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.dltk.internal.testing.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.testing.MemberResolverManager;
import org.eclipse.dltk.testing.IDLTKTestingConstants;
import org.eclipse.dltk.testing.ITestingElementResolver;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

/**
 * Open a class on a Test method.
 */
public class OpenTestAction extends OpenEditorAction {

	private String fMethodName;
	private ISourceRange fRange;

	public OpenTestAction(TestRunnerViewPart testRunner, String className,
			String method) {
		this(testRunner, className, method, true);
	}

	public OpenTestAction(TestRunnerViewPart testRunner, String className) {
		this(testRunner, className, null);
	}

	public OpenTestAction(TestRunnerViewPart testRunner, String className,
			String method, boolean activate) {
		super(testRunner, className, activate);
		PlatformUI.getWorkbench().getHelpSystem().setHelp(this,
				IDLTKTestingHelpContextIds.OPENTEST_ACTION);
		fMethodName = method;
	}

	protected void reveal(ITextEditor textEditor) {
		if (fRange != null)
			textEditor.selectAndReveal(fRange.getOffset(), fRange.getLength());
	}

	protected IModelElement findMember(IScriptProject project, String name)
			throws ModelException {
		IScriptProject launchedProject = fTestRunner.getLaunchedProject();
		ILaunch launch = fTestRunner.getLaunch();
		ILaunchConfiguration launchConfiguration = launch
				.getLaunchConfiguration();
		IModelElement element = null;
		String id = null;
		try {
			id = launchConfiguration.getAttribute(
					IDLTKTestingConstants.ENGINE_ID_ATR, "");
		} catch (CoreException e) {
			if (DLTKCore.DEBUG) {
				e.printStackTrace();
			}
		}
		if (id != null) {
			ITestingElementResolver resolver = MemberResolverManager.getResolver(id);
			if (resolver == null) {
				return element;
			}
			ISourceModule module = this.resolveSourceModule(launchedProject, launchConfiguration);
			element = resolver.resolveElement(launchedProject, launchConfiguration, module, name);
			this.fRange = resolver.resolveRange(project, launchConfiguration, name, module, element, this.fMethodName);
		}
		return element;
	}
	
}
