/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IModelStatusConstants;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.Messages;

public class ModelStatus
extends Status
implements IModelStatus,
IModelStatusConstants {
    protected IModelElement[] elements = new IModelElement[0];
    protected IPath path;
    protected String string;
    protected static final IStatus[] NO_CHILDREN = new IStatus[0];
    protected IStatus[] children = NO_CHILDREN;

    public ModelStatus() {
        super(4, "org.eclipse.dltk.core", 0, "ModelStatus", null);
    }

    public ModelStatus(int code) {
        super(4, "org.eclipse.dltk.core", code, "ModelStatus", null);
        this.elements = ModelElement.NO_ELEMENTS;
    }

    public ModelStatus(CoreException coreException) {
        super(4, "org.eclipse.dltk.core", 966, "ModelStatus", (Throwable)coreException);
        this.elements = ModelElement.NO_ELEMENTS;
    }

    public ModelStatus(int code, Throwable throwable) {
        super(4, "org.eclipse.dltk.core", code, "ModelStatus", throwable);
        this.elements = ModelElement.NO_ELEMENTS;
    }

    public ModelStatus(int code, IModelElement element) {
        this(code, new IModelElement[]{element});
    }

    public ModelStatus(int severity, int code, String string) {
        super(severity, "org.eclipse.dltk.core", code, "ModelStatus", null);
        this.elements = ModelElement.NO_ELEMENTS;
        this.path = null;
        this.string = string;
    }

    public ModelStatus(int code, IModelElement[] elements) {
        super(4, "org.eclipse.dltk.core", code, "ModelStatus", null);
        this.elements = elements;
        this.path = null;
    }

    public ModelStatus(int code, String string) {
        this(4, code, string);
    }

    public ModelStatus(int code, IModelElement element, IPath path) {
        this(code, new IModelElement[]{element});
        this.path = path;
    }

    public ModelStatus(int code, IModelElement element, String string) {
        this(code, new IModelElement[]{element});
        this.string = string;
    }

    public boolean isDoesNotExist() {
        int code = this.getCode();
        return code == 969 || code == 1006;
    }

    public IPath getPath() {
        return this.path;
    }

    public String toString() {
        if (this == VERIFIED_OK) {
            return "ModelStatus[OK]";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Model Status [");
        buffer.append(this.getMessage());
        buffer.append("]");
        return buffer.toString();
    }

    public String getMessage() {
        Throwable exception = this.getException();
        if (exception == null) {
            switch (this.getCode()) {
                case 966: {
                    return Messages.status_coreException;
                }
                case 973: {
                    return Messages.bind(Messages.status_cannotUseDeviceOnPath, this.getPath().toString());
                }
                case 969: {
                    return Messages.bind(Messages.element_doesNotExist, ((ModelElement)this.elements[0]).toStringWithAncestors());
                }
                case 1006: {
                    return Messages.bind(Messages.element_notOnClasspath, ((ModelElement)this.elements[0]).toStringWithAncestors());
                }
                case 980: {
                    return Messages.status_indexOutOfBounds;
                }
                case 984: {
                    return Messages.status_invalidContents;
                }
                case 978: {
                    return Messages.bind(Messages.status_invalidDestination, ((ModelElement)this.elements[0]).toStringWithAncestors());
                }
                case 967: {
                    StringBuffer buff = new StringBuffer(Messages.operation_notSupported);
                    int i = 0;
                    while (i < this.elements.length) {
                        if (i > 0) {
                            buff.append(", ");
                        }
                        buff.append(((ModelElement)this.elements[i]).toStringWithAncestors());
                        ++i;
                    }
                    return buff.toString();
                }
                case 983: {
                    return Messages.bind(Messages.status_invalidName, this.string);
                }
                case 998: {
                    return Messages.bind(Messages.status_invalidPackage, this.string);
                }
                case 979: {
                    if (this.string != null) {
                        return this.string;
                    }
                    return Messages.bind(Messages.status_invalidPath, new String[]{this.getPath() == null ? "null" : this.getPath().toString()});
                }
                case 997: {
                    return Messages.bind(Messages.status_invalidProject, this.string);
                }
                case 995: {
                    return Messages.bind(Messages.status_invalidResource, this.string);
                }
                case 996: {
                    return Messages.bind(Messages.status_invalidResourceType, this.string);
                }
                case 993: {
                    if (this.string != null) {
                        return Messages.bind(Messages.status_invalidSibling, this.string);
                    }
                    return Messages.bind(Messages.status_invalidSibling, ((ModelElement)this.elements[0]).toStringWithAncestors());
                }
                case 985: {
                    return Messages.status_IOException;
                }
                case 977: {
                    if (this.string != null) {
                        return this.string;
                    }
                    return Messages.bind(Messages.status_nameCollision, "");
                }
                case 968: {
                    return Messages.operation_needElements;
                }
                case 982: {
                    return Messages.operation_needName;
                }
                case 970: {
                    return Messages.operation_needPath;
                }
                case 974: {
                    return Messages.operation_needString;
                }
                case 971: {
                    return Messages.bind(Messages.operation_pathOutsideProject, new String[]{this.string, ((ModelElement)this.elements[0]).toStringWithAncestors()});
                }
                case 976: {
                    IModelElement element = this.elements[0];
                    String name = element.getElementName();
                    return Messages.bind(Messages.status_readOnly, name);
                }
                case 972: {
                    return Messages.bind(Messages.operation_needAbsolutePath, this.getPath().toString());
                }
                case 987: {
                    return Messages.status_targetException;
                }
                case 981: {
                    return Messages.status_updateConflict;
                }
                case 999: {
                    return Messages.bind(Messages.status_noLocalContents, this.getPath().toString());
                }
                case 963: {
                    ScriptProject scriptProject = (ScriptProject)this.elements[0];
                    BuildpathContainerInitializer initializer = DLTKCore.getBuildpathContainerInitializer(this.path.segment(0));
                    String description = null;
                    if (initializer != null) {
                        description = initializer.getDescription(this.path, scriptProject);
                    }
                    if (description == null) {
                        description = this.path.makeRelative().toString();
                    }
                    return Messages.bind(Messages.buildpath_unboundContainerPath, new String[]{description, scriptProject.getElementName()});
                }
                case 962: {
                    ScriptProject scriptProject = (ScriptProject)this.elements[0];
                    IBuildpathContainer container = null;
                    String description = null;
                    try {
                        container = DLTKCore.getBuildpathContainer(this.path, scriptProject);
                    }
                    catch (ModelException modelException) {}
                    if (container == null) {
                        BuildpathContainerInitializer initializer = DLTKCore.getBuildpathContainerInitializer(this.path.segment(0));
                        if (initializer != null) {
                            description = initializer.getDescription(this.path, scriptProject);
                        }
                    } else {
                        description = container.getDescription(scriptProject);
                    }
                    if (description == null) {
                        description = this.path.makeRelative().toString();
                    }
                    return Messages.bind(Messages.buildpath_invalidContainer, new String[]{description, scriptProject.getElementName()});
                }
                case 1001: {
                    ScriptProject scriptProject = (ScriptProject)this.elements[0];
                    return Messages.bind(Messages.buildpath_cycle, scriptProject.getElementName());
                }
                case 1002: {
                    ScriptProject scriptProject = (ScriptProject)this.elements[0];
                    String projectName = scriptProject.getElementName();
                    IPath newPath = this.path;
                    if (this.path.segment(0).toString().equals(projectName)) {
                        newPath = this.path.removeFirstSegments(1);
                    }
                    return Messages.bind(Messages.buildpath_disabledInclusionExclusionPatterns, new String[]{newPath.makeRelative().toString(), projectName});
                }
            }
            if (this.string != null) {
                return this.string;
            }
            return "";
        }
        String message = exception.getMessage();
        if (message != null) {
            return message;
        }
        return exception.toString();
    }

    public static IModelStatus newMultiStatus(IModelStatus[] children) {
        ModelStatus jms = new ModelStatus();
        jms.children = children;
        return jms;
    }
}

