/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.EnvironmentResolver;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.ScriptRuntime;

public class ScriptLaunchUtil {
    static /* synthetic */ Class class$0;

    public static InterpreterConfig createInterpreterConfig(IExecutionEnvironment exeEnv, IFileHandle scriptFile, IFileHandle workingDirectory) {
        return ScriptLaunchUtil.createInterpreterConfig(exeEnv, scriptFile, workingDirectory, null);
    }

    public static InterpreterConfig createInterpreterConfig(IExecutionEnvironment exeEnv, IFileHandle scriptFile, IFileHandle workingDirectory, EnvironmentVariable[] env) {
        Path workingDirectoryPath = null;
        if (workingDirectory != null) {
            workingDirectoryPath = new Path(workingDirectory.toOSString());
        }
        InterpreterConfig config = new InterpreterConfig(scriptFile.getEnvironment(), (IPath)new Path(scriptFile.toOSString()), (IPath)workingDirectoryPath);
        Map envVars = exeEnv.getEnvironmentVariables(false);
        config.addEnvVars(envVars);
        EnvironmentVariable[] resVars = EnvironmentResolver.resolve(envVars, env);
        if (resVars != null) {
            int i = 0;
            while (i < resVars.length) {
                config.addEnvVar(resVars[i].getName(), resVars[i].getValue());
                ++i;
            }
        }
        return config;
    }

    public static Process runScriptWithInterpreter(IExecutionEnvironment exeEnv, String interpreter, InterpreterConfig config) throws CoreException {
        String[] cmdLine = config.renderCommandLine(exeEnv.getEnvironment(), interpreter);
        String[] environmentAsStrings = config.getEnvironmentAsStrings();
        IPath workingDirectoryPath = config.getWorkingDirectoryPath();
        if (DLTKLaunchingPlugin.TRACE_EXECUTION) {
            ScriptLaunchUtil.traceExecution("runScript with interpreter", cmdLine, environmentAsStrings);
        }
        return exeEnv.exec(cmdLine, workingDirectoryPath, environmentAsStrings);
    }

    private static void traceExecution(String processLabel, String[] cmdLineLabel, String[] environment) {
        StringBuffer sb = new StringBuffer();
        sb.append("-----------------------------------------------\n");
        sb.append("Running ").append(processLabel).append('\n');
        sb.append("Command line: ");
        int i = 0;
        while (i < cmdLineLabel.length) {
            sb.append(" " + cmdLineLabel[i]);
            ++i;
        }
        sb.append("\n");
        sb.append("Environment:\n");
        i = 0;
        while (i < environment.length) {
            sb.append('\t').append(environment[i]).append('\n');
            ++i;
        }
        sb.append("-----------------------------------------------\n");
        System.out.println(sb);
    }

    public static Process runScriptWithInterpreter(IExecutionEnvironment exeEnv, String interpreter, IFileHandle scriptFile, IFileHandle workingDirectory, String[] interpreterArgs, String[] scriptArgs, EnvironmentVariable[] environment) throws CoreException {
        InterpreterConfig config = ScriptLaunchUtil.createInterpreterConfig(exeEnv, scriptFile, workingDirectory, environment);
        if (scriptArgs != null) {
            config.addScriptArgs(scriptArgs);
        }
        if (interpreterArgs != null) {
            config.addInterpreterArgs(interpreterArgs);
        }
        return ScriptLaunchUtil.runScriptWithInterpreter(exeEnv, interpreter, config);
    }

    public static IInterpreterInstall getDefaultInterpreterInstall(String natureId, String environment) {
        return ScriptRuntime.getDefaultInterpreterInstall(new ScriptRuntime.DefaultInterpreterEntry(natureId, environment));
    }

    public static IInterpreterInstall getProjectInterpreterInstall(IScriptProject project) throws CoreException {
        return ScriptRuntime.getInterpreterInstall(project);
    }

    public static ILaunch runScript(IInterpreterInstall install, InterpreterConfig config, IProgressMonitor monitor) throws CoreException {
        if (install == null) {
            return null;
        }
        Launch launch = new Launch(null, "run", null);
        IInterpreterRunner runner = install.getInterpreterRunner(launch.getLaunchMode());
        runner.run(config, (ILaunch)launch, monitor);
        return launch;
    }

    public static ILaunch runScript(IScriptProject project, InterpreterConfig config, IProgressMonitor monitor) throws CoreException {
        return ScriptLaunchUtil.runScript(ScriptLaunchUtil.getProjectInterpreterInstall(project), config, monitor);
    }

    public static ILaunch runScript(String natureId, String environment, InterpreterConfig config, IProgressMonitor monitor) throws CoreException {
        IInterpreterInstall install = ScriptLaunchUtil.getDefaultInterpreterInstall(natureId, environment);
        EnvironmentVariable[] variables = EnvironmentResolver.resolve(config.getEnvVars(), install.getEnvironmentVariables());
        if (variables != null) {
            int i = 0;
            while (i < variables.length) {
                config.addEnvVar(variables[i].getName(), variables[i].getValue());
                ++i;
            }
        }
        return ScriptLaunchUtil.runScript(install, config, monitor);
    }

    public static ILaunch runScript(String natureId, IFileHandle scriptFile, IFileHandle workingDirectory, String[] interpreterArgs, String[] scriptArgs, IProgressMonitor monitor) throws CoreException {
        IEnvironment environment = scriptFile.getEnvironment();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.environment.IExecutionEnvironment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IExecutionEnvironment execEnvironment = (IExecutionEnvironment)environment.getAdapter((Class)clazz);
        InterpreterConfig config = ScriptLaunchUtil.createInterpreterConfig(execEnvironment, scriptFile, workingDirectory);
        if (interpreterArgs != null) {
            config.addInterpreterArgs(interpreterArgs);
        }
        if (scriptArgs != null) {
            config.addScriptArgs(scriptArgs);
        }
        return ScriptLaunchUtil.runScript(natureId, environment.getId(), config, monitor);
    }
}

