/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.model;

import java.util.Comparator;

final class FeatureAttributeComparator
implements Comparator<String> {
    private static final String[] NAMES_FEATURE = new String[]{"id", "label", "version", "provider-name"};
    private static final String[] NAMES_PLUGIN = new String[]{"id", "os", "ws", "arch", "download-size", "install-size", "version", "fragment", "unpack"};
    private static final String[] NAMES_IMPORT = new String[]{"plugin", "feature", "version", "match"};
    private final String[] names;

    static FeatureAttributeComparator fromTag(String tagName) {
        if (tagName.equals("feature")) {
            return new FeatureAttributeComparator(NAMES_FEATURE);
        }
        if (tagName.equals("plugin")) {
            return new FeatureAttributeComparator(NAMES_PLUGIN);
        }
        if (tagName.equals("import")) {
            return new FeatureAttributeComparator(NAMES_IMPORT);
        }
        return new FeatureAttributeComparator(null);
    }

    private FeatureAttributeComparator(String[] names) {
        this.names = names;
    }

    private int getOrderNumber(String key) {
        int result = 0;
        String[] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(key)) {
                return result;
            }
            ++result;
            ++n2;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int compare(String o1, String o2) {
        if (this.names != null) {
            int num2;
            int num1 = this.getOrderNumber(o1);
            if (num1 < (num2 = this.getOrderNumber(o2))) {
                return -1;
            }
            if (num1 > num2) {
                return 1;
            }
        }
        return o1.compareTo(o2);
    }
}

